/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.txv;

import com.borland.mdlimport.impl.txv.Configurable;
import com.borland.mdlimport.impl.txv.Identifiable;
import com.borland.mdlimport.impl.txv.LinkContainer;
import com.borland.mdlimport.impl.txv.Participant;
import com.borland.mdlimport.impl.xml.XMLNode;
import com.borland.mdlimport.impl.xml.XMLUtil;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.IParticipant;
import com.borland.util.IProperty;
import java.util.Enumeration;

public class Link
extends XMLNode
implements ILink {
    private Identifiable myUinHolder;
    private Configurable myProperties;
    private LinkContainer myLinkContainer;

    public Link() {
        this(null, null, null, null, null);
    }

    public Link(String uin, String metaclass, String name, String clientUin, String supplierUin) {
        super("link");
        this.myUinHolder = new Identifiable(this, uin);
        this.myProperties = new Configurable(this, "participant");
        this.myLinkContainer = new LinkContainer(this, null);
        if (clientUin != null) {
            this.setClient(clientUin);
        }
        if (supplierUin != null) {
            this.setSupplier(supplierUin);
        }
        if (metaclass != null) {
            this.myProperties.setProperty("$metaclass", metaclass);
        }
        if (name != null) {
            this.myProperties.setProperty("$name", name);
        }
    }

    public IIdentifiable getParent() {
        return this.myUinHolder.getParent();
    }

    public String getUin() {
        return this.myUinHolder.getUin();
    }

    public void setClient(String clientUin) {
        this.setParticipant("Client", clientUin);
    }

    public IParticipant getClient() {
        return this.getParticipant("Client");
    }

    public void setSupplier(String supplierUin) {
        this.setParticipant("Supplier", supplierUin);
    }

    public IParticipant getSupplier() {
        return this.getParticipant("Supplier");
    }

    public ILink addLink(ILink link) {
        return this.myLinkContainer.addLink(link);
    }

    public int getLinkCount() {
        return this.myLinkContainer.getLinkCount();
    }

    public ILink getLink(int index) {
        return this.myLinkContainer.getLink(index);
    }

    public void removeLink(ILink link) {
        this.myLinkContainer.removeLink(link);
    }

    public IProperty setProperty(String name, String value) {
        return this.myProperties.setProperty(name, value);
    }

    public IProperty getProperty(String name) {
        return this.myProperties.getProperty(name);
    }

    public int getPropertiesCount() {
        return this.myProperties.getPropertiesCount();
    }

    public IProperty getProperty(int index) {
        return this.myProperties.getProperty(index);
    }

    public String getPropertyValue(String propertyName) {
        return this.myProperties.getPropertyValue(propertyName);
    }

    public IProperty addProperty(String name, String value) {
        return this.myProperties.addProperty(name, value);
    }

    public Enumeration properties(String name) {
        return this.myProperties.properties(name);
    }

    public String getMetaclass() {
        return this.myProperties.getMetaclass();
    }

    public String getName() {
        return this.myProperties.getName();
    }

    protected void setParticipant(String role, String uin) {
        IParticipant oldParticipant = this.getParticipant(role);
        if (oldParticipant == null) {
            this.addElement(new Participant(role, uin));
            return;
        }
        if (oldParticipant instanceof XMLNode) {
            XMLUtil.setAttribute((XMLNode)((Object)oldParticipant), "referencedUin", uin);
        }
    }

    protected IParticipant getParticipant(String role) {
        return (IParticipant)((Object)XMLUtil.getChildElement(this, "participant", "role", role));
    }
}

