/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal.parser;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.IParseListener;
import com.borland.mdlimport.impl.petal.PetalNode;
import com.borland.mdlimport.impl.petal.parser.PetalLexer;
import com.borland.mdlimport.impl.petal.parser.PetalLoader;
import com.borland.mdlimport.impl.petal.parser.PetalToken;
import com.borland.mdlimport.petal.IParser;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;

public class PetalParser
implements IParser,
VetoableChangeListener {
    private PetalLexer lexer;
    private PetalNode versionTree;
    private PetalNode modelTree;
    private String baseId = "";
    private Stack idStack = new Stack();
    private boolean isTreeOnly = false;
    private boolean isAllowed = true;
    private boolean isListMapping = true;
    private boolean noLogicalPresentation = false;
    private boolean mapProperties = true;
    private List myListeners;
    private boolean needProgressInfo = false;

    public IPetalNode parse(Configuration configuration) throws IOException, PropertyVetoException {
        return this.parse(configuration.petalFile, configuration.needProgressInfo);
    }

    public IPetalNode parse(File file, boolean needProgressInfo) throws IOException, PropertyVetoException {
        PetalLoader loader = new PetalLoader(file);
        this.lexer = new PetalLexer(loader);
        Logger.getInstance().log("parser", 0, String.valueOf(Resources.getString("PetalParser.Parsing_file__2")) + file + "...");
        this.needProgressInfo = needProgressInfo;
        this.doParse();
        loader.close();
        return this.getModelTree();
    }

    public IPetalNode getVersionTree() {
        return this.versionTree;
    }

    public IPetalNode getModelTree() {
        return this.modelTree;
    }

    public void addParseListener(IParseListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList();
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeParseListener(IParseListener listener) {
        if (this.myListeners != null && this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
    }

    public void vetoableChange(PropertyChangeEvent evt) throws PropertyVetoException {
        if (this.needProgressInfo && "loaderProgressProperty".equals(evt.getPropertyName())) {
            int newValue = (Integer)evt.getNewValue();
            String status = null;
            if (evt.getSource() instanceof PetalLoader) {
                status = ((PetalLoader)evt.getSource()).getParsedFileName();
            }
            if (this.myListeners != null) {
                int i = 0;
                while (i < this.myListeners.size()) {
                    try {
                        ((IParseListener)this.myListeners.get(i)).parseProgressChanged(status, newValue, 100);
                    }
                    catch (IParseListener.CancelException e) {
                        throw new PropertyVetoException("Cancel exception caught", evt);
                    }
                    ++i;
                }
            }
        }
    }

    private void doParse() throws PropertyVetoException {
        if (this.needProgressInfo) {
            this.lexer.getLoader().addPropertyChangeListener(this);
        }
        this.baseId = null;
        this.idStack.push(new Integer(0));
        this.versionTree = this.parseExpr("");
        this.idStack.push(new Integer(0));
        this.baseId = null;
        this.modelTree = this.parseExpr("");
        if (this.needProgressInfo) {
            this.lexer.getLoader().removePropertyChangeListener(this);
        }
    }

    private PetalNode parseObject(String key) throws PropertyVetoException {
        Integer topInt = (Integer)this.idStack.pop();
        int top = topInt;
        this.idStack.push(new Integer(++top));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = String.valueOf(this.baseId) + ".";
            this.baseId = String.valueOf(this.baseId) + topInt.toString();
        }
        PetalToken token = this.lexer.getNext();
        if (token.getType() != 0) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_object_token_9")));
            return null;
        }
        token = this.lexer.getNext();
        if (token.getType() != 6) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_string_11")));
            return null;
        }
        String label = token.getValue();
        PetalNode root = null;
        if (this.isTreeOnly) {
            if (key.equals("root_usecase_package") || key.equals("root_subsystem") || !this.mapProperties && key.equals("properties") && label.equals("Properties")) {
                this.isListMapping = false;
            } else if (key.equals("root_category") || key.equals("process_structure") && label.equals("Processes")) {
                this.isListMapping = true;
            }
        }
        root = new PetalNode(key, label, 2);
        root.setId(this.baseId);
        while ((token = this.lexer.peekNext()).getType() != 3) {
            token = this.lexer.getNext();
            if (token.getType() != 5) {
                return null;
            }
            String pairKey = token.getValue();
            PetalNode node = this.parseExpr(pairKey);
            if (this.isTreeOnly) {
                if (node == null) continue;
                root.addNode(node);
                continue;
            }
            if (node == null) {
                return null;
            }
            root.addNode(node);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return root;
    }

    private PetalNode parseValue(String key) throws PropertyVetoException {
        Integer topInt = (Integer)this.idStack.pop();
        int top = topInt;
        this.idStack.push(new Integer(++top));
        this.idStack.push(new Integer(0));
        if (this.baseId == null) {
            this.baseId = "id";
        } else {
            this.baseId = String.valueOf(this.baseId) + ".";
            this.baseId = String.valueOf(this.baseId) + topInt.toString();
        }
        PetalToken token = this.lexer.getNext();
        if (token.getType() != 7) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_value_token_22")));
            return null;
        }
        token = this.lexer.getNext();
        if (token.getType() != 6) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_string_24")));
            return null;
        }
        String label = token.getValue();
        PetalNode root = new PetalNode(key, label, 4);
        root.setId(this.baseId);
        PetalNode node = this.parseS_prime("");
        if (this.isTreeOnly) {
            if (node != null) {
                root.addNode(node);
            }
        } else {
            if (node == null) {
                return null;
            }
            root.addNode(node);
        }
        this.idStack.pop();
        if (this.baseId.lastIndexOf(46) > 0) {
            this.baseId = this.baseId.substring(0, this.baseId.lastIndexOf(46));
        }
        return root;
    }

    private PetalNode parseExpr(String key) throws PropertyVetoException {
        PetalToken token = this.lexer.peekNext();
        if (token.getType() == 2) {
            this.lexer.getNext();
            token = this.lexer.peekNext();
            PetalNode root = null;
            if (token.getType() == 0) {
                root = this.parseObject(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else if (token.getType() == 7) {
                root = this.parseValue(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else if (token.getType() == 1) {
                root = this.parseList(key);
                if (!this.isTreeOnly && root == null) {
                    return null;
                }
            } else {
                Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_object_or_list_27")));
                return null;
            }
            if ((token = this.lexer.getNext()).getType() != 3) {
                Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_right_parenthesis_29")));
                return null;
            }
            return root;
        }
        return this.parseS_prime(key);
    }

    private PetalNode parseS_prime(String key) throws PropertyVetoException {
        PetalToken token = this.lexer.peekNext();
        if (token.getType() == 6) {
            return new PetalNode(key, this.lexer.getNext().getValue(), 0);
        }
        if (token.getType() == 4) {
            PetalNode root = new PetalNode(key, "", 1);
            while ((token = this.lexer.peekNext()).getType() == 4) {
                token = this.lexer.getNext();
                token = this.lexer.getNext();
                if (token.getType() != 6) {
                    return null;
                }
                PetalNode node = new PetalNode("", token.getValue(), 0);
                if (root == null) continue;
                root.addNode(node);
            }
            return root;
        }
        this.lexer.printNeighbors();
        Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_string_or_|__33")));
        return null;
    }

    private PetalNode parseList(String key) throws PropertyVetoException {
        boolean wasAllowed = this.isAllowed;
        this.isAllowed = this.isListMapping && (!this.noLogicalPresentation || !key.equals("logical_presentations"));
        PetalToken token = this.lexer.getNext();
        if (token.getType() != 1) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_list_token_36")));
            return null;
        }
        token = this.lexer.getNext();
        if (token.getType() != 6) {
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_string_38")));
            return null;
        }
        String label = token.getValue();
        token = this.lexer.peekNext();
        PetalNode root = null;
        if (token.getType() == 2) {
            if (!this.isTreeOnly || this.isAllowed) {
                root = new PetalNode(key, label, 3);
            }
            while (true) {
                if ((token = this.lexer.getNext()).getType() != 2) {
                    Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_left_parenthesis_40")));
                    continue;
                }
                PetalNode node = this.parseObject("");
                if (this.isTreeOnly) {
                    if (root != null && node != null) {
                        root.addNode(node);
                    }
                } else {
                    if (node == null) continue;
                    if (root != null) {
                        root.addNode(node);
                    }
                }
                if ((token = this.lexer.getNext()).getType() != 3) {
                    Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_right_parenthesis_43")));
                    continue;
                }
                token = this.lexer.peekNext();
                if (token.getType() == 3) break;
            }
        } else if (token.getType() == 3) {
            if (!this.isTreeOnly || this.isAllowed) {
                root = new PetalNode(key, label, 3);
            }
        } else if (token.getType() == 6) {
            if (!this.isTreeOnly || this.isAllowed) {
                root = new PetalNode(key, label, 3);
            }
            while (true) {
                if ((token = this.lexer.getNext()).getType() != 6) {
                    Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_string_45")));
                    continue;
                }
                PetalNode node = new PetalNode("", token.getValue(), 0);
                if (root != null) {
                    root.addNode(node);
                }
                if ((token = this.lexer.peekNext()).getType() == 3) break;
            }
        } else {
            this.lexer.getNext();
            Logger.getInstance().log("parser", 2, this.getErrMsg(token.lineNum, Resources.getString("PetalParser.Expecting_left/right_parenthesis_or_string_48")));
        }
        this.isAllowed = wasAllowed;
        return root;
    }

    private String getErrMsg(int line, String addMsg) {
        return String.valueOf(Resources.getString("PetalParser.Petal_syntax_error_at_line__49")) + line + ". " + addMsg;
    }
}

