/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal.parser;

import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public class PetalLoader {
    public static final String PROGRESS_PROPERTY = "loaderProgressProperty";
    public static final int TOTAL_WORK = 100;
    private static final int PROGRESS_INCREMENT = 1;
    private BufferedReader bufferedReader;
    private String myFileName;
    private long fileLength = 0L;
    private long currentOffset = 0L;
    private int currentWork = 0;
    private List myListeners;

    public PetalLoader(File file) throws IOException {
        if (!file.isFile()) {
            throw new IOException(String.valueOf(Resources.getString("PetalLoader.Cannot_load_file__2")) + file + Resources.getString("PetalLoader.._File_not_found_3"));
        }
        this.bufferedReader = new BufferedReader(new FileReader(file));
        this.fileLength = file.length();
        this.myFileName = file.getName();
        this.currentOffset = 0L;
        this.currentWork = 0;
    }

    public void addPropertyChangeListener(VetoableChangeListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList();
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removePropertyChangeListener(VetoableChangeListener listener) {
        if (this.myListeners != null && this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void firePropertyChange(int oldValue, int newValue) throws PropertyVetoException {
        if (this.myListeners != null) {
            PropertyChangeEvent event = new PropertyChangeEvent(this, PROGRESS_PROPERTY, new Integer(oldValue), new Integer(newValue));
            int i = 0;
            while (i < this.myListeners.size()) {
                ((VetoableChangeListener)this.myListeners.get(i)).vetoableChange(event);
                ++i;
            }
        }
    }

    public String getParsedFileName() {
        return this.myFileName;
    }

    public String readLine() throws PropertyVetoException {
        if (this.fileLength == 0L) {
            return null;
        }
        try {
            String line = this.bufferedReader.readLine();
            if (line == null) {
                this.firePropertyChange(this.currentWork, 100);
                return null;
            }
            this.currentOffset += (long)line.length();
            int newValue = (int)(this.currentOffset * 100L / this.fileLength);
            if (newValue >= this.currentWork + 1) {
                if (newValue > 100) {
                    newValue = 100;
                }
                this.firePropertyChange(this.currentWork, newValue);
                this.currentWork = newValue;
            }
            return line;
        }
        catch (IOException ex) {
            Logger.getInstance().log("parser", ex);
            return null;
        }
    }

    public void close() throws IOException {
        if (this.bufferedReader != null) {
            this.bufferedReader.close();
        }
    }
}

