/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal.parser;

import com.borland.mdlimport.impl.petal.parser.PetalLoader;
import com.borland.mdlimport.impl.petal.parser.PetalToken;
import com.borland.util.Logger;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class PetalLexer {
    private static final int BLOCK_SIZE = 10000;
    private PetalLoader myPetalLoader;
    private List myTokens = new ArrayList();
    private int myCurrentElement = 0;
    private boolean myIsList = false;
    private int myLineCounter = 0;

    public PetalLexer(PetalLoader petalLoader) {
        this.myPetalLoader = petalLoader;
    }

    public PetalLoader getLoader() {
        return this.myPetalLoader;
    }

    public PetalToken getNext() throws PropertyVetoException {
        if (this.myCurrentElement >= this.myTokens.size()) {
            this.getNextBlock();
        }
        if (this.myCurrentElement < this.myTokens.size()) {
            PetalToken roseToken = (PetalToken)this.myTokens.get(this.myCurrentElement);
            ++this.myCurrentElement;
            return roseToken;
        }
        return null;
    }

    public PetalToken peekNext() throws PropertyVetoException {
        if (this.myCurrentElement >= this.myTokens.size()) {
            this.getNextBlock();
        }
        if (this.myCurrentElement < this.myTokens.size()) {
            return (PetalToken)this.myTokens.get(this.myCurrentElement);
        }
        return null;
    }

    public void printNeighbors() {
        int count = 100;
        if (this.myCurrentElement < 100) {
            count = this.myCurrentElement;
        }
        int i = this.myCurrentElement - count;
        while (i <= this.myCurrentElement) {
            PetalToken tok = (PetalToken)this.myTokens.get(i);
            Logger.getInstance().log("parser", tok.getToken());
            ++i;
        }
    }

    public void readLines() throws PropertyVetoException {
        int k = 0;
        while (k < 10000) {
            String currentLine = this.myPetalLoader.readLine();
            if (currentLine == null) {
                return;
            }
            ++this.myLineCounter;
            if (currentLine.length() == 0) {
                --k;
            } else if (currentLine.charAt(0) == '|') {
                PetalToken roseToken = new PetalToken(4, "");
                roseToken.lineNum = this.myLineCounter;
                this.myTokens.add(roseToken);
                currentLine = currentLine.substring(1);
                roseToken = new PetalToken(6, currentLine);
                roseToken.lineNum = this.myLineCounter;
                this.myTokens.add(roseToken);
            } else {
                StringTokenizer stringTokenizer = new StringTokenizer(currentLine);
                int i = 0;
                while (stringTokenizer.hasMoreTokens()) {
                    String temp;
                    String tok = stringTokenizer.nextToken();
                    if (tok.equals("#")) break;
                    currentLine = currentLine.substring(currentLine.indexOf(tok));
                    if (tok.equals("(object")) {
                        this.myIsList = false;
                        PetalToken roseToken = new PetalToken(2, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        roseToken = new PetalToken(0, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        currentLine = currentLine.substring(7).trim();
                        this.processToTheEnd(currentLine);
                        break;
                    }
                    if (tok.equals("(list")) {
                        this.myIsList = true;
                        PetalToken roseToken = new PetalToken(2, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        roseToken = new PetalToken(1, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        currentLine = currentLine.substring(5).trim();
                        this.processToTheEnd(currentLine);
                        break;
                    }
                    if (tok.equals("(value")) {
                        this.myIsList = false;
                        PetalToken roseToken = new PetalToken(2, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        roseToken = new PetalToken(7, "");
                        roseToken.lineNum = this.myLineCounter;
                        this.myTokens.add(roseToken);
                        currentLine = currentLine.substring(6).trim();
                        this.processValueToTheEnd(currentLine, this.myLineCounter);
                        break;
                    }
                    if (i == 0 && tok.charAt(0) == ')') {
                        int rightParenNum = 0;
                        temp = tok;
                        while (temp.length() > 0 && temp.charAt(temp.length() - 1) == ')') {
                            ++rightParenNum;
                            temp = temp.substring(0, temp.length() - 1);
                        }
                        int j = 0;
                        while (j < rightParenNum) {
                            this.myIsList = false;
                            PetalToken roseToken = new PetalToken(3, "");
                            roseToken.lineNum = this.myLineCounter;
                            this.myTokens.add(roseToken);
                            ++j;
                        }
                        break;
                    }
                    if (i == 0) {
                        if (this.myIsList) {
                            int rightParenNum = 0;
                            temp = currentLine.trim();
                            while (temp.charAt(temp.length() - 1) == ')') {
                                ++rightParenNum;
                                temp = temp.substring(0, temp.length() - 1);
                            }
                            if (currentLine.charAt(0) == '(') {
                                --rightParenNum;
                                temp = String.valueOf(temp) + ")";
                            }
                            PetalToken roseToken = new PetalToken(6, temp);
                            roseToken.lineNum = this.myLineCounter;
                            this.myTokens.add(roseToken);
                            int j = 0;
                            while (j < rightParenNum) {
                                this.myIsList = false;
                                roseToken = new PetalToken(3, "");
                                roseToken.lineNum = this.myLineCounter;
                                this.myTokens.add(roseToken);
                                ++j;
                            }
                            break;
                        }
                    } else {
                        this.myIsList = false;
                        currentLine = currentLine.trim();
                        this.processToTheEnd(currentLine);
                        break;
                    }
                    this.myIsList = false;
                    PetalToken roseToken = new PetalToken(5, tok);
                    roseToken.lineNum = this.myLineCounter;
                    this.myTokens.add(roseToken);
                    ++i;
                }
            }
            ++k;
        }
    }

    protected void getNextBlock() throws PropertyVetoException {
        PetalToken roseToken = null;
        if (this.myTokens.size() > this.myCurrentElement) {
            roseToken = (PetalToken)this.myTokens.get(this.myCurrentElement);
        }
        this.myTokens.clear();
        if (roseToken != null) {
            this.myTokens.add(roseToken);
        }
        this.myCurrentElement = 0;
        System.gc();
        this.readLines();
    }

    protected void processToTheEnd(String temp) throws PropertyVetoException {
        if (temp.length() == 0) {
            PetalToken roseToken = new PetalToken(6, temp);
            roseToken.lineNum = this.myLineCounter;
            this.myTokens.add(roseToken);
            return;
        }
        if (this.getQuoteCount(temp) % 2 == 1) {
            String currentLine = this.myPetalLoader.readLine();
            ++this.myLineCounter;
            temp = String.valueOf(temp) + currentLine;
            while (this.getQuoteCount(currentLine) == 0) {
                currentLine = this.myPetalLoader.readLine();
                ++this.myLineCounter;
                temp = String.valueOf(temp) + currentLine;
            }
        }
        int rightParenNum = 0;
        while (temp.charAt(temp.length() - 1) == ')') {
            ++rightParenNum;
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.charAt(0) == '(') {
            --rightParenNum;
            temp = String.valueOf(temp) + ")";
        }
        PetalToken roseToken = new PetalToken(6, temp);
        roseToken.lineNum = this.myLineCounter;
        this.myTokens.add(roseToken);
        int i = 0;
        while (i < rightParenNum) {
            this.myIsList = false;
            roseToken = new PetalToken(3, "");
            roseToken.lineNum = this.myLineCounter;
            this.myTokens.add(roseToken);
            ++i;
        }
    }

    protected void processValueToTheEnd(String temp, int lineCounter) {
        if (temp.length() == 0) {
            PetalToken roseToken = new PetalToken(6, temp);
            roseToken.lineNum = lineCounter;
            this.myTokens.add(roseToken);
            return;
        }
        int rightParenNum = 0;
        while (temp.charAt(temp.length() - 1) == ')') {
            ++rightParenNum;
            temp = temp.substring(0, temp.length() - 1);
        }
        if (temp.charAt(0) == '(') {
            --rightParenNum;
            temp = String.valueOf(temp) + ")";
        }
        String firstWord = temp;
        String restOfString = "";
        int indexOfSpace = temp.indexOf(" ");
        if (indexOfSpace == -1) {
            indexOfSpace = temp.indexOf("\t");
        }
        if (indexOfSpace != -1) {
            firstWord = temp.substring(0, indexOfSpace);
            restOfString = temp.substring(indexOfSpace).trim();
        }
        PetalToken roseToken = new PetalToken(6, firstWord);
        roseToken.lineNum = lineCounter;
        this.myTokens.add(roseToken);
        if (restOfString.length() > 0) {
            roseToken = new PetalToken(6, restOfString);
            roseToken.lineNum = lineCounter;
            this.myTokens.add(roseToken);
        }
        int i = 0;
        while (i < rightParenNum) {
            this.myIsList = false;
            roseToken = new PetalToken(3, "");
            roseToken.lineNum = lineCounter;
            this.myTokens.add(roseToken);
            ++i;
        }
    }

    private int getQuoteCount(String str) {
        int quotCount = 0;
        int curIndex = 0;
        while (curIndex < str.length()) {
            int nextIndex = str.indexOf("\"", curIndex);
            if (nextIndex == -1) break;
            curIndex = nextIndex + 1;
            if (nextIndex > 0 && str.charAt(nextIndex - 1) == '\\') continue;
            ++quotCount;
        }
        return quotCount;
    }
}

