/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.mdlimport.txv.IViewReference;
import com.borland.util.Logger;
import com.borland.util.Resources;

public class ViewUtil {
    public static String getScaledY(String location, double scale) {
        String result = null;
        if (location == null) {
            return null;
        }
        int index1 = location.indexOf(44);
        int index2 = location.indexOf(41);
        if (index1 > 0 && index2 > 0) {
            result = location.substring(index1 + 2, index2);
        }
        return ViewUtil.scaleInteger(result, scale);
    }

    public static String scaleInteger(String str, double scale) {
        int x = Integer.parseInt(str);
        return String.valueOf((int)((double)x * scale));
    }

    public static StringBuffer subtractBounds(String loc1, String loc2) {
        String[] xAndYAndWandH1 = loc1.split(",");
        String[] xAndYAndWandH2 = loc2.split(",");
        int x1 = Integer.parseInt(xAndYAndWandH1[0]);
        int y1 = Integer.parseInt(xAndYAndWandH1[1].trim());
        int x2 = Integer.parseInt(xAndYAndWandH2[0]);
        int y2 = Integer.parseInt(xAndYAndWandH2[1].trim());
        int h = Integer.parseInt(xAndYAndWandH1[2].trim());
        int w = Integer.parseInt(xAndYAndWandH1[3].trim());
        if (x1 - x2 < 0) {
            x1 = x2;
        }
        if (y1 - y2 < 0) {
            y1 = y2;
        }
        StringBuffer buffer = new StringBuffer(20);
        buffer.append(x1 - x2).append(',').append(y1 - y2).append(',').append(h).append(',').append(w);
        return buffer;
    }

    public static String trimBrackets(String str) {
        StringBuffer strBuf = new StringBuffer(str);
        strBuf.deleteCharAt(0);
        strBuf.deleteCharAt(strBuf.length() - 1);
        return strBuf.toString();
    }

    public static String scaleLocation(String str, double scale) {
        String[] xAndY = ViewUtil.trimBrackets(str).split(",");
        int x = Integer.parseInt(xAndY[0].trim());
        int y = Integer.parseInt(xAndY[1].trim());
        StringBuffer buffer = new StringBuffer(20);
        buffer.append((int)((double)x * scale)).append(',').append((int)((double)y * scale));
        return buffer.toString();
    }

    protected static boolean isDesignViewRef(IViewReference viewRef) {
        int index = viewRef.getReferencedUin().indexOf(":::");
        return index != -1;
    }

    protected static void setBounds(IPetalNode tree, IViewReference viewRef, IViewReference parentViewReference, double scaleFactor, String interactionPrefix, boolean setted_by_user) {
        String location = "(0,0)";
        if (tree.findNodeWithKey("location") != null) {
            location = tree.findNodeWithKey("location").getAllValues(true);
        }
        location = ViewUtil.scaleLocation(location, scaleFactor);
        IPetalNode heightNode = tree.findNodeWithKey("height");
        IPetalNode widthNode = tree.findNodeWithKey("width");
        StringBuffer bounds = new StringBuffer(20);
        if (widthNode == null || heightNode == null) {
            bounds.append(location).append(',').append("100,100");
        } else {
            bounds.append(location).append(',').append((int)((double)Integer.parseInt(widthNode.getValue()) * scaleFactor)).append(',').append((int)((double)Integer.parseInt(heightNode.getValue()) * scaleFactor));
            if (setted_by_user) {
                viewRef.setProperty("bounds_setted_by_user", "true");
            }
        }
        if (parentViewReference != null) {
            String containerBounds = parentViewReference.getPropertyValue("bounds");
            if (containerBounds == null) {
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("ViewUtil.Container_bounds_not_found_for_view__8")) + viewRef.getReferencedUin());
            } else {
                bounds = ViewUtil.subtractBounds(bounds.toString(), containerBounds);
            }
        }
        viewRef.setProperty(String.valueOf(interactionPrefix) + "bounds", bounds.toString());
    }

    public static void setFont(IPetalNode node, IViewReference viewRef) {
        IPetalNode fontNode = node.findNodeWithKey("font");
        if (fontNode == null) {
            return;
        }
        IPetalNode sizeNode = fontNode.findNodeWithKey("size");
        String size = sizeNode.getValue();
        IPetalNode familyNode = fontNode.findNodeWithKey("face");
        String family = familyNode.getName();
        IPetalNode boldNode = fontNode.findNodeWithKey("bold");
        String bold = boldNode.getValue();
        IPetalNode italicsNode = fontNode.findNodeWithKey("italics");
        String italics = italicsNode.getValue();
        viewRef.setProperty("@fontSize", size);
        viewRef.setProperty("@fontName", family);
        String TRUE = "TRUE";
        if (TRUE.equals(bold) && TRUE.equals(italics)) {
            viewRef.setProperty("@fontStyle", "3");
        } else if (TRUE.equals(bold)) {
            viewRef.setProperty("@fontStyle", "1");
        } else if (TRUE.equals(italics)) {
            viewRef.setProperty("@fontStyle", "2");
        } else {
            viewRef.setProperty("@fontStyle", "0");
        }
    }

    protected static void setColors(IPetalNode node, IViewReference viewRef, boolean convertRoseDefaultColors, String interactionPrefix) {
        IPetalNode fillColorNode = node.findNodeWithKey("fill_color");
        IPetalNode lineColorNode = node.findNodeWithKey("line_color");
        String fillColor = fillColorNode == null ? null : fillColorNode.getValue();
        String lineColor = lineColorNode == null ? null : lineColorNode.getValue();
        ViewUtil.setColors(fillColor, lineColor, viewRef, convertRoseDefaultColors, interactionPrefix);
    }

    protected static void setColors(String fillColor, String lineColor, IViewReference viewRef, boolean convertRoseDefaultColors, String interactionPrefix) {
        if (!(fillColor == null || "13434879".equals(fillColor) && convertRoseDefaultColors)) {
            viewRef.setProperty(String.valueOf(interactionPrefix) + "background_color", PetalUtil.toRGB(fillColor));
        }
        if (!(lineColor == null || "3342489".equals(lineColor) && convertRoseDefaultColors)) {
            viewRef.setProperty(String.valueOf(interactionPrefix) + "foreground_color", PetalUtil.toRGB(lineColor));
        }
    }
}

