/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.java.IJavaClassifier;
import com.borland.mdlimport.codegen.java.JavaTypes;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.AbstractHandler;
import com.borland.mdlimport.impl.petal.DesignModelHandler;
import com.borland.mdlimport.impl.petal.QuidAndQName;
import com.borland.mdlimport.impl.petal.SourceModelHandler;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.impl.petal.ViewUtil;
import com.borland.mdlimport.mapping.UinSupport;
import com.borland.mdlimport.mapping.providers.Extractors;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.mdlimport.txv.IElement;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.IReference;
import com.borland.mdlimport.txv.IView;
import com.borland.mdlimport.txv.IViewReference;
import com.borland.mdlimport.txv.TXVUtil;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.JavaNames;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class ViewHandler
extends AbstractHandler {
    public static final String GET_VIEW_REF = "get_view_ref";
    public static final String GET_UIN = "get_uin";
    public static final String GET_REF_UIN = "get_ref_uin";
    public static final String CREATE_VIEW = "create_view";
    public static final String HANDLE_NOTE_LINK = "handle_note_link";
    public static final String IS_SEQUENCE_DIAGRAM = "is_sequence_diagram";
    public static final String IS_COLLABORATION_DIAGRAM = "is_collaboration_diagram";
    public static final String IS_CLASS_DIAGRAM = "is_class_diagram";
    public static final String IS_MESSAGE_WITH_NOT_NESTED_ACTIVATION = "is_message_with_not_nested_activation";
    public static final String CLEAR_OUR_VIEW_REF = "clear_our_view_refs";
    public static final String CREATE_VIEW_REF_FOR_DESIGN = "create_view_ref_for_design";
    private HashMap ourViewRefs = new HashMap();
    private HashSet ourAddToSwimlane = new HashSet();
    private HashSet ourOriginalElements = new HashSet();
    private boolean processingSeqDiagram = false;
    private boolean processingColDiagram = false;
    private boolean processingClassDiagram = false;
    private HashMap myMessagesLinkViews = new HashMap();
    private List messageLinksWithNotNestedActivation = new ArrayList();
    private Map ourFocusOfControls = new HashMap();

    public ViewHandler(Configuration config) {
        super(config);
    }

    public void handlePetalNode(IPetalNode petalNode) {
        this.handlePetalNode(petalNode.getQuidu(), petalNode);
    }

    public void handlePetalNode(String uin, IPetalNode petalNode) {
        if (PetalUtil.isActorView(petalNode) && this.getConfiguration().actors) {
            this.handleNodeView(petalNode);
        } else if (PetalUtil.isSrcView(petalNode.getType()) && this.getConfiguration().generateSource) {
            this.handleSrcElementView(petalNode);
        } else if ("LinkView".equals(petalNode.getType())) {
            this.handleMessagesLinkView(petalNode);
        } else if ("LinkSelfView".equals(petalNode.getType())) {
            this.handleMessagesLinkView(petalNode);
        } else if ("AssocAttachView".equals(petalNode.getType())) {
            this.handleAssocAttachView(petalNode);
        } else if ("MessView".equals(petalNode.getType())) {
            this.handleMessageLinkView(petalNode);
        } else if ("InterMessView".equals(petalNode.getType())) {
            this.handleMessageLinkView(petalNode);
        } else if ("SelfMessView".equals(petalNode.getType())) {
            this.handleMessageLinkView(petalNode);
        } else if ("Focus_Of_Control".equals(petalNode.getKey())) {
            this.ourFocusOfControls.put(petalNode.getTag(), new FocusOfControlProps(petalNode));
        } else if (PetalUtil.isNodeView(petalNode)) {
            this.handleNodeView(uin, petalNode);
        } else if (PetalUtil.isAssocAttachView(petalNode)) {
            this.handleAssocAttachView(petalNode);
        } else if (PetalUtil.isAssociationLinkView(petalNode)) {
            this.handleAssociationView(petalNode);
        } else if (PetalUtil.isLinkView(petalNode)) {
            this.handleLinkView(uin, petalNode);
        } else if ("SegLabel".equals(petalNode.getType())) {
            this.handleSegLabel(petalNode);
        }
    }

    public Object execute(String operationCode, Object obj) {
        if (CLEAR_OUR_VIEW_REF.equals(operationCode)) {
            this.ourViewRefs.clear();
            return null;
        }
        if (GET_VIEW_REF.equals(operationCode)) {
            return this.ourViewRefs.get(obj);
        }
        if (GET_UIN.equals(operationCode)) {
            return this.getUin(obj.toString());
        }
        if (GET_REF_UIN.equals(operationCode)) {
            IViewReference viewRef = (IViewReference)this.ourViewRefs.get(obj);
            if (viewRef == null) {
                return null;
            }
            return viewRef.getReferencedUin();
        }
        if (CREATE_VIEW.equals(operationCode)) {
            Object[] params = (Object[])obj;
            this.createView((IPetalNode)params[0], (String)params[1], (String)params[2], (INodeSet)params[3]);
            return null;
        }
        if (HANDLE_NOTE_LINK.equals(operationCode)) {
            Object[] params = (Object[])obj;
            IViewReference viewRef = TxvAccess.createViewReference((String)params[0]);
            IViewReference clientRef = (IViewReference)params[1];
            if (clientRef == null) {
                return null;
            }
            clientRef.addViewReference(viewRef);
            return null;
        }
        if (IS_MESSAGE_WITH_NOT_NESTED_ACTIVATION.equals(operationCode)) {
            if (this.messageLinksWithNotNestedActivation.contains(obj)) {
                return new Object();
            }
            return null;
        }
        if (IS_SEQUENCE_DIAGRAM.equals(operationCode)) {
            Boolean isSeq = (Boolean)obj;
            this.processingSeqDiagram = isSeq;
            return null;
        }
        if (IS_COLLABORATION_DIAGRAM.equals(operationCode)) {
            Boolean isCol = (Boolean)obj;
            this.processingColDiagram = isCol;
            return null;
        }
        if (IS_CLASS_DIAGRAM.equals(operationCode)) {
            Boolean isCls = (Boolean)obj;
            this.processingClassDiagram = isCls;
            return null;
        }
        if (CREATE_VIEW_REF_FOR_DESIGN.equals(operationCode)) {
            Object[] params = (Object[])obj;
            INode node = (INode)params[0];
            INodeSet nodeSet = (INodeSet)params[1];
            if (node == null || nodeSet == null) {
                return null;
            }
            IViewReference viewRef = TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(node));
            if (nodeSet.getViewCount() != 0) {
                nodeSet.getView(0).addViewReference(viewRef);
            }
            return viewRef;
        }
        return null;
    }

    public void finish() {
    }

    protected String getUin(String tag) {
        IViewReference viewRef = (IViewReference)this.ourViewRefs.get(tag);
        if (viewRef == null) {
            return null;
        }
        return UinSupport.getNodeUin(viewRef.getReferencedUin());
    }

    protected void handleSegLabel(IPetalNode tree) {
        IPetalNode parentTagNode = tree.findNodeWithKey("Parent_View");
        String parentTag = parentTagNode.getType();
        Object parenRef = this.ourViewRefs.get(parentTag);
        this.ourViewRefs.put(tree.getTag(), parenRef);
    }

    protected void handleNodeView(IPetalNode tree) {
        this.handleNodeView(tree.getQuidu(), tree);
    }

    protected void handleNodeView(final String uin, IPetalNode petalNode) {
        if (uin == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("ViewHandler.Petal_node__12")) + petalNode + Resources.getString("ViewHandler._doesn__t_have_quidu_attribute_13"));
            return;
        }
        IElement elementForNode = TxvAccess.findElement(uin);
        final IViewReference viewRef = elementForNode == null ? TxvAccess.createViewReference() : TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(elementForNode));
        final INodeSet this_nodeSet = (INodeSet)this.getDesignModelHandler().execute("get_current_nodeset", null);
        this_nodeSet.getView(0).addViewReference(viewRef);
        final IElement this_currentNode = (IElement)this.getDesignModelHandler().execute("get_current_node", null);
        IPetalNode horizontalProperty = petalNode.findNodeWithKey("sync_is_horizontal");
        final String isHorizontal = horizontalProperty == null ? null : horizontalProperty.getValue();
        IPetalNode stateProperty = petalNode.findNodeWithKey("State");
        final String stateValue = stateProperty == null ? null : stateProperty.getValue();
        Runnable changeModel = new Runnable(){

            public void run() {
                IElement elementForNodeView = TxvAccess.findElement(uin);
                if (elementForNodeView != null) {
                    if ("Synchronization Bar".equals(elementForNodeView.getMetaclass())) {
                        if ("TRUE".equals(isHorizontal)) {
                            elementForNodeView.setProperty("$orientation", "horizontal");
                        } else {
                            elementForNodeView.setProperty("$orientation", "vertical");
                        }
                    }
                    if ("Object".equals(elementForNodeView.getMetaclass()) && stateValue != null) {
                        elementForNodeView.setProperty("$state", Extractors.CUT_QUOTES.extract(stateValue).toString());
                    }
                    if (!ViewHandler.this.getConfiguration().inPackage) {
                        if (elementForNodeView instanceof INode && !"Class".equals(elementForNodeView.getMetaclass()) && !"AssociationClass".equals(elementForNodeView.getMetaclass()) && !"Component".equals(elementForNodeView.getMetaclass())) {
                            if (ViewHandler.this.ourOriginalElements.contains(elementForNodeView)) {
                                viewRef.setProperty("$imported", "");
                            } else {
                                this_nodeSet.addNode((INode)TXVUtil.getContainerBeforeElement(elementForNodeView, this_currentNode));
                                ViewHandler.this.ourOriginalElements.add(elementForNodeView);
                            }
                        } else {
                            viewRef.setProperty("$imported", "");
                        }
                    }
                    Runnable command = new Runnable(this, elementForNodeView, viewRef){
                        final /* synthetic */ 1 this$1;
                        private final /* synthetic */ IElement val$elementForNodeView;
                        private final /* synthetic */ IViewReference val$viewRef;
                        {
                            this.this$1 = var1_1;
                            this.val$elementForNodeView = iElement;
                            this.val$viewRef = iViewReference;
                        }

                        public void run() {
                            String referencedUin = null;
                            referencedUin = this.val$elementForNodeView instanceof INodeSet ? UinSupport.getDesignReferencedUin(((INodeSet)((Object)this.val$elementForNodeView)).getView(0)) : UinSupport.getDesignReferencedUin(this.val$elementForNodeView);
                            this.val$viewRef.setReferencedUin(referencedUin);
                        }
                    };
                    CommandProcessor.runCommandLater(command, "onTraverseCompleteDesign");
                }
            }
        };
        if (elementForNode == null) {
            CommandProcessor.runCommandLater(changeModel, "onTxvCreation", uin);
        } else {
            changeModel.run();
        }
        IPetalNode parent_view = petalNode.findNodeWithKey("Parent_View");
        IReference parentViewReference = null;
        if (parent_view != null) {
            parentViewReference = (IViewReference)this.ourViewRefs.get(parent_view.getValue());
        }
        if (parentViewReference != null) {
            String parentUin = UinSupport.getNodeUin(parentViewReference.getReferencedUin());
            final INode parentElement = TxvAccess.findNode(parentUin);
            if (parentElement == null) {
                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_parent_node_by_Uin__15")) + parentUin);
            } else if ("Swimlane".equals(parentElement.getMetaclass())) {
                if (this.ourAddToSwimlane.contains(elementForNode)) {
                    return;
                }
                Runnable addToSwimLane = new Runnable(){

                    public void run() {
                        IElement elementForNodeView = TxvAccess.findElement(uin);
                        parentElement.addNode((INode)elementForNodeView);
                    }
                };
                if (elementForNode == null) {
                    CommandProcessor.runCommandLater(addToSwimLane, "onTxvCreation", parentUin);
                } else {
                    addToSwimLane.run();
                }
                this.ourAddToSwimlane.add(elementForNode);
            }
        }
        String interactionPrefix = Resources.getString("ViewHandler._16");
        if (this.processingSeqDiagram) {
            interactionPrefix = "seq_";
        }
        if (this.processingColDiagram) {
            interactionPrefix = "col_";
        }
        ViewUtil.setColors(petalNode, viewRef, this.getConfiguration().convertRoseDefaultColors, interactionPrefix);
        ViewUtil.setBounds(petalNode, viewRef, (IViewReference)parentViewReference, this.getConfiguration().scaleFactor, interactionPrefix, this.getConfiguration().preserveDiagramNodeBounds);
        ViewUtil.setFont(petalNode, viewRef);
        String tag = petalNode.getTag();
        this.ourViewRefs.put(tag, viewRef);
        if (parentViewReference != null) {
            parentViewReference.addViewReference(viewRef);
        } else {
            viewRef.setProperty("$shortcutReference", "true");
        }
    }

    protected void handleLinkView(IPetalNode tree) {
        this.handleLinkView(tree.getQuidu(), tree);
    }

    protected void handleLinkView(final String uin, IPetalNode petalNode) {
        IPetalNode client = petalNode.findNodeWithKey("client");
        IPetalNode supplier = petalNode.findNodeWithKey("supplier");
        String clientTag = client.getType();
        String supplierTag = supplier.getType();
        final IViewReference clientRef = (IViewReference)this.ourViewRefs.get(clientTag);
        if (clientRef == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("ViewHandler.Cannot_create_view_reference_for_link__18")) + petalNode.getQuidu() + Resources.getString("ViewHandler.._Link_client_not_found_or_not_valid_19"));
            return;
        }
        final IViewReference supplierRef = (IViewReference)this.ourViewRefs.get(supplierTag);
        final IViewReference viewRef = TxvAccess.createViewReference();
        clientRef.addViewReference(viewRef);
        this.ourViewRefs.put(petalNode.getTag(), viewRef);
        this.handleSrcLinkView(petalNode, clientRef, supplierRef, viewRef);
        ILink linkForView = TxvAccess.findLink(uin);
        Runnable creatingViewRef = new Runnable(){

            public void run() {
                ILink linkForViewDef = TxvAccess.findLink(uin);
                if (linkForViewDef == null) {
                    return;
                }
                String clientRefUin = clientRef.getReferencedUin();
                if (clientRefUin != null) {
                    String clientUin = UinSupport.getNodeUin(clientRefUin);
                    if ("Note Link".equals(linkForViewDef.getMetaclass())) {
                        IElement clientElement = TxvAccess.findElement(clientUin);
                        if (clientElement == null) {
                            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_element_by_Uin__26")) + clientUin);
                            return;
                        }
                        if (!"Note".equals(clientElement.getMetaclass())) {
                            viewRef.setReferencedUin(UinSupport.getDesignReferencedUin(linkForViewDef));
                            supplierRef.addViewReference(viewRef);
                            return;
                        }
                    }
                }
                String designRefUin = UinSupport.getDesignReferencedUin(linkForViewDef);
                int i = 0;
                while (i < clientRef.getViewReferenceCount()) {
                    IViewReference ref = clientRef.getViewReference(i);
                    if (ref != null && designRefUin.equals(ref.getReferencedUin())) {
                        return;
                    }
                    ++i;
                }
                viewRef.setReferencedUin(designRefUin);
            }
        };
        if (linkForView == null) {
            CommandProcessor.runCommandLater(creatingViewRef, "onTraverseCompleteDesign");
        } else {
            creatingViewRef.run();
        }
    }

    protected void handleSrcLinkView(IPetalNode petalNode, final IViewReference clientRef, final IViewReference supplierRef, final IViewReference viewRef) {
        if (!PetalUtil.isSrcLinkView(petalNode.getType())) {
            return;
        }
        final String petalNodeType = petalNode.getType();
        Runnable processSrcLinkView = new Runnable(){

            public void run() {
                if (clientRef != null && clientRef.getReferencedUin() != null && !ViewUtil.isDesignViewRef(clientRef) && supplierRef.getReferencedUin() != null && !ViewUtil.isDesignViewRef(supplierRef)) {
                    String clientFqn = UinSupport.getFqnByEClassRef(clientRef.getReferencedUin());
                    if (clientFqn == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_client_for_referenced_Uin__21")) + clientRef.getReferencedUin());
                        return;
                    }
                    String supplierFqn = UinSupport.getFqnByEClassRef(supplierRef.getReferencedUin());
                    if (supplierFqn == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_supplier_for_referenced_Uin__23")) + supplierRef.getReferencedUin());
                        return;
                    }
                    if ("InheritView".equals(petalNodeType)) {
                        viewRef.setReferencedUin(UinSupport.getInheritanceReferencedUin(0, clientFqn, supplierFqn));
                    } else if ("RealizeView".equals(petalNodeType)) {
                        viewRef.setReferencedUin(UinSupport.getInheritanceReferencedUin(1, clientFqn, supplierFqn));
                    } else if ("UsesView".equals(petalNodeType)) {
                        IJavaClassifier clientClassifier = (IJavaClassifier)ViewHandler.this.getSourceModelHandler().execute("get_classifier_by_valid_fqn", clientFqn);
                        IField depField = SourceModelUtil.findCommentedField(clientClassifier, JavaTypes.createTypeReference(supplierFqn), "/*#");
                        if (depField == null) {
                            return;
                        }
                        viewRef.setReferencedUin(UinSupport.getDependencyReferencedUin(clientFqn, depField.getShortName()));
                    }
                }
            }
        };
        if (clientRef != null && clientRef.getReferencedUin() != null && !ViewUtil.isDesignViewRef(clientRef) && supplierRef.getReferencedUin() != null && !ViewUtil.isDesignViewRef(supplierRef)) {
            processSrcLinkView.run();
        } else {
            CommandProcessor.runCommandLater(processSrcLinkView, "onTraverseCompleteSrc");
        }
    }

    protected void handleMessageLinkView(IPetalNode petalNode) {
        IPetalNode label = petalNode.findNodeWithKey("label");
        final String uin = label.getQuidu();
        ILink message_link = TxvAccess.findLink(uin);
        if (message_link == null) {
            return;
        }
        INodeSet nodeSet = (INodeSet)this.getDesignModelHandler().execute("get_current_nodeset", null);
        if (nodeSet != null && nodeSet.getView(0) != null) {
            message_link.setProperty("diagram_uniqe_name", UinSupport.getDesignReferencedUin(nodeSet.getView(0)));
        }
        IViewReference messageLinkViewRef = null;
        if (this.processingSeqDiagram) {
            String tag_of_FoC;
            FocusOfControlProps fOC;
            this.handleLinkView(uin, petalNode);
            messageLinkViewRef = (IViewReference)this.ourViewRefs.get(petalNode.getTag());
            IPetalNode supplier = petalNode.findNodeWithKey("supplier");
            if (supplier == null) {
                Logger.getInstance().log("visitor", 1, Resources.getString("ViewHandler.Cannot_create_view_reference_for_activation_-_parent_is_not_set._28"));
                return;
            }
            String supplierTag = supplier.getType();
            IViewReference supplierRef = (IViewReference)this.ourViewRefs.get(supplierTag);
            INode activation = (INode)this.getDesignModelHandler().execute("get_activation_by_uin", uin);
            String refUin = activation == null ? null : UinSupport.getDesignReferencedUin(activation);
            final IViewReference activationViewRef = TxvAccess.createViewReference(refUin);
            IPetalNode fOCEntryNode = petalNode.findNodeWithKey("Focus_Entry");
            if (fOCEntryNode != null && (fOC = (FocusOfControlProps)this.ourFocusOfControls.get(tag_of_FoC = fOCEntryNode.getValue())) != null) {
                String interactionPrefix = "";
                if (this.processingSeqDiagram) {
                    interactionPrefix = "seq_";
                }
                if (this.processingColDiagram) {
                    interactionPrefix = "col_";
                }
                ViewUtil.setColors(fOC.fillColor, fOC.lineColor, activationViewRef, this.getConfiguration().convertRoseDefaultColors, interactionPrefix);
                if (fOC.height != null) {
                    String tgHeight = ViewUtil.scaleInteger(fOC.height, this.getConfiguration().scaleFactor);
                    messageLinkViewRef.setProperty("processingDuration", tgHeight);
                }
                if (!fOC.isNested) {
                    this.messageLinksWithNotNestedActivation.add(uin);
                }
            }
            supplierRef.addViewReference(activationViewRef);
            Runnable command = new Runnable(){

                public void run() {
                    INode activation = (INode)ViewHandler.this.getDesignModelHandler().execute("get_activation_by_uin", uin);
                    if (activation == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_node_by_Uin__31")) + uin);
                        return;
                    }
                    activationViewRef.setReferencedUin(UinSupport.getDesignReferencedUin(activation));
                }
            };
            if (activation == null) {
                CommandProcessor.runCommandLater(command, "onTxvCreation", uin);
            } else {
                command.run();
            }
        } else if (this.processingColDiagram) {
            ILink messageLink = TxvAccess.findLink(uin);
            if (messageLink == null) {
                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_message_link_by_Uin__33")) + uin);
            } else {
                messageLinkViewRef = TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(messageLink));
                IPetalNode dirNode = petalNode.findNodeWithKey("dir");
                String dir = dirNode.getType();
                IPetalNode object_arcNode = petalNode.findNodeWithKey("object_arc");
                String object_arc = object_arcNode.getType();
                IViewReference messagesLinkViewRef = null;
                messagesLinkViewRef = "1".equals(dir) ? (IViewReference)this.ourViewRefs.get(object_arc) : (IViewReference)this.ourViewRefs.get("-" + object_arc);
                if (messagesLinkViewRef == null) {
                    Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Cannot_find_view_reference_for_parent_of_message_link__37")) + messageLink.getUin());
                } else {
                    messagesLinkViewRef.addViewReference(messageLinkViewRef);
                    messageLinkViewRef.setProperty("processingDuration", "20");
                }
            }
        }
        String seq_number = (String)this.getDesignModelHandler().execute("put_message_link_to_current_diagram", message_link);
        if (this.processingSeqDiagram) {
            IPetalNode origin = petalNode.findNodeWithKey("origin");
            if (origin != null) {
                String origin_y = ViewUtil.getScaledY(origin.getValue(), this.getConfiguration().scaleFactor);
                messageLinkViewRef.setProperty("sendingInstant", origin_y);
            }
        } else if (this.processingColDiagram && seq_number.indexOf(".") == -1) {
            int number = Integer.parseInt(seq_number);
            messageLinkViewRef.setProperty("sendingInstant", String.valueOf(115 + (number - 1) * 25));
        }
    }

    protected void handleMessagesLinkView(IPetalNode node) {
        if (this.processingColDiagram) {
            IPetalNode client = node.findNodeWithKey("client");
            IPetalNode supplier = node.findNodeWithKey("supplier");
            String clientTag = client.getType();
            String supplierTag = supplier.getType();
            String clientUin = UinSupport.getNodeUin(((IViewReference)this.ourViewRefs.get(clientTag)).getReferencedUin());
            String supplierUin = UinSupport.getNodeUin(((IViewReference)this.ourViewRefs.get(supplierTag)).getReferencedUin());
            String key = String.valueOf(clientUin) + "|||" + supplierUin;
            ILink messagesLink = (ILink)this.getDesignModelHandler().execute("get_messages_link", key);
            if (messagesLink != null) {
                if (this.myMessagesLinkViews.get(key) == null) {
                    IViewReference directMessagesLinkViewRef = TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(messagesLink));
                    this.ourViewRefs.put(node.getTag(), directMessagesLinkViewRef);
                    IViewReference clientViewRef = (IViewReference)this.ourViewRefs.get(clientTag);
                    clientViewRef.addViewReference(directMessagesLinkViewRef);
                    this.myMessagesLinkViews.put(key, directMessagesLinkViewRef);
                } else {
                    this.ourViewRefs.put(node.getTag(), this.myMessagesLinkViews.get(key));
                }
            }
            key = String.valueOf(supplierUin) + "|||" + clientUin;
            if (!supplierUin.equals(clientUin)) {
                messagesLink = (ILink)this.getDesignModelHandler().execute("get_messages_link", key);
                if (messagesLink != null) {
                    if (this.myMessagesLinkViews.get(key) == null) {
                        IViewReference undirectMessagesLinkViewRef = TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(messagesLink));
                        this.ourViewRefs.put("-" + node.getTag(), undirectMessagesLinkViewRef);
                        IViewReference supplierViewRef = (IViewReference)this.ourViewRefs.get(supplierTag);
                        supplierViewRef.addViewReference(undirectMessagesLinkViewRef);
                        this.myMessagesLinkViews.put(key, undirectMessagesLinkViewRef);
                    } else {
                        this.ourViewRefs.put("-" + node.getTag(), this.myMessagesLinkViews.get(key));
                    }
                }
            } else {
                this.ourViewRefs.put("-" + node.getTag(), this.ourViewRefs.get(node.getTag()));
            }
        }
    }

    protected void handleSrcElementView(IPetalNode tree) {
        final IViewReference viewRef = TxvAccess.createViewReference();
        INodeSet nodeSet = (INodeSet)this.getDesignModelHandler().execute("get_current_nodeset", null);
        nodeSet.getView(0).addViewReference(viewRef);
        this.ourViewRefs.put(tree.getTag(), viewRef);
        viewRef.setProperty("$shortcutReference", "true");
        viewRef.setProperty("$imported", "");
        ViewUtil.setBounds(tree, viewRef, null, this.getConfiguration().scaleFactor, "", this.getConfiguration().preserveDiagramNodeBounds);
        ViewUtil.setColors(tree, viewRef, this.getConfiguration().convertRoseDefaultColors, "");
        ViewUtil.setFont(tree, viewRef);
        final String realClassifierFqn = SourceModelUtil.convertRoseFqn(tree.getName());
        IClassifier classifier = (IClassifier)this.getSourceModelHandler().execute("get_classifier_by_real_fqn", realClassifierFqn);
        Runnable setReferencedUin = new Runnable(){

            public void run() {
                IClassifier classifier = (IClassifier)ViewHandler.this.getSourceModelHandler().execute("get_classifier_by_real_fqn", realClassifierFqn);
                viewRef.setReferencedUin(UinSupport.getClassifierReferencedUin(SourceModelUtil.convertRoseFqn(classifier.getQualifiedName())));
            }
        };
        if (classifier != null) {
            setReferencedUin.run();
        } else if (tree.getQuidu() != null) {
            CommandProcessor.runCommandLater(setReferencedUin, "onSrcCreation", new QuidAndQName.QUID_CONDITION(tree.getQuidu()));
        }
    }

    protected void handleAssocAttachView(IPetalNode petalNode) {
        if (this.getConfiguration().assClassesAsProperty) {
            return;
        }
        final INodeSet currentNodeSet = (INodeSet)this.getDesignModelHandler().execute("get_current_nodeset", null);
        String clientTag = petalNode.findNodeWithKey("client").getValue();
        String supplierTag = petalNode.findNodeWithKey("supplier").getValue();
        String assClassTag = clientTag;
        IViewReference tempAssClassViewRef1 = (IViewReference)this.ourViewRefs.get(assClassTag);
        if (tempAssClassViewRef1 == null && (tempAssClassViewRef1 = (IViewReference)this.ourViewRefs.get(assClassTag = supplierTag)) == null) {
            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Association_class_view_reference_for_tag__47")) + assClassTag + Resources.getString("ViewHandler._not_found_48"));
            return;
        }
        final IViewReference tempAssClassViewRef = tempAssClassViewRef1;
        Runnable command = new Runnable(){

            public void run() {
                IViewReference assClassViewRef = tempAssClassViewRef;
                IViewReference assAspectViewRef = null;
                if (ViewHandler.this.getConfiguration().generateSource) {
                    String assClassFqn = JavaNames.toJavaClassName(UinSupport.getNodeUin(assClassViewRef.getReferencedUin()));
                    IClassifier assClass = (IClassifier)ViewHandler.this.getSourceModelHandler().execute("get_classifier_by_valid_fqn", assClassFqn);
                    if (assClass == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("ViewHandler.Association_class_for_qualified_name__50")) + assClassFqn + Resources.getString("ViewHandler._not_found_51"));
                        return;
                    }
                    assAspectViewRef = TxvAccess.createViewReference(UinSupport.getReferencedUinForAspect(assClassFqn));
                    IField[] fields = (IField[])ViewHandler.this.getSourceModelHandler().execute("get_fields_for_ass_class", assClassFqn);
                    if (fields != null) {
                        int i = 0;
                        while (i < fields.length) {
                            IViewReference assEndViewRef = TxvAccess.createViewReference(UinSupport.getReferencedUinForAssEnd(fields[i]));
                            assAspectViewRef.addViewReference(assEndViewRef);
                            ++i;
                        }
                    }
                    IViewReference assConnector = TxvAccess.createViewReference(UinSupport.getReferencedUinForConnector(assClassFqn));
                    assClassViewRef.addViewReference(assConnector);
                    currentNodeSet.getView(0).addViewReference(assClassViewRef);
                } else {
                    String assClassQuid = UinSupport.getNodeUin(assClassViewRef.getReferencedUin());
                    INode aspect = (INode)ViewHandler.this.getDesignModelHandler().execute("get_aspect", assClassQuid);
                    assAspectViewRef = TxvAccess.createViewReference(UinSupport.getDesignReferencedUin(aspect));
                }
                assAspectViewRef.setProperty("$shortcutReference", "true");
                String assClassBounds = assClassViewRef.getPropertyValue("bounds");
                if (assClassBounds == null) {
                    assAspectViewRef.setProperty("bounds", "0,0,0,0");
                } else {
                    assAspectViewRef.setProperty("bounds", ViewUtil.subtractBounds(assClassBounds, "0,60,0,0").toString());
                }
                currentNodeSet.getView(0).addViewReference(assAspectViewRef);
            }
        };
        CommandProcessor.runCommandLater(command, "onTraverseCompleteDesign");
    }

    protected void handleAssociationView(IPetalNode petalNode) {
        final String quidu = petalNode.getQuidu();
        String viewTag = petalNode.getTag();
        if (this.getDesignModelHandler().execute("is_link_with_ass_class", new Object[]{quidu, viewTag}) != null) {
            return;
        }
        IPetalNode roleview_list = petalNode.findNodeWithKey("roleview_list");
        if (roleview_list == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("ViewHandler.roleview_list_property_not_found_for_association_link_view__56")) + viewTag);
            return;
        }
        List roleviews = roleview_list.findNodesWithType("RoleView");
        if (roleviews.size() != 2) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("ViewHandler.Number_of_roles_for_association_link_should_be_2,_not__58")) + roleviews.size() + Resources.getString("ViewHandler.._View_tag__59") + viewTag);
            return;
        }
        IPetalNode roleViewA = (IPetalNode)roleviews.get(0);
        IPetalNode roleViewB = (IPetalNode)roleviews.get(1);
        String clientTag = roleViewB.findNodeWithKey("supplier").getValue();
        String supplierTag = roleViewA.findNodeWithKey("supplier").getValue();
        final IViewReference viewRef = TxvAccess.createViewReference();
        this.ourViewRefs.put(viewTag, viewRef);
        ILink linkForView = TxvAccess.findLink(quidu);
        final IViewReference currentClientRef = (IViewReference)this.ourViewRefs.get(clientTag);
        final IViewReference currentSupplierRef = (IViewReference)this.ourViewRefs.get(supplierTag);
        Runnable setClientAndSupplier = new Runnable(){

            public void run() {
                ILink this_linkForView = TxvAccess.findLink(quidu);
                if (currentClientRef == null || currentSupplierRef == null) {
                    Logger.getInstance().log("visitor", 1, Resources.getString("ViewHandler.Cannot_create_view_reference_for_link_-_client_or_supplier_not_found._61"));
                    return;
                }
                if (this_linkForView != null) {
                    viewRef.setReferencedUin(UinSupport.getDesignReferencedUin(this_linkForView));
                } else {
                    String field_name = (String)ViewHandler.this.getSourceModelHandler().execute("get_field_for_ass_link", quidu);
                    if (field_name == null) {
                        return;
                    }
                    String clientFqn = UinSupport.getFqnByEClassRef(currentClientRef.getReferencedUin());
                    viewRef.setReferencedUin(UinSupport.getReferencedUinForAssLink(String.valueOf(clientFqn) + ":" + field_name));
                }
                currentClientRef.addViewReference(viewRef);
            }
        };
        if (linkForView == null) {
            Object field_name = this.getSourceModelHandler().execute("get_field_for_ass_link", quidu);
            if (field_name != null) {
                IViewReference clientRef = (IViewReference)this.ourViewRefs.get(clientTag);
                String clientFqn = UinSupport.getFqnByEClassRef(clientRef.getReferencedUin());
                viewRef.setReferencedUin(UinSupport.getReferencedUinForAssLink(String.valueOf(clientFqn) + ":" + field_name));
                clientRef.addViewReference(viewRef);
            } else {
                CommandProcessor.runCommandLater(setClientAndSupplier, "onTraverseCompleteDesign");
            }
        } else {
            setClientAndSupplier.run();
        }
    }

    protected void createView(IPetalNode node, String metaclass, String name, INodeSet nodeSet) {
        IView view = null;
        String quid = node.getQuid();
        String type = node.getType();
        if (nodeSet.getViewCount() == 0) {
            view = quid == null ? TxvAccess.createView(metaclass) : TxvAccess.createView(quid, metaclass);
            if (!("Package Diagram".equals(metaclass) || "Logical View".equals(name) || "Use Case View".equals(name) || "Component View".equals(name))) {
                view.setProperty("$name", name);
            } else {
                view.setProperty("$defaultDiagram", "true");
            }
            nodeSet.addView(view);
        }
    }

    private SourceModelHandler getSourceModelHandler() {
        return (SourceModelHandler)this.getMediator().getHandler("sourceModel");
    }

    private DesignModelHandler getDesignModelHandler() {
        return (DesignModelHandler)this.getMediator().getHandler("designModel");
    }

    private class FocusOfControlProps {
        String fillColor = null;
        String lineColor = null;
        String height = null;
        boolean isNested = false;

        public FocusOfControlProps(IPetalNode petalNode) {
            IPetalNode fillColorNode = petalNode.findNodeWithKey("fill_color");
            this.fillColor = fillColorNode == null ? null : fillColorNode.getValue();
            IPetalNode lineColorNode = petalNode.findNodeWithKey("line_color");
            this.lineColor = lineColorNode == null ? null : lineColorNode.getValue();
            IPetalNode heightNode = petalNode.findNodeWithKey("height");
            this.height = heightNode == null ? null : heightNode.getValue();
            IPetalNode nestedNode = petalNode.findNodeWithKey("Nested");
            this.isNested = nestedNode != null && "TRUE".equals(nestedNode.getType());
        }
    }
}

