/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.util.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class StubMdlBuilder {
    private List mySubUnits = new ArrayList();
    private static final String PETAL_HEADER = "(object Petal\n\tversion\t47\n\t_written \"Rose 8.0.0303.1400\"\n\tcharSet\t207)\n\n";
    private static final String ROOT_PACKAGE_HEADER = "(object Design \"Logical View\"\n\tlogical_models (list unit_reference_list\n";
    private static final String TAB = "        ";
    private static final String PACKAGE_NAME = "NewPackage";
    private static final String PSEUDO_FILE_NAME = "pseudo";
    private static final String PSEUDO_FILE_EXTENSION = ".mdl";

    public static List getFileNames(File conphig) throws IOException {
        ArrayList<String> fileNames = new ArrayList<String>();
        BufferedReader is = new BufferedReader(new FileReader(conphig));
        String fileName = null;
        while ((fileName = is.readLine()) != null) {
            fileNames.add(fileName);
        }
        is.close();
        return fileNames;
    }

    public static File createPseudoMdlFile(File directory) throws IOException {
        StringBuffer fileNameBuffer = new StringBuffer(directory.getAbsolutePath());
        fileNameBuffer.append("/").append(PSEUDO_FILE_NAME).append("{0}").append(PSEUDO_FILE_EXTENSION);
        String fileName = MessageFormat.format(fileNameBuffer.toString(), "");
        File file = new File(fileName);
        int i = 0;
        while (file.exists()) {
            fileName = MessageFormat.format(fileNameBuffer.toString(), new Integer(++i));
            file = new File(fileName);
        }
        file.createNewFile();
        return file;
    }

    public StubMdlBuilder(File config) throws IOException {
        this.mySubUnits = StubMdlBuilder.getFileNames(config);
    }

    public void write(File file) throws IOException {
        if (this.mySubUnits == null) {
            return;
        }
        FileWriter fw = new FileWriter(file);
        this.writeHeader(fw);
        this.writeRootPackage(fw);
        fw.flush();
        fw.close();
    }

    private void writeHeader(FileWriter fw) throws IOException {
        fw.write(PETAL_HEADER);
    }

    private void writeRootPackage(FileWriter fw) throws IOException {
        fw.write(ROOT_PACKAGE_HEADER);
        this.writePackages(fw);
        fw.write("))\n");
    }

    private void writePackages(FileWriter fw) throws IOException {
        int i = 0;
        while (i < this.mySubUnits.size()) {
            if (!this.subUnitExist(this.mySubUnits.get(i).toString())) {
                Logger.getInstance().log("pseudomdlbuilder", 2, "Subunit " + this.mySubUnits.get(i).toString() + " cannot be found");
            } else {
                StringBuffer buffer = new StringBuffer(TAB);
                buffer.append(TAB).append("(object Class_Category \"");
                buffer.append(PACKAGE_NAME);
                buffer.append(i + 1);
                buffer.append("\"\n");
                buffer.append(TAB).append(TAB).append(TAB).append("is_unit").append(TAB).append("TRUE\n");
                buffer.append(TAB).append(TAB).append(TAB).append("is_loaded").append(TAB).append("FALSE\n");
                buffer.append(TAB).append(TAB).append(TAB).append("file_name").append(TAB).append("\"").append(this.mySubUnits.get(i)).append("\")\n");
                fw.write(buffer.toString());
            }
            ++i;
        }
    }

    private boolean subUnitExist(String fileName) {
        File file = new File(fileName);
        return file.exists() && file.isFile();
    }
}

