/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.codegen.CodeModelFactory;
import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.ICodeModelFactory;
import com.borland.mdlimport.codegen.IComment;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.IInheritanceModel;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.codegen.ModelWriter;
import com.borland.mdlimport.codegen.java.IJavaClassifier;
import com.borland.mdlimport.codegen.java.IJavaFile;
import com.borland.mdlimport.codegen.java.JavaTypes;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.codegen.MethodImpl;
import com.borland.mdlimport.impl.petal.AbstractHandler;
import com.borland.mdlimport.impl.petal.DesignModelHandler;
import com.borland.mdlimport.impl.petal.QuidAndQName;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.mapping.MappingUtil;
import com.borland.mdlimport.mapping.MetaclassMapping;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.IExtractor;
import com.borland.util.IOperation;
import com.borland.util.ITokenizer;
import com.borland.util.JavaNames;
import com.borland.util.Logger;
import com.borland.util.NameUtil;
import com.borland.util.Resources;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.StringTokenizer;

public class SourceModelHandler
extends AbstractHandler {
    public static final String CONFIG = "config";
    public static final String GET_CURRENT_CLASSIFIER = "get_current_classifier";
    public static final String GET_CLASSIFIER_BY_REAL_FQN = "get_classifier_by_real_fqn";
    public static final String GET_CLASSIFIER_BY_VALID_FQN = "get_classifier_by_valid_fqn";
    public static final String GET_FIELDS_FOR_ASS_CLASS = "get_fields_for_ass_class";
    public static final String GET_FIELD_FOR_ASS_LINK = "get_field_for_ass_link";
    public static final String GET_CODE_ELEMENT_BY_QUID = "get_code_element_by_quid";
    public static final String SET_HYPERLINKS_TO_CURRENT_CLASSIFIER = "set_hyperlinks_to_current_classifier";
    public static final String HANDLE_ACTOR = "handle_actor";
    private Map ourSrcElements = new HashMap();
    private ICodeModel myCodeModel;
    private Map myFieldsForAssLinks = new HashMap();
    private Map myFieldsForAssClass = new HashMap();
    private ICodeModelFactory myCodeModelFactory;
    private Stack parentClassifiers = new Stack();
    private IJavaClassifier currentClassifier;
    private HashMap myLostClassifiers;

    public SourceModelHandler(Configuration config) {
        super(config);
        this.myCodeModelFactory = CodeModelFactory.createFactory("Java");
        this.myCodeModel = this.myCodeModelFactory.createModel();
    }

    public void handlePetalNode(IPetalNode petalNode) {
        this.handlePetalNode(petalNode.getQuid(), petalNode);
    }

    public void handlePetalNode(String uin, IPetalNode petalNode) {
        if (!this.getConfiguration().generateSource) {
            return;
        }
        this.parentClassifiers.push(this.currentClassifier);
        String metaclass = MetaclassMapping.getMetaclass(petalNode);
        if (MappingUtil.isSrcElement(metaclass)) {
            this.handleCodeElement(metaclass, petalNode);
        } else if (MappingUtil.isInherLink(metaclass)) {
            this.handleInherLink(metaclass, petalNode);
        } else if (MappingUtil.isDepLink(metaclass)) {
            this.handleDependencyLink(petalNode);
        } else if (!this.getConfiguration().assClassesAsProperty && PetalUtil.isAssLinkWithClass(petalNode)) {
            this.handleAssociationLinkWithClass(petalNode);
        } else if (MappingUtil.isAssLink(metaclass)) {
            this.handleAssociationLink(petalNode);
        }
    }

    public Object execute(String operationCode, Object obj) {
        if (!this.getConfiguration().generateSource) {
            return null;
        }
        if (GET_CURRENT_CLASSIFIER.equals(operationCode)) {
            return this.currentClassifier;
        }
        if (GET_CLASSIFIER_BY_REAL_FQN.equals(operationCode)) {
            return this.myCodeModel.findClassifier((String)obj, false);
        }
        if (GET_CLASSIFIER_BY_VALID_FQN.equals(operationCode)) {
            return this.myCodeModel.findClassifier((String)obj, true);
        }
        if (GET_FIELD_FOR_ASS_LINK.equals(operationCode)) {
            return this.myFieldsForAssLinks.get(obj);
        }
        if (GET_FIELDS_FOR_ASS_CLASS.equals(operationCode)) {
            return this.myFieldsForAssClass.get(obj);
        }
        if (GET_CODE_ELEMENT_BY_QUID.equals(operationCode)) {
            return this.ourSrcElements.get(obj);
        }
        if (SET_HYPERLINKS_TO_CURRENT_CLASSIFIER.endsWith(operationCode)) {
            if (this.currentClassifier == null) {
                return null;
            }
            String projectName = this.getConfiguration().projectName == null ? "PROJECT_NAME" : this.getConfiguration().projectName;
            String hyperlink = String.valueOf(MessageFormat.format("element://model:project::{0}/", projectName)) + obj.toString();
            this.currentClassifier.addTag("@url", hyperlink);
            return null;
        }
        if (HANDLE_ACTOR.equals(operationCode)) {
            this.handleCodeElement("Class", (IPetalNode)obj);
        }
        if ("rollback".equals(operationCode)) {
            this.currentClassifier = this.parentClassifiers.size() == 0 ? null : (IJavaClassifier)this.parentClassifiers.pop();
            return null;
        }
        return null;
    }

    public void finish() {
        if (this.getConfiguration().generateSource) {
            ModelWriter writer = new ModelWriter(this.myCodeModel, this.myCodeModelFactory.createSerializer());
            writer.write(new File(this.getConfiguration().destFolder, this.getConfiguration().srcFolderName));
        }
    }

    protected void handleCodeElement(String metaclass, IPetalNode petalNode) {
        String name = petalNode.getName();
        name = name.replace('\\', '_');
        boolean currentIsActor = (Boolean)this.getDesignModelHandler().execute("current_is_actor", null);
        if (currentIsActor) {
            Logger.getInstance().log("visitor", 1, String.valueOf(metaclass) + " " + petalNode.getName() + " is skipped because actors can not have inner elements.");
            return;
        }
        if ("Class".equals(metaclass)) {
            String javaName = JavaNames.toJavaClassName(name);
            if (this.currentClassifier != null) {
                this.currentClassifier = this.currentClassifier.getInnerClassifier(javaName, name, false, true);
            } else {
                IPackage aPackage = null;
                String currentPath = "" + this.getDesignModelHandler().execute("get_real_current_path", null);
                if (currentPath.length() == 0) {
                    aPackage = this.myCodeModel;
                } else {
                    String package_fqn = currentPath.replace('\\', '.');
                    aPackage = this.myCodeModel.getPackage(package_fqn, true);
                }
                IJavaFile source_file = (IJavaFile)aPackage.getFile(String.valueOf(javaName) + ".java", name, false, true);
                int index = source_file.getShortName().lastIndexOf(46);
                String publicClassName = source_file.getShortName().substring(0, index);
                this.currentClassifier = source_file.getClassifier(publicClassName, name, false, true);
            }
            String stereotype = petalNode.getProperty("stereotype");
            if ("Interface".equalsIgnoreCase(stereotype)) {
                this.currentClassifier.setInterface(true);
            }
            SourceModelUtil.addProperties(this.currentClassifier, "Class", petalNode);
            this.codeElementCreated(this.currentClassifier, petalNode);
        } else if ("Operation".equals(metaclass)) {
            if (this.currentClassifier == null) {
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_classifier_for_operation__12")) + petalNode.getName());
                return;
            }
            String javaName = JavaNames.toJavaMemberName(name);
            IPetalNode parameters = petalNode.findNodeWithKey("parameters");
            final ArrayList methodParams = new ArrayList();
            if (parameters != null) {
                List parameterList = parameters.findNodesWithType("Parameter");
                Iterator iter = parameterList.iterator();
                int paramPos = 0;
                while (iter.hasNext()) {
                    IPetalNode paramNode = (IPetalNode)iter.next();
                    final String paramName = JavaNames.toJavaMemberName(paramNode.getName());
                    if (paramName == null) {
                        ++paramPos;
                        continue;
                    }
                    final Integer paramPosition = new Integer(paramPos);
                    this.setTypeReference(paramNode, "type", new IOperation(){

                        public void run(Object source) {
                            MethodImpl.ParameterImpl parameter = new MethodImpl.ParameterImpl(paramName, (ITypeReference)source, paramPosition);
                            methodParams.add(parameter);
                        }
                    });
                    ++paramPos;
                }
            }
            final IMethod method = this.currentClassifier.addMethod(javaName, name, methodParams);
            this.setTypeReference(petalNode, "result", new IOperation(){

                public void run(Object source) {
                    method.setTypeReference((ITypeReference)source);
                }
            });
            String exceptions = petalNode.getProperty("exceptions");
            if (exceptions != null) {
                StringTokenizer st = new StringTokenizer(exceptions, ",");
                while (st.hasMoreTokens()) {
                    String next = st.nextToken().trim();
                    String[] all = ITokenizer.NAME_AND_QUID.tokens(next);
                    String name1 = all[0];
                    String quid = all[1];
                    this.setTypeReference(name1, quid, new IOperation(){

                        public void run(Object source) {
                            method.addThrowReference((ITypeReference)source);
                        }
                    });
                }
            }
            SourceModelUtil.addProperties(method, "Operation", petalNode);
            this.codeElementCreated(method, petalNode);
        } else if ("Attribute".equals(metaclass)) {
            if (this.currentClassifier == null) {
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_classifier_for_attribute__17")) + petalNode.getName());
                return;
            }
            String javaName = JavaNames.toJavaMemberName(name);
            final IField field = this.currentClassifier.addField(javaName, name, JavaTypes.INT);
            this.setTypeReference(petalNode, "type", new IOperation(){

                public void run(Object source) {
                    field.setTypeReference((ITypeReference)source);
                }
            });
            SourceModelUtil.addProperties(field, "Attribute", petalNode);
            this.codeElementCreated(field, petalNode);
        }
    }

    protected void setTypeReference(IPetalNode petalNode, String petalProperty, IOperation setTypeOperation) {
        String typeName = SourceModelUtil.convertRoseFqn(petalNode.getProperty(petalProperty));
        String typeQuid = petalNode.getQuidu();
        this.setTypeReference(typeName, typeQuid, setTypeOperation);
    }

    protected void setTypeReference(String typeName, final String typeQuid, final IOperation setTypeOperation) {
        IJavaClassifier resultType;
        int arrayDimension = 0;
        String qName = null;
        if (typeName != null) {
            if (JavaTypes.isSimpleType(typeName)) {
                setTypeOperation.run(JavaTypes.createTypeReference(typeName));
                return;
            }
            if (JavaTypes.isJavaLangType(typeName)) {
                setTypeOperation.run(JavaTypes.createJavaLangType(typeName));
                return;
            }
            if (typeName.indexOf(".") != -1) {
                ITypeReference type = JavaTypes.createTypeReference(typeName);
                setTypeOperation.run(type);
                return;
            }
            typeName = JavaNames.toJavaClassName(typeName);
            arrayDimension = JavaTypes.getArrayDimension(typeName);
            typeName = JavaTypes.toSingleTypeName(typeName);
            String packageQName = this.currentClassifier.getPackage().getQualifiedName();
            String string = qName = packageQName.length() > 0 ? String.valueOf(packageQName) + "." + typeName : typeName;
        }
        if (typeName == null && typeQuid == null) {
            return;
        }
        final String _qName = qName;
        final int _arrayDim = arrayDimension;
        final String _typeName = typeName;
        final String curPackageQName = this.currentClassifier.getPackage().getQualifiedName();
        Runnable setTypeCommand = new Runnable(){

            public void run() {
                IJavaClassifier classType;
                IJavaClassifier iJavaClassifier = classType = typeQuid == null ? (IJavaClassifier)SourceModelHandler.this.myCodeModel.findClassifier(_qName, false) : (IJavaClassifier)SourceModelHandler.this.ourSrcElements.get(typeQuid);
                if (classType != null) {
                    setTypeOperation.run(JavaTypes.toArrayType(JavaTypes.createTypeReference(classType.getQualifiedName()), _arrayDim));
                    return;
                }
                if (_typeName == null) {
                    String errMsg = String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_classifier_for__20")) + (typeQuid == null ? "type " + _qName : "quid " + typeQuid);
                    Logger.getInstance().log("visitor", 2, errMsg);
                    return;
                }
                IClassifier foundClassifier = this.findClassifier(_typeName);
                if (foundClassifier == null) {
                    setTypeOperation.run(JavaTypes.toArrayType(JavaTypes.createTypeReference(_typeName), _arrayDim));
                } else {
                    setTypeOperation.run(JavaTypes.toArrayType(JavaTypes.createTypeReference(foundClassifier.getQualifiedName()), _arrayDim));
                }
            }

            public IClassifier findClassifier(String classType) {
                if (SourceModelHandler.this.myLostClassifiers != null && SourceModelHandler.this.myLostClassifiers.containsKey(classType)) {
                    return (IClassifier)SourceModelHandler.this.myLostClassifiers.get(classType);
                }
                Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_classifier_for_type__25")) + _typeName + Resources.getString("SourceModelHandler._in_current_package__26") + curPackageQName + Resources.getString("SourceModelHandler.,_trying_to_find_it_in_model._27"));
                IClassifier found = SourceModelHandler.this.myCodeModel.findChildClassifier(classType, true);
                if (SourceModelHandler.this.myLostClassifiers == null) {
                    SourceModelHandler.this.myLostClassifiers = new HashMap();
                }
                SourceModelHandler.this.myLostClassifiers.put(classType, found);
                return found;
            }
        };
        IJavaClassifier iJavaClassifier = resultType = typeQuid == null ? (IJavaClassifier)this.myCodeModel.findClassifier(qName, false) : (IJavaClassifier)this.ourSrcElements.get(typeQuid);
        if (resultType == null) {
            CommandProcessor.runCommandLater(setTypeCommand, "onTraverseCompleteSrc");
        } else {
            setTypeCommand.run();
        }
    }

    protected void codeElementCreated(ICodeElement codeElement, IPetalNode petalNode) {
        String type = codeElement.getCodeElementType();
        if ("classifier".equals(type) || "method".equals(type)) {
            this.ourSrcElements.put(petalNode.getQuid(), codeElement);
        }
        this.fireSrcElementCreated(codeElement, petalNode);
    }

    protected void handleAssociationLinkWithClass(IPetalNode petalNode) {
        final String assClassFqn = SourceModelUtil.convertRoseFqn(petalNode.getProperty("AssociationClass"));
        final String realAssClassFqn = SourceModelUtil.convertRoseFqn(petalNode.getProperty("AssociationClass"));
        IClassifier assClass = this.myCodeModel.findClassifier(realAssClassFqn, false);
        final Map properties = PetalUtil.getAssociationLinkProps(petalNode);
        Runnable assClassRoutine = new Runnable(){

            public void run() {
                IJavaClassifier assClassDef = (IJavaClassifier)SourceModelHandler.this.myCodeModel.findClassifier(realAssClassFqn, false);
                if (assClassDef == null) {
                    Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_association_class__29")) + assClassFqn);
                    return;
                }
                assClassDef.addTag("@metaclass", "associationClass");
                if (properties == null) {
                    return;
                }
                IPetalNode clientRole = (IPetalNode)properties.get("client_role_node");
                IPetalNode supplierRole = (IPetalNode)properties.get("supplier_role_node");
                String assEnd1Fqn = SourceModelUtil.convertRoseFqn(clientRole.getMultiLinedProperty("supplier"));
                String assEnd2Fqn = SourceModelUtil.convertRoseFqn(supplierRole.getMultiLinedProperty("supplier"));
                IField[] assEnds = new IField[]{SourceModelUtil.createAssEndField(assClassDef, assEnd1Fqn, SourceModelHandler.this.myCodeModel), SourceModelUtil.createAssEndField(assClassDef, assEnd2Fqn, SourceModelHandler.this.myCodeModel)};
                SourceModelHandler.this.myFieldsForAssClass.put(assClassFqn, assEnds);
                SourceModelUtil.setPropertiesForAssLink(assEnds[0], PetalUtil.extractClientAssociationEndProps(properties));
                SourceModelUtil.setPropertiesForAssLink(assEnds[1], PetalUtil.extractSupplierAssociationEndProps(properties));
            }
        };
        if (assClass != null) {
            assClassRoutine.run();
        } else {
            CommandProcessor.runCommandLater(assClassRoutine, "onSrcCreation", new QuidAndQName.QNAME_CONDITION(assClassFqn));
        }
    }

    protected void handleAssociationLink(IPetalNode petalNode) {
        final Map properties = PetalUtil.getAssociationLinkProps(petalNode);
        if (properties == null) {
            return;
        }
        IPetalNode clientRole = (IPetalNode)properties.get("client_role_node");
        properties.remove("client_role_node");
        IPetalNode supplierRole = (IPetalNode)properties.get("supplier_role_node");
        properties.remove("supplier_role_node");
        String clientRoseFqn = clientRole.getMultiLinedProperty("supplier");
        String clientQuid = clientRole.getQuidu();
        if (clientRoseFqn == null) {
            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("SourceModelHandler.Can__t_find_qualified_name_of_association_link_client._Petal_node_Uin__31")) + petalNode.getQuid());
            return;
        }
        final String clientFqn = SourceModelUtil.convertRoseFqn(clientRoseFqn);
        String supplierRoseFqn = supplierRole.getMultiLinedProperty("supplier");
        final String supplierQuid = supplierRole.getQuidu();
        if (supplierRoseFqn == null) {
            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("SourceModelHandler.Can__t_find_qualified_name_of_association_link_supplier._Petal_node__33")) + petalNode.getQuid());
            return;
        }
        final String supplierFqn = SourceModelUtil.convertRoseFqn(supplierRoseFqn);
        final String supplierName = JavaNames.toJavaClassName(SourceModelUtil.getShortName(supplierFqn));
        IClassifier clientClassifier = this.myCodeModel.findClassifier(clientFqn, false);
        final String quid = petalNode.getQuid();
        final String documentation = petalNode.getMultiLinedProperty("documentation");
        Runnable createAssLink = new Runnable(){

            public void run() {
                IJavaClassifier clientClassifier = (IJavaClassifier)SourceModelHandler.this.myCodeModel.findClassifier(clientFqn, false);
                if (clientClassifier == null) {
                    Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("SourceModelHandler.Cannot_find_client_classifier__35")) + clientFqn);
                    return;
                }
                String fieldName = "lnk" + supplierName;
                IField lnkField = clientClassifier.findField(fieldName);
                if (lnkField != null) {
                    String name = NameUtil.newIndexedName(clientClassifier.fields(), fieldName, new IExtractor(this){
                        final /* synthetic */ 7 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Object extract(Object obj) {
                            return ((IField)obj).getShortName();
                        }
                    });
                    lnkField = clientClassifier.addField(name, name, JavaTypes.createTypeReference(supplierFqn));
                } else {
                    lnkField = clientClassifier.addField(fieldName, fieldName, JavaTypes.createTypeReference(supplierFqn));
                }
                IField defLinkField = lnkField;
                IClassifier supplierClassifier = SourceModelHandler.this.myCodeModel.findClassifier(supplierFqn, false);
                Runnable setType = new Runnable(this, supplierFqn, defLinkField){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ String val$supplierFqn;
                    private final /* synthetic */ IField val$defLinkField;
                    {
                        this.this$1 = var1_1;
                        this.val$supplierFqn = string;
                        this.val$defLinkField = iField;
                    }

                    public void run() {
                        IClassifier supplierClassifier = SourceModelHandler.access$0(7.access$0(this.this$1)).findClassifier(this.val$supplierFqn, false);
                        this.val$defLinkField.setTypeReference(JavaTypes.createTypeReference(supplierClassifier.getQualifiedName()));
                    }
                };
                if (supplierClassifier != null) {
                    setType.run();
                } else if (supplierQuid != null) {
                    CommandProcessor.runCommandLater(setType, "onSrcCreation", new QuidAndQName.QUID_CONDITION(supplierQuid));
                }
                SourceModelHandler.this.myFieldsForAssLinks.put(quid, lnkField.getShortName());
                SourceModelUtil.setPropertiesForAssLink(lnkField, properties);
                lnkField.setDescription(documentation);
                IJavaClassifier defClassifier = clientClassifier;
                IField field = lnkField;
                Runnable deleteField = new Runnable(this, defClassifier, field){
                    final /* synthetic */ 7 this$1;
                    private final /* synthetic */ IClassifier val$defClassifier;
                    private final /* synthetic */ IField val$field;
                    {
                        this.this$1 = var1_1;
                        this.val$defClassifier = iClassifier;
                        this.val$field = iField;
                    }

                    public void run() {
                        this.val$defClassifier.removeCodeElement(this.val$field);
                    }
                };
                IIdentifiable obj = TxvAccess.find(supplierQuid);
                if (obj != null) {
                    deleteField.run();
                } else {
                    CommandProcessor.runCommandLater(deleteField, "onTxvCreation", supplierQuid);
                }
            }

            static /* synthetic */ SourceModelHandler access$0(7 var0) {
                return var0.SourceModelHandler.this;
            }
        };
        if (clientClassifier != null) {
            createAssLink.run();
        } else if (clientQuid != null) {
            CommandProcessor.runCommandLater(createAssLink, "onSrcCreation", new QuidAndQName.QUID_CONDITION(clientQuid));
        }
    }

    protected void handleDependencyLink(IPetalNode petalNode) {
        if (this.currentClassifier != null) {
            String supplierFqn = petalNode.getMultiLinedProperty("supplier");
            if (supplierFqn == null) {
                return;
            }
            final String correctSupplierFqn = SourceModelUtil.convertRoseFqn(supplierFqn);
            String prefix = JavaNames.toJavaMemberName("Dependency Link");
            String fieldName = NameUtil.newIndexedName(this.currentClassifier.fields(), prefix, new IExtractor(){

                public Object extract(Object source) {
                    return ((IField)source).getShortName();
                }
            });
            final IField depField = this.currentClassifier.addField(fieldName, fieldName, JavaTypes.INT);
            depField.addTag("@link", "dependency");
            depField.setVisibility("");
            depField.setCommented(true, new IComment(){

                public String getCommentStart() {
                    return "/*#";
                }

                public String getCommentFinish() {
                    return "*/";
                }

                public boolean insertNewLine() {
                    return false;
                }
            });
            SourceModelUtil.addProperties(depField, "Dependency Link", petalNode);
            IClassifier classifier = this.myCodeModel.findClassifier(correctSupplierFqn, false);
            Runnable setTypeRef = new Runnable(){

                public void run() {
                    IClassifier classifier = SourceModelHandler.this.myCodeModel.findClassifier(correctSupplierFqn, false);
                    if (classifier != null) {
                        depField.setTypeReference(JavaTypes.createTypeReference(classifier.getQualifiedName()));
                    }
                }
            };
            if (classifier != null) {
                setTypeRef.run();
            } else if (petalNode.getQuidu() != null) {
                CommandProcessor.runCommandLater(setTypeRef, "onSrcCreation", new QuidAndQName.QUID_CONDITION(petalNode.getQuidu()));
            }
            this.getDesignModelHandler().execute("create_dep_link_for_class_and_package", new Object[]{this.currentClassifier, petalNode, depField});
        }
    }

    protected void handleInherLink(final String metaclass, IPetalNode petalNode) {
        if (this.currentClassifier != null) {
            final boolean isClientInterface = this.currentClassifier.isInterface();
            final int inherKind = "Implementation Link".equals(metaclass) ? 1 : 0;
            final IInheritanceModel inheritance = this.currentClassifier.getInheritanceModel();
            final String supplierFqn = SourceModelUtil.convertRoseFqn(petalNode.getMultiLinedProperty("supplier"));
            IClassifier classifier = this.myCodeModel.findClassifier(supplierFqn, false);
            Runnable setSupplier = new Runnable(){

                public void run() {
                    IJavaClassifier classifier = (IJavaClassifier)SourceModelHandler.this.myCodeModel.findClassifier(supplierFqn, false);
                    if (!isClientInterface && classifier.isInterface() && "Generalization Link".equals(metaclass)) {
                        inheritance.addElement(JavaTypes.createTypeReference(classifier.getQualifiedName()), 1);
                    } else {
                        inheritance.addElement(JavaTypes.createTypeReference(classifier.getQualifiedName()), inherKind);
                    }
                }
            };
            if (classifier != null) {
                setSupplier.run();
            } else if (petalNode.getQuidu() != null) {
                CommandProcessor.runCommandLater(setSupplier, "onSrcCreation", new QuidAndQName.QUID_CONDITION(petalNode.getQuidu()));
            }
        }
    }

    private DesignModelHandler getDesignModelHandler() {
        return (DesignModelHandler)this.getMediator().getHandler("designModel");
    }
}

