/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.AbstractHandler;
import com.borland.mdlimport.impl.petal.DesignModelHandler;
import com.borland.mdlimport.impl.petal.HandlerMediator;
import com.borland.mdlimport.impl.petal.IPetalNodeHandler;
import com.borland.mdlimport.impl.petal.SourceModelHandler;
import com.borland.mdlimport.impl.petal.ViewHandler;
import com.borland.mdlimport.mapping.MappingUtil;
import com.borland.mdlimport.mapping.MetaclassMapping;
import com.borland.mdlimport.petal.IElementListener;
import com.borland.mdlimport.petal.IParser;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.IPetalTreeVisitor;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyVetoException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;

public class PetalVisitor
implements IPetalTreeVisitor {
    private IParser myParser;
    private Configuration myConfiguration;
    private HandlerMediator myMediator = new HandlerMediator();
    private String myErrorMsg;
    private boolean myForceReturn = false;
    private IPetalNode myRoot;
    private Stack usedMechRefStack = new Stack();
    private List currentMechRefs = new ArrayList();

    public PetalVisitor(Configuration config, IParser parser) {
        this.myConfiguration = config;
        this.myParser = parser;
        DesignModelHandler designModelHandler = new DesignModelHandler(this.myConfiguration);
        this.myMediator.registerHandler("designModel", designModelHandler);
        SourceModelHandler sourceModelHandler = new SourceModelHandler(this.myConfiguration);
        this.myMediator.registerHandler("sourceModel", sourceModelHandler);
        ViewHandler viewHandler = new ViewHandler(this.myConfiguration);
        this.myMediator.registerHandler("view", viewHandler);
    }

    public void visitObject(IPetalNode node) throws PropertyVetoException {
        String metaclass = MetaclassMapping.getMetaclass(node);
        if (this.myRoot == null) {
            this.myRoot = node;
        }
        boolean disposeRecursive = false;
        IPetalNodeHandler petalNodeHandler = this.getHandler(node);
        if (petalNodeHandler == null) {
            if (PetalUtil.isInteractionDiagram(node)) {
                Logger.getInstance().log("visitor", String.valueOf(Resources.getString("PetalVisitor.Skipping_interaction_diagram")) + node.getName() + " " + Resources.getString("PetalVisitor.Because_diagram_for_its_mechanism_exists"));
            } else if ("properties".equals(node.getKey())) {
                Logger.getInstance().log("visitor", Resources.getString("PetalVisitor.Skipping___properties___node_2"));
                disposeRecursive = true;
            } else {
                this.visitChildren(node);
            }
        } else {
            petalNodeHandler.handlePetalNode(node);
            this.visitChildren(node);
            petalNodeHandler.execute("rollback", null);
        }
        if (MappingUtil.isPackage(metaclass)) {
            this.currentMechRefs = (List)this.usedMechRefStack.pop();
        }
        if (PetalUtil.isInteractionDiagram(node)) {
            this.getDesignModelHandler().execute("finish_interaction_diagram", null);
        }
        if (this.myRoot.equals(node)) {
            CommandProcessor.notify("onTraverseCompleteSrc", null);
            CommandProcessor.notify("onTraverseCompleteDesign", null);
        }
        node.dispose(disposeRecursive);
        node = null;
    }

    public void finish() {
        Iterator handlers = this.myMediator.handlers();
        while (handlers.hasNext()) {
            ((IPetalNodeHandler)handlers.next()).finish();
        }
    }

    public boolean isSuccessful() {
        return this.myErrorMsg == null;
    }

    public String getErrorMessage() {
        return this.myErrorMsg;
    }

    public void visitChildren(IPetalNode node) throws PropertyVetoException {
        String metaclass = MetaclassMapping.getMetaclass(node);
        if (MappingUtil.isLinkMetaclass(metaclass)) {
            return;
        }
        int i = 0;
        while (i < node.getChildNodes().size()) {
            if (this.myForceReturn) break;
            try {
                this.visitObject((IPetalNode)node.getChildNodes().get(i));
            }
            catch (OutOfMemoryError oom) {
                Logger.getInstance().log("visitor", oom);
                this.myForceReturn = true;
                this.myErrorMsg = oom.getClass().getName();
                break;
            }
            catch (PropertyVetoException th) {
                throw th;
            }
            catch (Throwable th) {
                Logger.getInstance().log("visitor", th);
                this.myErrorMsg = th.getMessage();
            }
            ++i;
        }
    }

    public void addElementListener(IElementListener listener) {
        Iterator handlers = this.myMediator.handlers();
        while (handlers.hasNext()) {
            ((IPetalNodeHandler)handlers.next()).addElementListener(listener);
        }
    }

    public void removeElementListener(IElementListener listener) {
        Iterator handlers = this.myMediator.handlers();
        while (handlers.hasNext()) {
            ((IPetalNodeHandler)handlers.next()).removeElementListener(listener);
        }
    }

    protected IPetalNodeHandler getHandler(IPetalNode node) throws PropertyVetoException {
        String metaclass = MetaclassMapping.getMetaclass(node);
        if (metaclass != null) {
            Object classifier;
            if (PetalUtil.isInteractionDiagram(node)) {
                IPetalNode mech_ref = node.findNodeWithKey("mechanism_ref");
                String mech_tag = mech_ref.getType();
                if (this.currentMechRefs.contains(mech_tag)) {
                    return null;
                }
                this.currentMechRefs.add(mech_tag);
            } else if (MappingUtil.isPackage(metaclass)) {
                this.usedMechRefStack.push(this.currentMechRefs);
                this.currentMechRefs = new ArrayList();
                if (PetalUtil.isSubUnitRef(node)) {
                    this.loadSubUnit(node);
                    return null;
                }
            } else if (MappingUtil.isSrcLink(metaclass) ? (classifier = this.getSourceModelHandler().execute("get_current_classifier", null)) != null : MappingUtil.isSrcElement(metaclass)) {
                return this.getSourceModelHandler();
            }
            return this.getDesignModelHandler();
        }
        if (PetalUtil.isDesignNode(node.getType())) {
            return this.getDesignModelHandler();
        }
        if (PetalUtil.isNodeView(node)) {
            return this.getViewHandler();
        }
        if (PetalUtil.isLinkView(node)) {
            return this.getViewHandler();
        }
        if ("SegLabel".equals(node.getType())) {
            return this.getViewHandler();
        }
        return null;
    }

    protected void loadSubUnit(IPetalNode petalNode) throws PropertyVetoException {
        IPetalNode subUnitTree = PetalUtil.getSubUnitTree(petalNode, this.myParser, this.myConfiguration);
        if (subUnitTree == null) {
            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("PetalVisitor.Cannot_load_sun-unit_for_package__6")) + petalNode.getName());
        } else {
            this.visitObject(subUnitTree);
        }
    }

    protected AbstractHandler getDesignModelHandler() {
        return (DesignModelHandler)this.myMediator.getHandler("designModel");
    }

    protected AbstractHandler getSourceModelHandler() {
        if (!this.myConfiguration.generateSource) {
            return this.getDesignModelHandler();
        }
        return (SourceModelHandler)this.myMediator.getHandler("sourceModel");
    }

    protected ViewHandler getViewHandler() {
        return (ViewHandler)this.myMediator.getHandler("view");
    }
}

