/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.mapping.MetaclassMapping;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.util.Resources;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;

public class PetalNode
implements IPetalNode {
    private static final int CLONE_DEPTH = 1;
    private static int ourCurrentCloneDepth = 0;
    private String myKey;
    private String myValue;
    private IPetalNode myParent;
    private IPetalNode myRoot;
    private List myChildNodes = new ArrayList();
    private int myType;
    private String myId;
    private boolean commit = true;
    private Object myNode;
    private boolean myDisposed = false;
    private boolean isPermitDispose = true;

    public PetalNode(String key, String value, int type) {
        this.myKey = key;
        this.myValue = value;
        this.myType = type;
    }

    public String toString() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_1"));
        }
        StringBuffer result = new StringBuffer();
        result.append("PetalNode [");
        result.append("quid='" + this.getQuid() + "'");
        result.append(", ");
        result.append("quidu='" + this.getQuidu() + "'");
        result.append(", ");
        result.append("key='" + this.myKey + "'");
        result.append(", ");
        result.append("name='" + this.getName() + "'");
        result.append(", ");
        result.append("value='" + this.myValue + "'");
        result.append(", ");
        result.append("type='" + this.getType() + "'");
        result.append("]");
        return result.toString();
    }

    public void dispose(boolean recursive) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_already_disposed_21"));
        }
        if (recursive) {
            int i = 0;
            while (i < this.myChildNodes.size()) {
                ((IPetalNode)this.myChildNodes.get(i)).dispose(true);
                ++i;
            }
        }
        this.myKey = null;
        this.myValue = null;
        this.myDisposed = true;
        this.myParent = null;
        this.myRoot = null;
        this.myId = null;
        this.myNode = null;
        this.myChildNodes.clear();
        this.myChildNodes = null;
    }

    public boolean isDisposed() {
        return this.myDisposed;
    }

    public void setParent(PetalNode parent) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        this.myParent = parent;
    }

    public IPetalNode getParent() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myParent;
    }

    public IPetalNode getRoot() {
        if (this.myRoot == null) {
            IPetalNode nextParent = this.getParent();
            while (nextParent != null) {
                this.myRoot = nextParent;
                nextParent = nextParent.getParent();
            }
        }
        return this.myRoot;
    }

    public String getKey() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myKey;
    }

    public String getType() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return PetalUtil.getType(this.myValue);
    }

    public String getAllValues() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.getAllValues(false);
    }

    public String getAllValues(boolean preserveSpace) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        String line_separator = System.getProperty("line.separator");
        if (this.myType == 1) {
            StringBuffer temp = new StringBuffer();
            int i = 0;
            while (i < this.myChildNodes.size()) {
                PetalNode n = (PetalNode)this.myChildNodes.get(i);
                temp.append(n.getValue());
                if (preserveSpace && i < this.myChildNodes.size() - 1) {
                    temp.append(line_separator);
                }
                ++i;
            }
            return temp.toString();
        }
        return preserveSpace ? PetalUtil.trimQuotes(this.myValue) : this.myValue;
    }

    public String getFilteredValues(String filter) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        if (this.myType == 1) {
            StringBuffer temp = new StringBuffer();
            int i = 0;
            while (i < this.myChildNodes.size()) {
                PetalNode n = (PetalNode)this.myChildNodes.get(i);
                if (i != 0 || !PetalUtil.getWord(n.getValue(), 1).equals(filter)) {
                    temp.append(n.getValue());
                    if (i < this.myChildNodes.size() - 1) {
                        temp.append('\n');
                    }
                }
                ++i;
            }
            return temp.toString();
        }
        String val = PetalUtil.trimQuotes(this.myValue);
        return PetalUtil.getWord(val, 1).equals(filter) ? "" : val;
    }

    public void setValue(String value) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        this.myValue = value;
    }

    public boolean getCommit() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.commit;
    }

    public void setCommit(boolean b) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        this.commit = b;
    }

    public String getId() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myId;
    }

    public String getAtId() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        int ind = this.myValue.lastIndexOf("@");
        return ind == -1 ? null : this.myValue.substring(ind + 1);
    }

    public void setId(String id) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        this.myId = id;
    }

    public int getPetalNodeType() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myType;
    }

    public List getChildNodes() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myChildNodes;
    }

    public void addNode(PetalNode n) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        n.myParent = this;
        this.myChildNodes.add(n);
    }

    public void deleteNode(PetalNode n) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        if (n != null) {
            this.myChildNodes.remove(n);
        }
    }

    public List findNodesWithType(String key) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        ArrayList<IPetalNode> list = new ArrayList<IPetalNode>();
        int i = 0;
        while (i < this.myChildNodes.size()) {
            IPetalNode node = (IPetalNode)this.myChildNodes.get(i);
            if (key.equals(node.getType())) {
                list.add(node);
            }
            ++i;
        }
        return list;
    }

    public IPetalNode findNodeWithKey(String key) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        int i = 0;
        while (i < this.myChildNodes.size()) {
            IPetalNode node = (IPetalNode)this.myChildNodes.get(i);
            if (key.equals(node.getKey())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public IPetalNode findNodeWithType(String key) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        int i = 0;
        while (i < this.myChildNodes.size()) {
            IPetalNode node = (IPetalNode)this.myChildNodes.get(i);
            if (key.equals(node.getType())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public IPetalNode findNodeWithValue(String value) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        int i = 0;
        while (i < this.myChildNodes.size()) {
            IPetalNode node = (IPetalNode)this.myChildNodes.get(i);
            if (value.equals(node.getValue())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public IPetalNode findNodeWithWord(String w) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        int i = 0;
        while (i < this.myChildNodes.size()) {
            IPetalNode node = (IPetalNode)this.myChildNodes.get(i);
            StringTokenizer st = new StringTokenizer(node.getValue());
            while (st.hasMoreTokens()) {
                String tok = st.nextToken();
                if (!tok.equals(w)) continue;
                return node;
            }
            ++i;
        }
        return null;
    }

    public String getQuid() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.getProperty("quid");
    }

    public String getQuidu() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.getProperty("quidu");
    }

    public String getRoseSupplier() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        IPetalNode node = this.findNodeWithKey("supplier");
        return node == null ? null : PetalUtil.trimQuotes(node.getValue());
    }

    public void setNode(Object node) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        this.myNode = node;
    }

    public Object getNode() {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        return this.myNode;
    }

    public String getStereotype() {
        String attributeValue = this.getAttributeValue("stereotype");
        return attributeValue;
    }

    public boolean isDerived() {
        String attributeValue = this.getAttributeValue("derived");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isAbstract() {
        String attributeValue = this.getAttributeValue("abstract");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isNavigable() {
        String attributeValue = this.getAttributeValue("is_navigable");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isAggregate() {
        String attributeValue = this.getAttributeValue("is_aggregate");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public String getContainment() {
        return this.getAttributeValue("Containment");
    }

    public String getConstraints() {
        return this.getAttributeValue("Constraints");
    }

    public String getResult() {
        return this.getAttributeValue("result");
    }

    public String getInitV() {
        return this.getAttributeValue("initv");
    }

    public String getDocumentation() {
        return this.getAttributeValue("documentation");
    }

    public boolean isLoaded() {
        String attributeValue = this.getAttributeValue("is_loaded");
        return attributeValue == null || "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isTransient() {
        String attributeValue = this.getAttributeValue("Ecore", "isTransient");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isVolatile() {
        String attributeValue = this.getAttributeValue("Ecore", "isVolatile");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isChangeable() {
        String attributeValue = this.getAttributeValue("Ecore", "isChangeable");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public boolean isResolveProxies() {
        String attributeValue = this.getAttributeValue("Ecore", "isResolveProxies");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public boolean isUnsettable() {
        String attributeValue = this.getAttributeValue("Ecore", "isUnsettable");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isID() {
        String attributeValue = this.getAttributeValue("Ecore", "isID");
        return "true".equalsIgnoreCase(attributeValue);
    }

    public boolean isUnique() {
        String attributeValue = this.getAttributeValue("Ecore", "isUnique");
        return !"false".equalsIgnoreCase(attributeValue);
    }

    public String getBasePackage() {
        return this.getAttributeValue("Ecore", "basePackage");
    }

    public String getPrefix() {
        return this.getAttributeValue("Ecore", "prefix");
    }

    public String getPackageName() {
        return this.getAttributeValue("Ecore", "packageName");
    }

    public String getClassifierName() {
        return this.getAttributeValue("Ecore", "classifierName");
    }

    public String getReferenceName() {
        return this.getAttributeValue("Ecore", "referenceName");
    }

    public String getAttributeName() {
        return this.getAttributeValue("Ecore", "attributeName");
    }

    public String getOperationName() {
        return this.getAttributeValue("Ecore", "operationName");
    }

    public String getNsPrefix() {
        String attributeValue = this.getAttributeValue("Ecore", "nsPrefix");
        if (attributeValue == null || attributeValue.length() == 0) {
            attributeValue = this.getAttributeValue("Ecore", "nsName");
        }
        return attributeValue;
    }

    public String getNsURI() {
        return this.getAttributeValue("Ecore", "nsURI");
    }

    protected String getAttributeValue(String key) {
        if (this.isDisposed()) {
            throw new RuntimeException(Resources.getString("PetalNode.Petal_node_is_disposed_22"));
        }
        Iterator i = this.getChildNodes().iterator();
        while (i.hasNext()) {
            PetalNode roseNode = (PetalNode)i.next();
            if (roseNode.getPetalNodeType() == 0) {
                String nodeKey = roseNode.getKey();
                String nodeValue = roseNode.getValue();
                if (!nodeKey.equals(key)) continue;
                nodeValue = PetalNode.dequote(nodeValue);
                return nodeValue;
            }
            if (roseNode.getPetalNodeType() != 1 || !roseNode.getKey().equals(key)) continue;
            List subNodes = roseNode.getChildNodes();
            StringBuffer result = new StringBuffer();
            Iterator j = subNodes.iterator();
            while (j.hasNext()) {
                PetalNode subNode = (PetalNode)j.next();
                if (subNode.getPetalNodeType() != 0) continue;
                if (subNode.getValue().equals("")) {
                    result.append(" ");
                    continue;
                }
                if (result.length() != 0) {
                    result.append(" ");
                }
                result.append(subNode.getValue());
            }
            return result.toString();
        }
        return null;
    }

    protected String getAttributeValue(String tool, String name) {
        String result = this.basicGetAttributeValue(tool, name);
        if (result == null && "Ecore".equals(tool)) {
            result = this.basicGetAttributeValue("eCore", name);
        }
        return result;
    }

    protected String basicGetAttributeValue(String tool, String name) {
        IPetalNode attributeListNode = this.findNodeWithKey("attributes");
        String value = this.getAttributeValueInAttributeList(attributeListNode, tool, name);
        if (value == null) {
            value = this.getAttributeValueInAttributeList(this.getDefaultAttributeList(tool), tool, name);
        }
        return value;
    }

    private String getAttributeValueInAttributeList(IPetalNode attributeListNode, String tool, String name) {
        List attributeNodes;
        if (attributeListNode != null && (attributeNodes = attributeListNode.getChildNodes()) != null) {
            Iterator i = attributeNodes.iterator();
            while (i.hasNext()) {
                PetalNode attributeNode = (PetalNode)i.next();
                List nodes = attributeNode.getChildNodes();
                if (nodes == null) continue;
                String setName = "";
                String tagName = "";
                String valueName = "";
                Iterator j = nodes.iterator();
                while (j.hasNext()) {
                    List stringNodes;
                    PetalNode node = (PetalNode)j.next();
                    if (node.getPetalNodeType() == 0) {
                        String stringV = PetalNode.dequote(node.getValue());
                        if (node.getKey().equals("tool")) {
                            setName = stringV;
                            continue;
                        }
                        if (node.getKey().equals("name")) {
                            tagName = stringV;
                            continue;
                        }
                        if (!node.getKey().equals("value")) continue;
                        valueName = stringV;
                        continue;
                    }
                    if (node.getPetalNodeType() != 4 || (stringNodes = node.getChildNodes()) == null || stringNodes.size() != 1) continue;
                    PetalNode stringNode = (PetalNode)stringNodes.get(0);
                    String stringV = PetalNode.dequote(stringNode.getValue());
                    if (node.getKey().equals("tool")) {
                        setName = stringV;
                        continue;
                    }
                    if (node.getKey().equals("name")) {
                        tagName = stringV;
                        continue;
                    }
                    if (!node.getKey().equals("value")) continue;
                    valueName = stringV;
                }
                if (!setName.equals(tool) || !tagName.equals(name)) continue;
                return valueName;
            }
        }
        return null;
    }

    public IPetalNode getDefaultAttributeList(String tool) {
        IPetalNode attributeListNode = null;
        PetalNode rootNode = (PetalNode)this.getRoot();
        String rootNodeValue = rootNode.getValue();
        String rootObjectType = PetalUtil.getType(rootNodeValue);
        if (rootObjectType.equals("Design")) {
            String objectType = PetalUtil.getType(this.getValue());
            IPetalNode defaultProperties = rootNode.findNodeWithKey("properties");
            if (defaultProperties != null) {
                IPetalNode attributes = defaultProperties.findNodeWithKey("attributes");
                Iterator i = attributes.getChildNodes().iterator();
                while (i.hasNext()) {
                    PetalNode attribute = (PetalNode)i.next();
                    IPetalNode toolNode = attribute.findNodeWithKey("tool");
                    if (toolNode == null || !PetalUtil.trimQuotes(toolNode.getValue()).equals(tool)) continue;
                    IPetalNode nameNode = attribute.findNodeWithKey("name");
                    String theName = PetalUtil.trimQuotes(nameNode.getValue());
                    if (objectType.equals("ClassAttribute") && theName.equals("default__Attribute")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Class") && theName.equals("default__Class")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Class_Category") && theName.equals("default__Category")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (objectType.equals("Operation") && theName.equals("default__Operation")) {
                        attributeListNode = attribute.findNodeWithKey("value");
                        break;
                    }
                    if (!objectType.equals("Role") || !theName.equals("default__Role")) continue;
                    attributeListNode = attribute.findNodeWithKey("value");
                    break;
                }
            }
        }
        return attributeListNode;
    }

    public String getRoleMultiplicity() {
        List nodes = this.getChildNodes();
        int i = 0;
        while (i < nodes.size()) {
            PetalNode node = (PetalNode)nodes.get(i);
            if (node.getPetalNodeType() == 4) {
                String objKey = node.getKey();
                String objType = PetalUtil.getType(node.getValue());
                if (objKey.equals("client_cardinality") && objType.equals("cardinality")) {
                    List subNodes = node.getChildNodes();
                    String value = "";
                    int j = 0;
                    while (j < subNodes.size()) {
                        PetalNode subNode = (PetalNode)subNodes.get(j);
                        if (subNode.getPetalNodeType() == 0) {
                            value = subNode.getValue();
                            value = value.substring(1, value.length() - 1);
                        } else if (subNode.getPetalNodeType() == 1) {
                            List subSubNodes = subNode.getChildNodes();
                            int k = 0;
                            while (k < subSubNodes.size()) {
                                PetalNode subSubNode = (PetalNode)subSubNodes.get(k);
                                if (subSubNode.getPetalNodeType() == 0) {
                                    value = String.valueOf(subSubNode.getValue()) + "|#" + value;
                                }
                                ++k;
                            }
                        }
                        ++j;
                    }
                    return value;
                }
            }
            ++i;
        }
        return null;
    }

    private static String dequote(String s) {
        if (s != null && s.length() >= 2 && s.charAt(0) == '\"' && s.charAt(s.length() - 1) == '\"') {
            s = s.substring(1, s.length() - 1);
            int i = s.indexOf("\\\\");
            while (i != -1) {
                s = String.valueOf(s.substring(0, i)) + s.substring(i + 1, s.length());
                i = s.indexOf("\\\\");
            }
        }
        return s;
    }

    public IPetalNode getParentPackage() {
        IPetalNode parent = this.getParent();
        while (parent != null) {
            String metaclass = MetaclassMapping.getMetaclass(parent);
            if (metaclass != null) {
                if ("Logical View".equals(parent.getName()) || "Use Case View".equals(parent.getName()) || "Component View".equals(parent.getName())) {
                    return null;
                }
                if ("Package".equals(metaclass)) {
                    return parent;
                }
                if ("Subsystem".equals(metaclass)) {
                    return parent;
                }
            }
            parent = parent.getParent();
        }
        return null;
    }

    public String getValue() {
        return this.myValue;
    }

    public String getName() {
        return PetalUtil.getName(this.myValue);
    }

    public String getProperty(String name) {
        IPetalNode property = this.findNodeWithKey(name);
        return property == null ? null : property.getName();
    }

    public String getMultiLinedProperty(String name) {
        IPetalNode property = this.findNodeWithKey(name);
        if (property == null) {
            return null;
        }
        if (property.getPetalNodeType() == 0) {
            return PetalUtil.excludeIncorrectChars(property.getName());
        }
        if (property.getPetalNodeType() == 1) {
            return PetalUtil.excludeIncorrectChars(property.getAllValues(true));
        }
        return null;
    }

    public String getTag() {
        String value = this.getValue();
        int index = value.lastIndexOf(" ");
        return index > 0 ? value.substring(index + 1) : null;
    }

    public String getInnerAttributeType(String tool, String name) {
        if (tool == null || name == null) {
            return null;
        }
        IPetalNode attrs = this.findNodeWithKey("attributes");
        if (attrs != null) {
            Iterator iter = attrs.getChildNodes().iterator();
            while (iter.hasNext()) {
                String nameValue;
                IPetalNode attribute = (IPetalNode)iter.next();
                String toolValue = attribute.getProperty("tool");
                if (!tool.equals(toolValue) || !name.equals(nameValue = attribute.getProperty("name"))) continue;
                IPetalNode value = attribute.findNodeWithKey("value");
                return value.getType();
            }
        }
        return null;
    }

    public String getInnerAttributeValue(String tool, String name) {
        if (tool == null || name == null) {
            return null;
        }
        IPetalNode attrs = this.findNodeWithKey("attributes");
        if (attrs != null) {
            Iterator iter = attrs.getChildNodes().iterator();
            while (iter.hasNext()) {
                String nameValue;
                IPetalNode attribute = (IPetalNode)iter.next();
                String toolValue = attribute.getProperty("tool");
                if (!tool.equals(toolValue) || !name.equals(nameValue = attribute.getProperty("name"))) continue;
                IPetalNode value = attribute.findNodeWithKey("value");
                return value.getValue();
            }
        }
        return null;
    }

    public String getInnerAttributeName(String tool, String name) {
        if (tool == null || name == null) {
            return null;
        }
        IPetalNode attrs = this.findNodeWithKey("attributes");
        if (attrs != null) {
            Iterator iter = attrs.getChildNodes().iterator();
            while (iter.hasNext()) {
                String nameValue;
                IPetalNode attribute = (IPetalNode)iter.next();
                String toolValue = attribute.getProperty("tool");
                if (!tool.equals(toolValue) || !name.equals(nameValue = attribute.getProperty("name"))) continue;
                IPetalNode value = attribute.findNodeWithKey("value");
                return value.getName();
            }
        }
        return null;
    }

    public void permitDispose(boolean permit) {
    }
}

