/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.QuidAndQName;
import com.borland.mdlimport.impl.petal.SourceModelHandler;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.mapping.IPropertyProvider;
import com.borland.mdlimport.mapping.IProviderEnumeration;
import com.borland.mdlimport.mapping.PropertyMapping;
import com.borland.mdlimport.mapping.UinSupport;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.txv.IConfigurable;
import com.borland.mdlimport.txv.IElement;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeContainer;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.File;
import com.borland.util.IExtractor;
import com.borland.util.IProperty;
import com.borland.util.NameUtil;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DesignModelUtil {
    public static String getCorrectFqnForType(String elementFqn, String typeFqn) {
        String elementPackageName = "";
        String typePackageName = "";
        int indexOfDot1 = elementFqn.lastIndexOf(46);
        int indexOfDot2 = typeFqn.lastIndexOf(46);
        if (indexOfDot1 != -1 && indexOfDot2 != -1 && (elementPackageName = elementFqn.substring(0, indexOfDot1)).equals(typePackageName = typeFqn.substring(0, indexOfDot2))) {
            return typeFqn.substring(indexOfDot2 + 1);
        }
        return typeFqn;
    }

    public static String pathToPackageName(String path) {
        if (path == null) {
            return null;
        }
        char[] chars = path.toCharArray();
        int i = 0;
        while (i < chars.length) {
            if (chars[i] == File.separatorChar) {
                chars[i] = 46;
                if (i == 0) {
                    chars[0] = 32;
                }
            }
            ++i;
        }
        return new String(chars).trim();
    }

    public static String getFqn(INode classifier) {
        StringBuffer fqn = new StringBuffer();
        if ("Class".equals(classifier.getMetaclass())) {
            fqn.append(classifier.getName());
            IIdentifiable objParent = classifier.getParent();
            while (objParent != null && objParent instanceof INode) {
                fqn.insert(0, ".").insert(0, ((INode)objParent).getName());
                objParent = ((INode)objParent).getParent();
            }
            if (objParent instanceof INodeSet && ((INodeSet)objParent).getPackage().length() > 0) {
                fqn.insert(0, ".").insert(0, ((INodeSet)objParent).getPackage());
            }
        }
        return fqn.toString();
    }

    public static void connectMethodToMessageLink(ILink messageLink, IMethod method) {
        ILink depLink = TxvAccess.createLink("Dependency Link", "Dependency Link");
        messageLink.addLink(depLink);
        depLink.setClient(UinSupport.getDesignReferencedUin(messageLink));
        depLink.setSupplier(UinSupport.getSourceReferencedUin(method));
        IClassifier classifier = method.getClassifier();
        messageLink.setProperty("operationDeclaringClass", classifier.getQualifiedName());
        messageLink.setProperty("operationName", method.getShortName());
        messageLink.setProperty("operationSignature", SourceModelUtil.getOperationSignatureProp(method));
    }

    public static void setInstantiesProperty(IPetalNode petalNode, INode object, boolean genSource, final SourceModelHandler sourceHandler) {
        String classFqn = petalNode.getProperty("class");
        if (classFqn == null) {
            return;
        }
        final String correctFqn = SourceModelUtil.convertRoseFqn(classFqn);
        final ILink depLink = TxvAccess.createLink("Dependency Link", DesignModelUtil.newIndexedName(object, "Dependency Link"));
        object.addLink(depLink);
        depLink.setClient(UinSupport.getDesignReferencedUin(object));
        if (genSource) {
            ICodeElement classifier = (ICodeElement)sourceHandler.execute("get_classifier_by_real_fqn", correctFqn);
            Runnable setSupplier = new Runnable(){

                public void run() {
                    ICodeElement classifier = (ICodeElement)sourceHandler.execute("get_classifier_by_real_fqn", correctFqn);
                    if (classifier != null) {
                        depLink.setSupplier(UinSupport.getReferencedUinByFqn(classifier.getQualifiedName()));
                    }
                }
            };
            if (classifier != null) {
                setSupplier.run();
            } else if (petalNode.getQuidu() != null) {
                CommandProcessor.runCommandLater(setSupplier, "onSrcCreation", new QuidAndQName.QUID_CONDITION(petalNode.getQuidu()));
            }
        } else {
            final String quidu = petalNode.getQuidu();
            IIdentifiable element = TxvAccess.find(quidu);
            if (element == null) {
                Runnable operation = new Runnable(){

                    public void run() {
                        IIdentifiable element = TxvAccess.find(quidu);
                        depLink.setSupplier(UinSupport.getDesignReferencedUin(element));
                    }
                };
                CommandProcessor.runCommandLater(operation, "onTxvCreation", quidu);
            } else {
                depLink.setSupplier(UinSupport.getDesignReferencedUin(element));
            }
        }
    }

    public static void addProperties(IConfigurable element, String metaclass, IPetalNode tree) {
        IProviderEnumeration providers = PropertyMapping.getApplicableProviders(metaclass);
        while (providers.hasMoreElements()) {
            String[] propertyNames;
            IPropertyProvider nextProvider = providers.next();
            IProperty[] properties = nextProvider.evaluatePropertyValues(metaclass, propertyNames = nextProvider.getSupportedProperties(), tree);
            if (properties == null) continue;
            int i = 0;
            while (i < properties.length) {
                if (properties[i] != null) {
                    if (properties[i].isMultiple()) {
                        String[] values = properties[i].getValues();
                        if (values != null) {
                            int j = 0;
                            while (j < values.length) {
                                String value = values[j];
                                if (DesignModelUtil.canAddProperty(element, properties[i].getName(), value)) {
                                    element.addProperty(properties[i].getName(), value);
                                }
                                ++j;
                            }
                        }
                    } else {
                        String value = properties[i].getValue();
                        if (value != null) {
                            element.setProperty(properties[i].getName(), value);
                        }
                    }
                }
                ++i;
            }
        }
    }

    protected static boolean canAddProperty(IConfigurable element, String propertyName, String propertyValue) {
        String[] propertyValues;
        IProperty property;
        boolean result = true;
        if ("@url".equals(propertyName) && propertyValue != null && (property = element.getProperty("@url")) != null && (propertyValues = property.getValues()) != null) {
            int i = 0;
            while (i < propertyValues.length && result) {
                result = !propertyValue.equals(propertyValues[i]);
                ++i;
            }
        }
        return result;
    }

    public static void setPropertiesForAssLink(ILink link, Map properties) {
        Set keys = properties.keySet();
        Iterator iter = keys.iterator();
        while (iter.hasNext()) {
            String propName = "" + iter.next();
            Object value = properties.get(propName);
            if (value == null) continue;
            if (value instanceof List) {
                Iterator list_prop_iter = ((List)value).iterator();
                while (list_prop_iter.hasNext()) {
                    link.addProperty(propName, "" + list_prop_iter.next());
                }
                continue;
            }
            link.setProperty(propName, "" + value);
        }
    }

    public static String newIndexedName(INodeContainer nodeContainer, String prefix, final String metaclass) {
        return NameUtil.newIndexedName(nodeContainer.getChildNodes(), prefix, new IExtractor(){

            public Object extract(Object obj) {
                String objectMetaclass = ((INode)obj).getMetaclass();
                if (metaclass.equals(objectMetaclass)) {
                    return ((INode)obj).getName();
                }
                return null;
            }
        });
    }

    public static String newIndexedName(INodeContainer nodeContainer, final String metaclass) {
        return NameUtil.newIndexedName(nodeContainer.getChildNodes(), metaclass, new IExtractor(){

            public Object extract(Object obj) {
                String objectMetaclass = ((INode)obj).getMetaclass();
                if (metaclass.equals(objectMetaclass)) {
                    return ((INode)obj).getName();
                }
                return null;
            }
        });
    }

    public static String newElementName(IElement client, String name, String metaclass) {
        if (client != null && (name == null || name.length() == 0) && client instanceof INodeContainer) {
            name = DesignModelUtil.newIndexedName((INodeContainer)((Object)client), metaclass);
        }
        return name;
    }

    public static ILink findLink(INode container, String metaclass, String propName, String propValue) {
        int linkCount = container.getLinkCount();
        ArrayList<ILink> inherLinks = new ArrayList<ILink>();
        int i = 0;
        while (i < linkCount) {
            ILink link = container.getLink(i);
            String thisMetaclass = link.getMetaclass();
            if (thisMetaclass.equals(metaclass) && propValue.equalsIgnoreCase(link.getPropertyValue(propName))) {
                return link;
            }
            if (thisMetaclass.equals("Generalization Link") || thisMetaclass.equals("Implementation Link")) {
                inherLinks.add(link);
            }
            ++i;
        }
        Iterator iter = inherLinks.iterator();
        while (iter.hasNext()) {
            String uin;
            ILink link;
            ILink inherLink = (ILink)iter.next();
            if (inherLink.getSupplier() == null || (link = DesignModelUtil.findLink((INode)TxvAccess.find(uin = UinSupport.getNodeUin(inherLink.getSupplier().getReferencedUin())), metaclass, propName, propValue)) == null) continue;
            return link;
        }
        return null;
    }
}

