/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IParameter;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.AbstractHandler;
import com.borland.mdlimport.impl.petal.DesignModelUtil;
import com.borland.mdlimport.impl.petal.SourceModelHandler;
import com.borland.mdlimport.impl.petal.SourceModelUtil;
import com.borland.mdlimport.impl.petal.ViewHandler;
import com.borland.mdlimport.mapping.MappingUtil;
import com.borland.mdlimport.mapping.MetaclassMapping;
import com.borland.mdlimport.mapping.UinSupport;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.PetalUtil;
import com.borland.mdlimport.txv.IConfigurable;
import com.borland.mdlimport.txv.IElement;
import com.borland.mdlimport.txv.IIdentifiable;
import com.borland.mdlimport.txv.ILink;
import com.borland.mdlimport.txv.ILinkContainer;
import com.borland.mdlimport.txv.INode;
import com.borland.mdlimport.txv.INodeContainer;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.IView;
import com.borland.mdlimport.txv.IViewReference;
import com.borland.mdlimport.txv.TXVUtil;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.JavaNames;
import com.borland.util.Logger;
import com.borland.util.NameUtil;
import com.borland.util.Resources;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.StringTokenizer;
import java.util.Vector;

public class DesignModelHandler
extends AbstractHandler {
    private INodeSet packageNodeSet;
    private INodeSet packageViewNodeSet;
    public static final String FINISH_INTERACTION_DIAGRAM = "finish_interaction_diagram";
    public static final String GET_ACTIVATION_BY_UIN = "get_activation_by_uin";
    public static final String GET_CURRENT_NODESET = "get_current_nodeset";
    public static final String GET_CURRENT_NODE = "get_current_node";
    public static final String GET_MESSAGES_LINK = "get_messages_link";
    public static final String PUT_MESSAGE_LINK_TO_CURRENT_DIAGRAM = "put_message_link_to_current_diagram";
    public static final String GET_CURRENT_PATH = "get_current_path";
    public static final String GET_REAL_CURRENT_PATH = "get_real_current_path";
    public static final String GET_ASPECT = "get_aspect";
    public static final String IS_LINK_WITH_ASS_CLASS = "is_link_with_ass_class";
    public static final String CREATE_DEP_LINK_FOR_CLASS_AND_PACKAGE = "create_dep_link_for_class_and_package";
    public static final String CURRENT_IS_ACTOR = "current_is_actor";
    private String currentPath = "";
    private String currentRealPath = "";
    private INode currentNode = null;
    private Stack states = new Stack();
    private INodeSet nodeSet;
    private String mySupplierObjectQuid;
    private HashMap ourMessageLinks = new HashMap();
    private HashMap ourMessagesLinks = new HashMap();
    private HashMap ourActivations = new HashMap();
    private HashMap currentDiagramMessageLinks = new HashMap();
    private ArrayList ourObjectsWithDestruction = new ArrayList();
    private Map ourLinksWithAssClass = new HashMap();
    private Map ourReturnLinks = new HashMap();
    private Map ourAspects = new HashMap();
    private Map currentMessagesLinkMessages = new HashMap();
    private Map changedPackageNames = new HashMap();

    public DesignModelHandler(Configuration config) {
        super(config);
    }

    public void handlePetalNode(IPetalNode node) {
        this.handlePetalNode(node.getQuid(), node);
    }

    public void handlePetalNode(String uin, IPetalNode petalNode) {
        this.states.push(new State(this.currentPath, this.currentRealPath, this.currentNode, this.packageNodeSet, this.packageViewNodeSet));
        String metaclass = MetaclassMapping.getMetaclass(petalNode);
        if (metaclass != null) {
            if (MappingUtil.isPackage(metaclass)) {
                this.handlePackage(petalNode, "Subsystem".equals(metaclass));
            } else if ("Object".equals(metaclass)) {
                this.createNode(metaclass, petalNode, false);
            } else if ("Return Link".equals(metaclass)) {
                this.handleReturnLink(petalNode);
            } else if ("Message Link".equals(metaclass)) {
                this.handleMessageLink(petalNode);
            } else if ("Messages Link".equals(metaclass)) {
                this.mySupplierObjectQuid = petalNode.getQuidu();
                this.currentMessagesLinkMessages.clear();
                this.currentMessagesLinkMessages = new HashMap();
                this.handleAssociationLinkOnCollDiagrams(petalNode);
            } else if ("Association Link".equals(metaclass)) {
                this.handleAssociationLink(petalNode);
            } else if (MappingUtil.isDiagramMetaclass(metaclass)) {
                this.nodeSet = this.createNodeSet(metaclass, petalNode);
            } else if (MappingUtil.isLinkMetaclass(metaclass)) {
                this.createLink(metaclass, petalNode);
            } else if ("Note".equals(metaclass)) {
                this.handleNote(petalNode);
            } else if ("Note Link".equals(metaclass)) {
                this.handleNoteLink(petalNode);
            } else {
                if ("mod_shapeParameter".equals(metaclass) && this.getConfiguration().generateSource) {
                    return;
                }
                this.createNode(metaclass, petalNode, false);
            }
        } else if ("Destruction_Marker".equals(petalNode.getType())) {
            this.handleDestructionMarker(petalNode);
        }
    }

    public Object execute(String operationCode, Object obj) {
        if (CURRENT_IS_ACTOR.equals(operationCode)) {
            return new Boolean(this.currentIsActor());
        }
        if (GET_ASPECT.equals(operationCode)) {
            return this.ourAspects.get(obj);
        }
        if (GET_CURRENT_NODE.equals(operationCode)) {
            return this.currentNode;
        }
        if (GET_CURRENT_NODESET.equals(operationCode)) {
            return this.nodeSet;
        }
        if (GET_CURRENT_PATH.equals(operationCode)) {
            return this.currentPath;
        }
        if (GET_REAL_CURRENT_PATH.equals(operationCode)) {
            return this.currentRealPath;
        }
        if (GET_ACTIVATION_BY_UIN.equals(operationCode)) {
            return this.ourActivations.get(obj);
        }
        if (GET_MESSAGES_LINK.equals(operationCode)) {
            return this.ourMessagesLinks.get(obj);
        }
        if (IS_LINK_WITH_ASS_CLASS.equals(operationCode)) {
            Object[] params = (Object[])obj;
            if (params.length != 2) {
                return null;
            }
            if (this.ourLinksWithAssClass.keySet().contains(params[0])) {
                return Boolean.TRUE;
            }
            return null;
        }
        if (CREATE_DEP_LINK_FOR_CLASS_AND_PACKAGE.equals(operationCode)) {
            if (obj == null) {
                return null;
            }
            Object[] params = (Object[])obj;
            IClassifier classifier = (IClassifier)params[0];
            IPetalNode petalNode = (IPetalNode)params[1];
            IField field = (IField)params[2];
            this.handleDependencyLink(classifier, petalNode, field);
            return null;
        }
        if (PUT_MESSAGE_LINK_TO_CURRENT_DIAGRAM.equals(operationCode)) {
            if (obj == null) {
                return null;
            }
            String seq_number = (String)this.ourMessageLinks.get(((ILink)obj).getUin());
            this.currentDiagramMessageLinks.put(seq_number, obj);
            return seq_number;
        }
        if ("rollback".equals(operationCode)) {
            if (this.states.size() == 0) {
                this.currentPath = "";
                this.currentRealPath = "";
                this.currentNode = null;
                this.packageNodeSet = null;
            } else {
                State oldState = (State)this.states.pop();
                this.currentPath = oldState.path;
                this.currentRealPath = oldState.realPath;
                this.currentNode = oldState.node;
                this.packageNodeSet = oldState.packageNodeSet;
                this.packageViewNodeSet = oldState.packageViewNodeSet;
            }
            return null;
        }
        if (FINISH_INTERACTION_DIAGRAM.equals(operationCode)) {
            this.finishInteractionDiagram();
            return null;
        }
        return null;
    }

    public void finish() {
        File parentFolder = new File(this.getConfiguration().destFolder, this.getConfiguration().modelFolderName);
        TxvAccess.writeAllNodeSets(parentFolder.getAbsolutePath());
    }

    protected void handleDestructionMarker(IPetalNode node) {
        IPetalNode parent_view = node.findNodeWithKey("Parent_View");
        if (parent_view != null) {
            String objectTag = parent_view.getValue();
            String objectUin = (String)this.getMediator().getHandler("view").execute("get_uin", objectTag);
            this.ourObjectsWithDestruction.add(objectUin);
        }
    }

    protected void handleAssociationLinkWithClass(IPetalNode petalNode) {
        final String assClassFqn = SourceModelUtil.convertRoseFqn(petalNode.getProperty("AssociationClass"));
        INode assClass = TxvAccess.findClassifier(assClassFqn);
        final INodeSet currectNodeSet = this.nodeSet;
        final Map properties = PetalUtil.getAssociationLinkProps(petalNode);
        Runnable assClassRoutine = new Runnable(){

            public void run() {
                INode assClassDef = TxvAccess.findClassifier(assClassFqn);
                if (assClassDef == null) {
                    Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_association_class__12")) + assClassFqn);
                    return;
                }
                assClassDef.setProperty("$metaclass", "AssociationClass");
                INode assAspect = TxvAccess.createNode("AssociationClassLinkAspect", "AssociationClassLinkAspect");
                assAspect.setProperty(Resources.getString("DesignModelHandler.@__associationClass_13"), UinSupport.getDesignReferencedUin(assClassDef));
                assAspect.setProperty(Resources.getString("DesignModelHandler.@__package_child_14"), "true");
                ILink assClassConnector = TxvAccess.createLink("AssociationClassConnectorAspect", "AssociationClassConnectorAspect");
                assClassConnector.setClient(UinSupport.getDesignReferencedUin(assClassDef));
                assClassConnector.setSupplier(UinSupport.getDesignReferencedUin(assAspect));
                assClassDef.addLink(assClassConnector);
                if (DesignModelHandler.this.getConfiguration().inPackage) {
                    DesignModelHandler.this.packageNodeSet.addNode(assAspect);
                } else {
                    currectNodeSet.addNode(assAspect);
                }
                if (properties == null) {
                    return;
                }
                IPetalNode clientRole = (IPetalNode)properties.get("client_role_node");
                IPetalNode supplierRole = (IPetalNode)properties.get("supplier_role_node");
                INode assEnd1 = TxvAccess.findNode(clientRole.getQuidu());
                INode assEnd2 = TxvAccess.findNode(supplierRole.getQuidu());
                ILink assEndLink1 = TxvAccess.createLink("AssociationEnd", "AssociationEnd1");
                ILink assEndLink2 = TxvAccess.createLink("AssociationEnd", "AssociationEnd2");
                assEndLink1.setClient(UinSupport.getDesignReferencedUin(assAspect));
                assEndLink2.setClient(UinSupport.getDesignReferencedUin(assAspect));
                assEndLink1.setSupplier(UinSupport.getDesignReferencedUin(assEnd1));
                assEndLink2.setSupplier(UinSupport.getDesignReferencedUin(assEnd2));
                assAspect.addLink(assEndLink1);
                assAspect.addLink(assEndLink2);
                DesignModelHandler.this.ourAspects.put(assClassDef.getUin(), assAspect);
                DesignModelUtil.setPropertiesForAssLink(assEndLink1, PetalUtil.extractClientAssociationEndProps(properties));
                DesignModelUtil.setPropertiesForAssLink(assEndLink2, PetalUtil.extractSupplierAssociationEndProps(properties));
            }
        };
        if (assClass != null) {
            assClassRoutine.run();
        } else {
            CommandProcessor.runCommandLater(assClassRoutine, "onTxvClassCreationWithName", SourceModelUtil.convertRoseFqn(assClassFqn));
        }
    }

    protected void handleAssociationLink(IPetalNode petalNode) {
        if (!this.getConfiguration().assClassesAsProperty && PetalUtil.isAssLinkWithClass(petalNode)) {
            this.ourLinksWithAssClass.put(petalNode.getQuid(), petalNode.getName());
            if (this.getConfiguration().generateSource) {
                this.getSourceModelHandler().handlePetalNode(petalNode);
            } else {
                this.handleAssociationLinkWithClass(petalNode);
            }
            return;
        }
        Map properties = PetalUtil.getAssociationLinkProps(petalNode);
        if (properties == null) {
            return;
        }
        final String clientQuidu = ((IPetalNode)properties.get("client_role_node")).getQuidu();
        properties.remove("client_role_node");
        final String supplierQuidu = ((IPetalNode)properties.get("supplier_role_node")).getQuidu();
        properties.remove("supplier_role_node");
        IElement client = (IElement)TxvAccess.find(clientQuidu);
        String name = DesignModelUtil.newElementName(client, petalNode.getName(), "Association Link");
        ILink link = null;
        link = TxvAccess.createLink("Association Link", name, null, null);
        if (client != null) {
            link = TxvAccess.createLink(petalNode.getQuid(), "Association Link", name, null, null);
            ((INode)client).addLink(link);
            this.addUpdatingTargetsOperation(link.getUin(), supplierQuidu);
        } else {
            final String temp_name = name;
            final ILink objLink = link;
            String quid = petalNode.getQuid();
            Runnable command = new Runnable(){

                public void run() {
                    INode node = TxvAccess.findNode(clientQuidu);
                    if (node == null) {
                        Logger.getInstance().log("VISITOR", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_node_by_Uin__18")) + clientQuidu);
                        return;
                    }
                    if (temp_name == null || temp_name.length() == 0) {
                        objLink.setProperty("$name", DesignModelUtil.newIndexedName(node, "Association Link"));
                    }
                    node.addLink(objLink);
                    DesignModelHandler.this.addUpdatingTargetsOperation(objLink.getUin(), supplierQuidu);
                }
            };
            CommandProcessor.runCommandLater(command, "onTxvCreation", clientQuidu);
            this.getSourceModelHandler().handlePetalNode(petalNode);
        }
        DesignModelUtil.setPropertiesForAssLink(link, properties);
        DesignModelUtil.addProperties(link, "Association Link", petalNode);
        this.fireDesignElementCreated(link, petalNode);
    }

    protected void handleDependencyLink(final IClassifier clientClass, IPetalNode petalNode, final IField field) {
        final String clientClassRefUin = UinSupport.getClassifierReferencedUin(clientClass.getQualifiedName());
        final ILink depLink = TxvAccess.createLink("Dependency Link", "Dependency Link");
        final String packageQuid = petalNode.getQuidu();
        DesignModelUtil.addProperties(depLink, "Dependency Link", petalNode);
        Runnable createDepLink = new Runnable(){

            public void run() {
                IView _package = TxvAccess.findView(packageQuid);
                INodeSet viewNodeSet = (INodeSet)_package.getParent();
                viewNodeSet.addLink(depLink);
                depLink.setSupplier(clientClassRefUin);
                depLink.setClient(UinSupport.getDesignReferencedUin(_package));
                depLink.addProperty("@reversed", "");
                clientClass.removeCodeElement(field);
            }
        };
        IView _package = TxvAccess.findView(packageQuid);
        if (_package != null) {
            createDepLink.run();
        } else {
            CommandProcessor.runCommandLater(createDepLink, "onTxvCreation", packageQuid);
        }
    }

    protected void handleNote(IPetalNode tree) {
        final INode node = this.createNode("Note", tree, true);
        String uin = node.getUin();
        final String hyperLinkQuid = tree.getQuidu();
        if (hyperLinkQuid != null) {
            IElement element = TxvAccess.findElement(hyperLinkQuid);
            Runnable setHyperLink = new Runnable(){

                public void run() {
                    IElement element = TxvAccess.findElement(hyperLinkQuid);
                    String hyperlink = String.valueOf(MessageFormat.format("element://model:project::{0}/", DesignModelHandler.this.getConfiguration().projectName)) + UinSupport.getDesignReferencedUin(element);
                    node.addProperty("@url", hyperlink);
                }
            };
            if (element != null) {
                setHyperLink.run();
            } else {
                CommandProcessor.runCommandLater(setHyperLink, "onTxvCreation", hyperLinkQuid);
            }
        }
        this.getViewHandler().handlePetalNode(uin, tree);
    }

    protected void handleReturnLink(IPetalNode node) {
        String seq_num = node.getProperty("sequence");
        if (seq_num == null) {
            return;
        }
        int index = seq_num.lastIndexOf(46);
        if (index == -1) {
            return;
        }
        ILink returnLink = TxvAccess.createLink("Return Link", "Return Link");
        returnLink.setProperty("$metaclass", "Return Link");
        String seq_num_of_parent_link = seq_num.substring(0, index);
        ILink messageLink = (ILink)this.currentMessagesLinkMessages.get(seq_num_of_parent_link);
        if (messageLink == null) {
            Logger.getInstance().log("visitor", 2, Resources.getString("DesignModelHandler.Cannot_find_parent_of_return_link"));
            return;
        }
        this.ourReturnLinks.put(messageLink.getUin(), returnLink);
    }

    protected void handleMessageLink(IPetalNode petalNode) {
        INode node;
        Runnable command;
        String synchr = petalNode.getProperty("synchronization");
        if (synchr != null && "Return".equals(synchr)) {
            this.handleReturnLink(petalNode);
            return;
        }
        String name = petalNode.getName();
        String quid = petalNode.getQuid();
        if (this.currentNode == null) {
            Logger.getInstance().log("visitor", 0, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_client_for_message_link__20")) + quid + Resources.getString("DesignModelHandler.._Link_will_be_added_to_nodeSet_21"));
            name = DesignModelUtil.newIndexedName(this.nodeSet, "Message Link");
        } else if (petalNode.getName() == null || petalNode.getName().length() == 0) {
            name = DesignModelUtil.newIndexedName(this.currentNode, "Message Link");
        }
        final String clientQuid = this.currentNode.getUin();
        final String supplierQuid = this.mySupplierObjectQuid;
        IElement supplier = TxvAccess.findElement(supplierQuid);
        ILink link = null;
        String concreteMetaclass = "Message Link";
        link = quid == null ? TxvAccess.createLink(concreteMetaclass, name, null, null) : TxvAccess.createLink(quid, concreteMetaclass, name, null, null);
        String seq_num = petalNode.getProperty("sequence");
        this.currentMessagesLinkMessages.put(seq_num, link);
        DesignModelUtil.addProperties(link, "Message Link", petalNode);
        this.fireDesignElementCreated(link, petalNode);
        IPetalNode dirNode = petalNode.findNodeWithKey("dir");
        if (dirNode == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Message_link__23")) + quid + Resources.getString("DesignModelHandler._has_no_direction_24"));
            return;
        }
        String dir = dirNode.getName();
        String key = null;
        boolean fromClientToSupplier = "FromClientToSupplier".equals(dir);
        boolean toClientFromSupplier = "ToClientFromSupplier".equals(dir);
        if (fromClientToSupplier) {
            this.currentNode.addLink(link);
            key = String.valueOf(clientQuid) + "|||" + supplierQuid;
            this.addUpdatingTargetsOperation(link.getUin(), supplierQuid);
        } else if (toClientFromSupplier) {
            key = String.valueOf(supplierQuid) + "|||" + clientQuid;
            link.setSupplier(UinSupport.getDesignReferencedUin(this.currentNode));
            if (supplier != null) {
                ((INode)supplier).addLink(link);
                this.addUpdatingTargetsOperation(link.getUin(), clientQuid);
            } else {
                final String linkUin = link.getUin();
                Runnable command2 = new Runnable(){

                    public void run() {
                        ILink aLink = TxvAccess.findLink(linkUin);
                        if (aLink == null) {
                            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_link_by_Uin__28")) + linkUin);
                            return;
                        }
                        INode supplier = TxvAccess.findNode(supplierQuid);
                        if (supplier == null) {
                            Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_link_supplier_by_Uin__30")) + supplierQuid);
                            return;
                        }
                        supplier.addLink(aLink);
                        DesignModelHandler.this.addUpdatingTargetsOperation(linkUin, clientQuid);
                    }
                };
                CommandProcessor.runCommandLater(command2, "onTxvCreation", supplierQuid);
            }
        } else {
            Logger.getInstance().log("visitor", 1, Resources.getString("DesignModelHandler.Message_Link_has_incorrect_direction_32"));
            return;
        }
        ILink messagesLink = (ILink)this.ourMessagesLinks.get(key);
        if (messagesLink == null) {
            messagesLink = TxvAccess.createLink("Messages Link", DesignModelUtil.newIndexedName(this.currentNode, "Messages Link"), null, null);
            if (fromClientToSupplier) {
                this.currentNode.addLink(messagesLink);
                this.addUpdatingTargetsOperation(messagesLink.getUin(), supplierQuid);
            } else if (toClientFromSupplier) {
                if (supplier != null) {
                    ((INode)supplier).addLink(messagesLink);
                    this.addUpdatingTargetsOperation(messagesLink.getUin(), clientQuid);
                } else {
                    final ILink temp_messagesLink = messagesLink;
                    command = new Runnable(){

                        public void run() {
                            INode supplier = TxvAccess.findNode(supplierQuid);
                            if (supplier == null) {
                                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_link_supplier_by_Uin__34")) + supplierQuid);
                                return;
                            }
                            supplier.addLink(temp_messagesLink);
                            DesignModelHandler.this.addUpdatingTargetsOperation(temp_messagesLink.getUin(), clientQuid);
                        }
                    };
                    node = TxvAccess.findNode(supplierQuid);
                    if (node == null) {
                        CommandProcessor.runCommandLater(command, "onTxvCreation", supplierQuid);
                    } else {
                        command.run();
                    }
                }
            }
            this.ourMessagesLinks.put(key, messagesLink);
        }
        final INode activation = TxvAccess.createNode("Activation", null);
        if (fromClientToSupplier) {
            if (supplier != null) {
                activation.setProperty("$name", DesignModelUtil.newIndexedName((INodeContainer)((Object)supplier), "Activation"));
                ((INode)supplier).addNode(activation);
            } else {
                command = new Runnable(){

                    public void run() {
                        INode node = TxvAccess.findNode(supplierQuid);
                        if (node == null) {
                            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_node_by_Uin__36")) + supplierQuid);
                            return;
                        }
                        activation.setProperty("$name", DesignModelUtil.newIndexedName(node, "Activation"));
                        node.addNode(activation);
                    }
                };
                node = TxvAccess.findNode(supplierQuid);
                if (node == null) {
                    CommandProcessor.runCommandLater(command, "onTxvCreation", supplierQuid);
                } else {
                    command.run();
                }
            }
        } else if (toClientFromSupplier) {
            activation.setProperty("$name", DesignModelUtil.newIndexedName(this.currentNode, "Activation"));
            this.currentNode.addNode(activation);
        }
        this.ourActivations.put(link.getUin(), activation);
        this.ourMessageLinks.put(link.getUin(), petalNode.getProperty("sequence"));
        final ILink tempLink = link;
        Runnable command3 = new Runnable(){

            public void run() {
                activation.setProperty("messageUid", UinSupport.getDesignReferencedUin(tempLink));
                tempLink.setProperty("activationUid", UinSupport.getDesignReferencedUin(activation));
            }
        };
        CommandProcessor.runCommandLater(command3, "onTraverseCompleteDesign");
        this.assignOperationForMessage(petalNode, link, supplierQuid);
    }

    private void assignOperationForMessage(IPetalNode petalNode, final ILink messageLink, final String supplierQuid) {
        String methodQuid = petalNode.getQuidu();
        if ("000000000000".equals(methodQuid)) {
            return;
        }
        String operation = petalNode.getProperty("Operation");
        if (operation == null && (operation = petalNode.getName()) == null) {
            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Operation_for_message_link__38")) + petalNode.getQuid() + Resources.getString("DesignModelHandler._not_defined_39"));
            return;
        }
        final String operationText = operation;
        final String operationQuid = petalNode.getQuidu();
        if (!this.getConfiguration().generateSource) {
            Runnable command = new Runnable(){

                public void run() {
                    if (operationQuid != null) {
                        INode operation = TxvAccess.findNode(operationQuid);
                        if (operation == null) {
                            Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_operation_with_quid__41")) + operationQuid);
                            return;
                        }
                        ILink depLink = TxvAccess.createLink("Dependency Link", "Dependency Link");
                        messageLink.addLink(depLink);
                        depLink.setClient(UinSupport.getDesignReferencedUin(messageLink));
                        depLink.setSupplier(UinSupport.getDesignReferencedUin(operation));
                    }
                }
            };
            CommandProcessor.runCommandLater(command, "onTraverseCompleteDesign");
        } else {
            Runnable command = new Runnable(){
                private static final int NOT_EQUAL = 0;
                private static final int INEXACT_EQUALITY = 1;
                private static final int EXACT_EQUALITY = 2;

                public void run() {
                    IElement supplier = TxvAccess.findElement(supplierQuid);
                    if (supplier == null) {
                        Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_supplier_object_by_Uin__43")) + supplierQuid);
                        return;
                    }
                    String qName = DesignModelHandler.this.getLinkedClassifierQName((INode)supplier);
                    if (qName == null) {
                        Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_associated_class_quialified_name_for_object__45")) + supplierQuid);
                        return;
                    }
                    int paramStart = operationText.indexOf("(");
                    if (paramStart == -1 || !operationText.endsWith(")")) {
                        Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Operation_text__49")) + operationText + Resources.getString("DesignModelHandler._is_not_valid_method_signature_50"));
                        return;
                    }
                    IClassifier classifier = (IClassifier)DesignModelHandler.this.getSourceModelHandler().execute("get_classifier_by_valid_fqn", qName);
                    if (classifier == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_classifier_by_qualified_name__52")) + qName);
                        return;
                    }
                    String opName = operationText.substring(0, paramStart);
                    String paramsText = operationText.substring(paramStart + 1, operationText.length() - 1).trim();
                    StringTokenizer paramTokenizer = new StringTokenizer(paramsText, ",");
                    Vector<String> params = new Vector<String>();
                    while (paramTokenizer.hasMoreTokens()) {
                        String token = paramTokenizer.nextToken();
                        int typeDelim = token.indexOf(":");
                        if (typeDelim == -1) {
                            params.add(token.trim());
                            continue;
                        }
                        params.add(token.substring(typeDelim + 1).trim());
                    }
                    IMethod result = null;
                    int inexactEqualCount = 0;
                    Iterator methods = classifier.getCodeElements("method");
                    while (methods.hasNext()) {
                        IParameter[] methodParams;
                        IMethod nextMethod = (IMethod)methods.next();
                        String nextName = nextMethod.getRealShortName();
                        if (!nextName.equals(opName) || (methodParams = nextMethod.getParameters()).length != params.size()) continue;
                        int nextInexactCount = 0;
                        boolean accepted = true;
                        int i = 0;
                        while (i < methodParams.length) {
                            int eqType = this.getEqualityType((String)params.elementAt(i), methodParams[i].getTypeReference());
                            if (eqType == 0) {
                                accepted = false;
                                break;
                            }
                            if (eqType == 1) {
                                ++nextInexactCount;
                            }
                            ++i;
                        }
                        if (!accepted || result != null && nextInexactCount >= inexactEqualCount) continue;
                        result = nextMethod;
                        if (nextInexactCount == 0) break;
                        inexactEqualCount = nextInexactCount;
                    }
                    if (result == null && (result = (IMethod)DesignModelHandler.this.getSourceModelHandler().execute("get_code_element_by_quid", operationQuid)) == null) {
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_method_with_signature__56")) + operationText + Resources.getString("DesignModelHandler._in_classifier__57") + classifier.getQualifiedName() + Resources.getString("DesignModelHandler.._Message_link__58") + messageLink.getUin());
                        return;
                    }
                    DesignModelUtil.connectMethodToMessageLink(messageLink, result);
                }

                public int getEqualityType(String param, ITypeReference typeRef) {
                    String pkg;
                    int lastDot = param.lastIndexOf(".");
                    String string = pkg = lastDot == -1 ? "" : param.substring(0, lastDot);
                    if (typeRef.isSimpleType() && pkg.length() > 0) {
                        return 0;
                    }
                    String shortName = lastDot == -1 ? param : param.substring(lastDot + 1);
                    int arrayDim = 0;
                    int arrayStart = shortName.indexOf("[");
                    if (arrayStart != -1) {
                        String arrayText = shortName.substring(arrayStart);
                        shortName = shortName.substring(0, arrayStart);
                        arrayStart = 0;
                        while (arrayStart != -1) {
                            ++arrayDim;
                            arrayStart = arrayText.indexOf("[", arrayStart + 1);
                        }
                    }
                    if (!shortName.equals(typeRef.getShortName())) {
                        return arrayDim == 0 && pkg.length() == 0 ? 1 : 0;
                    }
                    if (arrayDim != typeRef.getArrayDimension()) {
                        return arrayDim == 0 && pkg.length() == 0 ? 1 : 0;
                    }
                    if (typeRef.isSimpleType()) {
                        return 2;
                    }
                    String typeLocation = typeRef.getLocation();
                    if (pkg.equals(typeLocation) || pkg.length() == 0 && typeLocation == null) {
                        return 2;
                    }
                    return pkg.length() == 0 ? 1 : 0;
                }
            };
            IMethod method = (IMethod)this.getSourceModelHandler().execute("get_code_element_by_quid", operationQuid);
            if (method != null) {
                DesignModelUtil.connectMethodToMessageLink(messageLink, method);
            } else {
                CommandProcessor.runCommandLater(command, "onTraverseCompleteDesign");
            }
        }
    }

    private String getLinkedClassifierQName(INode object) {
        int i = 0;
        while (i < object.getLinkCount()) {
            ILink nextLink = object.getLink(i);
            if ("Dependency Link".equals(nextLink.getMetaclass()) && nextLink.getSupplier() != null) {
                String result = null;
                result = this.getConfiguration().generateSource ? JavaNames.toJavaClassName(UinSupport.getNodeUin(nextLink.getSupplier().getReferencedUin())) : UinSupport.getNodeUin(nextLink.getSupplier().getReferencedUin());
                return result;
            }
            ++i;
        }
        return null;
    }

    private INodeSet createNodeSet(String metaclass, IPetalNode tree) {
        this.getViewHandler().execute("clear_our_view_refs", null);
        this.getViewHandler().execute("is_sequence_diagram", new Boolean(false));
        this.getViewHandler().execute("is_collaboration_diagram", new Boolean(false));
        this.getViewHandler().execute("is_class_diagram", new Boolean(false));
        String diagramPath = PetalUtil.validatePathName(this.currentPath, String.valueOf(com.borland.util.File.separatorChar));
        String extension = TXVUtil.getTxvExtension(metaclass);
        String packageName = DesignModelUtil.pathToPackageName(this.currentPath);
        String name = PetalUtil.validateDiagramName(this.getConfiguration().destFolder + com.borland.util.File.separatorChar + this.getConfiguration().modelFolderName + com.borland.util.File.separatorChar + diagramPath + com.borland.util.File.separatorChar, tree.getName(), 0, extension);
        if ("Package".equals(metaclass) || "Package Diagram".equals(metaclass) || "Logical View".equals(name) || "Use Case View".equals(name) || "Component View".equals(name)) {
            name = "default";
        }
        String fileName = String.valueOf(name) + "." + extension;
        INodeSet aNodeSet = null;
        INodeSet tempNodeSet = TxvAccess.getNodeSet(diagramPath, fileName);
        if (tempNodeSet == null) {
            aNodeSet = TxvAccess.createNodeSet(diagramPath, fileName);
        } else if ("Package Diagram".equals(metaclass) || "Logical View".equals(name) || "Use Case View".equals(name) || "Component View".equals(name) || "Package".equals(metaclass)) {
            aNodeSet = tempNodeSet;
        } else {
            name = NameUtil.newDiagramIndexedName(TxvAccess.getNodeSetFiles(diagramPath), fileName);
            aNodeSet = TxvAccess.createNodeSet(PetalUtil.validatePathName(this.currentPath, String.valueOf(com.borland.util.File.separatorChar)), String.valueOf(name) + "." + extension);
        }
        aNodeSet.setPackage(packageName);
        if (!"Package".equals(metaclass)) {
            this.getViewHandler().execute("create_view", new Object[]{tree, metaclass, name, aNodeSet});
            if (this.currentNode != null) {
                String projectName = this.getConfiguration().projectName == null ? "PROJECT_NAME" : this.getConfiguration().projectName;
                String hyperlink = String.valueOf(MessageFormat.format("element://model:project::{0}/", projectName)) + UinSupport.getDesignReferencedUin(aNodeSet.getView(0));
                this.currentNode.addProperty("@url", hyperlink);
            } else {
                this.getSourceModelHandler().execute("set_hyperlinks_to_current_classifier", UinSupport.getDesignReferencedUin(aNodeSet.getView(0)));
            }
            DesignModelUtil.addProperties(aNodeSet.getView(0), metaclass, tree);
            this.getViewHandler().execute("is_sequence_diagram", new Boolean("Sequence Diagram".equals(metaclass)));
            this.getViewHandler().execute("is_collaboration_diagram", new Boolean("Collaboration Diagram".equals(metaclass)));
            this.getViewHandler().execute("is_class_diagram", new Boolean("Class Diagram".equals(metaclass)));
            this.fireDesignElementCreated(aNodeSet.getView(0), tree);
        }
        return aNodeSet;
    }

    private INode createNode(String metaclass, IPetalNode petalNode, boolean createUin) {
        String name = petalNode.getName();
        if (("Class".equals(metaclass) || "Operation".equals(metaclass) || "Attribute".equals(metaclass)) && this.currentIsActor()) {
            Logger.getInstance().log("visitor", 1, String.valueOf(metaclass) + " " + petalNode.getName() + " is skipped because actors can not have inner elements.");
            return null;
        }
        String prefix = metaclass;
        boolean isChanged = false;
        if ("Component".equals(metaclass)) {
            name = PetalUtil.trimQuotes(PetalUtil.getWord(petalNode.getValue(), "\"", 2));
        }
        if (this.getConfiguration().validateNames && MappingUtil.isSrcElement(metaclass)) {
            String newName = JavaNames.toJavaMemberName(name);
            isChanged = !newName.equals(name);
            String string = prefix = isChanged ? newName : metaclass;
        }
        if (name == null || name.length() == 0 || isChanged) {
            name = this.currentNode == null || "Object".equals(metaclass) || "Note".equals(metaclass) ? DesignModelUtil.newIndexedName(this.packageNodeSet, prefix, metaclass) : DesignModelUtil.newIndexedName(this.currentNode, prefix, metaclass);
        }
        INode node = null;
        node = !createUin ? TxvAccess.createNode(petalNode.getQuid(), metaclass, name) : TxvAccess.createNode(metaclass, name);
        if (this.currentNode == null && "Class".equals(metaclass)) {
            this.getViewHandler().execute("create_view_ref_for_design", new Object[]{node, this.packageViewNodeSet});
        }
        if (this.currentNode == null || "Object".equals(metaclass) || "Note".equals(metaclass) || "Component".equals(metaclass)) {
            this.packageNodeSet.addNode(node);
            this.currentNode = node;
        } else if (MappingUtil.isStateActivityElement(node.getMetaclass()) && !MappingUtil.isStateActivityElement(this.currentNode.getMetaclass())) {
            this.packageNodeSet.addNode(node);
            this.currentNode = node;
        } else {
            this.currentNode.addNode(node);
            this.currentNode = node;
        }
        if ("Object".equals(metaclass)) {
            DesignModelUtil.setInstantiesProperty(petalNode, node, this.getConfiguration().generateSource, this.getSourceModelHandler());
            final String quidu = petalNode.getQuidu();
            final INode nodeDef = node;
            if (quidu != null) {
                IElement actor = TxvAccess.findElement(quidu);
                Runnable setStereotype = new Runnable(){

                    public void run() {
                        IElement actorDef = TxvAccess.findElement(quidu);
                        String stereotype = actorDef.getPropertyValue("@stereotype");
                        if (stereotype != null) {
                            nodeDef.setProperty("@stereotype", stereotype);
                        }
                    }
                };
                if (actor != null) {
                    setStereotype.run();
                } else {
                    CommandProcessor.runCommandLater(setStereotype, "onTxvCreation", quidu);
                }
            }
        }
        DesignModelUtil.addProperties(node, metaclass, petalNode);
        this.fireDesignElementCreated(node, petalNode);
        return node;
    }

    public static String transformLinkMetaclass(ILink link, INode client, INode supplier) {
        String metaclass = link.getMetaclass();
        String result = null;
        String clientMetaclass = client.getMetaclass();
        String supplierMetaclass = supplier.getMetaclass();
        if ("Dependency Link".equals(metaclass) && "Use Case".equals(clientMetaclass) && "Use Case".equals(supplierMetaclass)) {
            String stereotype = link.getPropertyValue("@stereotype");
            if ("include".equals(stereotype)) {
                result = "Includes Link";
            } else if ("extend".equals(stereotype)) {
                result = "Extends Link";
            }
        } else if ("Dependency Link".equals(metaclass) && "Node".equals(clientMetaclass) && "Node".equals(supplierMetaclass)) {
            result = "Association Link";
        } else if ("Generalization Link".equals(metaclass) && "Class".equals(clientMetaclass) && "Class".equals(supplierMetaclass)) {
            boolean isSupplierInterface;
            boolean isClientInterface = client.getProperty("@mod__interface") != null;
            boolean bl = isSupplierInterface = supplier.getProperty("@mod__interface") != null;
            if (!isClientInterface && isSupplierInterface) {
                result = "Implementation Link";
            }
        }
        return result;
    }

    private ILink createLink(String metaclass, IPetalNode node) {
        String name = node.getName();
        String quid = node.getQuid();
        String supplierQuidu = node.getQuidu();
        if (this.currentNode == null) {
            Logger.getInstance().log("visitor", 0, String.valueOf(Resources.getString("DesignModelHandler.Link__67")) + quid + Resources.getString("DesignModelHandler._will_be_added_to_nodeSet_68"));
            name = DesignModelUtil.newIndexedName(this.nodeSet, metaclass);
        }
        ILink link = TxvAccess.createLink(quid, metaclass, name, null, null);
        this.addUpdatingTargetsOperation(quid, supplierQuidu);
        DesignModelUtil.addProperties(link, metaclass, node);
        if (this.currentNode != null) {
            this.currentNode.addLink(link);
        } else {
            this.nodeSet.addLink(link);
        }
        this.fireDesignElementCreated(link, node);
        return link;
    }

    protected void handleNoteLink(IPetalNode petalNode) {
        String clientTag = petalNode.findNodeWithKey("client").getValue();
        String supplierTag = petalNode.findNodeWithKey("supplier").getValue();
        final IViewReference clientViewRef = (IViewReference)this.getViewHandler().execute("get_view_ref", clientTag);
        final IViewReference supplierViewRef = (IViewReference)this.getViewHandler().execute("get_view_ref", supplierTag);
        final String nodeName = petalNode.getName();
        Runnable operation = new Runnable(){

            public void run() {
                boolean changeClientAndSupplier = false;
                String clientRefUinDef = clientViewRef.getReferencedUin();
                String supplierRefUinDef = supplierViewRef.getReferencedUin();
                String clientUinDef = UinSupport.getNodeUin(clientViewRef.getReferencedUin());
                String supplierUinDef = UinSupport.getNodeUin(supplierViewRef.getReferencedUin());
                IElement client = (IElement)TxvAccess.find(clientUinDef);
                if (client != null) {
                    clientRefUinDef = UinSupport.getDesignReferencedUin(client);
                }
                String name = DesignModelUtil.newElementName(client, nodeName, "Note Link");
                IElement supplier = (IElement)TxvAccess.find(supplierUinDef);
                if (supplier != null) {
                    supplierRefUinDef = UinSupport.getDesignReferencedUin(supplier);
                }
                ILink link = TxvAccess.createLink("Note Link", name, null, null);
                if (client != null && supplier != null) {
                    boolean bl = changeClientAndSupplier = !(client instanceof IConfigurable) || !"Note".equals(client.getMetaclass());
                    if (changeClientAndSupplier) {
                        String temp_string = clientRefUinDef;
                        clientRefUinDef = supplierRefUinDef;
                        supplierRefUinDef = temp_string;
                        IElement temp_element = client;
                        client = supplier;
                        supplier = temp_element;
                    }
                } else if (client == null && supplier != null) {
                    client = supplier;
                    supplier = null;
                    String temp_string = clientRefUinDef;
                    clientRefUinDef = supplierRefUinDef;
                    supplierRefUinDef = temp_string;
                    changeClientAndSupplier = true;
                } else if (client == null && supplier == null) {
                    Logger.getInstance().log("visitor", 2, Resources.getString("DesignModelHandler.Cannot_create_note_link._Client_and_supplier_not_found_in_model_70"));
                    return;
                }
                ((ILinkContainer)((Object)client)).addLink(link);
                link.setClient(clientRefUinDef);
                link.setSupplier(supplierRefUinDef);
                if (!changeClientAndSupplier) {
                    DesignModelHandler.this.getViewHandler().execute("handle_note_link", new Object[]{UinSupport.getDesignReferencedUin(link), clientViewRef});
                } else {
                    DesignModelHandler.this.getViewHandler().execute("handle_note_link", new Object[]{UinSupport.getDesignReferencedUin(link), supplierViewRef});
                }
            }
        };
        if (clientViewRef != null && supplierViewRef != null) {
            CommandProcessor.runCommandLater(operation, "onTraverseCompleteDesign");
        }
    }

    private void addUpdatingTargetsOperation(final String linkUin, final String supplierUin) {
        final ILink link = TxvAccess.findLink(linkUin);
        Runnable operation = new Runnable(){

            public void run() {
                String name;
                String metaclass;
                if (link == null) {
                    Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_link_by_uin___72")) + linkUin);
                    return;
                }
                IIdentifiable client = link.getParent();
                if (client == null) {
                    Logger.getInstance().log("visitor", 1, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_client_of_link__74")) + linkUin);
                    return;
                }
                if (client instanceof INodeSet) {
                    INodeSet clientNodeSet = (INodeSet)client;
                    link.setClient(UinSupport.getDesignReferencedUin(clientNodeSet.getView(0)));
                } else {
                    link.setClient(UinSupport.getDesignReferencedUin(client));
                }
                IIdentifiable supplier = TxvAccess.find(supplierUin);
                if (supplier == null) {
                    IClassifier classifier = (IClassifier)DesignModelHandler.this.getSourceModelHandler().execute("get_code_element_by_quid", supplierUin);
                    if (classifier == null) {
                        ILinkContainer node = (ILinkContainer)((Object)link.getParent());
                        node.removeLink(link);
                        Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_supplier_of_link__76")) + linkUin);
                        return;
                    }
                    link.setSupplier(UinSupport.getSourceReferencedUin(classifier));
                    return;
                }
                if (supplier instanceof INodeSet) {
                    INodeSet supplierNodeSet = (INodeSet)supplier;
                    link.setSupplier(UinSupport.getDesignReferencedUin(supplierNodeSet.getView(0)));
                } else {
                    link.setSupplier(UinSupport.getDesignReferencedUin(supplier));
                }
                if (client instanceof INode && supplier instanceof INode && (metaclass = DesignModelHandler.transformLinkMetaclass(link, (INode)client, (INode)supplier)) != null) {
                    link.setProperty("$metaclass", metaclass);
                }
                if ((name = link.getName()) == null || name.length() == 0) {
                    name = DesignModelUtil.newIndexedName((INodeContainer)((Object)client), link.getPropertyValue("$metaclass"));
                    link.setProperty("$name", name);
                }
            }
        };
        String metaclass = link.getMetaclass();
        IIdentifiable client = link.getParent();
        IIdentifiable supplier = TxvAccess.find(supplierUin);
        if (client != null && supplier != null) {
            operation.run();
        } else if (client != null && !"Transition".equals(metaclass)) {
            CommandProcessor.runCommandLater(operation, "onTxvCreation", supplierUin);
        } else {
            CommandProcessor.runCommandLater(operation, "onTraverseCompleteDesign");
        }
    }

    protected void handlePackage(IPetalNode tree, boolean subSystem) {
        String path = tree.getName();
        if (path == null) {
            path = "Logical View";
        }
        if ("Logical View".equals(path = path.replace('\\', '_')) || "Use Case View".equals(path) || "Component View".equals(path)) {
            this.currentPath = "";
            this.currentRealPath = "";
        } else {
            this.currentPath = String.valueOf(this.currentPath.replace(com.borland.util.File.separatorChar, '\\')) + "\\" + path;
            this.currentRealPath = String.valueOf(this.currentRealPath) + "\\" + path;
            String newCurPath = this.currentPath;
            if (this.changedPackageNames.containsKey(this.currentPath)) {
                this.currentPath = (String)this.changedPackageNames.get(this.currentPath);
            } else {
                newCurPath = this.getConfiguration().generateSource || this.getConfiguration().validateNames ? JavaNames.toJavaPackageName(this.currentPath) : PetalUtil.validatePathName(this.currentPath, "\\");
                if (!subSystem) {
                    String uniqName = this.generateUniquePackageName(newCurPath);
                    if (!newCurPath.equalsIgnoreCase(this.currentPath) || !newCurPath.equalsIgnoreCase(uniqName)) {
                        newCurPath = uniqName;
                        this.changedPackageNames.put(this.currentPath, newCurPath);
                        this.currentPath = newCurPath;
                    }
                } else {
                    String packageQuid = this.getPackageQuid(this.currentPath);
                    if (packageQuid != null) {
                        TxvAccess.setDuplicate(tree.getQuid(), packageQuid);
                    }
                }
            }
            if ('\\' != com.borland.util.File.separatorChar) {
                this.currentPath = this.currentPath.replace('\\', com.borland.util.File.separatorChar);
            }
            if (!this.createFolder(this.currentPath, false)) {
                return;
            }
        }
        this.packageViewNodeSet = this.nodeSet = this.createNodeSet("Package Diagram", tree);
        INodeSet iNodeSet = this.packageNodeSet = !this.getConfiguration().inPackage ? this.nodeSet : this.createNodeSet("Package", tree);
        if (this.nodeSet.getViewCount() != 0) {
            String stereotype = tree.getProperty("stereotype");
            this.nodeSet.getView(0).setProperty("@stereotype", stereotype);
        }
    }

    private String generateUniquePackageName(String newCurPath) {
        String lowerNewCurPath = newCurPath.toLowerCase();
        String packageName = this.getPackageName(lowerNewCurPath);
        String newName = newCurPath;
        int i = 0;
        while (packageName != null) {
            packageName = this.getPackageName(String.valueOf(lowerNewCurPath) + (i + 1));
            ++i;
        }
        newName = i != 0 ? String.valueOf(newCurPath) + i : newCurPath;
        return newName;
    }

    private void handleAssociationLinkOnCollDiagrams(IPetalNode petalNode) {
        final String assName = petalNode.getProperty("Association");
        if (assName == null) {
            return;
        }
        final ILink assLink = TxvAccess.createLink("Association Link", assName);
        final INode obj1Node = this.currentNode;
        final String obj2Quid = petalNode.getQuidu();
        final String objectLinkLabel = petalNode.getProperty("label");
        Runnable setProperty = new Runnable(){

            public void run() {
                INode obj2Node = TxvAccess.findNode(obj2Quid);
                String uinClass1 = DesignModelHandler.this.getLinkedClassifierQName(obj1Node);
                String uinClass2 = DesignModelHandler.this.getLinkedClassifierQName(obj2Node);
                HashMap<String, String> properties = null;
                if (DesignModelHandler.this.getConfiguration().generateSource) {
                    IClassifier classifier1 = (IClassifier)DesignModelHandler.this.getSourceModelHandler().execute("get_classifier_by_valid_fqn", uinClass1);
                    IClassifier classifier2 = (IClassifier)DesignModelHandler.this.getSourceModelHandler().execute("get_classifier_by_valid_fqn", uinClass2);
                    if (classifier1 == null || classifier2 == null) {
                        Logger.getInstance().log("visitor", 2, "Cannot create association link on collaboration diagram because cannot find classifiers connected to objects.Object1:" + obj1Node.getUin() + ". Object2:" + obj2Node.getUin() + ".Class1:" + uinClass1 + ". Class2:" + uinClass2 + ". Association:" + assName);
                        return;
                    }
                    IField result = SourceModelUtil.findFieldWithTag(classifier1, "@label", assName);
                    if (result != null) {
                        obj1Node.addLink(assLink);
                        assLink.setClient(UinSupport.getDesignReferencedUin(obj1Node));
                        assLink.setSupplier(UinSupport.getDesignReferencedUin(obj2Node));
                    } else {
                        result = SourceModelUtil.findFieldWithTag(classifier2, "@label", assName);
                        if (result != null) {
                            obj2Node.addLink(assLink);
                            assLink.setClient(UinSupport.getDesignReferencedUin(obj2Node));
                            assLink.setSupplier(UinSupport.getDesignReferencedUin(obj1Node));
                        }
                    }
                    if (result == null) {
                        obj1Node.addLink(assLink);
                        assLink.setClient(UinSupport.getDesignReferencedUin(obj1Node));
                        assLink.setSupplier(UinSupport.getDesignReferencedUin(obj2Node));
                        properties = new HashMap();
                    } else {
                        properties = new HashMap();
                        int i = 0;
                        while (i < result.getTags().length) {
                            properties.put(result.getTags()[i].getName(), result.getTags()[i].getValue());
                            ++i;
                        }
                    }
                } else {
                    INode classifierNode1 = TxvAccess.findNode(uinClass1);
                    INode classifierNode2 = TxvAccess.findNode(uinClass2);
                    if (classifierNode1 == null || classifierNode2 == null) {
                        Logger.getInstance().log("visitor", 2, "Cannot create association link on collaboration diagram because cannot find classifiers connected to objects.Object1:" + obj1Node.getUin() + ". Object2:" + obj2Node.getUin() + ".Class1:" + uinClass1 + ". Class2:" + uinClass2 + ". Association:" + assName);
                        return;
                    }
                    ILink result = DesignModelUtil.findLink(classifierNode1, "Association Link", "$name", assName);
                    if (result != null) {
                        obj1Node.addLink(assLink);
                        assLink.setClient(UinSupport.getDesignReferencedUin(obj1Node));
                        assLink.setSupplier(UinSupport.getDesignReferencedUin(obj2Node));
                    } else {
                        result = DesignModelUtil.findLink(classifierNode2, "Association Link", "$name", assName);
                        if (result != null) {
                            obj2Node.addLink(assLink);
                            assLink.setClient(UinSupport.getDesignReferencedUin(obj2Node));
                            assLink.setSupplier(UinSupport.getDesignReferencedUin(obj1Node));
                        }
                    }
                    if (result == null) {
                        obj1Node.addLink(assLink);
                        assLink.setClient(UinSupport.getDesignReferencedUin(obj1Node));
                        assLink.setSupplier(UinSupport.getDesignReferencedUin(obj2Node));
                        properties = new HashMap();
                    } else {
                        properties = new HashMap<String, String>();
                        int i = 0;
                        while (i < result.getPropertiesCount()) {
                            properties.put(result.getProperty(i).getName(), result.getProperty(i).getValue());
                            ++i;
                        }
                    }
                }
                DesignModelUtil.setPropertiesForAssLink(assLink, properties);
                if (objectLinkLabel != null) {
                    String oldValue = assLink.getPropertyValue("@label");
                    oldValue = oldValue != null ? " : " + oldValue : "";
                    assLink.setProperty("@label", String.valueOf(objectLinkLabel) + oldValue);
                }
            }
        };
        CommandProcessor.runCommandLater(setProperty, "onTraverseCompleteDesign");
    }

    private void createSubsystemHyperlink(INode node, String path) {
        String projectName = this.getConfiguration().projectName == null ? "PROJECT_NAME" : this.getConfiguration().projectName;
        String hyperlink = String.valueOf(MessageFormat.format("element://model:project::{0}/", projectName)) + UinSupport.getDesignReferencedUin(this.nodeSet.getView(0));
        node.addProperty("@url", hyperlink);
    }

    private boolean createFolder(String relPath, boolean source) {
        File parentFolder = source ? new File(this.getConfiguration().destFolder, this.getConfiguration().srcFolderName) : new File(this.getConfiguration().destFolder, this.getConfiguration().modelFolderName);
        File path = new File(parentFolder, relPath);
        if (path.exists()) {
            return true;
        }
        if (path.mkdirs()) {
            Logger.getInstance().log("visitor", 0, String.valueOf(Resources.getString("DesignModelHandler.Creating_folder____79")) + path);
            return true;
        }
        Logger.getInstance().log("importer", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_create_folder___80")) + path);
        return false;
    }

    protected ViewHandler getViewHandler() {
        return (ViewHandler)this.getMediator().getHandler("view");
    }

    protected SourceModelHandler getSourceModelHandler() {
        return (SourceModelHandler)this.getMediator().getHandler("sourceModel");
    }

    private void finishInteractionDiagram() {
        String key;
        HashMap<String, Integer> messageCounts = new HashMap<String, Integer>();
        Integer old_count = null;
        Set keys = this.currentDiagramMessageLinks.keySet();
        Iterator keys_iter = keys.iterator();
        while (keys_iter.hasNext()) {
            String key_prefix = "";
            key = keys_iter.next().toString();
            int dot_index = key.lastIndexOf(46);
            if (dot_index != -1) {
                key_prefix = key.substring(0, dot_index);
            }
            if ((old_count = (Integer)messageCounts.get(key_prefix)) == null) {
                messageCounts.put(key_prefix, new Integer(1));
                continue;
            }
            int old_int_value = old_count;
            messageCounts.put(key_prefix, new Integer(old_int_value + 1));
        }
        HashMap<String, String> linksForDestruction = new HashMap<String, String>();
        keys_iter = keys.iterator();
        while (keys_iter.hasNext()) {
            int dot_index;
            key = keys_iter.next().toString();
            ILink nextLink = (ILink)this.currentDiagramMessageLinks.get(key);
            String clientQuid = null;
            if (nextLink.getClient() != null) {
                clientQuid = UinSupport.getNodeUin(nextLink.getClient().getReferencedUin());
            }
            String supplierQuid = null;
            if (nextLink.getSupplier() != null) {
                supplierQuid = UinSupport.getNodeUin(nextLink.getSupplier().getReferencedUin());
            }
            if (clientQuid != null && supplierQuid != null) {
                if (this.ourObjectsWithDestruction.contains(supplierQuid)) {
                    Object result;
                    int dot_index2;
                    boolean self_link_not_nested = false;
                    if (clientQuid.equals(supplierQuid) && (dot_index2 = key.indexOf(".")) == -1) {
                        self_link_not_nested = true;
                    }
                    if ((result = this.getViewHandler().execute("is_message_with_not_nested_activation", nextLink.getUin())) != null || self_link_not_nested) {
                        String link_seq_num = (String)linksForDestruction.get(supplierQuid);
                        if (link_seq_num != null) {
                            if (link_seq_num.startsWith("-")) {
                                link_seq_num = link_seq_num.substring(1);
                            }
                            if (key.compareTo(link_seq_num) > 0) {
                                linksForDestruction.put(supplierQuid, key);
                            }
                        } else {
                            linksForDestruction.put(supplierQuid, key);
                        }
                    }
                }
                if (!clientQuid.equals(supplierQuid) && this.ourObjectsWithDestruction.contains(clientQuid) && (dot_index = key.indexOf(".")) == -1) {
                    String link_seq_num = (String)linksForDestruction.get(clientQuid);
                    if (link_seq_num != null) {
                        if (link_seq_num.startsWith("-")) {
                            link_seq_num = link_seq_num.substring(1);
                        }
                        if (key.compareTo(link_seq_num) > 0) {
                            linksForDestruction.put(clientQuid, "-" + key);
                        }
                    } else {
                        linksForDestruction.put(clientQuid, "-" + key);
                    }
                }
            }
            dot_index = key.lastIndexOf(46);
            String key_prefix = "";
            String number = null;
            if (dot_index == -1) {
                number = key;
            } else {
                key_prefix = key.substring(0, dot_index);
                number = key.substring(dot_index + 1);
                ILink predecessor = (ILink)this.currentDiagramMessageLinks.get(key_prefix);
                if (predecessor == null) {
                    Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_message_predecessor_with_sequence_number__90")) + key_prefix);
                } else {
                    nextLink.setProperty("predecessorUid", UinSupport.getDesignReferencedUin(predecessor));
                }
            }
            Integer count = (Integer)messageCounts.get(key_prefix);
            if (count == null) {
                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_message_links_with_sequence_number__92")) + key_prefix);
                return;
            }
            if (number.equals(" ")) continue;
            double norm_index = (double)Integer.parseInt(number) / (double)(count + 1);
            nextLink.setProperty("normalizedIndex", new Double(norm_index).toString());
        }
        if (linksForDestruction.values() != null) {
            Iterator iter = linksForDestruction.values().iterator();
            while (iter.hasNext()) {
                ILink link;
                String seq_num = (String)iter.next();
                if (seq_num.startsWith("-") || (link = (ILink)this.currentDiagramMessageLinks.get(seq_num)) == null) continue;
                link.setProperty("destruction", "true");
            }
        }
        Set message_links_quidu = this.ourReturnLinks.keySet();
        Iterator iterator = message_links_quidu.iterator();
        while (iterator.hasNext()) {
            String quid = (String)iterator.next();
            ILink messageLink = TxvAccess.findLink(quid);
            if (messageLink == null) {
                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Cannot_find_message_link_by_sequence_number__96")) + quid);
                continue;
            }
            if (messageLink.getClient() == null) {
                Logger.getInstance().log("visitor", 2, String.valueOf(Resources.getString("DesignModelHandler.Client_of_message_link__98")) + messageLink.getUin() + Resources.getString("DesignModelHandler._not_found_99"));
                continue;
            }
            messageLink.setProperty("showReturnArrow", "");
            String supplierRef = messageLink.getClient().getReferencedUin();
            INode activation = (INode)this.ourActivations.get(messageLink.getUin());
            ILink returnLink = (ILink)this.ourReturnLinks.get(quid);
            if (returnLink == null) continue;
            returnLink.setClient(UinSupport.getDesignReferencedUin(activation));
            returnLink.setSupplier(supplierRef);
            activation.addLink(returnLink);
            returnLink.setProperty("normalizedIndex", "1.0");
        }
        this.ourObjectsWithDestruction.clear();
        linksForDestruction.clear();
        messageCounts.clear();
        this.currentDiagramMessageLinks.clear();
        this.ourReturnLinks.clear();
    }

    private ILink getMessageLink(String seq_number) {
        Set keys = this.ourMessageLinks.keySet();
        Iterator keys_iter = keys.iterator();
        while (keys_iter.hasNext()) {
            String uin = (String)keys_iter.next();
            String seq = (String)this.ourMessageLinks.get(uin);
            if (!seq_number.equals(seq)) continue;
            return TxvAccess.findLink(uin);
        }
        return null;
    }

    public void fireDesignElementCreated(IElement element, IPetalNode petalNode) {
        String fqn;
        super.fireDesignElementCreated(element, petalNode);
        if (element instanceof INode && (fqn = DesignModelUtil.getFqn((INode)element)) != null) {
            CommandProcessor.notify("onTxvClassCreationWithName", fqn);
        }
    }

    private String getPackageName(String folderPath) {
        Enumeration diagrams = TxvAccess.getNodeSets(folderPath);
        if (diagrams.hasMoreElements()) {
            INodeSet nodeSet = (INodeSet)diagrams.nextElement();
            return nodeSet.getPackage();
        }
        return null;
    }

    private String getPackageQuid(String folderPath) {
        INodeSet diagram = TxvAccess.getNodeSet(folderPath, "default." + TXVUtil.getTxvExtension("Package Diagram"));
        if (diagram != null) {
            return diagram.getView(0).getUin();
        }
        return null;
    }

    private boolean currentIsActor() {
        return this.currentNode != null && "Actor".equals(this.currentNode.getMetaclass());
    }

    private class State {
        String path;
        String realPath;
        INode node;
        INodeSet packageNodeSet;
        INodeSet packageViewNodeSet;

        public State(String path, String realPath, INode node, INodeSet packageNodeSet, INodeSet packageViewNodeSet) {
            this.path = path;
            this.realPath = realPath;
            this.node = node;
            this.packageNodeSet = packageNodeSet;
            this.packageViewNodeSet = packageViewNodeSet;
        }

        public String toString() {
            return this.path;
        }
    }
}

