/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.petal;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.HandlerMediator;
import com.borland.mdlimport.impl.petal.IPetalNodeHandler;
import com.borland.mdlimport.impl.petal.QuidAndQName;
import com.borland.mdlimport.petal.IElementListener;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.txv.IElement;
import java.util.Vector;

public abstract class AbstractHandler
implements IPetalNodeHandler {
    private HandlerMediator myMediator;
    private Configuration myConfig;
    private Vector myElementListeners;

    public AbstractHandler(Configuration config) {
        this.myConfig = config;
    }

    public void setMediator(HandlerMediator mediator) {
        this.myMediator = mediator;
    }

    public HandlerMediator getMediator() {
        return this.myMediator;
    }

    public Configuration getConfiguration() {
        return this.myConfig;
    }

    public void addElementListener(IElementListener listener) {
        if (this.myElementListeners == null) {
            this.myElementListeners = new Vector();
        }
        if (!this.myElementListeners.contains(listener)) {
            this.myElementListeners.add(listener);
        }
    }

    public void removeElementListener(IElementListener listener) {
        if (this.myElementListeners == null) {
            return;
        }
        this.myElementListeners.remove(listener);
    }

    public void fireDesignElementCreated(IElement element, IPetalNode petalNode) {
        CommandProcessor.notify("onTxvCreation", petalNode.getQuid());
        if (this.myElementListeners != null) {
            int i = 0;
            while (i < this.myElementListeners.size()) {
                ((IElementListener)this.myElementListeners.elementAt(i)).designElementCreated(element, petalNode);
                ++i;
            }
        }
    }

    public void fireSrcElementCreated(ICodeElement element, IPetalNode petalNode) {
        CommandProcessor.notify("onSrcCreation", new QuidAndQName(petalNode.getQuid(), element.getQualifiedName(false)));
        if (this.myElementListeners != null) {
            int i = 0;
            while (i < this.myElementListeners.size()) {
                ((IElementListener)this.myElementListeners.elementAt(i)).srcElementCreated(element, petalNode);
                ++i;
            }
        }
    }
}

