/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen.java;

import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IParameter;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.codegen.java.JavaTypes;
import java.util.HashMap;
import java.util.Map;

public class JavaUtil {
    private static Map map = new HashMap();

    static {
        map.put(JavaTypes.VOID, "V");
        map.put(JavaTypes.BOOLEAN, "Z");
        map.put(JavaTypes.BYTE, "B");
        map.put(JavaTypes.CHAR, "C");
        map.put(JavaTypes.SHORT, "S");
        map.put(JavaTypes.INT, "I");
        map.put(JavaTypes.LONG, "J");
        map.put(JavaTypes.FLOAT, "F");
        map.put(JavaTypes.DOUBLE, "D");
    }

    public static String getRuntimeSignature(IMethod method) {
        StringBuffer result = new StringBuffer();
        result.append(method.getShortName());
        IParameter[] params = method.getParameters();
        int i = 0;
        while (i < params.length) {
            result.append("~");
            result.append(JavaUtil.getCompressedName(params[i].getTypeReference()));
            ++i;
        }
        return result.toString();
    }

    public static String getCompressedName(ITypeReference typeRef) {
        StringBuffer result = new StringBuffer();
        if (typeRef.isArray()) {
            int dimension = typeRef.getArrayDimension();
            int j = 0;
            while (j < dimension) {
                result.append("[");
                ++j;
            }
        }
        if (typeRef.isSimpleType()) {
            result.append((String)map.get(typeRef));
        } else {
            result.append("Q");
            result.append(typeRef.getQualifiedName());
            result.append(";");
        }
        return result.toString();
    }
}

