/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen.java;

import com.borland.mdlimport.codegen.CodeFormatter;
import com.borland.mdlimport.codegen.IAnnotated;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeElementContainer;
import com.borland.mdlimport.codegen.ICodeSerializer;
import com.borland.mdlimport.codegen.IComment;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IInheritanceElement;
import com.borland.mdlimport.codegen.IInheritanceModel;
import com.borland.mdlimport.codegen.IMember;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IModifiers;
import com.borland.mdlimport.codegen.IParameter;
import com.borland.mdlimport.codegen.ITag;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.codegen.java.IJavaClassifier;
import com.borland.mdlimport.codegen.java.IJavaFile;
import com.borland.mdlimport.codegen.java.JavaTypes;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.Iterator;
import java.util.StringTokenizer;

public class JavaSerializer
implements ICodeSerializer {
    private StringBuffer myBuffer;
    private int myCurrentLevel = 0;
    private int myCurrentOffset = 0;
    private CodeFormatter myFormat = new CodeFormatter();

    public String serialize(IFile file) {
        this.myBuffer = new StringBuffer();
        this.writePackage(file);
        this.writeImports((IJavaFile)file);
        Iterator classifiers = ((IJavaFile)file).classifiers();
        if (!classifiers.hasNext()) {
            Logger.getInstance().log("codegen", 1, String.valueOf(Resources.getString("JavaSerializer.File__2")) + file.getFullName() + Resources.getString("JavaSerializer._doesn__t_contain_classes_3"));
            return this.myBuffer.toString();
        }
        this.writeChildren(file);
        return this.myBuffer.toString();
    }

    public void setCodeFormatter(CodeFormatter formatter) {
        this.myFormat = formatter;
    }

    public CodeFormatter getCodeFormatter() {
        return this.myFormat;
    }

    protected void writePackage(IFile file) {
        String packageQName = file.getPackage().getQualifiedName();
        if (packageQName == null || packageQName.length() == 0) {
            return;
        }
        this.write("package ");
        this.write(packageQName);
        this.write(";");
        this.writeLine();
    }

    protected void writeImports(IJavaFile file) {
        this.createImports(file, null);
        Iterator imports = file.imports();
        boolean first = true;
        while (imports.hasNext()) {
            String next = (String)imports.next();
            if (first) {
                this.writeLine();
                first = false;
            }
            this.write("import ");
            this.write(next);
            this.write(";");
            this.writeLine();
        }
    }

    protected void createImports(IJavaFile file, IJavaClassifier classifier) {
        Iterator classes = null;
        classes = classifier == null ? file.classifiers() : classifier.innerClassifiers();
        while (classes.hasNext()) {
            IJavaClassifier nextClass = (IJavaClassifier)classes.next();
            IInheritanceModel inhModel = nextClass.getInheritanceModel();
            IInheritanceElement[] elems = inhModel.getElements();
            int i = 0;
            while (i < elems.length) {
                if (this.acceptShortTypeRef(file, elems[i].getTypeReference())) {
                    file.addImport(elems[i].getTypeReference());
                }
                ++i;
            }
            Iterator fields = nextClass.fields();
            while (fields.hasNext()) {
                IField nextField = (IField)fields.next();
                if (!this.acceptShortTypeRef(file, nextField.getTypeReference())) continue;
                file.addImport(nextField.getTypeReference());
            }
            Iterator methods = nextClass.methods();
            while (methods.hasNext()) {
                IMethod nextMethod = (IMethod)methods.next();
                if (nextMethod.isCommented()) continue;
                if (this.acceptShortTypeRef(file, nextMethod.getTypeReference())) {
                    file.addImport(nextMethod.getTypeReference());
                }
                IParameter[] params = nextMethod.getParameters();
                int i2 = 0;
                while (i2 < params.length) {
                    if (this.acceptShortTypeRef(file, params[i2].getTypeReference())) {
                        file.addImport(params[i2].getTypeReference());
                    }
                    ++i2;
                }
                ITypeReference[] exceptions = nextMethod.getThrowList();
                int i3 = 0;
                while (i3 < exceptions.length) {
                    if (this.acceptShortTypeRef(file, exceptions[i3])) {
                        file.addImport(exceptions[i3]);
                    }
                    ++i3;
                }
            }
            this.createImports(file, nextClass);
        }
    }

    private boolean acceptShortTypeRef(ICodeElementContainer container, ITypeReference typeRef) {
        Iterator codeElements = container.getCodeElements("classifier");
        while (codeElements.hasNext()) {
            ITypeReference classRef;
            IJavaClassifier nextClass = (IJavaClassifier)codeElements.next();
            if (nextClass.getShortName().equals(typeRef.getShortName()) && (classRef = nextClass.createTypeReference()) != null && !classRef.equals(typeRef)) {
                return false;
            }
            if (this.acceptShortTypeRef(nextClass, typeRef)) continue;
            return false;
        }
        return true;
    }

    protected void writeCodeElement(ICodeElement codeElement) {
        String codeElementType = codeElement.getCodeElementType();
        if (!("classifier".equals(codeElementType) || "method".equals(codeElementType) || "field".equals(codeElementType))) {
            Logger.getInstance().log("codegen", 1, String.valueOf(Resources.getString("JavaSerializer.Code_element_type__9")) + codeElementType + Resources.getString("JavaSerializer._is_not_supported_10"));
            return;
        }
        this.writeWithTabs("");
        if (codeElement instanceof IJavaClassifier) {
            IComment comment;
            IComment iComment = comment = codeElement.isCommented() ? codeElement.getComment() : null;
            if (comment != null) {
                this.write(comment.getCommentStart());
                if (comment.insertNewLine()) {
                    this.writeLine();
                    this.writeWithTabs("");
                }
            }
            this.writeClassifier((IJavaClassifier)codeElement);
            if (comment != null) {
                if (comment.insertNewLine()) {
                    this.writeLine();
                    this.writeWithTabs(comment.getCommentFinish());
                } else {
                    this.write(comment.getCommentFinish());
                }
            }
        } else if (codeElement instanceof IMember) {
            this.writeMember((IMember)codeElement, codeElementType);
        }
        this.writeLine();
    }

    protected void writeClassifier(IJavaClassifier aClass) {
        this.writeAnnotations(aClass);
        this.writeVisibility(aClass);
        this.writeModifiers(aClass);
        String classOrInterface = aClass.isInterface() ? "interface" : "class";
        this.write(classOrInterface);
        this.writeSpace();
        this.write(aClass.getShortName());
        this.writeSpace();
        this.writeInheritance(aClass);
        this.write("{");
        this.writeLine();
        ++this.myCurrentLevel;
        this.writeChildren(aClass);
        --this.myCurrentLevel;
        this.writeWithTabs("}");
    }

    protected void writeVisibility(ICodeElement codeElement) {
        String visibility = codeElement.getVisibility();
        if (visibility != null && visibility.length() > 0) {
            this.write(visibility);
            this.writeSpace();
        }
    }

    protected void writeModifiers(ICodeElement codeElement) {
        IModifiers modifiers = codeElement.getModifiers();
        if (modifiers.getFlags() > 0) {
            if (modifiers.hasFlag(1)) {
                this.write("abstract");
                this.writeSpace();
            }
            if (modifiers.hasFlag(2)) {
                this.write("static");
                this.writeSpace();
            }
            if (modifiers.hasFlag(4)) {
                this.write("final");
                this.writeSpace();
            }
        }
    }

    protected void writeInheritance(IJavaClassifier aClass) {
        IInheritanceElement[] implElements;
        IInheritanceModel inheritance = aClass.getInheritanceModel();
        if (inheritance == null) {
            return;
        }
        IInheritanceElement[] extendElements = inheritance.getElements(0);
        if (extendElements != null && extendElements.length > 0) {
            this.write("extends ");
            int i = 0;
            while (i < extendElements.length) {
                ITypeReference typeRef = extendElements[i].getTypeReference();
                if (this.acceptShortTypeRef(aClass.getFile(), typeRef)) {
                    this.write(typeRef.getShortName());
                } else {
                    this.write(typeRef.getFullName());
                }
                if (i < extendElements.length - 1) {
                    this.write(", ");
                } else {
                    this.writeSpace();
                }
                ++i;
            }
        }
        if ((implElements = inheritance.getElements(1)) != null && implElements.length > 0) {
            this.write("implements ");
            int i = 0;
            while (i < implElements.length) {
                ITypeReference typeRef = implElements[i].getTypeReference();
                if (this.acceptShortTypeRef(aClass.getFile(), typeRef)) {
                    this.write(typeRef.getShortName());
                } else {
                    this.write(typeRef.getFullName());
                }
                if (i < implElements.length - 1) {
                    this.write(", ");
                } else {
                    this.writeSpace();
                }
                ++i;
            }
        }
    }

    protected void writeChildren(ICodeElementContainer container) {
        Iterator allElements = container.getAllCodeElements();
        while (allElements.hasNext()) {
            this.writeLine();
            this.writeCodeElement((ICodeElement)allElements.next());
        }
    }

    protected void writeMember(IMember member, String codeElementType) {
        boolean isInterface;
        IComment comment;
        ITypeReference typeRef = member.getTypeReference();
        if (typeRef == null) {
            Logger.getInstance().log("codegen", 1, String.valueOf(Resources.getString("JavaSerializer.Type_reference_for_member__22")) + member.getQualifiedName() + Resources.getString("JavaSerializer._is_null_23"));
            return;
        }
        boolean isMethod = "method".equals(codeElementType);
        this.writeAnnotations(member);
        IComment iComment = comment = member.isCommented() ? member.getComment() : null;
        if (comment != null) {
            this.write(comment.getCommentStart());
            if (comment.insertNewLine()) {
                this.writeLine();
                this.writeWithTabs("");
            }
        }
        if (!(isInterface = ((IJavaClassifier)member.getClassifier()).isInterface())) {
            this.writeVisibility(member);
            this.writeModifiers(member);
        }
        if (!isMethod || !member.getShortName().equals(member.getClassifier().getShortName())) {
            if (this.acceptShortTypeRef(member.getFile(), typeRef)) {
                this.write(typeRef.getShortName());
            } else {
                this.write(typeRef.getFullName());
            }
            if (typeRef.isArray()) {
                int dimension = typeRef.getArrayDimension();
                int j = 0;
                while (j < dimension) {
                    this.write("[]");
                    ++j;
                }
            }
            this.writeSpace();
        }
        if (!isMethod) {
            this.write(member.getShortName());
            String initialValue = ((IField)member).getInitialValue();
            if (initialValue != null) {
                this.writeSpace();
                this.write("=");
                this.writeSpace();
                this.write(initialValue);
            }
            this.write(";");
            if (comment != null) {
                if (comment.insertNewLine()) {
                    this.writeLine();
                    this.writeWithTabs(comment.getCommentFinish());
                } else {
                    this.write(comment.getCommentFinish());
                }
            }
            return;
        }
        this.write(((IMethod)member).getSignature(false));
        if (isInterface || member.getModifiers().hasFlag(1)) {
            this.write(";");
        } else {
            this.writeSpace();
            this.write("{");
            this.writeLine();
            if (!JavaTypes.VOID.equals(typeRef)) {
                ++this.myCurrentLevel;
                this.writeWithTabs("throw new UnsupportedOperationException();");
                this.writeLine();
                --this.myCurrentLevel;
            }
            this.writeWithTabs("}");
        }
        if (comment != null) {
            if (comment.insertNewLine()) {
                this.writeLine();
                this.writeWithTabs(comment.getCommentFinish());
            } else {
                this.write(comment.getCommentFinish());
            }
        }
    }

    protected void writeAnnotations(IAnnotated annotated) {
        String dscr = annotated.getDescription();
        ITag[] tags = annotated.getTags();
        if (!(dscr != null && dscr.length() != 0 || tags != null && tags.length != 0)) {
            return;
        }
        this.write("/**");
        this.writeLine();
        if (dscr != null && dscr.length() > 0) {
            StringTokenizer tokenizer = new StringTokenizer(dscr, System.getProperty("line.separator"));
            while (tokenizer.hasMoreTokens()) {
                this.writeWithTabs(" * ");
                this.write(tokenizer.nextToken());
                this.writeLine();
            }
        }
        if (tags != null && tags.length > 0) {
            int i = 0;
            while (i < tags.length) {
                this.writeWithTabs(" * ");
                this.write(tags[i].getName());
                String tagValue = tags[i].getValue();
                if (tagValue != null && tagValue.length() > 0) {
                    this.writeSpace();
                    this.write(tags[i].getValue());
                }
                this.writeLine();
                ++i;
            }
        }
        this.writeWithTabs(" */");
        this.writeLine();
        this.writeWithTabs("");
    }

    protected void write(String str, int level) {
        this.shift(level);
        if (this.myCurrentOffset > 0 && this.myCurrentOffset + str.length() > this.myFormat.getMaxLineWidth()) {
            this.writeLine();
            this.shift(level + 1);
        }
        this.myBuffer.append(str);
        this.myCurrentOffset += str.length();
    }

    protected void write(String str) {
        this.write(str, 0);
    }

    protected void writeWithTabs(String str) {
        this.write(str, this.myCurrentLevel);
    }

    protected void writeLine() {
        this.myBuffer.append(System.getProperty("line.separator"));
        this.myCurrentOffset = 0;
    }

    protected void writeSpace() {
        this.myBuffer.append(" ");
    }

    protected void shift(int level) {
        if (level == 0) {
            return;
        }
        String offsetSymbol = this.myFormat.getUseTab() ? "\t" : " ";
        int iterationsCount = this.myFormat.getUseTab() ? level : level * this.myFormat.getTabWidth();
        int i = 0;
        while (i < iterationsCount) {
            this.myBuffer.append(offsetSymbol);
            ++i;
        }
        this.myCurrentOffset += level * this.myFormat.getTabWidth();
    }
}

