/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen.java;

import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.IField;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IInheritanceElement;
import com.borland.mdlimport.codegen.IInheritanceModel;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IParameter;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.codegen.java.IJavaClassifier;
import com.borland.mdlimport.codegen.java.JavaTypes;
import com.borland.mdlimport.impl.codegen.ClassifierImpl;
import com.borland.mdlimport.impl.codegen.InheritanceModelImpl;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public class JavaClassifier
extends ClassifierImpl
implements IJavaClassifier {
    private boolean myIsInterface = false;
    private static final Comparator ELEMENT_COMPARATOR = new Comparator(){
        private static final double PUBLIC_CLASSES = 0.1;
        private static final double PUBLIC_CONSTANTS = 0.2;
        private static final double PUBLIC_CONSTRUCTORS = 0.31;
        private static final double OTHER_CONSTRUCTORS = 0.31;
        private static final double PUBLIC_METHODS = 0.41;
        private static final double PROTECTED_METHODS = 0.42;
        private static final double PACKAGE_METHODS = 0.43;
        private static final double PRIVATE_METHODS = 0.44;
        private static final double PROTECTED_FIELDS = 0.51;
        private static final double PACKAGE_FIELDS = 0.52;
        private static final double PRIVATE_FIELDS = 0.53;
        private static final double OTHER_CLASSES = 0.6;
        private static final double OTHER_ELEMENTS = 0.9;

        public int compare(Object obj1, Object obj2) {
            ICodeElement elem1 = (ICodeElement)obj1;
            ICodeElement elem2 = (ICodeElement)obj2;
            double diff = this.getWeight(elem1) - this.getWeight(elem2);
            if (diff < 0.0) {
                return -1;
            }
            if (diff > 0.0) {
                return 1;
            }
            return 0;
        }

        private double getWeight(ICodeElement element) {
            String visibility = element.getVisibility();
            String type = element.getCodeElementType();
            if ("classifier".equals(type)) {
                if ("public".equals(visibility)) {
                    return 0.1;
                }
                return 0.6;
            }
            if ("field".equals(type)) {
                if ("public".equals(visibility)) {
                    return 0.2;
                }
                if ("protected".equals(visibility)) {
                    return 0.51;
                }
                if ("".equals(visibility)) {
                    return 0.52;
                }
                return 0.53;
            }
            if ("method".equals(type)) {
                if (JavaClassifier.isConstructor((IMethod)element)) {
                    if ("public".equals(visibility)) {
                        return 0.31;
                    }
                    return 0.31;
                }
                if ("public".equals(visibility)) {
                    return 0.41;
                }
                if ("protected".equals(visibility)) {
                    return 0.42;
                }
                if ("".equals(visibility)) {
                    return 0.43;
                }
                return 0.44;
            }
            return 0.9;
        }
    };

    public JavaClassifier(IFile file, String shortName, String realName) {
        super(file, shortName, realName);
        this.setElementComparator(ELEMENT_COMPARATOR);
    }

    public ITypeReference createTypeReference() {
        return JavaTypes.createTypeReference(this.getQualifiedName());
    }

    public IMethod addMethod(String shortName, String realName, List params) {
        return this.addMethod(shortName, realName, JavaTypes.VOID, params);
    }

    public IMethod addMethod(String shortName, String realName, ITypeReference typeRef, List params) {
        IMethod newMethod = (IMethod)this.getModel().createCodeElement(this.getFile(), shortName, realName, "method");
        Iterator iter = params.iterator();
        while (iter.hasNext()) {
            IParameter aParam = (IParameter)iter.next();
            newMethod.addParameter(aParam.getName(), aParam.getTypeReference(), aParam.getPosition());
        }
        newMethod.setTypeReference(typeRef);
        return (IMethod)this.addCodeElement(newMethod);
    }

    public Iterator methods() {
        return this.getCodeElements("method");
    }

    public IMethod findMethod(String shortSignature) {
        Iterator allMethods = this.methods();
        while (allMethods.hasNext()) {
            IMethod next = (IMethod)allMethods.next();
            if (!next.getShortSignature(true).equals(shortSignature)) continue;
            return next;
        }
        return null;
    }

    public IField addField(String shortName, String realName, ITypeReference typeRef) {
        IField newField = (IField)this.getModel().createCodeElement(this.getFile(), shortName, realName, "field");
        newField.setTypeReference(typeRef);
        return (IField)this.addCodeElement(newField);
    }

    public Iterator fields() {
        return this.getCodeElements("field");
    }

    public IField findField(String shortName) {
        Iterator allFields = this.fields();
        while (allFields.hasNext()) {
            IField next = (IField)allFields.next();
            if (!next.getShortName().equals(shortName)) continue;
            return next;
        }
        return null;
    }

    public IJavaClassifier getInnerClassifier(String shortName, String realName, boolean byValid, boolean create) {
        Iterator classifiers = this.getCodeElements("classifier");
        while (classifiers.hasNext()) {
            IJavaClassifier next = (IJavaClassifier)classifiers.next();
            if (!(byValid ? shortName.equals(next.getShortName()) : realName.equals(next.getRealShortName()))) continue;
            return next;
        }
        if (!create) {
            return null;
        }
        IJavaClassifier newClass = (IJavaClassifier)this.getModel().createCodeElement(this.getFile(), shortName, realName, "classifier");
        this.addCodeElement(newClass);
        return newClass;
    }

    public Iterator innerClassifiers() {
        return this.getCodeElements("classifier");
    }

    public boolean isInterface() {
        return this.myIsInterface;
    }

    public void setInterface(boolean anInterface) {
        this.myIsInterface = anInterface;
    }

    public void setVisibility(String visibility) {
        if (visibility == null || "public".equals(visibility) || "".equals(visibility)) {
            super.setVisibility(visibility);
            return;
        }
        boolean isTop = this.getParent() == null;
        boolean validValue = ("private".equals(visibility) || "protected".equals(visibility)) && !isTop;
        super.setVisibility(validValue ? visibility : "");
    }

    protected IInheritanceModel createInheritanceModel() {
        return new InheritanceModelImpl(this){

            public IInheritanceElement addElement(ITypeReference typeRef, int inheritanceKind) {
                int count;
                boolean anInterface = ((IJavaClassifier)this.getClassifier()).isInterface();
                if (anInterface) {
                    if (inheritanceKind == 1) {
                        String logMsg = String.valueOf(Resources.getString("JavaClassifier.Implementation_type_of_inheritance_is_not_supported_for_java_interfaces._n_1")) + Resources.getString("JavaClassifier._tElement__2") + typeRef.getQualifiedName() + Resources.getString("JavaClassifier._will_be_ignored_for_interface__3") + this.getClassifier().getQualifiedName();
                        Logger.getInstance().log("codegen", 1, logMsg);
                        return null;
                    }
                } else if (inheritanceKind == 0 && (count = this.getElements(0).length) > 0) {
                    String logMsg = String.valueOf(Resources.getString("JavaClassifier.Java_doesn__t_support_multiple_inheritance._n_5")) + Resources.getString("JavaClassifier._tElement__6") + typeRef.getQualifiedName() + Resources.getString("JavaClassifier._will_be_ignored_for_class__7") + this.getClassifier().getQualifiedName();
                    Logger.getInstance().log("codegen", 1, logMsg);
                    return null;
                }
                return super.addElement(typeRef, inheritanceKind);
            }
        };
    }

    private static boolean isConstructor(IMethod method) {
        return method.getShortName().equals(method.getClassifier().getShortName());
    }
}

