/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.ICodeModelFactory;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.util.JavaNames;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.File;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;

public class PackageImpl
implements IPackage {
    private ICodeModel myModel;
    private IPackage myParent;
    private String myShortName;
    private String myRealName;
    private ICodeModelFactory myFactory;
    private Vector myPackages;
    private Vector myFiles;

    public PackageImpl(IPackage parent, String shortName, String realName, ICodeModelFactory factory) {
        this.myParent = parent;
        this.myShortName = shortName;
        this.myFactory = factory;
        this.myRealName = realName;
        if (this.myParent != null && this.myParent instanceof PackageImpl) {
            ((PackageImpl)this.myParent).addChildPackage(this);
        }
    }

    public String getQualifiedName() {
        return this.getQualifiedName(true);
    }

    public String getQualifiedName(boolean getValid) {
        if (this.myParent == null) {
            return getValid ? this.getShortName() : this.getRealName();
        }
        String parentQName = this.myParent.getQualifiedName(getValid);
        if (parentQName.length() == 0) {
            return getValid ? this.getShortName() : this.getRealName();
        }
        return String.valueOf(parentQName) + "." + this.getShortName();
    }

    public String getPath() {
        StringBuffer path = new StringBuffer();
        StringTokenizer tokenizer = new StringTokenizer(this.getQualifiedName(), ".");
        while (tokenizer.hasMoreTokens()) {
            path.append(tokenizer.nextToken());
            if (!tokenizer.hasMoreTokens()) continue;
            path.append(File.separator);
        }
        return path.toString();
    }

    public ICodeModel getModel() {
        if (this.myModel == null) {
            IPackage aPackage = this;
            while (aPackage != null) {
                if (aPackage instanceof ICodeModel) {
                    this.myModel = (ICodeModel)aPackage;
                    break;
                }
                aPackage = aPackage.getParentPackage();
            }
        }
        return this.myModel;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public IPackage getParentPackage() {
        return this.myParent;
    }

    public IPackage[] getChildPackages() {
        return this.myPackages == null ? new IPackage[]{} : this.myPackages.toArray(new IPackage[this.myPackages.size()]);
    }

    public IPackage getChildPackage(String realShortName, boolean byValid, boolean create) {
        String validShortName = JavaNames.toJavaPackageName(realShortName);
        boolean existWithSuchShortName = false;
        if (this.myPackages != null) {
            int i = 0;
            while (i < this.myPackages.size()) {
                IPackage next = (IPackage)this.myPackages.elementAt(i);
                if (!byValid ? realShortName.equals(next.getRealName()) : validShortName.equals(next.getShortName())) {
                    return next;
                }
                if (validShortName.equals(next.getShortName())) {
                    existWithSuchShortName = true;
                }
                ++i;
            }
        }
        if (existWithSuchShortName && create) {
            validShortName = this.generateChildPackageUniqueName(validShortName);
        }
        return create ? this.myFactory.createPackage(this, validShortName, realShortName) : null;
    }

    public IFile[] getFiles() {
        return this.myFiles == null ? new IFile[]{} : this.myFiles.toArray(new IFile[this.myFiles.size()]);
    }

    public IFile getFile(String name, String realPublicClassName, boolean byValid, boolean create) {
        String validShortName = String.valueOf(JavaNames.toJavaClassShortName(realPublicClassName)) + ".java";
        String realName = String.valueOf(realPublicClassName) + ".java";
        boolean existWithSuchShortName = false;
        if (this.myFiles != null) {
            int i = 0;
            while (i < this.myFiles.size()) {
                IFile next = (IFile)this.myFiles.elementAt(i);
                if (!byValid ? realName.equals(next.getRealShortName()) : validShortName.equals(next.getShortName())) {
                    return next;
                }
                if (validShortName.equals(next.getShortName())) {
                    existWithSuchShortName = true;
                }
                ++i;
            }
        }
        if (existWithSuchShortName && create) {
            validShortName = this.generateChildFileUniqueName(validShortName);
        }
        return create ? this.myFactory.createFile(this, validShortName, realName) : null;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public IClassifier findChildClassifier(String shortName, boolean recursive) {
        IFile[] files = this.getFiles();
        int i = 0;
        while (i < files.length) {
            Iterator classes = files[i].getCodeElements("classifier");
            while (classes.hasNext()) {
                IClassifier nextClass = (IClassifier)classes.next();
                if (!nextClass.getShortName().equals(shortName)) continue;
                return nextClass;
            }
            ++i;
        }
        if (!recursive) {
            return null;
        }
        IPackage[] children = this.getChildPackages();
        int i2 = 0;
        while (i2 < children.length) {
            IClassifier found = children[i2].findChildClassifier(shortName, recursive);
            if (found != null) {
                return found;
            }
            ++i2;
        }
        return null;
    }

    ICodeModelFactory getFactory() {
        return this.myFactory;
    }

    void addChildPackage(IPackage childPackage) {
        if (this.myPackages == null) {
            this.myPackages = new Vector();
        }
        this.myPackages.add(childPackage);
    }

    void addFile(IFile file) {
        if (this.myFiles == null) {
            this.myFiles = new Vector();
        }
        if (file.getShortName().indexOf("/") != -1) {
            String errMsg = String.valueOf(Resources.getString("PackageImpl.File_name__4")) + file.getShortName() + Resources.getString("PackageImpl._is_not_valid._It_should_not_contain_separators_5");
            Logger.getInstance().log("codegen", 2, errMsg);
            return;
        }
        this.myFiles.add(file);
    }

    public void setRealName(String myRealName) {
        this.myRealName = myRealName;
    }

    public String getRealName() {
        return this.myRealName;
    }

    public boolean childPackageExistByShortName(String shortName) {
        if (this.myPackages != null) {
            int i = 0;
            while (i < this.myPackages.size()) {
                IPackage next = (IPackage)this.myPackages.get(i);
                if (next.getShortName().equals(shortName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean childFileExistByShortName(String shortName) {
        if (this.myFiles != null) {
            int i = 0;
            while (i < this.myFiles.size()) {
                IFile next = (IFile)this.myFiles.get(i);
                if (next.getShortName().equals(shortName)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private String generateChildPackageUniqueName(String name) {
        int index = 0;
        String newName = name;
        while (this.childPackageExistByShortName(newName)) {
            newName = String.valueOf(name) + ++index;
        }
        return String.valueOf(name) + index;
    }

    private String generateChildFileUniqueName(String name) {
        int index = 0;
        int indexOfDot = name.lastIndexOf(".");
        String filename = null;
        String ext = null;
        if (indexOfDot == -1) {
            return null;
        }
        filename = name.substring(0, indexOfDot);
        ext = name.substring(indexOfDot);
        String newName = String.valueOf(filename) + ext;
        while (this.childFileExistByShortName(newName)) {
            newName = String.valueOf(filename) + ++index + ext;
        }
        return newName;
    }
}

