/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElementContainer;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.codegen.IParameter;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.mdlimport.impl.codegen.MemberImpl;
import java.util.Iterator;
import java.util.Vector;

public class MethodImpl
extends MemberImpl
implements IMethod {
    private Vector myParameters;
    private Vector myThrowList;

    public MethodImpl(IFile file, String shortName, String realName, ITypeReference returnType) {
        super(file, shortName, realName, "method", returnType);
    }

    public IParameter[] getParameters() {
        if (this.myParameters == null) {
            return new IParameter[0];
        }
        Vector<IParameter> nonEmptyParams = new Vector<IParameter>();
        int i = 0;
        while (i < this.myParameters.size()) {
            IParameter next = (IParameter)this.myParameters.elementAt(i);
            if (next != null) {
                nonEmptyParams.add(next);
            }
            ++i;
        }
        return nonEmptyParams.toArray(new IParameter[nonEmptyParams.size()]);
    }

    public IParameter addParameter(String name, ITypeReference typeRef) {
        return this.addParameter(name, typeRef, this.getParameters().length);
    }

    public IParameter addParameter(String name, ITypeReference typeRef, int position) {
        if (this.myParameters == null) {
            this.myParameters = new Vector();
        }
        ParameterImpl newParam = new ParameterImpl(name, typeRef, position);
        if (this.myParameters.size() < position) {
            this.myParameters.setSize(position);
        }
        this.myParameters.insertElementAt(newParam, position);
        return newParam;
    }

    public String getSignature(boolean qNames) {
        return this.getSignature(qNames, false);
    }

    public String getShortSignature(boolean qNames) {
        return this.getSignature(qNames, true);
    }

    public String getQualifiedName() {
        return String.valueOf(this.getClassifier().getQualifiedName()) + "." + this.getShortSignature(true);
    }

    public String getQualifiedName(boolean getValid) {
        return String.valueOf(this.getClassifier().getQualifiedName(getValid)) + "." + this.getShortSignature(true);
    }

    private String getSignature(boolean qNames, boolean isShort) {
        String typeName;
        boolean shortTypeAccepted;
        ITypeReference typeRef;
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getShortName());
        buffer.append("(");
        IParameter[] params = this.getParameters();
        int i = 0;
        while (i < params.length) {
            IParameter nextParam = params[i];
            typeRef = nextParam.getTypeReference();
            shortTypeAccepted = this.acceptShortTypeRef(this.getFile(), typeRef);
            typeName = qNames || !shortTypeAccepted ? typeRef.getFullName() : typeRef.getShortName();
            buffer.append(typeName);
            if (typeRef.isArray()) {
                int dimension = typeRef.getArrayDimension();
                int j = 0;
                while (j < dimension) {
                    buffer.append("[]");
                    ++j;
                }
            }
            if (!isShort) {
                buffer.append(" ");
                buffer.append(nextParam.getName());
            }
            if (i < params.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(")");
        ITypeReference[] throwList = this.getThrowList();
        if (throwList.length > 0) {
            buffer.append(" throws ");
            int i2 = 0;
            while (i2 < throwList.length) {
                typeRef = throwList[i2];
                shortTypeAccepted = this.acceptShortTypeRef(this.getFile(), typeRef);
                typeName = qNames || !shortTypeAccepted ? typeRef.getFullName() : typeRef.getShortName();
                buffer.append(typeName);
                if (i2 < throwList.length - 1) {
                    buffer.append(", ");
                }
                ++i2;
            }
        }
        return buffer.toString();
    }

    private boolean acceptShortTypeRef(ICodeElementContainer container, ITypeReference typeRef) {
        Iterator codeElements = container.getCodeElements("classifier");
        while (codeElements.hasNext()) {
            ITypeReference classRef;
            IClassifier nextClass = (IClassifier)codeElements.next();
            if (nextClass.getShortName().equals(typeRef.getShortName()) && (classRef = nextClass.createTypeReference()) != null && !classRef.equals(typeRef)) {
                return false;
            }
            if (this.acceptShortTypeRef(nextClass, typeRef)) continue;
            return false;
        }
        return true;
    }

    public void addThrowReference(ITypeReference throwType) {
        if (this.myThrowList == null) {
            this.myThrowList = new Vector();
        }
        this.myThrowList.add(throwType);
    }

    public ITypeReference[] getThrowList() {
        if (this.myThrowList == null) {
            return new ITypeReference[0];
        }
        return this.myThrowList.toArray(new ITypeReference[this.myThrowList.size()]);
    }

    public static class ParameterImpl
    implements IParameter {
        private String myParamName;
        private ITypeReference myParamTypeRef;
        private int myPosition;

        public ParameterImpl(String name, ITypeReference typeRef, int pos) {
            this.myParamName = name;
            this.myPosition = pos;
            if (typeRef != null) {
                this.setTypeReference(typeRef);
            }
        }

        public String getName() {
            return this.myParamName;
        }

        public void setTypeReference(ITypeReference typeRef) {
            this.myParamTypeRef = typeRef;
        }

        public ITypeReference getTypeReference() {
            return this.myParamTypeRef;
        }

        public int getPosition() {
            return this.myPosition;
        }
    }
}

