/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.IInheritanceElement;
import com.borland.mdlimport.codegen.IInheritanceModel;
import com.borland.mdlimport.codegen.ITypeReference;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Vector;

public class InheritanceModelImpl
implements IInheritanceModel {
    private IClassifier myParent;
    private HashMap myElements;

    public InheritanceModelImpl(IClassifier parent) {
        this.myParent = parent;
    }

    public IInheritanceElement[] getElements() {
        if (this.myElements == null) {
            return new IInheritanceElement[0];
        }
        Iterator kindsIter = this.myElements.keySet().iterator();
        Vector allElements = new Vector();
        while (kindsIter.hasNext()) {
            allElements.addAll((Vector)this.myElements.get(kindsIter.next()));
        }
        return allElements.toArray(new IInheritanceElement[allElements.size()]);
    }

    public IInheritanceElement[] getElements(int inheritanceKind) {
        Vector elems = this.myElements == null ? null : (Vector)this.myElements.get(new Integer(inheritanceKind));
        return elems == null ? new IInheritanceElement[]{} : elems.toArray(new IInheritanceElement[elems.size()]);
    }

    public IInheritanceElement addElement(final ITypeReference typeRef, final int inheritanceKind) {
        Vector<1> elems;
        String qName = typeRef.getQualifiedName();
        if (qName == null || qName.length() == 0) {
            Logger.getInstance().log("codegen", 2, Resources.getString("InheritanceModelImpl.Cannot_add_inheritance_element_with_empty_qualified_name_2"));
            return null;
        }
        if (this.myElements == null) {
            this.myElements = new HashMap();
        }
        if ((elems = (Vector<1>)this.myElements.get(new Integer(inheritanceKind))) == null) {
            elems = new Vector<1>();
            this.myElements.put(new Integer(inheritanceKind), elems);
        }
        final InheritanceModelImpl model = this;
        IInheritanceElement newElement = new IInheritanceElement(){

            public ITypeReference getTypeReference() {
                return typeRef;
            }

            public int getInheritanceKind() {
                return inheritanceKind;
            }

            public IInheritanceModel getInhheritanceModel() {
                return model;
            }
        };
        elems.add(newElement);
        return newElement;
    }

    public IClassifier getClassifier() {
        return this.myParent;
    }
}

