/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeElementListener;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.ICodeModelFactory;
import com.borland.mdlimport.codegen.ICodeSerializer;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.mdlimport.impl.codegen.ClassifierImpl;
import com.borland.mdlimport.impl.codegen.FieldImpl;
import com.borland.mdlimport.impl.codegen.FileImpl;
import com.borland.mdlimport.impl.codegen.MethodImpl;
import com.borland.mdlimport.impl.codegen.PackageImpl;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.StringTokenizer;
import java.util.Vector;

public class CodeModelImpl
extends PackageImpl
implements ICodeModel {
    private String myLanguage;
    private ICodeModelFactory myDefaultFactory;
    private Vector myListeners;

    public CodeModelImpl(String language, ICodeModelFactory factory) {
        super(null, "", "", factory);
        this.myLanguage = language;
    }

    public String getLanguage() {
        return this.myLanguage;
    }

    public IPackage getPackage(String qualifiedName, boolean create) {
        String[] path = this.getPathForQName(qualifiedName);
        if (path.length == 0) {
            return null;
        }
        IPackage parent = this;
        int i = 0;
        while (i < path.length - 1) {
            if ((parent = parent.getChildPackage(path[i], false, create)) == null) break;
            ++i;
        }
        if (parent == null) {
            Logger.getInstance().log("codegen", 1, String.valueOf(Resources.getString("CodeModelImpl.Cannot_find_package_by_qualified_name__3")) + qualifiedName);
            return null;
        }
        String name = path[path.length - 1];
        return parent.getChildPackage(name, false, create);
    }

    public ICodeElement createCodeElement(IFile file, String shortName, String realName, String codeElementType) {
        ICodeElement element = this.getFactory().createCodeElement(file, shortName, realName, codeElementType);
        return element == null ? this.getDefaultFactory().createCodeElement(file, shortName, realName, codeElementType) : element;
    }

    public void addCodeElementListener(ICodeElementListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new Vector();
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeCodeElementListener(ICodeElementListener listener) {
        if (this.myListeners == null) {
            return;
        }
        this.myListeners.remove(listener);
    }

    public IClassifier findClassifier(String qName, boolean byValid) {
        return null;
    }

    void fireCodeElementCreated(ICodeElement codeElement) {
        if (this.myListeners == null) {
            return;
        }
        int i = 0;
        while (i < this.myListeners.size()) {
            ((ICodeElementListener)this.myListeners.elementAt(i)).codeElementCreated(codeElement);
            ++i;
        }
    }

    protected String[] getPathForQName(String qualifiedName) {
        Vector<String> path = new Vector<String>();
        StringTokenizer tokenizer = new StringTokenizer(qualifiedName, ".");
        while (tokenizer.hasMoreTokens()) {
            path.add(tokenizer.nextToken());
        }
        return path.toArray(new String[path.size()]);
    }

    private ICodeModelFactory getDefaultFactory() {
        if (this.myDefaultFactory == null) {
            this.myDefaultFactory = new DefaultModelFactory();
        }
        return this.myDefaultFactory;
    }

    private class DefaultModelFactory
    implements ICodeModelFactory {
        DefaultModelFactory() {
        }

        public ICodeModel createModel() {
            return null;
        }

        public IPackage createPackage(IPackage parentPackage, String shortName, String realName) {
            return new PackageImpl(parentPackage, shortName, realName, CodeModelImpl.this.getFactory());
        }

        public IFile createFile(IPackage parentPackage, String fileName, String realFileName) {
            return new FileImpl(this, parentPackage, fileName, realFileName){
                final /* synthetic */ DefaultModelFactory this$1;
                {
                    this.this$1 = defaultModelFactory;
                }

                public boolean isTypeAvailable(String type) {
                    return "classifier".equals(type);
                }
            };
        }

        public ICodeElement createCodeElement(IFile file, String shortName, String realName, String codeElementType) {
            if ("classifier".equals(codeElementType)) {
                return new ClassifierImpl(file, shortName, realName);
            }
            if ("method".equals(codeElementType)) {
                return new MethodImpl(file, shortName, realName, null);
            }
            if ("field".equals(codeElementType)) {
                return new FieldImpl(file, shortName, realName, null);
            }
            return null;
        }

        public ICodeSerializer createSerializer() {
            return null;
        }
    }
}

