/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.IAnnotated;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeElementContainer;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.IComment;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IModifiers;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.mdlimport.codegen.ITag;
import com.borland.mdlimport.impl.codegen.AnnotatedImpl;

public abstract class CodeElementImpl
implements ICodeElement {
    private ICodeElementContainer myParent;
    private IFile myFile;
    protected String myShortName;
    protected String myRealName;
    private String myType;
    private String myVisibility;
    private IModifiers myModifiers;
    private boolean myIsCommented = false;
    private IComment myComment;
    private IAnnotated myAnnotated = new AnnotatedImpl();

    public CodeElementImpl(IFile file, String shortName, String realName, String type) {
        this.myFile = file;
        this.myShortName = shortName;
        this.myType = type;
        this.myRealName = realName;
    }

    public ICodeElementContainer getParent() {
        return this.myParent;
    }

    void setParent(ICodeElementContainer parent) {
        this.myParent = parent;
    }

    public ICodeModel getModel() {
        return this.getPackage().getModel();
    }

    public IFile getFile() {
        return this.myFile;
    }

    public String getShortName() {
        return this.myShortName;
    }

    public void setShortName(String name) {
        this.myShortName = name;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public String getCodeElementType() {
        return this.myType;
    }

    public IPackage getPackage() {
        return this.getFile().getPackage();
    }

    public IModifiers getModifiers() {
        if (this.myModifiers == null) {
            this.myModifiers = new IModifiers(){
                private int myFlags = 0;

                public int getFlags() {
                    return this.myFlags;
                }

                public int setFlag(int flag) {
                    this.myFlags |= flag;
                    return this.myFlags;
                }

                public boolean hasFlag(int flag) {
                    return (this.myFlags & flag) != 0;
                }

                public int clearFlag(int flag) {
                    this.myFlags &= ~flag;
                    return this.myFlags;
                }
            };
        }
        return this.myModifiers;
    }

    public String getVisibility() {
        return this.myVisibility;
    }

    public void setVisibility(String visibility) {
        this.myVisibility = visibility;
    }

    public boolean isCommented() {
        return this.myIsCommented;
    }

    public IComment getComment() {
        return this.myComment;
    }

    public void setCommented(boolean commented, IComment comment) {
        this.myIsCommented = commented;
        this.myComment = comment;
    }

    public String getDescription() {
        return this.myAnnotated.getDescription();
    }

    public void setDescription(String description) {
        this.myAnnotated.setDescription(description);
    }

    public ITag[] getTags() {
        return this.myAnnotated.getTags();
    }

    public ITag addTag(String name, String value) {
        return this.myAnnotated.addTag(name, value);
    }

    public void setRealName(String myRealName) {
        this.myRealName = myRealName;
    }

    public String getRealShortName() {
        return this.myRealName;
    }
}

