/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.impl.codegen;

import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeElementContainer;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.IMethod;
import com.borland.mdlimport.impl.codegen.CodeElementImpl;
import com.borland.mdlimport.impl.codegen.CodeModelImpl;
import com.borland.util.FilteredIterator;
import com.borland.util.ICondition;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;

public abstract class CodeElementContainerImpl
implements ICodeElementContainer {
    private List myElements;
    private Comparator myComparator;

    public ICodeElement addCodeElement(ICodeElement codeElement) {
        return this.addCodeElementInternal(codeElement, this);
    }

    public void removeCodeElement(ICodeElement codeElement) {
        this.removeCodeElementInternal(codeElement);
    }

    public Iterator getCodeElements(final String type) {
        if (!this.isTypeAvailable(type)) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("CodeElementContainerImpl.Child_elements_of_type__2")) + type + Resources.getString("CodeElementContainerImpl._are_not_available_for_container__3") + this);
            return new ArrayList().iterator();
        }
        ICondition typeCondition = new ICondition(){

            public boolean accept(Object source) {
                if (!(source instanceof ICodeElement)) {
                    return false;
                }
                return type.equals(((ICodeElement)source).getCodeElementType());
            }
        };
        this.sort();
        return this.myElements == null ? new ArrayList().iterator() : new FilteredIterator(this.myElements.iterator(), typeCondition);
    }

    public Iterator getAllCodeElements() {
        if (this.myElements == null) {
            return new ArrayList().iterator();
        }
        this.sort();
        return this.myElements.iterator();
    }

    public void setElementComparator(Comparator comparator) {
        this.myComparator = comparator;
    }

    public Comparator getElementComparator() {
        return this.myComparator;
    }

    ICodeElement addCodeElementInternal(ICodeElement codeElement, ICodeElementContainer parent) {
        ICodeModel model;
        String type = codeElement.getCodeElementType();
        if (!this.isTypeAvailable(type)) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("CodeElementContainerImpl.Cannot_add_code_element_of_type__5")) + type + Resources.getString("CodeElementContainerImpl._to_container__6") + this);
            return null;
        }
        this.setUniqueShortName(codeElement);
        if (this.myElements == null) {
            this.myElements = new ArrayList();
        }
        this.myElements.add(codeElement);
        if (codeElement instanceof CodeElementImpl) {
            ((CodeElementImpl)codeElement).setParent(parent);
        }
        if ((model = codeElement.getModel()) != null && model instanceof CodeModelImpl) {
            ((CodeModelImpl)model).fireCodeElementCreated(codeElement);
        }
        return codeElement;
    }

    void removeCodeElementInternal(ICodeElement codeElement) {
        if (this.myElements != null) {
            this.myElements.remove(codeElement);
        }
    }

    private void sort() {
        if (this.myElements != null && this.myComparator != null) {
            Collections.sort(this.myElements, this.myComparator);
        }
    }

    private boolean nameExists(String type, ICodeElement codeElement) {
        String name = codeElement.getShortName();
        if (codeElement instanceof IMethod) {
            name = ((IMethod)codeElement).getShortSignature(true);
        }
        Iterator iter = this.getCodeElements(type);
        while (iter.hasNext()) {
            IMethod method;
            ICodeElement next = (ICodeElement)iter.next();
            if (!(next instanceof IMethod ? name.equals((method = (IMethod)next).getShortSignature(true)) : name.equals(next.getShortName()))) continue;
            return true;
        }
        return false;
    }

    private void setUniqueShortName(ICodeElement codeElement) {
        String shortName = codeElement.getShortName();
        String type = codeElement.getCodeElementType();
        String newName = shortName;
        int i = 1;
        while (this.nameExists(type, codeElement)) {
            newName = String.valueOf(shortName) + i;
            codeElement.setShortName(newName);
            ++i;
        }
        codeElement.setShortName(newName);
    }
}

