/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.command;

import com.borland.util.ICondition;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CommandProcessor {
    private static Map ourWaitingCommands;

    public static void runCommandLater(Runnable command, String eventCode) {
        CommandProcessor.runCommandLater(command, eventCode, null);
    }

    public static void runCommandLater(Runnable command, String eventCode, String value) {
        CommandProcessor.runCommandLater(new WaitingCommand(command, eventCode, value), eventCode);
    }

    public static void runCommandLater(Runnable command, String eventCode, ICondition condition) {
        CommandProcessor.runCommandLater(new WaitingCommand(command, eventCode, condition), eventCode);
    }

    private static void runCommandLater(WaitingCommand command, String eventCode) {
        LinkedList<WaitingCommand> commands;
        if (ourWaitingCommands == null) {
            ourWaitingCommands = new HashMap();
        }
        if ((commands = (LinkedList<WaitingCommand>)ourWaitingCommands.get(eventCode)) == null) {
            commands = new LinkedList<WaitingCommand>();
            ourWaitingCommands.put(eventCode, commands);
        }
        commands.add(command);
    }

    public static void notify(String eventCode, Object value) {
        if (ourWaitingCommands == null || ourWaitingCommands.size() == 0) {
            return;
        }
        List commands = (List)ourWaitingCommands.get(eventCode);
        if (commands == null || commands.size() == 0) {
            ourWaitingCommands.remove(eventCode);
            return;
        }
        ArrayList currentCommands = new ArrayList(commands);
        Iterator it = currentCommands.iterator();
        while (it.hasNext()) {
            WaitingCommand nextCommand = (WaitingCommand)it.next();
            if (!CommandProcessor.accept(nextCommand, value)) continue;
            try {
                nextCommand.run();
            }
            catch (OutOfMemoryError err) {
                Logger.getInstance().log("command", err);
                CommandProcessor.clear();
                throw err;
            }
            catch (Throwable th) {
                String errMsg = String.valueOf(Resources.getString("CommandProcessor.Exception_occured_during_running_deferred_command._Event_code__2")) + eventCode + Resources.getString("CommandProcessor.,_value__3") + value;
                Logger.getInstance().log("command", 2, errMsg);
                Logger.getInstance().log("command", th);
            }
            commands.remove(nextCommand);
        }
        if (commands.size() == 0) {
            ourWaitingCommands.remove(eventCode);
        }
        if (ourWaitingCommands.size() == 0) {
            ourWaitingCommands = null;
        }
    }

    public static boolean hasCommands() {
        boolean hasCommands;
        boolean bl = hasCommands = ourWaitingCommands != null && ourWaitingCommands.size() > 0;
        if (hasCommands && Logger.getInstance().hasCategory("command")) {
            Iterator eventCodes = ourWaitingCommands.keySet().iterator();
            while (eventCodes.hasNext()) {
                String code = (String)eventCodes.next();
                Logger.getInstance().log("command", String.valueOf(Resources.getString("CommandProcessor.Not_executed_commands_found_for_event_code__8")) + code + Resources.getString("CommandProcessor.._Number_of_commands__9") + ((List)ourWaitingCommands.get(code)).size());
            }
        }
        return hasCommands;
    }

    public static void clear() {
        if (ourWaitingCommands != null) {
            ourWaitingCommands.clear();
            ourWaitingCommands = null;
        }
    }

    private static boolean accept(WaitingCommand command, Object value) {
        ICondition condition = command.getCondition();
        if (condition != null) {
            return condition.accept(value);
        }
        if (command.getValue() == null && value == null) {
            return true;
        }
        return value != null && value.equals(command.getValue());
    }

    private static class WaitingCommand
    implements Runnable {
        private Runnable myCommand;
        private String myEventCode;
        private String myValue;
        ICondition myCondition;

        public WaitingCommand(Runnable command, String eventCode, String value) {
            this.myCommand = command;
            this.myEventCode = eventCode;
            this.myValue = value;
        }

        public WaitingCommand(Runnable command, String eventCode, ICondition condition) {
            this.myCommand = command;
            this.myEventCode = eventCode;
            this.myCondition = condition;
        }

        public void run() {
            this.myCommand.run();
        }

        public String getEventCode() {
            return this.myEventCode;
        }

        public String getValue() {
            return this.myValue;
        }

        public ICondition getCondition() {
            return this.myCondition;
        }
    }
}

