/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.codegen.java;

import com.borland.mdlimport.codegen.ITypeReference;
import java.util.ArrayList;
import java.util.List;

public class JavaTypes {
    private static final List PRIMITIVE_TYPES = new ArrayList();
    public static final ITypeReference VOID;
    public static final ITypeReference BOOLEAN;
    public static final ITypeReference INT;
    public static final ITypeReference SHORT;
    public static final ITypeReference LONG;
    public static final ITypeReference BYTE;
    public static final ITypeReference DOUBLE;
    public static final ITypeReference FLOAT;
    public static final ITypeReference CHAR;
    public static final ITypeReference STRING;
    public static final ITypeReference VECTOR;

    static {
        PRIMITIVE_TYPES.add("void");
        PRIMITIVE_TYPES.add("boolean");
        PRIMITIVE_TYPES.add("int");
        PRIMITIVE_TYPES.add("short");
        PRIMITIVE_TYPES.add("long");
        PRIMITIVE_TYPES.add("byte");
        PRIMITIVE_TYPES.add("double");
        PRIMITIVE_TYPES.add("float");
        PRIMITIVE_TYPES.add("char");
        VOID = JavaTypes.createSimpleTypeReference("void");
        BOOLEAN = JavaTypes.createSimpleTypeReference("boolean");
        INT = JavaTypes.createSimpleTypeReference("int");
        SHORT = JavaTypes.createSimpleTypeReference("short");
        LONG = JavaTypes.createSimpleTypeReference("long");
        BYTE = JavaTypes.createSimpleTypeReference("byte");
        DOUBLE = JavaTypes.createSimpleTypeReference("double");
        FLOAT = JavaTypes.createSimpleTypeReference("float");
        CHAR = JavaTypes.createSimpleTypeReference("char");
        STRING = JavaTypes.createTypeReference("java.lang.String");
        VECTOR = JavaTypes.createTypeReference("java.util.Vector");
    }

    private static ITypeReference createSimpleTypeReference(String simpleType) {
        return JavaTypes.createSimpleTypeReference(simpleType, 0);
    }

    private static ITypeReference createSimpleTypeReference(final String simpleType, final int arrayDimension) {
        return new AbstractType(){

            public boolean isSimpleType() {
                return true;
            }

            public int getArrayDimension() {
                return arrayDimension;
            }

            public String getQualifiedName() {
                return null;
            }

            public String getShortName() {
                return simpleType;
            }

            public String getFullName() {
                return this.getShortName();
            }

            public String getLocation() {
                return null;
            }
        };
    }

    public static ITypeReference toArrayType(ITypeReference singleTypeRef) {
        return JavaTypes.toArrayType(singleTypeRef, 1);
    }

    public static ITypeReference toArrayType(final ITypeReference singleTypeRef, final int arrayDimension) {
        if (arrayDimension == 0) {
            return singleTypeRef;
        }
        return new AbstractType(){

            public boolean isSimpleType() {
                return singleTypeRef.isSimpleType();
            }

            public int getArrayDimension() {
                return arrayDimension;
            }

            public String getQualifiedName() {
                return singleTypeRef.getQualifiedName();
            }

            public String getShortName() {
                return singleTypeRef.getShortName();
            }

            public String getFullName() {
                return singleTypeRef.getFullName();
            }

            public String getLocation() {
                return singleTypeRef.getLocation();
            }
        };
    }

    public static ITypeReference toSingleType(final ITypeReference arrayTypeRef) {
        if (!arrayTypeRef.isArray()) {
            return arrayTypeRef;
        }
        return new AbstractType(){

            public boolean isSimpleType() {
                return arrayTypeRef.isSimpleType();
            }

            public int getArrayDimension() {
                return 0;
            }

            public String getQualifiedName() {
                return arrayTypeRef.getQualifiedName();
            }

            public String getShortName() {
                return arrayTypeRef.getShortName();
            }

            public String getFullName() {
                return this.getQualifiedName();
            }

            public String getLocation() {
                return arrayTypeRef.getLocation();
            }
        };
    }

    public static ITypeReference createTypeReference(String qName) {
        if (qName == null || qName.length() == 0) {
            return VOID;
        }
        int arrayDimension = JavaTypes.getArrayDimension(qName);
        String singleQName = JavaTypes.toSingleTypeName(qName);
        if (PRIMITIVE_TYPES.contains(singleQName)) {
            return JavaTypes.createSimpleTypeReference(singleQName, arrayDimension);
        }
        if (JavaTypes.isJavaLangType(singleQName)) {
            return JavaTypes.toArrayType(JavaTypes.createJavaLangType(singleQName), arrayDimension);
        }
        return JavaTypes.createTypeReferenceInternal(singleQName, arrayDimension);
    }

    public static boolean isJavaLangType(String name) {
        return JavaTypes.createJavaLangType(name) != null;
    }

    public static ITypeReference createJavaLangType(String name) {
        if (name.startsWith("java.lang.")) {
            String subName = name.substring("java.lang.".length() + 1);
            if (subName.indexOf(".") == -1) {
                int arrayDimension = JavaTypes.getArrayDimension(name);
                String singleQName = JavaTypes.toSingleTypeName(name);
                return JavaTypes.createTypeReferenceInternal(singleQName, arrayDimension);
            }
            return null;
        }
        if (name.indexOf(".") != -1) {
            return null;
        }
        int arrayDimension = JavaTypes.getArrayDimension(name);
        String singleQName = JavaTypes.toSingleTypeName(name);
        String fullName = "java.lang." + singleQName;
        try {
            Class.forName(fullName);
            return JavaTypes.createTypeReferenceInternal(fullName, arrayDimension);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    public static boolean isSimpleType(String typeName) {
        int arrayDimension = JavaTypes.getArrayDimension(typeName);
        String singleQName = arrayDimension > 0 ? typeName.substring(0, typeName.indexOf("[]")) : typeName;
        return PRIMITIVE_TYPES.contains(singleQName);
    }

    public static String toSingleTypeName(String typeName) {
        int index = typeName.indexOf("[]");
        return index == -1 ? typeName : typeName.substring(0, index);
    }

    public static int getArrayDimension(String qName) {
        int lastIndex;
        int dimension = 0;
        while ((lastIndex = qName.lastIndexOf("[]")) != -1) {
            qName = qName.substring(0, lastIndex);
            ++dimension;
        }
        return dimension;
    }

    private static ITypeReference createTypeReferenceInternal(final String qName, final int arrayDimension) {
        return new AbstractType(){
            private String myLocation;
            private String myShortName;
            private boolean parsed = false;

            public boolean isSimpleType() {
                return false;
            }

            public int getArrayDimension() {
                return arrayDimension;
            }

            public String getQualifiedName() {
                return qName;
            }

            public String getShortName() {
                if (!this.parsed) {
                    this.parseQName();
                }
                return this.myShortName;
            }

            public String getFullName() {
                return this.getQualifiedName();
            }

            public String getLocation() {
                if (!this.parsed) {
                    this.parseQName();
                }
                return this.myLocation;
            }

            private void parseQName() {
                int lastDot = qName.lastIndexOf(".");
                if (lastDot == -1) {
                    this.myLocation = "";
                    this.myShortName = qName;
                } else {
                    this.myLocation = qName.substring(0, lastDot);
                    this.myShortName = qName.substring(lastDot + 1);
                }
                this.parsed = true;
            }
        };
    }

    private static abstract class AbstractType
    implements ITypeReference {
        AbstractType() {
        }

        public int hashCode() {
            if (this.isSimpleType()) {
                return this.getShortName().hashCode();
            }
            return this.getQualifiedName().hashCode();
        }

        public boolean isArray() {
            return this.getArrayDimension() > 0;
        }

        public int getArrayDimension() {
            return 0;
        }

        public boolean equals(Object obj) {
            return obj instanceof ITypeReference && ((ITypeReference)obj).hashCode() == this.hashCode();
        }
    }
}

