/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.codegen.java;

import com.borland.mdlimport.codegen.IClassifier;
import com.borland.mdlimport.codegen.ICodeElement;
import com.borland.mdlimport.codegen.ICodeElementContainer;
import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.ICodeModelFactory;
import com.borland.mdlimport.codegen.ICodeSerializer;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.mdlimport.codegen.java.IJavaClassifier;
import com.borland.mdlimport.codegen.java.IJavaFile;
import com.borland.mdlimport.impl.codegen.CodeModelImpl;
import com.borland.mdlimport.impl.codegen.FieldImpl;
import com.borland.mdlimport.impl.codegen.MethodImpl;
import com.borland.mdlimport.impl.codegen.PackageImpl;
import com.borland.mdlimport.impl.codegen.java.JavaClassifier;
import com.borland.mdlimport.impl.codegen.java.JavaFile;
import com.borland.mdlimport.impl.codegen.java.JavaSerializer;

public class JavaModelFactory
implements ICodeModelFactory {
    public ICodeModel createModel() {
        return new CodeModelImpl("Java", this){

            public IClassifier findClassifier(String qName, boolean byValid) {
                if (qName == null || qName.length() == 0) {
                    return null;
                }
                IPackage aPackage = this;
                String[] path = this.getPathForQName(qName);
                int index = 0;
                while (index < path.length - 1) {
                    IPackage next = aPackage.getChildPackage(path[index], byValid, false);
                    if (next == null) break;
                    aPackage = next;
                    ++index;
                }
                String fileName = String.valueOf(path[index]) + ".java";
                IJavaFile file = (IJavaFile)aPackage.getFile(fileName, path[index], byValid, false);
                IJavaClassifier resultClass = null;
                if (file != null) {
                    String[] className = new String[path.length - index];
                    System.arraycopy(path, index, className, 0, className.length);
                    ICodeElementContainer classContainer = file;
                    int j = 0;
                    while (j < className.length) {
                        resultClass = classContainer instanceof IJavaFile ? classContainer.getClassifier(className[j], className[j], byValid, false) : ((IJavaClassifier)classContainer).getInnerClassifier(className[j], className[j], byValid, false);
                        if (resultClass == null) break;
                        classContainer = resultClass;
                        ++j;
                    }
                }
                return resultClass;
            }
        };
    }

    public IPackage createPackage(IPackage parentPackage, String shortName, String realName) {
        return new PackageImpl(parentPackage, shortName, realName, this);
    }

    public IFile createFile(IPackage parentPackage, String fileName, String realName) {
        return new JavaFile(parentPackage, fileName, realName);
    }

    public ICodeElement createCodeElement(IFile file, String shortName, String realName, String codeElementType) {
        if ("classifier".equals(codeElementType)) {
            return new JavaClassifier(file, shortName, realName){

                public String getVisibility() {
                    String visibility = super.getVisibility();
                    return visibility == null ? "public" : visibility;
                }

                public void setVisibility(String visibility) {
                    if (JavaModelFactory.this.isValidJavaVisibility(visibility)) {
                        super.setVisibility(visibility);
                    }
                }
            };
        }
        if ("method".equals(codeElementType)) {
            return new MethodImpl(file, shortName, realName, null){

                public String getVisibility() {
                    String visibility = super.getVisibility();
                    return visibility == null ? "public" : visibility;
                }

                public void setVisibility(String visibility) {
                    if (JavaModelFactory.this.isValidJavaVisibility(visibility)) {
                        super.setVisibility(visibility);
                    }
                }
            };
        }
        if ("field".equals(codeElementType)) {
            return new FieldImpl(file, shortName, realName, null){

                public String getVisibility() {
                    String visibility = super.getVisibility();
                    return visibility == null ? "private" : visibility;
                }

                public void setVisibility(String visibility) {
                    if (JavaModelFactory.this.isValidJavaVisibility(visibility)) {
                        super.setVisibility(visibility);
                    }
                }
            };
        }
        return null;
    }

    protected boolean isValidJavaVisibility(String visibility) {
        if ("public".equals(visibility)) {
            return true;
        }
        if ("protected".equals(visibility)) {
            return true;
        }
        if ("".equals(visibility)) {
            return true;
        }
        return "private".equals(visibility);
    }

    public ICodeSerializer createSerializer() {
        return new JavaSerializer();
    }
}

