/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport.codegen;

import com.borland.mdlimport.codegen.ICodeModel;
import com.borland.mdlimport.codegen.ICodeSerializer;
import com.borland.mdlimport.codegen.IFile;
import com.borland.mdlimport.codegen.IPackage;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class ModelWriter {
    private ICodeModel myModel;
    private ICodeSerializer mySerializer;
    private File myDestFolder;

    public ModelWriter(ICodeModel codeModel, ICodeSerializer serializer) {
        this.myModel = codeModel;
        this.mySerializer = serializer;
    }

    public ICodeModel getModel() {
        return this.myModel;
    }

    public boolean write(String destinationFolder) {
        return this.write(new File(destinationFolder));
    }

    public boolean write(File destinationFolder) {
        this.myDestFolder = destinationFolder;
        if (!this.createPackage(this.myModel)) {
            return false;
        }
        this.writeFiles(this.myModel);
        this.scanPackages(this.myModel);
        return true;
    }

    protected void scanPackages(IPackage parent) {
        IPackage[] packages = parent.getChildPackages();
        int i = 0;
        while (i < packages.length) {
            if (this.createPackage(packages[i])) {
                this.writeFiles(packages[i]);
                this.scanPackages(packages[i]);
            }
            ++i;
        }
    }

    protected void writeFiles(IPackage parent) {
        IFile[] files = parent.getFiles();
        int i = 0;
        while (i < files.length) {
            this.writeFile(parent, files[i]);
            ++i;
        }
    }

    protected boolean createPackage(IPackage aPackage) {
        File newFolder;
        String path = aPackage.getPath();
        File file = newFolder = path.length() == 0 ? this.myDestFolder : new File(this.myDestFolder, path);
        if (!newFolder.isDirectory() && !newFolder.mkdirs()) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("ModelWriter.Cannot_create_package__2")) + aPackage.getQualifiedName());
            return false;
        }
        return true;
    }

    protected boolean writeFile(IPackage aPackage, IFile file) {
        boolean deleted;
        String fullPath = file.getFullName();
        File newFile = new File(this.myDestFolder, fullPath);
        if (newFile.isFile() && !(deleted = newFile.delete())) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("ModelWriter.Cannot_remove_existing_file__4")) + newFile);
            return false;
        }
        boolean created = false;
        try {
            created = newFile.createNewFile();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (!created) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("ModelWriter.Cannot_create_file__6")) + newFile);
            return false;
        }
        if (!newFile.canWrite()) {
            Logger.getInstance().log("codegen", 2, String.valueOf(Resources.getString("ModelWriter.Cannot_write_to_file__8")) + newFile);
            return false;
        }
        String buffer = this.mySerializer.serialize(file);
        if (buffer == null || buffer.length() == 0) {
            Logger.getInstance().log("codegen", 1, String.valueOf(Resources.getString("ModelWriter.File__10")) + fullPath + Resources.getString("ModelWriter._has_empty_content_11"));
            return false;
        }
        try {
            BufferedWriter writer = new BufferedWriter(new FileWriter(newFile), buffer.length());
            writer.write(buffer);
            ((Writer)writer).close();
        }
        catch (IOException ex) {
            Logger.getInstance().log("codegen", ex);
            return false;
        }
        return true;
    }
}

