/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport;

import com.borland.mdlimport.Configuration;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;

public class PathAliasSearcher {
    private ArrayList myAliases;
    private HashMap myPlan;
    private ArrayList myListeners = new ArrayList();
    private Configuration myConfiguration;
    private static final String REFERENCE = "(file_name|external_doc_path)";

    private PathAliasSearcher(Configuration configuration) {
        this.myConfiguration = configuration;
        this.myListeners = new ArrayList();
    }

    public static PathAliasSearcher getInstance(Configuration configuration) {
        return new PathAliasSearcher(configuration);
    }

    public boolean canAdvance() {
        return this.myPlan == null || !this.myPlan.isEmpty();
    }

    public String[] advance() {
        Configuration configuration = this.getConfiguration();
        if (this.myAliases == null) {
            this.myAliases = new ArrayList();
        }
        ArrayList aliasesBeforeAdvance = new ArrayList();
        aliasesBeforeAdvance.addAll(this.myAliases);
        if (this.myPlan == null) {
            this.myPlan = new HashMap();
            File rootFile = configuration.petalFile;
            this.visitNode(rootFile);
        } else {
            ArrayList<String> paths = new ArrayList<String>();
            Iterator<Object> iterator = this.myPlan.keySet().iterator();
            while (iterator.hasNext()) {
                String alias = (String)iterator.next();
                ArrayList postponed = (ArrayList)this.myPlan.get(alias);
                Iterator iterator2 = postponed.iterator();
                while (iterator2.hasNext()) {
                    String path = (String)iterator2.next();
                    String realPath = this.replaceAlias(path, alias);
                    if (realPath.equals(path) || paths.contains(realPath)) continue;
                    paths.add(realPath);
                }
            }
            this.myPlan.clear();
            iterator = paths.iterator();
            while (iterator.hasNext()) {
                String path = (String)iterator.next();
                this.visitNode(new File(path));
            }
        }
        ArrayList newAliases = new ArrayList();
        newAliases.addAll(this.myAliases);
        newAliases.removeAll(aliasesBeforeAdvance);
        return newAliases.toArray(new String[newAliases.size()]);
    }

    /*
     * Unable to fully structure code
     */
    private void visitNode(File file) {
        content = this.loadFile(file);
        whitespaces = "(\\s){1,}";
        parts = content.split(whitespaces.concat("(file_name|external_doc_path)").concat(whitespaces));
        i = 1;
        while (i < parts.length) {
            block5: {
                part = parts[i];
                index = part.indexOf("\"", 1);
                if (index <= -1) break block5;
                path = part.substring(1, index);
                startIndex = path.indexOf("$");
                if (startIndex <= -1 || (endIndex = path.indexOf(92, startIndex + 1)) <= startIndex + 1) ** GOTO lbl27
                alias = path.substring(startIndex + 1, endIndex);
                realPath = this.replaceAlias(path, alias);
                if (realPath.equals(path)) {
                    if (!this.myAliases.contains(alias)) {
                        this.myAliases.add(alias);
                    }
                    if (!this.myPlan.containsKey(alias)) {
                        this.myPlan.put(alias, new ArrayList<E>());
                    }
                    postponed = (ArrayList)this.myPlan.get(alias);
                    postponed.add(path);
                    this.fireProgressChange(i, parts.length - 1, file.getName());
                } else {
                    path = realPath;
lbl27:
                    // 2 sources

                    this.fireProgressChange(i, parts.length - 1, file.getName());
                    this.visitNode(new File(path));
                }
            }
            ++i;
        }
    }

    private String replaceAlias(String path, String alias) {
        String replace = this.getConfiguration().getMdlOption(alias);
        if (replace == null) {
            return path;
        }
        File file = new File(replace);
        if (!file.exists() || !file.isDirectory()) {
            return path;
        }
        int index = path.indexOf("$");
        if (index == -1) {
            return path;
        }
        String lastPart = path.substring(index + alias.length() + 1);
        lastPart = PathAliasSearcher.convertPathToPlatformDependent(lastPart);
        file = new File(replace, lastPart);
        return file.getAbsolutePath();
    }

    private static String convertPathToPlatformDependent(String str) {
        if (File.separatorChar != '/') {
            str = str.replace('/', File.separatorChar);
        }
        if (File.separatorChar != '\\') {
            str = str.replace('\\', File.separatorChar);
        }
        return str;
    }

    private String loadFile(File file) {
        StringBuffer buffer = new StringBuffer();
        try {
            FileReader fileReader = new FileReader(file);
            BufferedReader reader = new BufferedReader(fileReader);
            while (true) {
                try {
                    String line = reader.readLine();
                    if (line == null) break;
                    buffer.append(line.trim()).append(" ");
                }
                catch (IOException e) {
                    break;
                }
            }
            reader.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return buffer.toString();
    }

    public String[] getAliases() {
        return this.myAliases.toArray(new String[this.myAliases.size()]);
    }

    public void fireProgressChange(int currentStep, int totalSteps, String report) {
        ProgressListener[] listeners = this.myListeners.toArray(new ProgressListener[this.myListeners.size()]);
        int i = 0;
        while (i < listeners.length) {
            listeners[i].parseProgressChanged(report, currentStep, totalSteps);
            ++i;
        }
    }

    public void addProgressListener(ProgressListener listener) {
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
    }

    public void removeProgressListener(ProgressListener listener) {
        this.myListeners.remove(listener);
    }

    private Configuration getConfiguration() {
        return this.myConfiguration;
    }

    public static interface ProgressListener {
        public void parseProgressChanged(String var1, int var2, int var3);
    }
}

