/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport;

import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.ImportProcessListener;
import com.borland.mdlimport.InvalidConfigurationException;
import com.borland.mdlimport.Messages;
import com.borland.mdlimport.command.CommandProcessor;
import com.borland.mdlimport.impl.petal.PetalVisitor;
import com.borland.mdlimport.impl.petal.parser.PetalParser;
import com.borland.mdlimport.impl.txv.NodeSet;
import com.borland.mdlimport.impl.txv.TXVAccessImpl;
import com.borland.mdlimport.mapping.DefaultMapping;
import com.borland.mdlimport.petal.IParser;
import com.borland.mdlimport.petal.IPetalNode;
import com.borland.mdlimport.petal.IPetalTreeVisitor;
import com.borland.mdlimport.txv.INodeSet;
import com.borland.mdlimport.txv.TxvAccess;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyVetoException;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

public class Importer {
    public static final String LOG_CATEGORY = "importer";
    private Configuration myConfiguration;
    private IParser myParser;
    private IPetalTreeVisitor myVisitor;
    private List myListeners;
    private PrintStream myLogStream;

    public Importer(Configuration configuration) throws InvalidConfigurationException {
        if (configuration == null) {
            throw new InvalidConfigurationException(Resources.getString("Importer.Importer_configuration_not_defined_2"));
        }
        this.myConfiguration = configuration;
        String validationError = this.myConfiguration.validate();
        PrintStream stream = this.createLogStream();
        Logger.getInstance().setStream(stream, stream);
        if (validationError != null) {
            Logger.getInstance().log(LOG_CATEGORY, 2, validationError);
            this.cleanUp();
            throw new InvalidConfigurationException(validationError);
        }
        TxvAccess.setImplementation(new TXVAccessImpl());
    }

    public boolean doImport() throws PropertyVetoException {
        boolean success;
        String errMsg = this.doImportInternal();
        boolean bl = success = errMsg == null;
        if (!success) {
            System.err.println(Messages.IMPORT_FAILED);
        }
        boolean errors = Logger.getInstance().getErrorCount() > 0;
        String msg = null;
        if (success) {
            if (errors) {
                msg = String.valueOf(Messages.COMPLETED_WITH_ERRORS) + " ";
                int logLevel = Logger.getInstance().getLevel();
                if (logLevel == 1 || logLevel == 2) {
                    msg = String.valueOf(msg) + Messages.SEE_LOG;
                }
            } else {
                msg = Messages.COMPLETED_SUCCESSFULLY;
            }
        } else {
            msg = errMsg;
        }
        int logType = success ? 3 : 2;
        Logger.getInstance().log(LOG_CATEGORY, logType, msg);
        return success;
    }

    public void cleanUp() {
        CommandProcessor.clear();
        this.closeLogStream();
        if (this.getConfiguration().fFile != null && this.getConfiguration().petalFile != null && this.getConfiguration().petalFile.delete()) {
            Logger.getInstance().log(LOG_CATEGORY, 0, "Pseudo mdl file " + this.getConfiguration().petalFile.getPath() + " is deleted");
        }
        Logger.createNewInstance();
        DefaultMapping.cleanUp();
    }

    public Configuration getConfiguration() {
        return this.myConfiguration;
    }

    public void setParser(IParser parser) {
        this.myParser = parser;
    }

    public IParser getParser() {
        if (this.myParser == null) {
            this.myParser = new PetalParser();
        }
        return this.myParser;
    }

    public void setVisitor(IPetalTreeVisitor visitor) {
        this.myVisitor = visitor;
    }

    public IPetalTreeVisitor getVisitor() {
        if (this.myVisitor == null) {
            this.myVisitor = new PetalVisitor(this.myConfiguration, this.getParser());
        }
        return this.myVisitor;
    }

    public void addImportProcessListener(ImportProcessListener listener) {
        if (this.myListeners == null) {
            this.myListeners = new ArrayList();
        }
        if (!this.myListeners.contains(listener)) {
            this.myListeners.add(listener);
        }
        this.getParser().addParseListener(listener);
    }

    public void removeImportProcessListener(ImportProcessListener listener) {
        if (this.myListeners != null && this.myListeners.contains(listener)) {
            this.myListeners.remove(listener);
        }
        this.getParser().removeParseListener(listener);
    }

    public INodeSet createNodeSet() {
        return new NodeSet();
    }

    protected PrintStream createLogStream() {
        File logFile = this.myConfiguration.logFile;
        if (logFile == null) {
            logFile = new File(System.getProperty("user.dir"), "mdlimport.log");
        }
        if (!logFile.isFile() && !logFile.exists()) {
            boolean fileCreated = false;
            try {
                fileCreated = logFile.createNewFile();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            if (!fileCreated) {
                System.err.println(String.valueOf(Resources.getString("Importer.Can__t_create_log_file__6")) + logFile);
                return null;
            }
        }
        if (!logFile.canWrite()) {
            System.err.println(String.valueOf(Resources.getString("Importer.Can__t_write_to_log_file__7")) + logFile);
            return null;
        }
        try {
            this.myLogStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile, true)));
        }
        catch (IOException ex) {
            System.err.println(String.valueOf(Resources.getString("Importer.Can__t_create_stream_for_log_file__8")) + logFile);
            return null;
        }
        return this.myLogStream;
    }

    protected void closeLogStream() {
        if (this.myLogStream != null) {
            this.myLogStream.flush();
            this.myLogStream.close();
            this.myLogStream = null;
        }
    }

    protected String doImportInternal() throws PropertyVetoException {
        IParser parser = this.getParser();
        if (parser == null) {
            return MessageFormat.format(Messages.CONFIGURATION_ERROR, Resources.getString("Importer.Parser_is_not_defined._9"));
        }
        this.fireParseStarted();
        IPetalNode rootNode = null;
        try {
            rootNode = parser.parse(this.myConfiguration);
        }
        catch (IOException ex) {
            Logger.getInstance().log("parser", ex);
        }
        if (rootNode == null) {
            return Messages.PARSE_FAILED;
        }
        this.fireParseCompleted();
        IPetalTreeVisitor visitor = this.getVisitor();
        if (visitor == null) {
            return MessageFormat.format(Messages.CONFIGURATION_ERROR, Resources.getString("Importer.Visitor_is_not_defined._11"));
        }
        DefaultMapping.registerDefaults(this);
        this.fireTraversalStarted();
        this.myConfiguration.getClass();
        visitor.visitObject(rootNode);
        visitor.finish();
        this.fireTraversalCompleted();
        return visitor.isSuccessful() ? null : visitor.getErrorMessage();
    }

    protected void fireParseStarted() {
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ImportProcessListener)this.myListeners.get(i)).parseStarted();
                ++i;
            }
        }
    }

    protected void fireParseCompleted() {
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ImportProcessListener)this.myListeners.get(i)).parseCompleted();
                ++i;
            }
        }
    }

    protected void fireTraversalStarted() {
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ImportProcessListener)this.myListeners.get(i)).traversalStarted();
                ++i;
            }
        }
    }

    protected void fireTraversalCompleted() {
        if (this.myListeners != null) {
            int i = 0;
            while (i < this.myListeners.size()) {
                ((ImportProcessListener)this.myListeners.get(i)).traversalCompleted();
                ++i;
            }
        }
    }
}

