/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport;

import com.borland.mdlimport.Messages;
import com.borland.mdlimport.impl.petal.StubMdlBuilder;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;

public class Configuration {
    public boolean isSubUnit = false;
    public boolean convertRoseDefaultColors = false;
    public double scaleFactor = 0.3;
    public File petalFile = null;
    public File destFolder = null;
    public String modelFolderName = "Model Folder";
    public String srcFolderName = "src";
    public String aliasesFileName = "aliases.tmp";
    public String progressFileName = "progress.tmp";
    public boolean generateSource = false;
    public boolean preserveDiagramNodeBounds = false;
    public boolean needProgressInfo = true;
    public String projectName = null;
    public File logFile = null;
    public File fFile = null;
    public File cpmFile = null;
    public boolean validateNames = false;
    public boolean inPackage = false;
    public boolean actors = false;
    public boolean assClassesAsProperty = false;
    public boolean useDiskFileToReturnValues = false;
    private static final List ROSE_EXTENSIONS = new ArrayList();
    private Map mdlOptions;
    private List myCustomPropMapping = new ArrayList();

    static {
        ROSE_EXTENSIONS.add("mdl");
        ROSE_EXTENSIONS.add("ptl");
        ROSE_EXTENSIONS.add("cat");
        ROSE_EXTENSIONS.add("sub");
    }

    public String validate() {
        if (this.fFile == null) {
            if (this.petalFile == null) {
                return Messages.PETAL_NOT_SPECIFIED;
            }
            if (!this.petalFile.isFile()) {
                return MessageFormat.format(Messages.FILE_NOT_FOUND, this.petalFile.toString());
            }
            boolean bl = this.isSubUnit = this.petalFile.getName().toLowerCase().endsWith(".cat") || this.petalFile.getName().toLowerCase().endsWith(".sub");
            if (!Configuration.isValidExtension(this.petalFile.getName())) {
                return Messages.EXTENSION_NOT_VALID;
            }
        }
        if (this.destFolder == null) {
            this.destFolder = new File(System.getProperty("user.dir"));
        }
        if (!this.destFolder.isDirectory() && !this.destFolder.mkdirs()) {
            return MessageFormat.format(Messages.CREATE_DIR_ERROR, this.destFolder.getName());
        }
        File modelFolder = new File(this.destFolder, this.modelFolderName);
        if (!modelFolder.isDirectory() && !modelFolder.mkdirs()) {
            return MessageFormat.format(Messages.CREATE_DIR_ERROR, modelFolder.getName());
        }
        if (!this.destFolder.canWrite()) {
            return MessageFormat.format(Messages.CANT_WRITE_TO_DIR, this.destFolder.getName());
        }
        if (this.logFile == null) {
            this.logFile = new File("mdlimport.log");
        }
        if (!this.isSubUnit && this.fFile != null) {
            if (!this.fFile.exists()) {
                return MessageFormat.format("File with paths to subunits {0} can not be found", this.fFile.getName());
            }
            try {
                File pseudo = StubMdlBuilder.createPseudoMdlFile(this.destFolder);
                StubMdlBuilder stubBuilder = new StubMdlBuilder(this.fFile);
                stubBuilder.write(pseudo);
                this.petalFile = pseudo;
            }
            catch (Exception e) {
                return MessageFormat.format("Error while creating pseudo mdl file. {0}", e.getMessage());
            }
        }
        if (this.cpmFile != null) {
            if (!this.cpmFile.exists()) {
                return MessageFormat.format("File with custom properties mapping {0} can not be found", this.cpmFile.getName());
            }
            try {
                this.gatherCustomPropertyMapping(this.cpmFile);
            }
            catch (Exception e) {
                return "Error while gathering custom properties mappings from file";
            }
        }
        return null;
    }

    public void addCustomPropertyMapping(String tool, String roseProp, String tgProp) {
        this.myCustomPropMapping.add(new CustomPropertyMapping(tool, roseProp, tgProp));
    }

    public List getCustomProperyMapping() {
        return this.myCustomPropMapping;
    }

    public void addMDLOption(String optionName, String optionValue) {
        if (this.mdlOptions == null) {
            this.mdlOptions = new HashMap();
        }
        this.mdlOptions.put(optionName.toLowerCase(), optionValue);
    }

    public String getMdlOption(String optionName) {
        String value;
        if (this.mdlOptions != null && (value = (String)this.mdlOptions.get(optionName.toLowerCase())) != null) {
            return value;
        }
        Logger.getInstance().log("importer", 1, String.valueOf(Resources.getString("Configuration.MDL_parameter____7")) + optionName + Resources.getString("Configuration.___is_not_specified._8"));
        return null;
    }

    protected static boolean isValidExtension(String fileName) {
        int dotIndex = fileName.lastIndexOf(".");
        if (dotIndex == -1 || dotIndex == fileName.length() - 1) {
            return false;
        }
        String ext = fileName.substring(dotIndex + 1);
        return ROSE_EXTENSIONS.contains(ext);
    }

    protected void gatherCustomPropertyMapping(File file) throws IOException {
        BufferedReader is = new BufferedReader(new FileReader(file));
        String str = null;
        while ((str = is.readLine()) != null) {
            StringTokenizer strtknzr = new StringTokenizer(str, ".= ");
            int i = 0;
            String tool = null;
            String rose = null;
            String tg = null;
            while (strtknzr.hasMoreTokens()) {
                String next = strtknzr.nextToken();
                switch (i) {
                    case 0: {
                        tool = next;
                        break;
                    }
                    case 1: {
                        rose = next;
                        break;
                    }
                    case 2: {
                        tg = next;
                    }
                }
                ++i;
            }
            this.addCustomPropertyMapping(tool, rose, tg);
        }
        is.close();
    }

    public static class CustomPropertyMapping {
        String myTool = null;
        String myRoseProp = null;
        String myTgProp = null;

        public CustomPropertyMapping(String tool, String rose, String tg) {
            this.myTool = tool;
            this.myRoseProp = rose;
            this.myTgProp = tg;
        }

        public String getTool() {
            return this.myTool;
        }

        public String getRosePropertyName() {
            return this.myRoseProp;
        }

        public String getTgPropertyName() {
            return this.myTgProp;
        }
    }
}

