/*
 * Decompiled with CFR 0.152.
 */
package com.borland.mdlimport;

import com.borland.mdlimport.CmdLineOptions;
import com.borland.mdlimport.Configuration;
import com.borland.mdlimport.ImportProcessAdapter;
import com.borland.mdlimport.Importer;
import com.borland.mdlimport.InvalidConfigurationException;
import com.borland.mdlimport.PathAliasSearcher;
import com.borland.util.IFunction;
import com.borland.util.ILogListener;
import com.borland.util.Logger;
import com.borland.util.Resources;
import java.beans.PropertyVetoException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.ArrayList;

public class CmdLineImporter {
    private static RandomAccessFile myProgressFile;
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Double;
    static /* synthetic */ Class class$java$io$File;

    public static void main(String[] args) {
        Configuration configuration = CmdLineImporter.getCommandLineConfiguration(args);
        if (configuration == null) {
            return;
        }
        if (configuration.useDiskFileToReturnValues) {
            CmdLineImporter.importUsingDisk(configuration);
        } else {
            CmdLineImporter.standardImport(configuration);
        }
    }

    private static void standardImport(Configuration configuration) {
        Importer importer = null;
        try {
            importer = new Importer(configuration);
        }
        catch (InvalidConfigurationException ex) {
            System.err.println(ex.getMessage());
            return;
        }
        Logger.getInstance().addLogListener(new ILogListener(){

            public void logging(String category, int status, String message) {
                if ("importer".equals(category)) {
                    if (status == 0 || status == 3) {
                        System.out.println(message);
                    } else {
                        System.err.println(message);
                    }
                }
            }

            public void logging(String category, int status, Throwable throwable) {
            }
        });
        importer.addImportProcessListener(new ImportProcessAdapter(){

            public void parseProgressChanged(String status, int newValue, int totalWork) {
                Logger.getInstance().log("progress", Resources.getString("CmdLineImporter.Parse_progress___2") + newValue + Resources.getString("CmdLineImporter._from__3") + totalWork);
            }
        });
        if (configuration.useDiskFileToReturnValues) {
            File progressFile = new File(configuration.progressFileName);
            if (progressFile.exists()) {
                progressFile.delete();
            }
            try {
                progressFile.createNewFile();
                final RandomAccessFile progress = myProgressFile = new RandomAccessFile(progressFile, "rws");
                importer.addImportProcessListener(new ImportProcessAdapter(){

                    public void parseProgressChanged(String status, int newValue, int totalWork) {
                        try {
                            progress.setLength(0L);
                            progress.writeUTF(status + "\n" + newValue + "\n" + totalWork);
                        }
                        catch (IOException e) {
                            // empty catch block
                        }
                    }
                });
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        long start = System.currentTimeMillis();
        try {
            importer.doImport();
        }
        catch (PropertyVetoException e) {
            importer.cleanUp();
            e.printStackTrace();
        }
        long millis = System.currentTimeMillis() - start;
        int days = (int)(millis / 86400000L);
        int hours = (int)(millis / 3600000L);
        int minutes = (int)(millis / 60000L);
        float seconds = (float)millis / 1000.0f;
        StringBuffer totalTime = new StringBuffer();
        if (days > 0) {
            totalTime.append(days + Resources.getString("CmdLineImporter._day(s),__4"));
        }
        if (hours > 0 || days > 0) {
            totalTime.append(hours - days * 24 + Resources.getString("CmdLineImporter._hour(s),__5"));
        }
        if (minutes > 0 || hours > 0 || days > 0) {
            totalTime.append(minutes - hours * 60 + Resources.getString("CmdLineImporter._minute(s),__6"));
        }
        totalTime.append(seconds - (float)(minutes * 60) + Resources.getString("CmdLineImporter._seconds_7"));
        Logger.getInstance().log("importer", 3, Resources.getString("CmdLineImporter.Total_time___8") + totalTime.toString());
        importer.cleanUp();
        if (myProgressFile != null) {
            try {
                myProgressFile.close();
            }
            catch (IOException e1) {
                // empty catch block
            }
        }
    }

    private static void importUsingDisk(Configuration configuration) {
        String[] newAliases;
        String validationError = configuration.validate();
        if (validationError != null) {
            return;
        }
        PathAliasSearcher preImporter = PathAliasSearcher.getInstance(configuration);
        AliasSearchListener listener = new AliasSearchListener();
        ArrayList allAliases = new ArrayList();
        preImporter.addProgressListener(listener);
        if (preImporter.canAdvance() && (newAliases = preImporter.advance()).length > 0) {
            File aliases = new File(configuration.aliasesFileName);
            if (aliases.exists()) {
                aliases.delete();
            }
            try {
                aliases.createNewFile();
                BufferedWriter aliasesWriter = new BufferedWriter(new FileWriter(aliases));
                for (int i = 0; i < newAliases.length; ++i) {
                    aliasesWriter.write(newAliases[i]);
                    aliasesWriter.newLine();
                }
                aliasesWriter.close();
            }
            catch (IOException e) {
                // empty catch block
            }
            return;
        }
        CmdLineImporter.standardImport(configuration);
    }

    public static Configuration getCommandLineConfiguration(String[] cmdArgs) {
        return CmdLineImporter.parseArgs(cmdArgs);
    }

    protected static Configuration parseArgs(String[] cmdArgs) {
        if (cmdArgs.length < 1) {
            CmdLineImporter.usage(Resources.getString("CmdLineImporter.Too_few_arguments_9"));
            return null;
        }
        Configuration configuration = new Configuration();
        CmdLineOptions options = new CmdLineOptions(configuration);
        for (int i = 0; i < cmdArgs.length; ++i) {
            String nextArg = cmdArgs[i];
            if (nextArg.startsWith("-")) {
                CmdLineOptions.OptionDscr nextOption = options.getOption(nextArg);
                if (nextOption == null) {
                    CmdLineImporter.usage();
                    return null;
                }
                Class valueType = nextOption.getValueType();
                Object value = null;
                IFunction valueResolver = nextOption.getValueResolver();
                if (valueResolver != null) {
                    value = valueResolver.execute(nextArg);
                    if (value == null) {
                        CmdLineImporter.usage();
                        return null;
                    }
                } else if (valueType == (class$java$lang$Boolean == null ? CmdLineImporter.class$("java.lang.Boolean") : class$java$lang$Boolean)) {
                    value = Boolean.TRUE;
                } else {
                    String nextValue;
                    if (!nextOption.isEmptyValueAllowed() && i > cmdArgs.length - 2) {
                        CmdLineImporter.usage(Resources.getString("CmdLineImporter.Too_few_arguments_11"));
                        return null;
                    }
                    if ((nextValue = cmdArgs[++i]).startsWith("-")) {
                        if (!nextOption.isEmptyValueAllowed()) {
                            CmdLineImporter.usage(Resources.getString("CmdLineImporter.Value_required_for_option__13") + nextOption.getId());
                            return null;
                        }
                        --i;
                    } else if (valueType == (class$java$lang$Integer == null ? CmdLineImporter.class$("java.lang.Integer") : class$java$lang$Integer)) {
                        try {
                            value = new Integer(Integer.parseInt(nextValue));
                        }
                        catch (NumberFormatException ex) {
                            CmdLineImporter.usage(CmdLineImporter.getErrorValueMessage(nextOption.getId(), (class$java$lang$Integer == null ? (class$java$lang$Integer = CmdLineImporter.class$("java.lang.Integer")) : class$java$lang$Integer).getName()));
                            return null;
                        }
                    } else if (valueType == (class$java$lang$Double == null ? CmdLineImporter.class$("java.lang.Double") : class$java$lang$Double)) {
                        try {
                            value = new Double(Double.parseDouble(nextValue));
                        }
                        catch (NumberFormatException ex) {
                            CmdLineImporter.usage(CmdLineImporter.getErrorValueMessage(nextOption.getId(), (class$java$lang$Double == null ? (class$java$lang$Double = CmdLineImporter.class$("java.lang.Double")) : class$java$lang$Double).getName()));
                            return null;
                        }
                    } else {
                        value = valueType == (class$java$io$File == null ? CmdLineImporter.class$("java.io.File") : class$java$io$File) ? new File(nextValue) : nextValue;
                    }
                }
                nextOption.saveToConfig(value);
                continue;
            }
            if (cmdArgs.length <= i + 1) continue;
            CmdLineImporter.usage(Resources.getString("CmdLineImporter.Too_many_arguments_14"));
            return null;
        }
        return configuration;
    }

    protected static void usage() {
        CmdLineImporter.usage(null);
    }

    protected static void usage(String msg) {
        if (msg != null) {
            System.out.println(msg);
        }
        System.out.println(Resources.getString("CmdLineImporter.Usage__java_com.borland.mdlimport.CmdLineImporter_[-options]_mdlfile_n_15") + Resources.getString("CmdLineImporter.where_possible_options_include__16") + CmdLineImporter.getOptionsDescription());
    }

    private static String getErrorValueMessage(String optionName, String requiredTypeName) {
        return Resources.getString("CmdLineImporter.Value_of_parameter__17") + optionName + Resources.getString("CmdLineImporter._should_be_of_type__18") + requiredTypeName;
    }

    private static String getOptionsDescription() {
        int i;
        StringBuffer optionsBuffer = new StringBuffer();
        CmdLineOptions.OptionDscr[] options = new CmdLineOptions(null).getOptions();
        int maxLength = 0;
        for (i = 0; i < options.length; ++i) {
            if (options[i].getText().length() <= maxLength) continue;
            maxLength = options[i].getText().length();
        }
        for (i = 0; i < options.length; ++i) {
            optionsBuffer.append("\n\t");
            optionsBuffer.append(options[i].getText());
            int offset = maxLength - options[i].getText().length();
            for (int j = 0; j < offset; ++j) {
                optionsBuffer.append(" ");
            }
            optionsBuffer.append("\t\t");
            optionsBuffer.append(options[i].getDescription());
        }
        return optionsBuffer.toString();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class AliasSearchListener
    implements PathAliasSearcher.ProgressListener {
        private AliasSearchListener() {
        }

        public void parseProgressChanged(String report, int currentStep, int totalSteps) {
            double stage = (double)currentStep * 100.0 / (double)totalSteps;
            int percent = (int)stage;
        }
    }
}

