/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.logging;

import com.starbase.util.logging.Log;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.net.Socket;
import java.text.DateFormat;
import java.util.Date;

public class RemoteLogWriter
implements Log.Writer {
    public static final DateFormat DATE_FORMAT = DateFormat.getDateTimeInstance(3, 2);

    public final void write(int level, String message, String category) {
        String host = System.getProperty("RemoteLogWriter.host");
        String portString = System.getProperty("RemoteLogWriter.port");
        int port = portString != null ? Integer.parseInt(portString) : -1;
        try {
            Socket s = new Socket(host, port);
            OutputStreamWriter w = new OutputStreamWriter(s.getOutputStream(), "UTF-8");
            w.write(DATE_FORMAT.format(new Date()) + " ");
            w.write(message != null ? message : "(message was null)");
            w.close();
        }
        catch (IOException e) {
            throw new RuntimeException();
        }
    }
}

