/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.logging;

import com.starbase.util.logging.Log;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Date;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;

public class GuiLogWriter
implements Log.Writer {
    static int last = 0;
    private final Vector messages = new Vector();
    private final ChronoView chrono = new ChronoView();
    private final ThreadView thread = new ThreadView();
    private final CategoryView category = new CategoryView();
    private final MessageSink[] sinks = new MessageSink[]{this.chrono, this.thread, this.category};
    private final JTabbedPane views = new JTabbedPane();
    private final JTextArea details = new JTextArea(15, 40);

    public GuiLogWriter() {
        this.details.setLineWrap(true);
        this.views.add("Chronological", this.chrono);
        this.views.add("By Thread", this.thread);
        this.views.add("By Category", this.category);
        this.views.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                int end = GuiLogWriter.this.details.getDocument().getEndPosition().getOffset() - 1;
                GuiLogWriter.this.details.replaceRange("", 0, end);
            }
        });
        JFrame f = new JFrame();
        Box b = new Box(1);
        b.add(this.views);
        b.add(new JScrollPane(this.details));
        f.getContentPane().add(b);
        f.pack();
        f.show();
        f.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent e) {
                System.exit(0);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void write(int level, String message, String category) {
        Vector vector = this.messages;
        synchronized (vector) {
            Message m = new Message(level, message, category);
            int i = 0;
            while (i < this.sinks.length) {
                MessageSink messageSink = this.sinks[i];
                synchronized (messageSink) {
                    this.sinks[i].maybeAdd(m);
                }
                ++i;
            }
        }
    }

    public static void main(String[] args) {
        GuiLogWriter g = new GuiLogWriter();
        g.write(1, "hi", "mom");
    }

    class CategoryModel
    extends ChronoModel
    implements MessageSink {
        private final String category;

        CategoryModel(String category) {
            this.category = category;
        }

        public boolean maybeAdd(Message m) {
            boolean ret = this.category.equals(m.category) ? super.maybeAdd(m) : false;
            return ret;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            String ret;
            switch (column) {
                case 0: {
                    ret = "Thread";
                    break;
                }
                case 1: {
                    ret = "Level";
                    break;
                }
                case 2: {
                    ret = "Timestamp";
                    break;
                }
                case 3: {
                    ret = "Message";
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }

        public Object getValueAt(int row, int column) {
            Object ret;
            Message m = (Message)this.byChronoOrder.elementAt(row);
            switch (column) {
                case 0: {
                    ret = m.thread;
                    break;
                }
                case 1: {
                    ret = new Integer(m.level);
                    break;
                }
                case 2: {
                    ret = new Date(m.timestamp);
                    break;
                }
                case 3: {
                    ret = m.message;
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }
    }

    class CategoryView
    extends CategorizedView
    implements MessageSink {
        CategoryView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startNewTab(Message m) {
            JTabbedPane jTabbedPane = this.tabs;
            synchronized (jTabbedPane) {
                CategoryModel model = this.startNewModel(m);
                JTable table = new JTable(model);
                table.getSelectionModel().addListSelectionListener(new ListSelectionListener(this, table, model){
                    private final /* synthetic */ JTable val$table;
                    private final /* synthetic */ CategoryModel val$model;
                    private final /* synthetic */ CategoryView this$1;
                    {
                        this.this$1 = this$1;
                        this.val$table = val$table;
                        this.val$model = val$model;
                    }

                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            int end = GuiLogWriter.access$100(CategoryView.access$500(this.this$1)).getDocument().getEndPosition().getOffset() - 1;
                            if (this.val$table.getSelectionModel().isSelectedIndex(e.getFirstIndex())) {
                                GuiLogWriter.access$100(CategoryView.access$500(this.this$1)).replaceRange(this.val$model.detailsOf(e.getFirstIndex()), 0, end);
                            } else {
                                GuiLogWriter.access$100(CategoryView.access$500(this.this$1)).replaceRange(this.val$model.detailsOf(e.getLastIndex()), 0, end);
                            }
                        }
                    }
                });
                this.tabs.add("".equals(m.category) ? "<uncategorized>" : m.category, new JScrollPane(table));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        CategoryModel startNewModel(Message m) {
            CategoryModel ret;
            Vector vector = this.models;
            synchronized (vector) {
                ret = new CategoryModel(m.category);
                ret.maybeAdd(m);
                this.models.addElement(ret);
            }
            return ret;
        }

        static /* synthetic */ GuiLogWriter access$500(CategoryView x0) {
            return x0.GuiLogWriter.this;
        }
    }

    class ThreadModel
    extends ChronoModel
    implements MessageSink {
        private final String thread;

        ThreadModel(String thread) {
            this.thread = thread;
        }

        public boolean maybeAdd(Message m) {
            boolean ret = this.thread.equals(m.thread) ? super.maybeAdd(m) : false;
            return ret;
        }

        public int getColumnCount() {
            return 4;
        }

        public String getColumnName(int column) {
            String ret;
            switch (column) {
                case 0: {
                    ret = "Level";
                    break;
                }
                case 1: {
                    ret = "Timestamp";
                    break;
                }
                case 2: {
                    ret = "Category";
                    break;
                }
                case 3: {
                    ret = "Message";
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }

        public Object getValueAt(int row, int column) {
            Object ret;
            Message m = (Message)this.byChronoOrder.elementAt(row);
            switch (column) {
                case 0: {
                    ret = new Integer(m.level);
                    break;
                }
                case 1: {
                    ret = new Date(m.timestamp);
                    break;
                }
                case 2: {
                    ret = m.category;
                    break;
                }
                case 3: {
                    ret = m.message;
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }
    }

    class ThreadView
    extends CategorizedView
    implements MessageSink {
        ThreadView() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void startNewTab(Message m) {
            JTabbedPane jTabbedPane = this.tabs;
            synchronized (jTabbedPane) {
                ThreadModel model = this.startNewModel(m);
                JTable table = new JTable(model);
                table.getSelectionModel().setSelectionMode(0);
                table.getSelectionModel().addListSelectionListener(new ListSelectionListener(this, table, model){
                    private final /* synthetic */ JTable val$table;
                    private final /* synthetic */ ThreadModel val$model;
                    private final /* synthetic */ ThreadView this$1;
                    {
                        this.this$1 = this$1;
                        this.val$table = val$table;
                        this.val$model = val$model;
                    }

                    public void valueChanged(ListSelectionEvent e) {
                        if (!e.getValueIsAdjusting()) {
                            int end = GuiLogWriter.access$100(ThreadView.access$400(this.this$1)).getDocument().getEndPosition().getOffset() - 1;
                            if (this.val$table.getSelectionModel().isSelectedIndex(e.getFirstIndex())) {
                                GuiLogWriter.access$100(ThreadView.access$400(this.this$1)).replaceRange(this.val$model.detailsOf(e.getFirstIndex()), 0, end);
                            } else {
                                GuiLogWriter.access$100(ThreadView.access$400(this.this$1)).replaceRange(this.val$model.detailsOf(e.getLastIndex()), 0, end);
                            }
                        }
                    }
                });
                this.tabs.add(m.thread, new JScrollPane(table));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        ThreadModel startNewModel(Message m) {
            ThreadModel ret;
            Vector vector = this.models;
            synchronized (vector) {
                ret = new ThreadModel(m.thread);
                ret.maybeAdd(m);
                this.models.addElement(ret);
            }
            return ret;
        }

        static /* synthetic */ GuiLogWriter access$400(ThreadView x0) {
            return x0.GuiLogWriter.this;
        }
    }

    abstract class CategorizedView
    extends Box
    implements MessageSink {
        protected final Vector models;
        protected final JTabbedPane tabs;

        CategorizedView() {
            super(1);
            this.models = new Vector();
            this.tabs = new JTabbedPane();
            this.tabs.addChangeListener(new ChangeListener(this){
                private final /* synthetic */ CategorizedView this$1;
                {
                    this.this$1 = this$1;
                }

                public void stateChanged(ChangeEvent e) {
                    int end = GuiLogWriter.access$100(CategorizedView.access$300(this.this$1)).getDocument().getEndPosition().getOffset() - 1;
                    GuiLogWriter.access$100(CategorizedView.access$300(this.this$1)).replaceRange("", 0, end);
                }
            });
            this.add(this.tabs);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean maybeAdd(Message m) {
            boolean ret = false;
            Vector vector = this.models;
            synchronized (vector) {
                int i = 0;
                while (i < this.models.size()) {
                    ret = ((MessageSink)this.models.elementAt(i)).maybeAdd(m);
                    if (ret) break;
                    ++i;
                }
                if (!ret) {
                    this.startNewTab(m);
                    ret = true;
                }
            }
            return ret;
        }

        abstract void startNewTab(Message var1);

        static /* synthetic */ GuiLogWriter access$300(CategorizedView x0) {
            return x0.GuiLogWriter.this;
        }
    }

    class ChronoModel
    extends AbstractTableModel
    implements MessageSink {
        protected Vector byChronoOrder = new Vector();

        ChronoModel() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean maybeAdd(Message m) {
            int originalSize = this.byChronoOrder.size();
            Vector vector = this.byChronoOrder;
            synchronized (vector) {
                int index = this.byChronoOrder.size();
                while (index >= 0) {
                    if (index == 0) {
                        this.byChronoOrder.insertElementAt(m, 0);
                    } else if (m.ordinal > ((Message)this.byChronoOrder.elementAt((int)(index - 1))).ordinal) {
                        this.byChronoOrder.insertElementAt(m, index);
                        break;
                    }
                    --index;
                }
            }
            this.fireTableDataChanged();
            return true;
        }

        public int getRowCount() {
            return this.byChronoOrder.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public String getColumnName(int column) {
            String ret;
            switch (column) {
                case 0: {
                    ret = "Thread";
                    break;
                }
                case 1: {
                    ret = "Level";
                    break;
                }
                case 2: {
                    ret = "Timestamp";
                    break;
                }
                case 3: {
                    ret = "Category";
                    break;
                }
                case 4: {
                    ret = "Message";
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }

        String detailsOf(int index) {
            return this.byChronoOrder.elementAt(index).toString();
        }

        public Object getValueAt(int row, int column) {
            Object ret;
            Message m = (Message)this.byChronoOrder.elementAt(row);
            switch (column) {
                case 0: {
                    ret = m.thread;
                    break;
                }
                case 1: {
                    ret = new Integer(m.level);
                    break;
                }
                case 2: {
                    ret = new Date(m.timestamp);
                    break;
                }
                case 3: {
                    ret = m.category;
                    break;
                }
                case 4: {
                    ret = m.message;
                    break;
                }
                default: {
                    ret = "#<invalid column index: " + column;
                }
            }
            return ret;
        }
    }

    class ChronoView
    extends Box
    implements MessageSink {
        private final ChronoModel model;

        ChronoView() {
            super(1);
            this.model = new ChronoModel();
            JTable chronoTable = new JTable(this.model);
            chronoTable.getSelectionModel().addListSelectionListener(new ListSelectionListener(this, chronoTable){
                private final /* synthetic */ JTable val$chronoTable;
                private final /* synthetic */ ChronoView this$1;
                {
                    this.this$1 = this$1;
                    this.val$chronoTable = val$chronoTable;
                }

                public void valueChanged(ListSelectionEvent e) {
                    if (!e.getValueIsAdjusting()) {
                        int end = GuiLogWriter.access$100(ChronoView.access$000(this.this$1)).getDocument().getEndPosition().getOffset() - 1;
                        if (this.val$chronoTable.getSelectionModel().isSelectedIndex(e.getFirstIndex())) {
                            GuiLogWriter.access$100(ChronoView.access$000(this.this$1)).replaceRange(ChronoView.access$200(this.this$1).detailsOf(e.getFirstIndex()), 0, end);
                        } else {
                            GuiLogWriter.access$100(ChronoView.access$000(this.this$1)).replaceRange(ChronoView.access$200(this.this$1).detailsOf(e.getLastIndex()), 0, end);
                        }
                    }
                }
            });
            this.add(new JScrollPane(chronoTable));
        }

        public boolean maybeAdd(Message m) {
            return this.model.maybeAdd(m);
        }

        static /* synthetic */ GuiLogWriter access$000(ChronoView x0) {
            return x0.GuiLogWriter.this;
        }

        static /* synthetic */ ChronoModel access$200(ChronoView x0) {
            return x0.model;
        }
    }

    static interface MessageSink {
        public boolean maybeAdd(Message var1);
    }

    class Message {
        final Object counterLock = new Object();
        final int level;
        final String message;
        final String category;
        final long timestamp;
        final String thread;
        final int ordinal;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        Message(int level, String message, String category) {
            this.level = level;
            this.message = message;
            this.category = category;
            this.timestamp = System.currentTimeMillis();
            this.thread = Thread.currentThread().getName();
            Object object = this.counterLock;
            synchronized (object) {
                this.ordinal = ++last;
            }
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("level: " + this.level + eol);
            buff.append("category: " + this.category + eol);
            buff.append("timestamp: " + new Date(this.timestamp) + eol);
            buff.append("thread: " + this.thread + eol);
            buff.append("message: " + this.message + eol);
            return buff.toString();
        }
    }
}

