/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.Window;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.swing.SwingUtilities;

class Utils {
    Utils() {
    }

    public static void centerOnScreen(Component comp) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension compsize = comp.getSize();
        comp.setLocation((screen.width - compsize.width) / 2, (screen.height - compsize.height) / 2);
    }

    public static Window findParentFrameOrDialog(Component component) {
        Window ret = null;
        if (component != null) {
            ret = SwingUtilities.getWindowAncestor(component);
            while (ret != null && !(ret instanceof Frame) && !(ret instanceof Dialog)) {
                ret = SwingUtilities.getWindowAncestor(ret);
            }
        }
        return ret;
    }

    protected static Throwable unwrapSDKRuntimeException(Throwable sdkException) {
        Throwable t = null;
        try {
            Method m = sdkException.getClass().getMethod("getException", new Class[0]);
            t = (Throwable)m.invoke((Object)sdkException, new Object[0]);
        }
        catch (NoSuchMethodException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {}
        return t;
    }

    protected static boolean isSDKRuntimeException(Throwable error) {
        return error != null && "com.starbase.starteam.SDKRuntimeException".equals(error.getClass().getName());
    }

    protected static Dimension adjustPreferredSize(Dimension componentPreferred) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        return new Dimension(Math.min(componentPreferred.width, screenSize.width / 2), Math.min(componentPreferred.height, screenSize.height / 3));
    }
}

