/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.util.errorhandling.ClassLoaderUtils;
import com.starbase.util.errorhandling.ErrorBundle;
import com.starbase.util.errorhandling.ErrorDetailInfo;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Source
extends JPanel
implements ErrorDetailInfo {
    protected final JTextArea m_source = new JTextArea();

    public Source() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JTextArea text = this.m_source;
        text.setEditable(false);
        JScrollPane scroll = new JScrollPane(text, 20, 30);
        Dimension scrollSize = Utils.adjustPreferredSize(text.getPreferredScrollableViewportSize());
        scroll.setPreferredSize(scrollSize);
        this.add((Component)scroll, "Center");
    }

    public String getName() {
        return "Source";
    }

    public void setError(ErrorBundle error) {
        this.m_source.setText(this.createText(error));
        this.m_source.setCaretPosition(0);
    }

    public JPanel getPanel() {
        return this;
    }

    public String createText(ErrorBundle error) {
        StringBuffer buffer = new StringBuffer();
        String eol = System.getProperty("line.separator");
        if (error.m_source != null) {
            buffer.append("Source class: ");
            buffer.append(error.m_source.getClass().getName());
            buffer.append(eol);
            buffer.append("Source identity hash: ");
            buffer.append("" + System.identityHashCode(error.m_source));
            buffer.append(eol);
            buffer.append("Source toString: ");
            buffer.append(error.m_source.toString());
            buffer.append(eol);
            buffer.append("ClassLoaders: ");
            buffer.append(eol);
            ClassLoader[] lineage = ClassLoaderUtils.getLineage(error.m_source.getClass().getClassLoader());
            int i = 0;
            while (i < lineage.length) {
                buffer.append(ClassLoaderUtils.stringRepresentation(lineage[i], true, 0));
                buffer.append(eol);
                ++i;
            }
            buffer.append(eol);
        } else {
            buffer.append("N/A");
        }
        return buffer.toString();
    }
}

