/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.util.errorhandling.GraphicalErrorHandler;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.util.Vector;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.Border;
import javax.swing.border.EmptyBorder;

public class Overview
extends JPanel {
    protected final Vector m_errors;

    public Overview(Vector errors) {
        this.m_errors = errors;
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.setBorder(new EmptyBorder(15, 15, 15, 15));
        JTextArea overview = new JTextArea();
        String eol = System.getProperty("line.separator");
        int i = 0;
        while (i < this.m_errors.size()) {
            overview.append(this.m_errors.get(i).toString());
            if (i < this.m_errors.size() - 1) {
                overview.append(eol + "-----" + eol);
            }
            ++i;
        }
        if (overview.getText().length() > 30) {
            overview.setColumns(40);
            overview.setRows(overview.getText().length() / 40 + 1);
        }
        overview.setLineWrap(true);
        overview.setWrapStyleWord(true);
        overview.setEditable(false);
        overview.setBackground(this.getBackground());
        overview.setCaretPosition(0);
        Dimension viewportSize = overview.getPreferredScrollableViewportSize();
        final JScrollPane scroll = new JScrollPane(overview, 20, 31);
        Dimension scrollSize = Utils.adjustPreferredSize(viewportSize);
        scroll.setPreferredSize(scrollSize);
        if (viewportSize.height <= scrollSize.height) {
            scroll.setMinimumSize(new Dimension(viewportSize.width, viewportSize.height));
        }
        final Border originalBorder = scroll.getBorder();
        final EmptyBorder emptyBorder = new EmptyBorder(0, 0, 0, 0);
        if (viewportSize.height <= scrollSize.height) {
            scroll.setBorder(emptyBorder);
        }
        scroll.getVerticalScrollBar().addComponentListener(new ComponentAdapter(){

            public void componentHidden(ComponentEvent ev) {
                scroll.setBorder(emptyBorder);
            }

            public void componentShown(ComponentEvent ev) {
                scroll.setBorder(originalBorder);
            }
        });
        this.add((Component)scroll, "Center");
    }

    public static void main(String[] args) {
        GraphicalErrorHandler.main(args);
    }
}

