/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.starteam.BuildNumber;
import com.starbase.util.errorhandling.AmbientInfo;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Enumeration;
import java.util.Properties;
import java.util.SimpleTimeZone;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Miscellaneous
extends JPanel
implements AmbientInfo {
    protected String m_text = "";

    public Miscellaneous() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        this.initText();
        JTextArea text = new JTextArea(this.m_text);
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        JScrollPane scroll = new JScrollPane(text, 20, 30);
        Dimension scrollSize = Utils.adjustPreferredSize(text.getPreferredScrollableViewportSize());
        scroll.setPreferredSize(scrollSize);
        this.add((Component)scroll, "Center");
    }

    protected void initText() {
        StringBuffer buffer = new StringBuffer();
        String eol = System.getProperty("line.separator");
        SimpleTimeZone zone = new SimpleTimeZone(0, "GMT");
        SimpleDateFormat fmt = new SimpleDateFormat("yyyy'-'MM'-'dd' 'HH':'mm':'ss'Z'");
        fmt.setTimeZone(zone);
        buffer.append("Time of report generation: " + fmt.format(new Date()) + eol);
        buffer.append("SDK Build: " + BuildNumber.getDisplayString() + eol);
        Package[] packages = Package.getPackages();
        Arrays.sort(packages, new Comparator(){

            public int compare(Object a, Object b) {
                return ((Package)a).getName().compareTo(((Package)b).getName());
            }
        });
        int i = 0;
        while (i < packages.length) {
            buffer.append("Package " + packages[i].getName());
            buffer.append(eol);
            buffer.append("   " + packages[i].getSpecificationTitle());
            buffer.append("," + packages[i].getSpecificationVersion());
            buffer.append("," + packages[i].getSpecificationVendor());
            buffer.append(eol);
            buffer.append("   " + packages[i].getImplementationTitle());
            buffer.append("," + packages[i].getImplementationVersion());
            buffer.append("," + packages[i].getImplementationVendor());
            buffer.append(eol);
            ++i;
        }
        Properties props = System.getProperties();
        Enumeration<Object> propKeys = props.keys();
        while (propKeys.hasMoreElements()) {
            Object key = propKeys.nextElement();
            buffer.append("" + key + "=" + props.get(key));
            buffer.append(eol);
        }
        this.m_text = buffer.toString();
    }

    public String getName() {
        return "Miscellaneous";
    }

    public JPanel getPanel() {
        return this;
    }

    public String getText() {
        return this.m_text;
    }
}

