/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.util.errorhandling.ErrorBundle;
import com.starbase.util.errorhandling.ErrorDetailInfo;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Location
extends JPanel
implements ErrorDetailInfo {
    public JTextArea m_location = new JTextArea(0, 80);

    public Location() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JTextArea text = this.m_location;
        text.setEditable(false);
        text.setTabSize(3);
        JScrollPane scroll = new JScrollPane(text, 20, 30);
        Dimension scrollSize = Utils.adjustPreferredSize(text.getPreferredScrollableViewportSize());
        scroll.setPreferredSize(scrollSize);
        this.add((Component)scroll, "Center");
    }

    public String getName() {
        return "Location";
    }

    public void setError(ErrorBundle error) {
        this.m_location.setText(this.createText(error));
        this.m_location.setCaretPosition(0);
    }

    public JPanel getPanel() {
        return this;
    }

    public String createText(ErrorBundle error) {
        StringWriter errorTrace;
        StringBuffer buffer = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buffer.append(error.m_thread);
        if (error.m_error != null) {
            errorTrace = new StringWriter();
            error.m_error.printStackTrace(new PrintWriter(errorTrace));
        } else {
            errorTrace = null;
        }
        buffer.append("Error stack trace:" + eol);
        buffer.append(errorTrace != null ? errorTrace.toString() : "N/A");
        buffer.append(eol + "---" + eol);
        if (Utils.isSDKRuntimeException(error.m_error)) {
            StringWriter innerTrace;
            Throwable t = Utils.unwrapSDKRuntimeException(error.m_error);
            if (t != null) {
                innerTrace = new StringWriter();
                t.printStackTrace(new PrintWriter(innerTrace));
            } else {
                innerTrace = null;
            }
            buffer.append("Originating error stack trace:" + eol);
            buffer.append(innerTrace != null ? innerTrace.toString() : "N/A");
            buffer.append(eol + "---" + eol);
        }
        buffer.append("Where the error was handled:" + eol);
        buffer.append(error.m_callTrace);
        buffer.append(eol + "---" + eol);
        return buffer.toString();
    }
}

