/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.util.errorhandling.DisplayComponent;
import com.starbase.util.errorhandling.ErrorBundle;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.border.EmptyBorder;

public class GraphicalErrorHandler {
    public static final Object IGNORE = "Ignore";
    public static final Object IGNORE_ALL = "Ignore all";
    public static final Object ABORT = "Abort";
    public static final Object RETRY = "Retry";
    public static final Object FAIL = "Fail";
    protected final Vector m_errors = new Vector();
    protected final PropertyChangeSupport m_changeSupport = new PropertyChangeSupport(this);

    public Object handleErrors(Component parent, String title, String message, Throwable error, Object source, Object[] options, int defaultSelectionIndex, int closeOperationIndex) {
        GraphicalErrorHandler handler = new GraphicalErrorHandler();
        handler.accumulateError(source, error, message, new Object[0]);
        return handler.handleErrors(parent, title, null, options, defaultSelectionIndex, closeOperationIndex);
    }

    public synchronized int getAccumulatedErrorCount() {
        return this.m_errors.size();
    }

    public synchronized int accumulateError(Object source, Throwable error, String message, Object[] disposition) {
        int oldCount = this.m_errors.size();
        CallTrace t = new CallTrace();
        StringWriter trace = new StringWriter();
        t.printStackTrace(new PrintWriter(trace));
        this.m_errors.add(new ErrorBundle(source, error, message, disposition, trace.toString(), Thread.currentThread()));
        int count = this.m_errors.size();
        this.firePropertyChange(new PropertyChangeEvent(this, "errorCount", new Integer(oldCount), new Integer(count)));
        return count;
    }

    public synchronized Object handleErrors(Component parent, String title, String extraMessage, Object[] options, int defaultSelectionIndex, int closeOperationIndex) {
        if (options != null && options.length != 0 && (defaultSelectionIndex < 0 || defaultSelectionIndex >= options.length)) {
            String msg = "defaultSelectionIndex parameter of GraphicalErrorHandler.show must be a valid index of the options parameter";
            throw new IllegalArgumentException("defaultSelectionIndex parameter of GraphicalErrorHandler.show must be a valid index of the options parameter");
        }
        if (options != null && options.length != 0 && (closeOperationIndex < 0 || closeOperationIndex >= options.length)) {
            String msg = "closeOperationIndex parameter of GraphicalErrorHandler.show must be a valid index of the options parameter";
            throw new IllegalArgumentException("closeOperationIndex parameter of GraphicalErrorHandler.show must be a valid index of the options parameter");
        }
        Window parentWindow = (Window)(parent instanceof Window ? parent : Utils.findParentFrameOrDialog(parent));
        JDialog dlg = parentWindow instanceof Dialog ? new JDialog((Dialog)parentWindow, title) : (parentWindow instanceof Frame ? new JDialog((Frame)parentWindow, title) : new JDialog((Frame)null, title));
        dlg.setModal(true);
        JPanel content = new JPanel();
        content.setLayout(new BorderLayout());
        dlg.setContentPane(content);
        if (extraMessage != null && !"".equals(extraMessage.trim())) {
            JTextArea messageArea = new JTextArea();
            messageArea.setBorder(new EmptyBorder(15, 15, 0, 15));
            messageArea.setWrapStyleWord(true);
            messageArea.setLineWrap(true);
            messageArea.setText(extraMessage);
            messageArea.setEditable(false);
            messageArea.setBackground(content.getBackground());
            content.add((Component)messageArea, "North");
        }
        Component display = GraphicalErrorHandler.createDisplayComponent(this.m_errors, title, extraMessage);
        content.add(display, "Center");
        Object[] responseAccumulator = new Object[]{options == null || options.length == 0 ? null : options[closeOperationIndex]};
        Component buttons = GraphicalErrorHandler.createButtonsComponent(options, defaultSelectionIndex, dlg, responseAccumulator);
        content.add(buttons, "South");
        dlg.pack();
        if (parent != null) {
            dlg.setLocationRelativeTo(parent);
        }
        if (parentWindow == null) {
            Utils.centerOnScreen(dlg);
        }
        dlg.show();
        int oldCount = this.m_errors.size();
        this.m_errors.clear();
        this.firePropertyChange(new PropertyChangeEvent(this, "errorCount", new Integer(oldCount), new Integer(0)));
        return responseAccumulator[0];
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.m_changeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.m_changeSupport.removePropertyChangeListener(listener);
    }

    protected void firePropertyChange(PropertyChangeEvent ev) {
        this.m_changeSupport.firePropertyChange(ev);
    }

    protected static Component createDisplayComponent(Vector errors, String title, String extraMessage) {
        return new DisplayComponent(errors, title, extraMessage);
    }

    protected static Component createButtonsComponent(Object[] options, int defaultSelectionIndex, JDialog dialog, Object[] responseAccumulator) {
        JPanel panel = new JPanel();
        if (options == null || options.length == 0) {
            options = new Object[]{"OK"};
            defaultSelectionIndex = 0;
        }
        int i = 0;
        while (i < options.length) {
            final JButton button = GraphicalErrorHandler.createButton(options[i].toString(), options[i], dialog, responseAccumulator);
            panel.add(button);
            if (defaultSelectionIndex == i) {
                dialog.addWindowListener(new WindowAdapter(){

                    public void windowOpened(WindowEvent ev) {
                        button.requestFocus();
                    }
                });
                dialog.getRootPane().setDefaultButton(button);
            }
            ++i;
        }
        return panel;
    }

    protected static JButton createButton(String name, final Object value, final JDialog dialog, final Object[] responseAccumulator) {
        JButton ret = new JButton(name);
        ret.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                responseAccumulator[0] = value;
                dialog.dispose();
            }
        });
        return ret;
    }

    public static void main(String[] args) {
        Object source = new Object();
        GraphicalErrorHandler h = new GraphicalErrorHandler();
        int i = 0;
        while (i < 2) {
            try {
                throw new Error("foo");
            }
            catch (Throwable t) {
                h.accumulateError(h, t, "message_" + i + " Now is the time for all good men to come to the aid of their country. Now is the time for all good men to come to the aid of their country.", new Object[0]);
                ++i;
            }
        }
        JFrame f = new JFrame();
        Object ret = h.handleErrors(f, "title", "extra message", new Object[]{"<", ">"}, 0, 1);
        System.out.println(ret);
        try {
            throw new Error("bar");
        }
        catch (Throwable t) {
            h.handleErrors(f, "title", "message", t, source, null, 0, 0);
            try {
                throw new Error("Could not find C:\\ProgramFiles\\Starbase\\StarTeamCrossPlatformClient\\Lib\\starteam-gui-resources.txt, and I looked everywhere on your hard drive.  Please tell me you know where it is.");
            }
            catch (Throwable t2) {
                h.handleErrors(f, "title", null, t2, source, null, 0, 0);
                try {
                    throw new Error("WWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWWW");
                }
                catch (Throwable t3) {
                    h.handleErrors(f, "title", null, t3, source, null, 0, 0);
                    return;
                }
            }
        }
    }

    protected static class CallTrace
    extends Throwable {
        protected CallTrace() {
        }
    }
}

