/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.util.errorhandling.AmbientInfo;
import com.starbase.util.errorhandling.Description;
import com.starbase.util.errorhandling.ErrorBundle;
import com.starbase.util.errorhandling.ErrorDetailInfo;
import com.starbase.util.errorhandling.GraphicalErrorHandler;
import com.starbase.util.errorhandling.Location;
import com.starbase.util.errorhandling.Miscellaneous;
import com.starbase.util.errorhandling.Overview;
import com.starbase.util.errorhandling.Source;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.StringSelection;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.border.EmptyBorder;
import javax.swing.plaf.basic.BasicArrowButton;

class DisplayComponent
extends JPanel {
    protected JButton m_previousButton = new BasicArrowButton(7);
    protected JButton m_nextButton = new BasicArrowButton(3);
    protected int m_currentErrorIndex = 0;
    protected CardLayout m_cards = new CardLayout();
    protected final JLabel m_navigatorIndex = new JLabel();
    protected final String m_title;
    protected final String m_extraMessage;
    protected final Vector m_errors;
    protected final Vector m_ambients = new Vector();
    protected final Vector m_details = new Vector();

    protected DisplayComponent(Vector errors, String title, String extraMessage) {
        this.m_errors = errors;
        this.m_title = title;
        this.m_extraMessage = extraMessage;
        this.init();
        if (this.m_errors.size() > 0) {
            this.hookupSideEffects();
            this.setCurrentErrorBundle(0);
        }
    }

    protected void init() {
        if (this.m_errors.size() > 0) {
            this.setLayout(this.m_cards);
            this.add(this.initOverview(), "overview");
            this.m_cards.first(this);
        } else {
            this.add(new JLabel("No errors"));
        }
    }

    protected Component initOverview() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.add((Component)new Overview(this.m_errors), "Center");
        JPanel buttons = new JPanel();
        buttons.setBorder(new EmptyBorder(0, 0, 0, 0));
        buttons.setLayout(new BoxLayout(buttons, 0));
        panel.add((Component)buttons, "South");
        buttons.add(Box.createHorizontalGlue());
        JButton detailsButton = new JButton(new AbstractAction(){
            boolean addedDetails = false;
            {
                this.putValue("Name", "Details >>>");
            }

            public void actionPerformed(ActionEvent ev) {
                if (!this.addedDetails) {
                    DisplayComponent.this.add(DisplayComponent.this.initDetails(), "details");
                    Window w = SwingUtilities.getWindowAncestor(DisplayComponent.this);
                    if (w != null) {
                        w.pack();
                        Utils.centerOnScreen(w);
                    }
                    this.addedDetails = true;
                }
                DisplayComponent.this.m_cards.last(DisplayComponent.this);
            }
        });
        detailsButton.setForeground(Color.blue);
        detailsButton.setBorder(new EmptyBorder(0, 0, 0, 15));
        detailsButton.setCursor(new Cursor(12));
        buttons.add(Box.createHorizontalStrut(detailsButton.getPreferredSize().width * 2));
        buttons.add(detailsButton);
        return panel;
    }

    protected Component initDetails() {
        JPanel panel = new JPanel(new BorderLayout());
        panel.setBorder(new EmptyBorder(5, 5, 5, 5));
        Miscellaneous misc = new Miscellaneous();
        this.m_ambients.add(misc);
        Description description = new Description();
        this.m_details.add(description);
        description.setError((ErrorBundle)this.m_errors.get(this.m_currentErrorIndex));
        Source source = new Source();
        this.m_details.add(source);
        source.setError((ErrorBundle)this.m_errors.get(this.m_currentErrorIndex));
        Location location = new Location();
        this.m_details.add(location);
        location.setError((ErrorBundle)this.m_errors.get(this.m_currentErrorIndex));
        JTabbedPane tabs = new JTabbedPane();
        tabs.add((Component)description.getPanel(), description.getName());
        tabs.add((Component)source.getPanel(), source.getName());
        tabs.add((Component)location.getPanel(), location.getName());
        tabs.add((Component)misc.getPanel(), misc.getName());
        panel.add((Component)tabs, "Center");
        JPanel buttons = new JPanel();
        buttons.setLayout(new BoxLayout(buttons, 0));
        panel.add((Component)buttons, "South");
        buttons.add(Box.createHorizontalGlue());
        JButton copyButton = new JButton("Copy...");
        copyButton.setToolTipText("Copy error information to the clipboard");
        copyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                SecurityManager sm = System.getSecurityManager();
                try {
                    if (sm != null) {
                        sm.checkSystemClipboardAccess();
                    }
                    Clipboard clipboard = DisplayComponent.this.getToolkit().getSystemClipboard();
                    StringSelection selection = new StringSelection(DisplayComponent.this.createBugReport());
                    clipboard.setContents(selection, null);
                }
                catch (SecurityException se) {
                    JOptionPane.showMessageDialog(DisplayComponent.this, "System clipboard is unavailable", "Error", 0);
                }
            }
        });
        buttons.add(copyButton);
        buttons.add(this.initNavigator());
        buttons.add(new JButton(new AbstractAction(){
            {
                this.putValue("Name", "<<< Overview");
            }

            public void actionPerformed(ActionEvent ev) {
                DisplayComponent.this.m_cards.first(DisplayComponent.this);
            }
        }));
        return panel;
    }

    protected JPanel initNavigator() {
        JPanel panel = new JPanel();
        panel.add(this.m_previousButton);
        panel.add(this.m_navigatorIndex);
        panel.add(this.m_nextButton);
        return panel;
    }

    protected void hookupSideEffects() {
        this.m_nextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DisplayComponent.this.setCurrentErrorBundle(DisplayComponent.this.m_currentErrorIndex + 1);
            }
        });
        this.m_previousButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                DisplayComponent.this.setCurrentErrorBundle(DisplayComponent.this.m_currentErrorIndex - 1);
            }
        });
    }

    protected void setCurrentErrorBundle(int index) {
        this.m_currentErrorIndex = index;
        this.m_navigatorIndex.setText("" + (index + 1) + " of " + this.m_errors.size());
        if (index == 0) {
            this.m_previousButton.setEnabled(false);
        } else {
            this.m_previousButton.setEnabled(true);
        }
        if (index == this.m_errors.size() - 1) {
            this.m_nextButton.setEnabled(false);
        } else {
            this.m_nextButton.setEnabled(true);
        }
        this.invalidate();
        ErrorBundle error = (ErrorBundle)this.m_errors.get(index);
        int i = 0;
        while (i < this.m_details.size()) {
            ((ErrorDetailInfo)this.m_details.get(i)).setError(error);
            ++i;
        }
    }

    protected String createBugReport() {
        StringWriter swriter = new StringWriter();
        PrintWriter pw = new PrintWriter(swriter);
        int i = 0;
        while (i < this.m_ambients.size()) {
            AmbientInfo info = (AmbientInfo)this.m_ambients.get(i);
            pw.println(info.getText());
            if (i < this.m_ambients.size() - 1) {
                pw.println("------------------------------------");
            }
            ++i;
        }
        pw.println(this.m_title);
        pw.println(this.m_extraMessage);
        pw.println("*****************************************************");
        pw.println();
        int i2 = 0;
        while (i2 < this.m_errors.size()) {
            pw.println("Error #" + (i2 + 1));
            pw.println();
            int k = 0;
            while (k < this.m_details.size()) {
                ErrorDetailInfo info = (ErrorDetailInfo)this.m_details.get(k);
                pw.println(info.createText((ErrorBundle)this.m_errors.get(i2)));
                if (k < this.m_details.size() - 1) {
                    pw.println("------------------------------------");
                }
                ++k;
            }
            pw.println("*****************************************************");
            pw.println();
            ++i2;
        }
        return swriter.toString();
    }

    public static void main(String[] args) {
        GraphicalErrorHandler.main(args);
    }
}

