/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import com.starbase.starteam.ServerException;
import com.starbase.util.errorhandling.ErrorBundle;
import com.starbase.util.errorhandling.ErrorDetailInfo;
import com.starbase.util.errorhandling.Utils;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;

public class Description
extends JPanel
implements ErrorDetailInfo {
    protected JTextArea m_description = new JTextArea();

    public Description() {
        this.init();
    }

    protected void init() {
        this.setLayout(new BorderLayout());
        JTextArea text = this.m_description;
        text.setWrapStyleWord(true);
        text.setLineWrap(true);
        text.setEditable(false);
        JScrollPane scroll = new JScrollPane(text, 20, 31);
        Dimension scrollSize = Utils.adjustPreferredSize(text.getPreferredScrollableViewportSize());
        scroll.setPreferredSize(scrollSize);
        this.add((Component)scroll, "Center");
    }

    public String getName() {
        return "Description";
    }

    public void setError(ErrorBundle error) {
        this.m_description.setText(this.createText(error));
        this.m_description.setCaretPosition(0);
    }

    public JPanel getPanel() {
        return this;
    }

    public String createText(ErrorBundle error) {
        StringBuffer buffer = new StringBuffer();
        String eol = System.getProperty("line.separator");
        if (error.m_error instanceof ServerException) {
            ServerException se = (ServerException)error.m_error;
            buffer.append("Server Exception Message:" + eol);
            buffer.append(se.getMessage() + eol);
            if (!se.isLogged()) {
                buffer.append("ClassName: " + se.getClassName() + eol);
                buffer.append("ErrorSource: " + se.getErrorSource() + eol);
                buffer.append("Error Code: " + se.getErrorCode() + eol);
                String[] keys = se.getAuxKeys();
                int i = 0;
                while (i < keys.length) {
                    buffer.append("Aux key: " + keys[i] + " value: " + se.getAuxData(keys[i]) + eol);
                    ++i;
                }
            }
        } else {
            Throwable t;
            buffer.append("Error type: ");
            buffer.append(error.m_error != null ? error.m_error.getClass().getName() : "N/A");
            buffer.append(eol + "---" + eol);
            if (Utils.isSDKRuntimeException(error.m_error)) {
                t = Utils.unwrapSDKRuntimeException(error.m_error);
                buffer.append("Originating error type: ");
                buffer.append(t != null ? t.getClass().getName() : "N/A");
                buffer.append(eol + "---" + eol);
            }
            buffer.append("Application message: ");
            buffer.append(error.m_message != null ? error.m_message : "N/A");
            buffer.append(eol + "---" + eol);
            buffer.append("Exception message: ");
            buffer.append(error.m_error == null || error.m_error.getMessage() == null ? "N/A" : error.m_error.getMessage());
            buffer.append(eol + "---" + eol);
            if (Utils.isSDKRuntimeException(error.m_error)) {
                t = Utils.unwrapSDKRuntimeException(error.m_error);
                buffer.append("Originating exception message: ");
                buffer.append(t != null ? t.getMessage() : "N/A");
                buffer.append(eol + "---" + eol);
            }
            buffer.append("Exception toString: ");
            buffer.append(error.m_error == null ? "N/A" : error.m_error.toString());
            buffer.append(eol + "---" + eol);
            if (Utils.isSDKRuntimeException(error.m_error)) {
                t = Utils.unwrapSDKRuntimeException(error.m_error);
                buffer.append("Originating exception toString: ");
                buffer.append(t != null ? t.toString() : "N/A");
            }
        }
        return buffer.toString();
    }
}

