/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.util.errorhandling;

import java.net.URL;
import java.net.URLClassLoader;
import java.util.Vector;

class ClassLoaderUtils {
    ClassLoaderUtils() {
    }

    public static void dumpLineage(ClassLoader loader) {
        ClassLoader[] lineage = ClassLoaderUtils.getLineage(loader);
        int i = lineage.length - 1;
        while (i >= 0) {
            System.out.println(ClassLoaderUtils.stringRepresentation(lineage[i], true, lineage.length - 1 - i));
            --i;
        }
    }

    public static ClassLoader[] getLineage(ClassLoader loader) {
        Vector<ClassLoader> v = new Vector<ClassLoader>();
        ClassLoader l = loader;
        while (l != null) {
            v.add(l);
            l = l.getParent();
        }
        Object[] ret = new ClassLoader[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static ClassLoader whoLoads(Class classToLoad) {
        ClassLoader[] lineage = ClassLoaderUtils.getLineage(classToLoad.getClassLoader());
        ClassLoader last = classToLoad.getClassLoader();
        int i = 1;
        while (i < lineage.length) {
            try {
                Class<?> c = lineage[i].loadClass(classToLoad.getName());
                if (c.equals(classToLoad)) {
                    last = lineage[i];
                }
            }
            catch (ClassNotFoundException e) {
                // empty catch block
            }
            ++i;
        }
        return last;
    }

    public static String stringRepresentation(ClassLoader loader, boolean detailed, int indent) {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buff.append(ClassLoaderUtils.indent(indent) + "ClassLoader: " + loader + eol);
        if (detailed && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            int k = 0;
            while (k < urls.length) {
                buff.append(ClassLoaderUtils.indent(indent) + "----" + urls[k] + eol);
                ++k;
            }
        }
        return buff.toString();
    }

    public static String indent(int depth) {
        String ret = "";
        int i = 0;
        while (i < depth) {
            ret = ret + "    ";
            ++i;
        }
        return ret;
    }
}

