/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.toollocator;

import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.InvalidDescriptorFormatException;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.ResourceNotFoundException;
import com.starbase.starteam.tool.DefaultErrorHandler;
import com.starbase.starteam.tool.DefaultToolDescriptor;
import com.starbase.starteam.tool.ManagedTool;
import com.starbase.starteam.tool.Tool;
import com.starbase.starteam.tool.ToolDescriptor;
import com.starbase.starteam.tool.ToolErrorHandler;
import com.starbase.starteam.tool.ToolException;
import com.starbase.starteam.tool.UnavailableException;
import com.starbase.starteam.toollocator.DefaultToolLocator;
import com.starbase.starteam.toollocator.ToolApplicability;
import com.starbase.starteam.toollocator.ToolLocator;
import com.starbase.util.logging.Log;
import java.beans.Beans;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextServiceProvider;
import java.beans.beancontext.BeanContextServices;
import java.io.IOException;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Vector;

public class DefaultToolLocator
implements ToolLocator {
    protected ResourceLocator m_locator;
    protected ToolErrorHandler m_errorHandler = new DefaultErrorHandler();
    protected ClassLoaderFactory m_classLoaderFactory;
    static /* synthetic */ Class class$com$starbase$starteam$toollocator$BeanContextServicesImpl;
    static /* synthetic */ Class class$com$starbase$starteam$tool$ManagedTool;

    public DefaultToolLocator(ResourceLocator locator, ClassLoaderFactory loaderFactory) {
        this.m_locator = locator;
        this.m_classLoaderFactory = loaderFactory;
    }

    public Object getTool(ClassLoader parentLoader, String name, ToolApplicability applicability, BeanContext nestingContext, ToolLocator.Service[] services) throws MisconfigurationException {
        BeanContextServices ctx;
        Object ret = null;
        try {
            ctx = (BeanContextServices)Beans.instantiate(this.getClass().getClassLoader(), (class$com$starbase$starteam$toollocator$BeanContextServicesImpl == null ? (class$com$starbase$starteam$toollocator$BeanContextServicesImpl = DefaultToolLocator.class$("com.starbase.starteam.toollocator.BeanContextServicesImpl")) : class$com$starbase$starteam$toollocator$BeanContextServicesImpl).getName(), nestingContext);
        }
        catch (IOException e) {
            throw new MisconfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MisconfigurationException(e);
        }
        if (services != null) {
            int i = 0;
            while (i < services.length) {
                ctx.addService(services[i].getServiceClass(), services[i].getProvider());
                ++i;
            }
        }
        parentLoader = parentLoader != null ? parentLoader : this.getClass().getClassLoader();
        ToolDescriptor[] descriptors = this.getToolDescriptors(name + ".tool.xml", applicability);
        if (descriptors.length > 0) {
            DefaultToolDescriptor desc = (DefaultToolDescriptor)descriptors[0];
            ret = this.loadTool(parentLoader, desc, ctx);
        } else {
            ret = null;
        }
        return ret;
    }

    public BeanContextServices getTools(ClassLoader parentLoader, String pattern, ToolApplicability applicability, BeanContext nestingContext, ToolLocator.Service[] services) throws MisconfigurationException {
        BeanContextServices ctx;
        if (Log.logging) {
            Log.write(500, "getTools called with: parentLoader=" + parentLoader + ", pattern=" + pattern + ", applicability=" + applicability + ", nestingContext=" + nestingContext + ", services=" + services + (services != null ? "[" + services.length + "]" : ""), "tool");
        }
        parentLoader = parentLoader != null ? parentLoader : this.getClass().getClassLoader();
        BeanContextServices ret = null;
        try {
            ctx = (BeanContextServices)Beans.instantiate(this.getClass().getClassLoader(), (class$com$starbase$starteam$toollocator$BeanContextServicesImpl == null ? (class$com$starbase$starteam$toollocator$BeanContextServicesImpl = DefaultToolLocator.class$("com.starbase.starteam.toollocator.BeanContextServicesImpl")) : class$com$starbase$starteam$toollocator$BeanContextServicesImpl).getName(), nestingContext);
        }
        catch (IOException e) {
            throw new MisconfigurationException(e);
        }
        catch (ClassNotFoundException e) {
            throw new MisconfigurationException(e);
        }
        ToolDescriptor[] descriptors = this.getToolDescriptors(pattern, applicability);
        int i = 0;
        while (i < descriptors.length) {
            DefaultToolDescriptor desc = (DefaultToolDescriptor)descriptors[i];
            this.loadTool(parentLoader, desc, ctx);
            ++i;
        }
        if (services != null) {
            int i2 = 0;
            while (i2 < services.length) {
                ctx.addService(services[i2].getServiceClass(), services[i2].getProvider());
                ++i2;
            }
        }
        ret = ctx;
        return ret;
    }

    public ToolDescriptor[] getToolDescriptors(String pattern, ToolApplicability applicability) {
        String[] names;
        Vector<DefaultToolDescriptor> v;
        block8: {
            v = new Vector<DefaultToolDescriptor>();
            names = null;
            pattern = pattern + ".tool.xml";
            try {
                names = this.m_locator.getResourceNames(pattern);
            }
            catch (IOException e) {
                ToolErrorHandler handler = this.getDefaultErrorHandler();
                String msg = "I/O error occurred while searching for tool descriptors matching " + pattern + ".";
                if (handler == null) break block8;
                handler.accumulateError(this, e, msg, null);
            }
        }
        int i = 0;
        while (i < names.length) {
            block9: {
                try {
                    Resource r = this.m_locator.getResource(names[i]);
                    DefaultToolDescriptor desc = DefaultToolDescriptor.load(r.getInputStream());
                    if (applicability.isApplicable(desc)) {
                        v.add(desc);
                    }
                }
                catch (IOException e) {
                    ToolErrorHandler handler = this.getDefaultErrorHandler();
                    String msg = "I/O error occurred while searching for tool descriptors named " + names[i] + ".";
                    if (handler != null) {
                        handler.accumulateError(this, e, msg, null);
                    }
                }
                catch (InvalidDescriptorFormatException e) {
                    ToolErrorHandler handler = this.getDefaultErrorHandler();
                    String msg = "Resource named " + names[i] + " is not a valid " + "tool descriptor.";
                    if (handler == null) break block9;
                    handler.accumulateError(this, e, msg, null);
                }
            }
            ++i;
        }
        Object[] ret = new ToolDescriptor[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected Object loadTool(ClassLoader parentLoader, DefaultToolDescriptor desc, BeanContext ctx) {
        Object tool;
        block28: {
            String msg;
            ToolErrorHandler handler;
            String msg2;
            ToolErrorHandler handler2;
            String msg3;
            ToolErrorHandler handler3;
            String msg4;
            ToolErrorHandler handler4;
            block27: {
                tool = null;
                try {
                    String[] jarNames = desc.getRunContext().getJarNames();
                    Resource[] jars = new Resource[jarNames.length];
                    int i = 0;
                    while (i < jars.length) {
                        Resource r = this.m_locator.getResource(jarNames[i]);
                        if (r == null) {
                            throw new ResourceNotFoundException(jarNames[i] + " not found while trying to load descriptor for " + desc.getDisplayName() + " (" + desc.getID() + ").");
                        }
                        jars[i] = r;
                        ++i;
                    }
                    if (Log.logging) {
                        Log.write(500, "DefaultToolLocator loading " + desc.getDisplayName(), "tool");
                    }
                    ClassLoader loader = this.m_classLoaderFactory.getClassLoader(parentLoader, jars, this.m_locator, 1, 0);
                    if (Log.logging) {
                        Log.write(500, "Loading tool (" + desc.getDisplayName() + ") with: " + loader, "tool");
                    }
                    tool = Beans.instantiate(loader, desc.getRunContext().getClassName(), ctx);
                }
                catch (ResourceNotFoundException e) {
                    handler4 = this.getDefaultErrorHandler();
                    if (handler4 != null) {
                        handler4.accumulateError(this, e, null, null);
                    }
                }
                catch (IOException e) {
                    ToolErrorHandler handler5 = this.getDefaultErrorHandler();
                    msg4 = "I/O failure while fetching resources for " + desc.getDisplayName() + " (" + desc.getID() + ").";
                    if (handler5 != null) {
                        handler5.accumulateError(this, e, msg4, null);
                    }
                }
                catch (MisconfigurationException e) {
                    handler3 = this.getDefaultErrorHandler();
                    msg3 = "Failure creating class loader for " + desc.getDisplayName() + " (" + desc.getID() + ").";
                    if (handler3 != null) {
                        handler3.accumulateError(this, e, msg3, null);
                    }
                }
                catch (ClassNotFoundException e) {
                    handler2 = this.getDefaultErrorHandler();
                    msg2 = "Class  not found: " + e.getMessage() + " for " + desc.getDisplayName() + " (" + desc.getID() + ").";
                    if (handler2 != null) {
                        handler2.accumulateError(this, e, msg2, null);
                    }
                }
                catch (NoClassDefFoundError e) {
                    handler = this.getDefaultErrorHandler();
                    msg = "Tool named " + desc.getDisplayName() + " is missing implementation " + "resources: " + e.getMessage();
                    if (handler == null) break block27;
                    handler.accumulateError(tool, e, msg, null);
                }
            }
            try {
                if (tool == null) break block28;
                ((ManagedTool)tool).init(desc, this.getDefaultErrorHandler());
                if (((Tool)tool).getDescriptor() == null) {
                    ToolErrorHandler handler6 = this.getDefaultErrorHandler();
                    String msg5 = "Tool not properly initialized Tool.getDescriptor returned null: " + desc.getDisplayName();
                    if (handler6 != null) {
                        handler6.accumulateError(tool, null, msg5, null);
                    }
                    ctx.remove(tool);
                    tool = null;
                }
            }
            catch (InvalidDescriptorFormatException e) {
                handler4 = this.getDefaultErrorHandler();
                String msg6 = "Tool named " + desc.getDisplayName() + " threw an exception " + "during initialization: " + e;
                if (handler4 != null) {
                    handler4.accumulateError(tool, e, msg6, null);
                }
                ctx.remove(tool);
                tool = null;
            }
            catch (UnavailableException e) {
                ToolErrorHandler handler7 = this.getDefaultErrorHandler();
                msg4 = "Tool named " + desc.getDisplayName() + " reports that it " + "is unavailable: " + e;
                if (handler7 != null) {
                    handler7.accumulateError(tool, e, msg4, null);
                }
            }
            catch (ToolException e) {
                handler3 = this.getDefaultErrorHandler();
                msg3 = "Tool named " + desc.getDisplayName() + " threw an exception " + "during initialization: " + e;
                if (handler3 != null) {
                    handler3.accumulateError(tool, e, msg3, null);
                }
                ctx.remove(tool);
                tool = null;
            }
            catch (ClassCastException e) {
                handler2 = this.getDefaultErrorHandler();
                msg2 = "Tool named " + desc.getDisplayName() + " does not conform to " + "the " + (class$com$starbase$starteam$tool$ManagedTool == null ? (class$com$starbase$starteam$tool$ManagedTool = DefaultToolLocator.class$("com.starbase.starteam.tool.ManagedTool")) : class$com$starbase$starteam$tool$ManagedTool).getName() + " interface.";
                if (handler2 != null) {
                    handler2.accumulateError(tool, e, msg2, null);
                }
                ctx.remove(tool);
                tool = null;
            }
            catch (RuntimeException e) {
                handler = this.getDefaultErrorHandler();
                msg = "Tool named " + desc.getDisplayName() + " threw an unexpected " + "exception during initialization: " + e;
                if (handler != null) {
                    handler.accumulateError(tool, e, msg, null);
                }
                ctx.remove(tool);
                tool = null;
            }
        }
        return tool;
    }

    public ToolLocator.Service createSimpleServiceProvider(final Class service, final Object implementation) {
        return new ToolLocator.Service(){

            public Class getServiceClass() {
                return service;
            }

            public BeanContextServiceProvider getProvider() {
                return new BeanContextServiceProvider(this){
                    private final /* synthetic */ 1 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public Object getService(BeanContextServices bcs, Object requestor, Class serviceClass, Object serviceSelector) {
                        return serviceClass.equals(this.this$1.getServiceClass()) ? 1.access$000(this.this$1) : null;
                    }

                    public void releaseService(BeanContextServices bcs, Object requestor, Object service) {
                    }

                    public Iterator getCurrentServiceSelectors(BeanContextServices bcs, Class serviceClass) {
                        return new Iterator(this){
                            private final /* synthetic */ 2 this$2;
                            {
                                this.this$2 = this$2;
                            }

                            public boolean hasNext() {
                                return false;
                            }

                            public Object next() {
                                throw new NoSuchElementException();
                            }

                            public void remove() {
                                throw new UnsupportedOperationException();
                            }
                        };
                    }
                };
            }

            static /* synthetic */ Object access$000(1 x0) {
                return x0.implementation;
            }
        };
    }

    public ToolErrorHandler getDefaultErrorHandler() {
        return this.m_errorHandler;
    }

    public void setDefaultErrorHandler(ToolErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    public String toString() {
        return "ToolLocator using " + this.m_locator;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

