/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.tool;

import com.starbase.starteam.deployer.InvalidDescriptorFormatException;
import com.starbase.starteam.tool.ToolDescriptor;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DefaultToolDescriptor
implements ToolDescriptor {
    protected final String m_id;
    protected final Description m_description;
    protected final Applications m_applications;
    protected final RunContext m_runContext;
    protected final Properties m_properties;
    protected final Element m_rootElement;
    public static final String[] SUPPORTED_VERSIONS = new String[]{"1.0"};

    public DefaultToolDescriptor(String id, Description description, Applications applications, RunContext runContext, Properties properties, Element rootElement) {
        if (runContext == null) {
            throw new IllegalArgumentException("[runContext : RunContext] may not be null");
        }
        this.m_id = id != null ? id : "";
        this.m_description = description != null ? description : new Description("", "", "");
        this.m_applications = applications != null ? applications : new Applications();
        this.m_runContext = runContext;
        this.m_properties = properties != null ? properties : new Properties();
        this.m_rootElement = rootElement;
    }

    public Description getDescription() {
        return this.m_description;
    }

    public Applications getApplications() {
        return this.m_applications;
    }

    public RunContext getRunContext() {
        return this.m_runContext;
    }

    public String getID() {
        return this.m_id;
    }

    public String getDisplayName() {
        return this.m_description.getDisplayName();
    }

    public String getShortDescription() {
        return this.m_description.getShortDescription();
    }

    public String getLongDescription() {
        return this.m_description.getLongDescription();
    }

    public java.util.Properties getProperties() {
        return this.m_properties;
    }

    public Element getSource() {
        return this.m_rootElement;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buff.append(this.m_description + eol);
        buff.append(this.m_applications + eol);
        buff.append(this.m_runContext + eol);
        buff.append(this.m_properties + eol);
        return buff.toString();
    }

    public static DefaultToolDescriptor load(InputStream input) throws IOException, InvalidDescriptorFormatException {
        Document doc;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            doc = parser.parse(new InputSource(input));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to initialize tool descriptor parser: " + e.toString());
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse tool descriptor: " + e.toString());
        }
        Element rootElement = doc.getDocumentElement();
        return DefaultToolDescriptor.load(rootElement);
    }

    public static DefaultToolDescriptor load(Element rootElement) throws InvalidDescriptorFormatException {
        if (!"tool".equals(rootElement.getNodeName())) {
            throw new InvalidDescriptorFormatException("Input appears not to be a tool descriptor.");
        }
        Vector<String> versions = new Vector<String>();
        int i = 0;
        while (i < SUPPORTED_VERSIONS.length) {
            versions.addElement(SUPPORTED_VERSIONS[i]);
            ++i;
        }
        String formatVersion = rootElement.getAttribute("format-version").trim();
        if (!versions.contains(formatVersion)) {
            String supportedVersions = "";
            int i2 = 0;
            while (i2 < SUPPORTED_VERSIONS.length) {
                supportedVersions = supportedVersions + SUPPORTED_VERSIONS[i2];
                if (i2 < SUPPORTED_VERSIONS.length - 1) {
                    supportedVersions = supportedVersions + ", ";
                }
                ++i2;
            }
            String msg = "Input appears to be a tool descriptor, but uses format-version " + formatVersion + ".  " + "This tool understands versions " + supportedVersions + ".";
            throw new InvalidDescriptorFormatException(msg);
        }
        String id = rootElement.getAttribute("name").trim();
        Node runContextNode = DefaultToolDescriptor.findChild(rootElement, "javaclass");
        RunContext runContext = runContextNode != null ? RunContext.read(runContextNode) : null;
        if (runContext == null) {
            String msg = "Input appears to be a tool descriptor, but is missing a javaclass node and is therefore invalid.";
            throw new InvalidDescriptorFormatException("Input appears to be a tool descriptor, but is missing a javaclass node and is therefore invalid.");
        }
        return new DefaultToolDescriptor(id, Description.read(DefaultToolDescriptor.findChild(rootElement, "description")), Applications.read(DefaultToolDescriptor.findChild(rootElement, "applications")), runContext, Properties.read(DefaultToolDescriptor.findChild(rootElement, "properties")), rootElement);
    }

    protected static String getChildElementValue(Node parent, String tag) {
        Node node = DefaultToolDescriptor.findChild(parent, tag);
        String ret = DefaultToolDescriptor.getChildText(node);
        return ret;
    }

    protected static Node findChild(Node parent, String childTagName) {
        Node[] children = DefaultToolDescriptor.findChildren(parent, childTagName);
        return children.length > 0 ? children[0] : null;
    }

    protected static Node[] findChildren(Node parent, String childTagName) {
        Vector<Node> v = new Vector<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals(childTagName)) {
                v.addElement(children.item(i));
            }
            ++i;
        }
        Object[] ret = new Node[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected static String getChildText(Node node) {
        String ret;
        if (node == null) {
            ret = null;
        } else {
            StringBuffer stringbuffer = new StringBuffer();
            Node child = node.getFirstChild();
            while (child != null) {
                if (child.getNodeType() == 3 || child.getNodeType() == 4) {
                    stringbuffer.append(child.getNodeValue());
                }
                child = child.getNextSibling();
            }
            ret = stringbuffer.toString();
        }
        return ret;
    }

    public static class Properties
    extends java.util.Properties {
        public static final String NODE_NAME = "properties";

        public String getProperty(String name) {
            return this.getProperty(name, null);
        }

        public String getProperty(String name, String defaultValue) {
            String value = (String)this.get(name);
            return value != null ? value : defaultValue;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Properties" + eol);
            Enumeration<Object> enumeration = this.keys();
            while (enumeration.hasMoreElements()) {
                Object key = enumeration.nextElement();
                buff.append("  " + key + ": " + this.get(key) + eol);
            }
            return buff.toString();
        }

        protected static Properties read(Node in) throws InvalidDescriptorFormatException {
            Properties ret;
            if (in != null && NODE_NAME.equals(in.getNodeName())) {
                ret = new Properties();
                Node[] nodes = DefaultToolDescriptor.findChildren(in, "property");
                int i = 0;
                while (i < nodes.length) {
                    String name = ((Element)nodes[i]).getAttribute("name").trim();
                    String value = DefaultToolDescriptor.getChildText(nodes[i]);
                    if (name == null) {
                        String msg = "Malformed <property> element: missing \"name\" attribute.";
                        throw new InvalidDescriptorFormatException("Malformed <property> element: missing \"name\" attribute.");
                    }
                    ret.put(name, value);
                    ++i;
                }
            } else {
                ret = null;
            }
            return ret;
        }
    }

    public static class RunContext {
        public static final String NODE_NAME = "javaclass";
        private final String m_className;
        private final String[] m_jars;

        public RunContext(String className, String[] jars) {
            this.m_className = className;
            this.m_jars = jars;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String[] getJarNames() {
            return this.m_jars;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("RunContext" + eol);
            buff.append("  Class: " + this.m_className + eol);
            buff.append("  Jars: ");
            int i = 0;
            while (i < this.m_jars.length) {
                buff.append(this.m_jars[i]);
                if (i < this.m_jars.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
            buff.append(eol);
            return buff.toString();
        }

        protected static RunContext read(Node in) throws InvalidDescriptorFormatException {
            RunContext ret;
            if (in != null && NODE_NAME.equals(in.getNodeName())) {
                String className = ((Element)in).getAttribute("name").trim();
                Node[] jarNodes = DefaultToolDescriptor.findChildren(in, "jar");
                String[] jars = new String[jarNodes.length];
                int i = 0;
                while (i < jarNodes.length) {
                    jars[i] = ((Element)jarNodes[i]).getAttribute("name").trim();
                    ++i;
                }
                ret = new RunContext(className, jars);
            } else {
                ret = null;
            }
            return ret;
        }
    }

    public static class Applications {
        public static final String NODE_NAME = "applications";
        private final Application[] m_applications;

        public Applications() {
            this.m_applications = new Application[]{new Application("*", new String[]{"*"})};
        }

        public Applications(Application[] applications) {
            Application[] applicationArray;
            if (applications != null && applications.length > 0) {
                applicationArray = applications;
            } else {
                Application[] applicationArray2 = new Application[1];
                applicationArray = applicationArray2;
                applicationArray2[0] = new Application("*", new String[]{"*"});
            }
            this.m_applications = applicationArray;
        }

        public Application[] getApplications() {
            return this.m_applications;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Applications:" + eol);
            int i = 0;
            while (i < this.m_applications.length) {
                buff.append("  " + this.m_applications[i] + eol);
                ++i;
            }
            return buff.toString();
        }

        protected static Applications read(Node in) {
            Applications ret;
            if (in != null && NODE_NAME.equals(in.getNodeName())) {
                Vector<Application> v = new Vector<Application>();
                Node[] applicationNodes = DefaultToolDescriptor.findChildren(in, "application");
                int i = 0;
                while (i < applicationNodes.length) {
                    Vector<String> c = new Vector<String>();
                    String name = ((Element)applicationNodes[i]).getAttribute("name").trim();
                    Node[] componentNodes = DefaultToolDescriptor.findChildren(applicationNodes[i], "component");
                    int k = 0;
                    while (k < componentNodes.length) {
                        c.addElement(((Element)componentNodes[k]).getAttribute("name").trim());
                        ++k;
                    }
                    Object[] componentNames = new String[c.size()];
                    c.copyInto(componentNames);
                    v.addElement(new Application(name, (String[])componentNames));
                    ++i;
                }
                Object[] applications = new Application[v.size()];
                v.copyInto(applications);
                ret = new Applications((Application[])applications);
            } else {
                ret = null;
            }
            return ret;
        }

        public static class Application {
            private final String m_name;
            private final String[] m_components;

            public Application(String name, String[] components) {
                String[] stringArray;
                String string = this.m_name = name != null && !"".equals(name) ? name : "*";
                if (components != null && components.length > 0) {
                    stringArray = components;
                } else {
                    String[] stringArray2 = new String[1];
                    stringArray = stringArray2;
                    stringArray2[0] = "*";
                }
                this.m_components = stringArray;
            }

            public String getName() {
                return this.m_name;
            }

            public String[] getComponents() {
                return this.m_components;
            }

            public String toString() {
                StringBuffer buff = new StringBuffer();
                buff.append("Application: " + this.m_name + "; Components: ");
                int i = 0;
                while (i < this.m_components.length) {
                    buff.append(this.m_components[i]);
                    if (i < this.m_components.length - 1) {
                        buff.append(", ");
                    }
                    ++i;
                }
                return buff.toString();
            }
        }
    }

    public static class Description {
        public static final String NODE_NAME = "description";
        private String m_displayName;
        private String m_shortDescription;
        private String m_longDescription;

        public Description(String displayName, String shortDescription, String longDescription) {
            this.m_displayName = displayName;
            this.m_shortDescription = shortDescription;
            this.m_longDescription = longDescription;
        }

        public String getDisplayName() {
            return this.m_displayName;
        }

        public String getShortDescription() {
            return this.m_shortDescription;
        }

        public String getLongDescription() {
            return this.m_longDescription;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Description" + eol);
            buff.append("  m_displayName: " + this.m_displayName + eol);
            buff.append("  m_shortDescription: " + this.m_shortDescription + eol);
            buff.append("  m_longDescription: " + this.m_longDescription + eol);
            return buff.toString();
        }

        protected static Description read(Node in) throws InvalidDescriptorFormatException {
            Description ret = in != null && NODE_NAME.equals(in.getNodeName()) ? new Description(DefaultToolDescriptor.getChildElementValue(in, "display-name"), DefaultToolDescriptor.getChildElementValue(in, "short-description"), DefaultToolDescriptor.getChildElementValue(in, "long-description")) : null;
            return ret;
        }
    }
}

