/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.tool;

import com.starbase.starteam.deployer.InvalidDescriptorFormatException;
import com.starbase.starteam.tool.DefaultErrorHandler;
import com.starbase.starteam.tool.ManagedTool;
import com.starbase.starteam.tool.ToolDescriptor;
import com.starbase.starteam.tool.ToolErrorHandler;
import com.starbase.starteam.tool.ToolException;
import com.starbase.starteam.tool.UnavailableException;
import com.starbase.util.logging.Log;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.beans.beancontext.BeanContext;
import java.beans.beancontext.BeanContextChild;
import java.beans.beancontext.BeanContextChildSupport;
import java.beans.beancontext.BeanContextServiceAvailableEvent;
import java.beans.beancontext.BeanContextServiceRevokedEvent;
import java.beans.beancontext.BeanContextServices;
import java.beans.beancontext.BeanContextServicesListener;
import java.net.URL;
import java.util.HashMap;
import java.util.Properties;
import java.util.TooManyListenersException;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ImageIcon;
import javax.swing.JMenuItem;

public abstract class AbstractTool
extends AbstractAction
implements ManagedTool,
BeanContextChild,
BeanContextServicesListener {
    protected final transient BeanContextChildSupport m_bccSupport;
    protected transient ToolDescriptor m_descriptor;
    protected transient boolean m_avoidingGui = false;
    protected transient ToolErrorHandler m_errorHandler = new DefaultErrorHandler();
    protected transient HashMap m_services = new HashMap();

    public AbstractTool() {
        this.m_bccSupport = new BeanContextChildSupport(this){

            protected void initializeBeanContextResources() {
                if (this.beanContext instanceof BeanContextServices) {
                    ((BeanContextServices)this.beanContext).addBeanContextServicesListener(this);
                }
            }

            public void serviceAvailable(BeanContextServiceAvailableEvent ev) {
                if (Log.logging) {
                    Log.write(500, "" + this + " received BeanContextServiceAvailableEvent: " + ev + " [serviceClass=" + ev.getServiceClass() + "]", "tool");
                }
            }
        };
    }

    public ToolDescriptor getToolDescriptor() {
        return this.m_descriptor;
    }

    protected void setToolDescriptor(ToolDescriptor descriptor) {
        ImageIcon icon;
        URL imageUrl;
        String smallIcon;
        String mnemonic;
        String actionCommand;
        if (Log.logging) {
            Log.write(500, "Setting ToolDescriptor: " + descriptor, "tool");
        }
        this.m_descriptor = descriptor;
        Properties props = this.m_descriptor.getProperties();
        if (this.m_descriptor.getDisplayName() != null) {
            this.putValue("Name", this.m_descriptor.getDisplayName());
        }
        if (this.m_descriptor.getShortDescription() != null) {
            this.putValue("ShortDescription", this.m_descriptor.getShortDescription());
        }
        if (this.m_descriptor.getLongDescription() != null) {
            this.putValue("LongDescription", this.m_descriptor.getLongDescription());
        }
        if ((actionCommand = props.getProperty("actionCommand")) != null) {
            this.putValue("ActionCommandKey", actionCommand);
        }
        if ((mnemonic = props.getProperty("mnemonic")) != null && !"".equals(mnemonic)) {
            this.putValue("MnemonicKey", new Integer(mnemonic.charAt(0)));
        }
        if ((smallIcon = props.getProperty("smallIcon")) != null && (imageUrl = this.getBeanContext().getResource(smallIcon, this)) != null && (icon = new ImageIcon(imageUrl)) != null) {
            this.putValue("SmallIcon", icon);
        }
    }

    public void init(ToolDescriptor toolDescriptor, ToolErrorHandler handler) throws UnavailableException, ToolException, InvalidDescriptorFormatException {
        this.setToolDescriptor(toolDescriptor);
        this.setErrorHandler(handler);
    }

    public void destroy() {
    }

    public Component getToolBarComponent() {
        return null;
    }

    public JMenuItem getMenuItem() {
        return null;
    }

    public Action getAction() {
        return this;
    }

    public ToolDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    public URL getHelp() {
        return null;
    }

    public ToolErrorHandler getErrorHandler() {
        return this.m_errorHandler;
    }

    public void setErrorHandler(ToolErrorHandler handler) {
        this.m_errorHandler = handler;
    }

    public boolean avoidingGui() {
        return this.m_avoidingGui;
    }

    public void okToUseGui() {
        this.m_avoidingGui = false;
    }

    public void dontUseGui() {
        this.m_avoidingGui = true;
    }

    public boolean needsGui() {
        return true;
    }

    public abstract void service() throws UnavailableException, ToolException;

    public void actionPerformed(ActionEvent ev) {
        block8: {
            try {
                this.service();
            }
            catch (UnavailableException e) {
                this.setEnabled(false);
                ToolErrorHandler handler = this.getErrorHandler();
                if (handler != null) {
                    Component parent = ev.getSource() instanceof Component ? (Component)ev.getSource() : null;
                    handler.handleErrors(parent, "Tool Unavailable", null, e, this, null, 0, 0);
                }
            }
            catch (ToolException e) {
                ToolErrorHandler handler = this.getErrorHandler();
                if (handler != null) {
                    Component parent = ev.getSource() instanceof Component ? (Component)ev.getSource() : null;
                    handler.handleErrors(parent, "Tool Error", null, e, this, null, 0, 0);
                }
            }
            catch (RuntimeException e) {
                ToolErrorHandler handler = this.getErrorHandler();
                if (handler != null) {
                    Component parent = ev.getSource() instanceof Component ? (Component)ev.getSource() : null;
                    handler.handleErrors(parent, "Unexpected Tool Error", null, e, this, null, 0, 0);
                }
            }
            catch (NoClassDefFoundError e) {
                this.setEnabled(false);
                ToolErrorHandler handler = this.getErrorHandler();
                if (handler == null) break block8;
                Component parent = ev.getSource() instanceof Component ? (Component)ev.getSource() : null;
                handler.handleErrors(parent, "Tool Configuration Error", null, e, this, null, 0, 0);
            }
        }
    }

    public void addPropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bccSupport.addPropertyChangeListener(name, pcl);
    }

    public void addVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bccSupport.addVetoableChangeListener(name, vcl);
    }

    public BeanContext getBeanContext() {
        return this.m_bccSupport.getBeanContext();
    }

    public void removePropertyChangeListener(String name, PropertyChangeListener pcl) {
        this.m_bccSupport.removePropertyChangeListener(name, pcl);
    }

    public void removeVetoableChangeListener(String name, VetoableChangeListener vcl) {
        this.m_bccSupport.removeVetoableChangeListener(name, vcl);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void setBeanContext(BeanContext bc) throws PropertyVetoException {
        BeanContextChildSupport beanContextChildSupport = this.m_bccSupport;
        synchronized (beanContextChildSupport) {
            if (this.getBeanContext() instanceof BeanContextServices) {
                ((BeanContextServices)this.getBeanContext()).removeBeanContextServicesListener(this);
            }
            this.m_bccSupport.setBeanContext(bc);
            if (bc instanceof BeanContextServices) {
                ((BeanContextServices)bc).addBeanContextServicesListener(this);
            }
        }
    }

    public void serviceAvailable(BeanContextServiceAvailableEvent ev) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void serviceRevoked(BeanContextServiceRevokedEvent ev) {
        BeanContextChildSupport beanContextChildSupport = this.m_bccSupport;
        synchronized (beanContextChildSupport) {
            this.m_services.remove(ev.getServiceClass());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(Class serviceIdentifier, Object selector) {
        Object ret;
        BeanContextChildSupport beanContextChildSupport = this.m_bccSupport;
        synchronized (beanContextChildSupport) {
            HashMap<Object, Object> cachedServices = (HashMap<Object, Object>)this.m_services.get(serviceIdentifier);
            Object cachedService = cachedServices != null ? (Object)cachedServices.get(selector) : null;
            if (cachedService == null) {
                if (this.getBeanContext() != null && this.getBeanContext() instanceof BeanContextServices) {
                    BeanContextServices bcs = (BeanContextServices)this.getBeanContext();
                    try {
                        ret = bcs.getService(this, this, serviceIdentifier, selector, this);
                        if (cachedServices == null) {
                            cachedServices = new HashMap<Object, Object>();
                            this.m_services.put(serviceIdentifier, cachedServices);
                        }
                        cachedServices.put(selector, ret);
                    }
                    catch (TooManyListenersException e) {
                        throw new RuntimeException("Error while fetching service from context: Tool seems already to be registered as having obtained a reference to the service.");
                    }
                } else {
                    ret = null;
                }
            } else {
                ret = cachedService;
            }
        }
        return ret;
    }

    public void releaseService(Object service) {
        if (service != null && this.getBeanContext() != null && this.getBeanContext() instanceof BeanContextServices) {
            BeanContextServices bcs = (BeanContextServices)this.getBeanContext();
            bcs.releaseService(this, this, service);
        }
    }
}

