/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.toolext;

import com.starbase.starteam.Item;
import com.starbase.starteam.Items;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Project;
import com.starbase.starteam.Task;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.standard.ManuallyRefreshable;
import com.starbase.starteam.starflow.ItemWrapper;
import com.starbase.starteam.starflow.TaskWrapper;
import com.starbase.starteam.starflow.Workflow;
import com.starbase.starteam.starflow.locator.Locator;
import com.starbase.starteam.starflow.toolext.ItemWrappers;
import com.starbase.starteam.starflow.toolext.WorkflowContext;
import java.io.IOException;
import java.util.Hashtable;
import java.util.WeakHashMap;

public class DefaultWorkflowContext
implements WorkflowContext {
    protected static final Object NO_WORKFLOW = new Object();
    protected final Hashtable m_workflowStatusPropertyNames = new Hashtable();
    protected final WeakHashMap m_lastFetch = new WeakHashMap();

    public DefaultWorkflowContext() {
        this.m_workflowStatusPropertyNames.put("File", "Usr_StarFlowStatus");
        this.m_workflowStatusPropertyNames.put("ChangeRequest", "Usr_StarFlowStatus");
        this.m_workflowStatusPropertyNames.put("Requirement", "Status");
        this.m_workflowStatusPropertyNames.put("Task", "Status");
    }

    public boolean isWorkflowEnforced(Item item) throws IOException {
        boolean useAlternateEditor;
        block7: {
            useAlternateEditor = false;
            try {
                String typeName = item.getType().getName();
                Project project = item.getView().getProject();
                if ("ChangeRequest".equals(typeName)) {
                    useAlternateEditor = project.getInt("DisplayAltCREditor") == 1;
                    break block7;
                }
                if ("Requirement".equals(typeName) || "CStRequirement".equals(typeName)) {
                    useAlternateEditor = project.getInt("DisplayAltReqEditor") == 1;
                    break block7;
                }
                if ("Task".equals(typeName)) {
                    useAlternateEditor = project.getInt("DisplayAltTaskEditor") == 1;
                    break block7;
                }
                if ("Topic".equals(typeName)) {
                    useAlternateEditor = project.getInt("DisplayAltTopicEditor") == 1;
                    break block7;
                }
                if ("File".equals(typeName)) {
                    useAlternateEditor = project.getInt("DisplayAltFileEditor") == 1;
                    break block7;
                }
                useAlternateEditor = false;
            }
            catch (NoSuchPropertyException e) {
                useAlternateEditor = false;
            }
        }
        return useAlternateEditor;
    }

    public Workflow getWorkflow(Item item) throws IOException, MisconfigurationException {
        Workflow workflow;
        Object cached = this.m_lastFetch.get(item.getView());
        if (cached == null) {
            String viewName;
            String projectName;
            Locator locator = new Locator(item.getServer());
            ResourceLocator resourceLocator = locator.getViewShadowingCachingLocator(projectName = item.getView().getProject().getName(), viewName = item.getView().getName(), false);
            if (resourceLocator instanceof ManuallyRefreshable) {
                ((ManuallyRefreshable)((Object)resourceLocator)).triggerRefresh(30000L);
            }
            if ((workflow = locator.getWorkflow(projectName, viewName, item.getType().getName())) == null) {
                this.m_lastFetch.put(item.getView(), NO_WORKFLOW);
            } else {
                this.m_lastFetch.put(item.getView(), workflow);
            }
        } else {
            workflow = NO_WORKFLOW.equals(cached) ? null : (Workflow)cached;
        }
        return workflow;
    }

    public ItemWrapper wrap(Item item) throws IOException, MisconfigurationException {
        Workflow workflow = this.getWorkflow(item);
        String workflowStatusPropertyName = this.getWorkflowStatusPropertyName(workflow, item);
        if (workflow != null && workflowStatusPropertyName == null) {
            throw new MisconfigurationException("WorkflowContext not properly configured to support workflow for" + item.getType() + ".");
        }
        return this.createItemWrapper(item, workflow, workflowStatusPropertyName);
    }

    public ItemWrappers wrap(Items items) throws IOException, MisconfigurationException {
        ItemWrapper[] wrappers;
        if (items.size() > 0) {
            Item sample = items.getAt(0);
            Workflow workflow = this.getWorkflow(sample);
            String workflowStatusPropertyName = this.getWorkflowStatusPropertyName(workflow, sample);
            if (workflow != null && workflowStatusPropertyName == null) {
                throw new MisconfigurationException("WorkflowContext not properly configured to support workflow for" + sample.getType() + ".");
            }
            wrappers = new ItemWrapper[items.size()];
            int i = 0;
            while (i < wrappers.length) {
                wrappers[i] = this.createItemWrapper(items.getAt(i), workflow, workflowStatusPropertyName);
                ++i;
            }
        } else {
            wrappers = new ItemWrapper[]{};
        }
        return new ItemWrappers(){

            public int size() {
                return wrappers.length;
            }

            public ItemWrapper getAt(int index) {
                return wrappers[index];
            }
        };
    }

    public void discardWorkflow(Item item) {
        this.m_lastFetch.remove(item.getView());
    }

    protected String getWorkflowStatusPropertyName(Workflow workflow, Item item) {
        String workflowStatusPropertyName = workflow != null && workflow.getWorkflowStatusPropertyName() != null ? workflow.getWorkflowStatusPropertyName() : (workflow != null ? (String)this.m_workflowStatusPropertyNames.get(item.getType().getName()) : null);
        return workflowStatusPropertyName;
    }

    protected ItemWrapper createItemWrapper(Item item, Workflow workflow, String workflowStatusPropertyName) {
        ItemWrapper wrapper = item instanceof Task ? new TaskWrapper((Task)item, workflow, workflowStatusPropertyName) : new ItemWrapper(item, workflow, workflowStatusPropertyName);
        return wrapper;
    }
}

