/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.locator;

import com.starbase.starteam.Folder;
import com.starbase.starteam.Item;
import com.starbase.starteam.NoSuchPropertyException;
import com.starbase.starteam.Project;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.starflow.locator.Locator;
import java.awt.Window;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.StringTokenizer;

public class PropertyEditorUtils {
    public static String getEditorKey(String typeName, Project project) {
        String key = null;
        boolean useAlternateEditor = false;
        try {
            if ("ChangeRequest".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltCREditor") == 1;
                key = project.getString("AltCREditorPath");
            } else if ("Requirement".equals(typeName) || "CStRequirement".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltReqEditor") == 1;
                key = project.getString("AltReqEditorPath");
            } else if ("Task".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltTaskEditor") == 1;
                key = project.getString("AltTaskEditorPath");
            } else if ("Topic".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltTopicEditor") == 1;
                key = project.getString("AltTopicEditorPath");
            } else if ("File".equals(typeName)) {
                useAlternateEditor = project.getInt("DisplayAltFileEditor") == 1;
                key = project.getString("AltFileEditorPath");
            } else {
                useAlternateEditor = false;
            }
        }
        catch (NoSuchPropertyException e) {
            useAlternateEditor = false;
        }
        if (key != null) {
            StringTokenizer tok = new StringTokenizer(key);
            if (tok.hasMoreElements()) {
                tok.nextElement();
            }
            key = tok.hasMoreElements() ? tok.nextToken() : null;
        }
        return useAlternateEditor ? key : null;
    }

    public static void edit(Window frameOrDialog, String whichEditor, Item[] items, int currentItemIndex, boolean readOnly, boolean requireModal) throws IOException, MisconfigurationException {
        if (items == null || items.length == 0) {
            throw new IllegalArgumentException("PropertyEditorUtils.edit() takes a non-null, non-empty array of Items.");
        }
        if ((whichEditor == null || "".equals(whichEditor)) && (whichEditor = PropertyEditorUtils.getEditorKey(items[0].getType().getName(), items[0].getView().getProject())) == null) {
            IllegalStateException ise = new IllegalStateException("No Alternate Property Editor has been defined for use with " + items[0].getType().getName() + " Items in " + items[0].getView().getProject().getName() + ".");
            throw new MisconfigurationException(ise);
        }
        Locator l = new Locator(items[0].getServer());
        String platform = System.getProperty("os.name");
        try {
            System.out.println(items.length);
            l.launchPropertyEditor(frameOrDialog, whichEditor, platform, items, 0, readOnly);
        }
        catch (ClassNotFoundException e) {
            throw new MisconfigurationException(e);
        }
        catch (IllegalAccessException e) {
            throw new MisconfigurationException(e);
        }
        catch (InvocationTargetException e) {
            throw new MisconfigurationException(e);
        }
        catch (NoSuchMethodException e) {
            throw new MisconfigurationException(e);
        }
    }

    public static Item add(Window frameOrDialog, String whichEditor, String itemType, Folder parentFolder, boolean requireModal) throws IOException, MisconfigurationException {
        if (itemType == null || "".equals(itemType)) {
            throw new IllegalArgumentException("PropertyEditorUtils.add() takes a non-null, non-empty Item type name.");
        }
        if (parentFolder == null) {
            throw new IllegalArgumentException("PropertyEditorUtils.add() takes a non-null parent Folder.");
        }
        Item ret = Item.createItem((String)itemType, (Folder)parentFolder);
        PropertyEditorUtils.edit(frameOrDialog, whichEditor, new Item[]{ret}, 0, false, requireModal);
        return ret;
    }
}

