/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.locator;

import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PropertyEditorDescriptor {
    protected final JavaInvocationTarget m_javaInvocationTarget;
    protected final ExternalInvocationTarget[] m_externalInvocationTargets;
    protected String m_defaultPlatform;

    public PropertyEditorDescriptor(JavaInvocationTarget java, ExternalInvocationTarget[] externals) {
        this.m_javaInvocationTarget = java;
        this.m_externalInvocationTargets = externals;
    }

    public JavaInvocationTarget getJavaInvocationTarget() {
        return this.m_javaInvocationTarget;
    }

    public ExternalInvocationTarget getExternalInvocationTarget(String platform) {
        platform = platform == null || "".equals(platform.trim()) ? "*" : platform.trim();
        ExternalInvocationTarget ret = null;
        if (this.m_externalInvocationTargets != null && this.m_externalInvocationTargets.length > 0) {
            int i = 0;
            while (i < this.m_externalInvocationTargets.length) {
                String[] platforms = this.m_externalInvocationTargets[i].getPlatforms();
                int k = 0;
                while (k < platforms.length) {
                    if ("*".equals(platform) || "*".equals(platforms[k]) || platform.toUpperCase().indexOf(platforms[k].toUpperCase()) != -1) {
                        ret = this.m_externalInvocationTargets[i];
                        break;
                    }
                    ++k;
                }
                if (ret != null) break;
                ++i;
            }
        }
        return ret;
    }

    public String toString() {
        StringBuffer buff = new StringBuffer();
        String eol = System.getProperty("line.separator");
        buff.append("Java target:" + eol);
        buff.append("------------" + eol);
        buff.append(this.m_javaInvocationTarget + eol);
        buff.append(eol);
        buff.append("Default external platform: " + this.m_defaultPlatform + eol);
        buff.append("External targets:" + eol);
        buff.append("-----------------" + eol);
        if (this.m_externalInvocationTargets != null) {
            int i = 0;
            while (i < this.m_externalInvocationTargets.length) {
                buff.append(this.m_externalInvocationTargets[i] + eol);
                if (i < this.m_externalInvocationTargets.length - 1) {
                    buff.append("----" + eol);
                }
                ++i;
            }
        }
        return buff.toString();
    }

    public static PropertyEditorDescriptor load(InputStream input) throws IOException {
        Object[] externalTargets;
        JavaInvocationTarget javaTarget;
        Document doc;
        try {
            DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
            DocumentBuilder parser = fact.newDocumentBuilder();
            doc = parser.parse(new InputSource(input));
        }
        catch (ParserConfigurationException e) {
            throw new IOException("Unable to configure parser to parse property editor descriptor: " + e.toString());
        }
        catch (SAXException e) {
            throw new IOException("Failed to parse property editor descriptor: " + e.toString());
        }
        Node javaNode = PropertyEditorDescriptor.findChild(doc.getDocumentElement(), "javaclass");
        if (javaNode != null) {
            String className = ((Element)javaNode).getAttribute("name");
            String methodName = ((Element)javaNode).getAttribute("method");
            Node[] jarNodes = PropertyEditorDescriptor.findChildren(javaNode, "jar");
            String[] jars = new String[jarNodes.length];
            int i = 0;
            while (i < jarNodes.length) {
                jars[i] = ((Element)jarNodes[i]).getAttribute("name");
                ++i;
            }
            javaTarget = new JavaInvocationTarget(className, methodName, jars);
        } else {
            javaTarget = null;
        }
        Node externalNode = PropertyEditorDescriptor.findChild(doc.getDocumentElement(), "external");
        if (externalNode != null) {
            Vector<ExternalInvocationTarget> v = new Vector<ExternalInvocationTarget>();
            Node[] commandNodes = PropertyEditorDescriptor.findChildren(externalNode, "command");
            int i = 0;
            while (i < commandNodes.length) {
                String platformAttr = ((Element)commandNodes[i]).getAttribute("platform");
                String[] platforms = PropertyEditorDescriptor.split(platformAttr, ",");
                String command = ((Element)commandNodes[i]).getAttribute("call");
                Node[] argumentNodes = PropertyEditorDescriptor.findChildren(commandNodes[i], "arg");
                String[] arguments = new String[argumentNodes.length];
                int k = 0;
                while (k < argumentNodes.length) {
                    arguments[k] = ((Element)argumentNodes[k]).getFirstChild().getNodeValue().trim();
                    ++k;
                }
                v.addElement(new ExternalInvocationTarget(platforms, command, arguments));
                ++i;
            }
            externalTargets = new ExternalInvocationTarget[v.size()];
            v.copyInto(externalTargets);
        } else {
            externalTargets = null;
        }
        return new PropertyEditorDescriptor(javaTarget, (ExternalInvocationTarget[])externalTargets);
    }

    protected static Node findChild(Node parent, String childTagName) {
        Node[] children = PropertyEditorDescriptor.findChildren(parent, childTagName);
        return children.length > 0 ? children[0] : null;
    }

    protected static Node[] findChildren(Node parent, String childTagName) {
        Vector<Node> v = new Vector<Node>();
        NodeList children = parent.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            if (children.item(i).getNodeName().equals(childTagName)) {
                v.addElement(children.item(i));
            }
            ++i;
        }
        Object[] ret = new Node[v.size()];
        v.copyInto(ret);
        return ret;
    }

    protected static String[] split(String s, String delim) {
        Vector<String> v = new Vector<String>();
        int index = s.indexOf(delim);
        while (index != -1) {
            v.addElement(s.substring(0, index).trim());
            s = s.substring(index + delim.length()).trim();
            index = s.indexOf(delim);
        }
        if (!"".equals(s)) {
            v.addElement(s);
        }
        Object[] ret = new String[v.size()];
        v.copyInto(ret);
        return ret;
    }

    public static class ExternalInvocationTarget {
        protected final String[] m_platforms;
        protected final String m_command;
        protected final String[] m_arguments;

        public ExternalInvocationTarget(String[] platforms, String command, String[] arguments) {
            this.m_platforms = platforms;
            this.m_command = command;
            this.m_arguments = arguments;
        }

        public String[] getPlatforms() {
            return this.m_platforms;
        }

        public String getCommand() {
            return this.m_command;
        }

        public String[] getArgs() {
            return this.m_arguments;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Platforms: ");
            int i = 0;
            while (i < this.m_platforms.length) {
                buff.append(this.m_platforms[i]);
                if (i < this.m_platforms.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
            buff.append(eol);
            buff.append("Command: " + this.m_command);
            buff.append("Arguments: ");
            int i2 = 0;
            while (i2 < this.m_arguments.length) {
                buff.append(this.m_arguments[i2]);
                if (i2 < this.m_arguments.length - 1) {
                    buff.append(", ");
                }
                ++i2;
            }
            buff.append("eol");
            return buff.toString();
        }
    }

    public static class JavaInvocationTarget {
        protected final String m_className;
        protected final String m_methodName;
        protected final String[] m_jars;

        public JavaInvocationTarget(String className, String methodName, String[] jars) {
            this.m_className = className;
            this.m_methodName = methodName != null && !"".equals(methodName.trim()) ? methodName : "main";
            this.m_jars = jars;
        }

        public String getClassName() {
            return this.m_className;
        }

        public String getMethodName() {
            return this.m_methodName;
        }

        public String[] getJarNames() {
            return this.m_jars;
        }

        public String toString() {
            StringBuffer buff = new StringBuffer();
            String eol = System.getProperty("line.separator");
            buff.append("Class: " + this.m_className + eol);
            buff.append("Method: " + this.m_methodName + eol);
            buff.append("Jars: ");
            int i = 0;
            while (i < this.m_jars.length) {
                buff.append(this.m_jars[i]);
                if (i < this.m_jars.length - 1) {
                    buff.append(", ");
                }
                ++i;
            }
            buff.append(eol);
            return buff.toString();
        }
    }
}

