/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.locator;

import com.starbase.starteam.File;
import com.starbase.starteam.Item;
import com.starbase.starteam.Project;
import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamFinder;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.View;
import com.starbase.starteam.deployer.ClassLoaderFactory;
import com.starbase.starteam.deployer.DeployerBootstrap;
import com.starbase.starteam.deployer.MisconfigurationException;
import com.starbase.starteam.deployer.Resource;
import com.starbase.starteam.deployer.ResourceLocator;
import com.starbase.starteam.deployer.StarTeamURLString;
import com.starbase.starteam.deployer.standard.DefaultClassLoaderFactory;
import com.starbase.starteam.deployer.standard.ManuallyRefreshable;
import com.starbase.starteam.starflow.PropertyEditorCommand;
import com.starbase.starteam.starflow.Workflow;
import com.starbase.starteam.starflow.formserver.FormServer;
import com.starbase.starteam.starflow.locator.LocatorKernel;
import com.starbase.starteam.starflow.locator.PropertyEditorDescriptor;
import com.starbase.util.Platform;
import com.starbase.util.UTF8;
import com.starbase.util.errorhandling.NestedException;
import java.awt.Window;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.JDialog;
import javax.swing.JFrame;

public class Locator
extends LocatorKernel {
    protected static HashMap m_serverCache = new HashMap();
    protected final Server m_server;
    protected static final ClassLoaderFactory m_classLoaderFactory = new DefaultClassLoaderFactory();
    static /* synthetic */ Class class$com$starbase$starteam$Server;
    static /* synthetic */ Class array$Ljava$lang$String;
    static /* synthetic */ Class class$java$awt$Window;
    static /* synthetic */ Class array$Lcom$starbase$starteam$Item;
    static /* synthetic */ Class class$com$starbase$starteam$starflow$PropertyEditorCommand;

    public Locator(Server server) {
        super(server);
        this.m_server = server;
    }

    public Server getServer() {
        return this.m_server;
    }

    public Workflow getWorkflow(String projectName, String viewName, String typeName) throws IOException {
        InputStream workflow = this.getResourceAsStream(projectName, viewName, typeName + ".Workflow.xml", false);
        InputStream groups = this.getResourceAsStream(projectName, viewName, "groups.xml", false);
        if (workflow == null) {
            throw new RuntimeException("Error locating workflow for " + typeName + " on this server.  This most likely indicates that the server was not properly configured to use Alternate Property Editors for " + typeName + " type items.");
        }
        Workflow ret = Workflow.createWorkflow(workflow, groups);
        return ret;
    }

    public java.io.File getResource(String projectName, String viewName, String resourceName, boolean caseSensitiveFileNames) throws IOException {
        return super.getResource(projectName, viewName, resourceName, caseSensitiveFileNames);
    }

    public InputStream getResourceAsStream(String projectName, String viewName, String resourceName, boolean caseSensitiveFileNames) throws IOException {
        return super.getResourceAsStream(projectName, viewName, resourceName, caseSensitiveFileNames);
    }

    public File locateResourceInStarTeam(String projectName, String viewName, String resourceName, boolean caseSensitiveSearch) throws IOException {
        return super.locateResourceInStarTeam(projectName, viewName, resourceName, caseSensitiveSearch);
    }

    public void launchPropertyEditor(String apeName, String platform, PropertyEditorCommand cmd) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        InputStream descriptorStream;
        ResourceLocator rl = this.getResourceLocator(cmd.getProject(), cmd.getView(), false);
        if (rl instanceof ManuallyRefreshable) {
            ((ManuallyRefreshable)((Object)rl)).triggerRefresh(0L);
        }
        if ((descriptorStream = this.getResourceAsStream(cmd.getProject(), cmd.getView(), apeName + ".propertyeditor.xml", false)) == null) {
            throw new RuntimeException("No launch descriptor found for " + apeName + " property editor.  This most likely indicates that the server was not properly configured to use Alternate Property Editors for " + apeName + " type items.");
        }
        PropertyEditorDescriptor descriptor = PropertyEditorDescriptor.load(descriptorStream);
        PropertyEditorDescriptor.ExternalInvocationTarget external = descriptor.getExternalInvocationTarget(platform);
        PropertyEditorDescriptor.JavaInvocationTarget java = descriptor.getJavaInvocationTarget();
        if (external != null) {
            this.launchExternal(external, cmd);
        } else if (java != null) {
            this.launchJava(java, cmd);
        }
    }

    public void launchPropertyEditor(String typeName, String platform, Item[] items, int firstItemIndex, boolean isHistoryItem) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        this.launchPropertyEditor(null, typeName, platform, items, firstItemIndex, isHistoryItem);
    }

    public void launchPropertyEditor(Window window, String typeName, String platform, Item[] items, int firstItemIndex, boolean isHistoryItem) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        InputStream descriptorStream;
        String viewName;
        Item sample;
        String projectName;
        ResourceLocator rl;
        if (!(window instanceof JDialog) && !(window instanceof JFrame)) {
            window = null;
        }
        if ((rl = this.getResourceLocator(projectName = (sample = items[0]).getView().getProject().getName(), viewName = sample.getView().getName(), false)) instanceof ManuallyRefreshable) {
            ((ManuallyRefreshable)((Object)rl)).triggerRefresh(0L);
        }
        if ((descriptorStream = this.getResourceAsStream(projectName, viewName, typeName + ".propertyeditor.xml", false)) == null) {
            throw new RuntimeException("No launch descriptor found for " + typeName + " property editor.  This most likely indicates that the server was not properly configured to use Alternate Property Editors for " + typeName + " type items.");
        }
        PropertyEditorDescriptor descriptor = PropertyEditorDescriptor.load(descriptorStream);
        PropertyEditorDescriptor.ExternalInvocationTarget external = descriptor.getExternalInvocationTarget(platform);
        PropertyEditorDescriptor.JavaInvocationTarget java = descriptor.getJavaInvocationTarget();
        if (external != null) {
            throw new RuntimeException("Out-of-process editors are not currently supported by this client configuration.");
        }
        if (java != null) {
            this.launchJava(window, java, items, firstItemIndex, isHistoryItem);
        }
    }

    protected void launchExternal(PropertyEditorDescriptor.ExternalInvocationTarget target, PropertyEditorCommand cmd) throws IOException {
        Process p;
        String[] cmdArray = new String[1 + target.getArgs().length + 1 + cmd.getArgs().length];
        cmdArray[0] = target.getCommand();
        System.arraycopy(target.getArgs(), 0, cmdArray, 1, target.getArgs().length);
        cmdArray[1 + target.getArgs().length] = cmd.getCommand();
        System.arraycopy(cmd.getArgs(), 0, cmdArray, 1 + target.getArgs().length + 1, cmd.getArgs().length);
        int i = 0;
        while (i < cmdArray.length) {
            String s = cmdArray[i];
            String expanded = "";
            int point = s.toLowerCase().indexOf("${resource:");
            while (point != -1) {
                expanded = expanded + s.substring(0, point);
                int index = (s = s.substring(point + "${resource:".length())).indexOf("}");
                if (index == -1) {
                    throw new RuntimeException("Unmatched braces in ${resource:..} expression in the launch descriptor (.propertyeditor.xml).");
                }
                String resource = s.substring(0, index);
                java.io.File cacheFile = this.getResource(cmd.getProject(), cmd.getView(), resource, Platform.caseSensitiveFileNames());
                if (cacheFile == null) {
                    throw new RuntimeException("Resource not found: " + resource);
                }
                expanded = expanded + cacheFile.getAbsolutePath();
                s = s.substring(index + 1);
                point = s.indexOf("${resource:");
            }
            cmdArray[i] = expanded = expanded + s;
            ++i;
        }
        try {
            p = Runtime.getRuntime().exec(cmdArray);
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        try {
            p.waitFor();
            System.out.println("Done with process");
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (p != null) {
            int c = p.getInputStream().read();
            while (c != -1) {
                System.out.print((char)c);
                c = p.getInputStream().read();
            }
        }
        if (p != null) {
            int c = p.getErrorStream().read();
            while (c != -1) {
                System.out.print((char)c);
                c = p.getErrorStream().read();
            }
        }
    }

    protected ClassLoader findClassLoader(String[] jarNames, String projectName, String viewName) throws IOException {
        ClassLoader loader;
        ResourceLocator locator = this.getResourceLocator(projectName, viewName, Platform.caseSensitiveFileNames());
        Resource[] classpath = new Resource[jarNames.length];
        int i = 0;
        while (i < classpath.length) {
            classpath[i] = locator.getResource(jarNames[i]);
            if (classpath[i] == null) {
                String strError = "Can't find resource \"" + jarNames[i] + "\"";
                if (projectName != null && projectName.length() != 0) {
                    strError = strError + " for project \"" + projectName + "\"";
                }
                if (viewName != null && viewName.length() != 0) {
                    strError = strError + ", view \"" + viewName + "\"";
                }
                strError = strError + ".";
                throw new RuntimeException(strError);
            }
            ++i;
        }
        try {
            loader = m_classLoaderFactory.getClassLoader((class$com$starbase$starteam$Server == null ? (class$com$starbase$starteam$Server = Locator.class$("com.starbase.starteam.Server")) : class$com$starbase$starteam$Server).getClassLoader(), classpath, locator, 1, 2);
            System.out.println("Created new loader");
        }
        catch (MisconfigurationException e) {
            throw new NestedException(e);
        }
        return loader;
    }

    protected void launchJava(PropertyEditorDescriptor.JavaInvocationTarget target, PropertyEditorCommand cmd) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        ClassLoader loader = this.findClassLoader(target.getJarNames(), cmd.getProject(), cmd.getView());
        Class<?> c = loader.loadClass(target.getClassName());
        Method m = c.getMethod(target.getMethodName(), array$Ljava$lang$String == null ? (array$Ljava$lang$String = Locator.class$("[Ljava.lang.String;")) : array$Ljava$lang$String);
        String[] tmp = new String[cmd.getArgs().length + 1];
        tmp[0] = cmd.getCommand();
        int i = 0;
        while (i < cmd.getArgs().length) {
            tmp[i + 1] = cmd.getArgs()[i];
            ++i;
        }
        m.invoke(null, new Object[]{tmp});
    }

    public void launchJava(Window window, PropertyEditorDescriptor.JavaInvocationTarget target, Item[] items, int firstItemIndex, boolean isHistoryItem) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Item sample = items[0];
        ClassLoader loader = this.findClassLoader(target.getJarNames(), sample.getView().getProject().getName(), sample.getView().getName());
        Class<?> c = loader.loadClass(target.getClassName());
        try {
            Method m = c.getMethod(target.getMethodName(), class$java$awt$Window == null ? (class$java$awt$Window = Locator.class$("java.awt.Window")) : class$java$awt$Window, array$Lcom$starbase$starteam$Item == null ? (array$Lcom$starbase$starteam$Item = Locator.class$("[Lcom.starbase.starteam.Item;")) : array$Lcom$starbase$starteam$Item, Integer.TYPE, Boolean.TYPE);
            m.invoke(null, window, items, new Integer(firstItemIndex), new Boolean(isHistoryItem));
        }
        catch (NoSuchMethodException e) {
            Method m = c.getMethod(target.getMethodName(), array$Lcom$starbase$starteam$Item == null ? (array$Lcom$starbase$starteam$Item = Locator.class$("[Lcom.starbase.starteam.Item;")) : array$Lcom$starbase$starteam$Item, Integer.TYPE, Boolean.TYPE);
            m.invoke(null, items, new Integer(firstItemIndex), new Boolean(isHistoryItem));
        }
    }

    public void run(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        FormServer server = new FormServer();
        server.run(args);
    }

    public void run(Server server, String[] args) {
        String command = args[1];
        String[] remainingArgs = new String[args.length - 2];
        int i = 0;
        while (i < remainingArgs.length) {
            remainingArgs[i] = args[i + 2];
            ++i;
        }
        PropertyEditorCommand cmd = new PropertyEditorCommand(command, remainingArgs);
        m_serverCache.put(Locator.makeServerCacheKey(cmd), server);
        FormServer formServer = new FormServer();
        formServer.run(args);
    }

    public void runNoSpawn(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        if (args.length < 3) {
            throw new RuntimeException("Not enough args passed to Locator.run(String[]).");
        }
        String type = args[0];
        String command = args[1];
        String platform = System.getProperty("os.name");
        String[] followingArgs = new String[args.length - 2];
        if (args.length > 2) {
            System.arraycopy(args, 2, followingArgs, 0, followingArgs.length);
        }
        PropertyEditorCommand cmd = new PropertyEditorCommand(command, followingArgs);
        this.launchPropertyEditor(type, platform, cmd);
    }

    public static void main(String[] args) throws IOException, ClassNotFoundException, NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        String password;
        StarTeamURL url = null;
        String encpasswd = null;
        int i = 0;
        while (i < args.length) {
            if ("-p".equals(args[i]) && i < args.length - 1) {
                url = new StarTeamURL(args[i + 1]);
            }
            if ("-encryptedpassword".equals(args[i]) && i < args.length - 1) {
                encpasswd = args[i + 1];
            }
            ++i;
        }
        if (url == null) {
            throw new RuntimeException("No server specified in command line.  Locator cannot create a server connection.");
        }
        if (encpasswd != null) {
            byte[] passwordBytes = new byte[encpasswd.length() / 2];
            int i2 = 0;
            while (i2 < passwordBytes.length) {
                passwordBytes[i2] = (byte)(Integer.parseInt(encpasswd.substring(i2 * 2, i2 * 2 + 2), 16) ^ passwordBytes.length);
                ++i2;
            }
            password = UTF8.Utf8ToString((byte[])passwordBytes);
        } else {
            password = url.getPassword() == null ? "" : url.getPassword();
        }
        Server s = new Server(url.getHostName(), Integer.parseInt(url.getPort()));
        s.logOn(url.getUserName(), password);
        Locator locator = new Locator(s);
        locator.run(args);
    }

    protected static String makeServerCacheKey(PropertyEditorCommand cmd) {
        return cmd.getUser() + ":" + cmd.getPassword() + "@" + cmd.getURL().getHostName() + ":" + cmd.getURL().getPort();
    }

    public static View findMaybeOpenView(PropertyEditorCommand cmd) {
        View v;
        Project p;
        String key = Locator.makeServerCacheKey(cmd);
        Server server = (Server)m_serverCache.get(key);
        if (server == null || !server.ping()) {
            if (server != null) {
                server.disconnect();
            }
            Class c = class$com$starbase$starteam$starflow$PropertyEditorCommand == null ? (class$com$starbase$starteam$starflow$PropertyEditorCommand = Locator.class$("com.starbase.starteam.starflow.PropertyEditorCommand")) : class$com$starbase$starteam$starflow$PropertyEditorCommand;
            Method m = null;
            try {
                m = c.getMethod("openServer", c);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
            if (m != null) {
                try {
                    server = (Server)m.invoke(null, cmd);
                }
                catch (IllegalArgumentException e) {
                    server = null;
                }
                catch (IllegalAccessException e) {
                    server = null;
                }
                catch (InvocationTargetException e) {
                    if (e.getTargetException() instanceof RuntimeException) {
                        throw (RuntimeException)e.getTargetException();
                    }
                    throw new RuntimeException(e.getTargetException().toString());
                }
            }
            if (server == null) {
                server = StarTeamFinder.openServer((String)key);
            }
            m_serverCache.put(key, server);
        }
        View ret = (p = Locator.openProject(server, cmd.getProject())) != null ? ((v = Locator.openView(p, cmd.getView())) != null ? (cmd.isViewConfigurationSpecified() ? cmd.openViewWithConfiguration(v) : v) : null) : null;
        return ret;
    }

    protected static Project openProject(Server s, String projectName) {
        StarTeamURLString url = new StarTeamURLString(s, DeployerBootstrap.getLogOnName(s), null);
        try {
            url = new StarTeamURLString(url.getServerURLString() + projectName + "/");
        }
        catch (MalformedURLException e) {
            throw new NestedException(e);
        }
        DeployerBootstrap bootstrap = null;
        try {
            bootstrap = DeployerBootstrap.getOrCreateAndCacheBootstrap(s, null, false);
        }
        catch (MisconfigurationException e) {
            throw new NestedException(e);
        }
        try {
            bootstrap.getResourceCache().put(s);
        }
        catch (MalformedURLException e) {
            throw new NestedException(e);
        }
        catch (IOException e) {
            throw new NestedException(e);
        }
        Project p = bootstrap.getResourceCache().getProject(url, true);
        return p;
    }

    protected static View openView(Project p, String viewName) {
        View result;
        if (viewName != null) {
            StarTeamURLString url = new StarTeamURLString(p.getServer(), DeployerBootstrap.getLogOnName(p.getServer()), null);
            try {
                url = new StarTeamURLString(url.getServerURLString() + p.getName() + "/" + viewName + "/");
            }
            catch (MalformedURLException e) {
                throw new NestedException(e);
            }
            DeployerBootstrap bootstrap = null;
            try {
                bootstrap = DeployerBootstrap.getOrCreateAndCacheBootstrap(p.getServer(), null, false);
            }
            catch (MisconfigurationException e) {
                throw new NestedException(e);
            }
            try {
                bootstrap.getResourceCache().put(p.getServer());
            }
            catch (MalformedURLException e) {
                throw new NestedException(e);
            }
            catch (IOException e) {
                throw new NestedException(e);
            }
            result = bootstrap.getResourceCache().getView(url, true);
        } else {
            result = p.getDefaultView();
        }
        return result;
    }

    public static Map getServerCache() {
        return m_serverCache;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

