/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.formserver;

import com.starbase.starteam.Server;
import com.starbase.starteam.StarTeamURL;
import com.starbase.starteam.View;
import com.starbase.starteam.starflow.PropertyEditorCommand;
import com.starbase.starteam.starflow.formserver.CAT;
import com.starbase.starteam.starflow.formserver.DataInputStream;
import com.starbase.starteam.starflow.formserver.DataOutputStream;
import com.starbase.starteam.starflow.formserver.DesktopIndicator;
import com.starbase.starteam.starflow.formserver.DesktopIndicatorListener;
import com.starbase.starteam.starflow.locator.Locator;
import com.starbase.util.UTF8;
import com.starbase.util.errorhandling.GraphicalErrorHandler;
import java.awt.Toolkit;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.util.Iterator;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;

public class FormServer
implements DesktopIndicatorListener {
    protected final GraphicalErrorHandler m_errorHandler = new GraphicalErrorHandler();
    protected DesktopIndicator m_indicator;
    public static int MAGIC_COOKIE_LENGTH;
    protected File m_lockFile = null;
    protected boolean m_deleteLock = false;
    protected final String LOCALHOST = "127.0.0.1";
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$com$starbase$starteam$starflow$formserver$FormServer;

    public String getMagicCookie() {
        return "StarTeam Elite Form Server 1.0";
    }

    public File getApplicationDir() {
        return new File(System.getProperty("user.dir") + System.getProperty("file.separator"));
    }

    protected Locator createLocator(String[] args) {
        String command = args[1];
        String[] remainingArgs = new String[args.length - 2];
        int i = 0;
        while (i < remainingArgs.length) {
            remainingArgs[i] = args[i + 2];
            ++i;
        }
        PropertyEditorCommand cmd = new PropertyEditorCommand(command, remainingArgs);
        View view = Locator.findMaybeOpenView(cmd);
        if (view == null) {
            throw new RuntimeException("No server specified in command line.  Form Server cannot create Locator.");
        }
        return new Locator(view.getServer());
    }

    protected Locator OLDcreateLocator(String[] args) {
        String password;
        StarTeamURL url = null;
        String encpasswd = null;
        int i = 0;
        while (i < args.length) {
            if ("-p".equals(args[i]) && i < args.length - 1) {
                url = new StarTeamURL(args[i + 1]);
            }
            if ("-encryptedpassword".equals(args[i]) && i < args.length - 1) {
                encpasswd = args[i + 1];
            }
            ++i;
        }
        if (url == null) {
            throw new RuntimeException("No server specified in command line.  Form Server cannot create Locator.");
        }
        if (encpasswd != null) {
            byte[] passwordBytes = new byte[encpasswd.length() / 2];
            int i2 = 0;
            while (i2 < passwordBytes.length) {
                passwordBytes[i2] = (byte)(Integer.parseInt(encpasswd.substring(i2 * 2, i2 * 2 + 2), 16) ^ passwordBytes.length);
                ++i2;
            }
            password = UTF8.Utf8ToString((byte[])passwordBytes);
        } else {
            password = url.getPassword() == null ? "" : url.getPassword();
        }
        Server s = new Server(url.getHostName(), Integer.parseInt(url.getPort()));
        s.logOn(url.getUserName(), password);
        return new Locator(s);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int handleArgs(boolean firstTime, String[] args) {
        try {
            try {
                Locator l = this.createLocator(args);
                l.runNoSpawn(args);
                System.gc();
                CAT.debug("called runNoSpawn");
            }
            catch (Exception e) {
                JFrame f = new JFrame("StarTeam Form Server");
                URL imageUrl = (class$com$starbase$starteam$starflow$formserver$FormServer == null ? (class$com$starbase$starteam$starflow$formserver$FormServer = FormServer.class$("com.starbase.starteam.starflow.formserver.FormServer")) : class$com$starbase$starteam$starflow$formserver$FormServer).getResource("StarTeam16x16.gif");
                if (imageUrl != null) {
                    f.setIconImage(Toolkit.getDefaultToolkit().createImage(imageUrl));
                }
                this.m_errorHandler.handleErrors(f, "StarTeam Form Server", null, e, this, null, 0, 0);
                CAT.error("Exception", e);
                Object var7_6 = null;
            }
            Object var7_5 = null;
        }
        catch (Throwable throwable) {
            Object var7_7 = null;
            throw throwable;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void run(String[] args) {
        int exitCode = 0;
        try {
            block14: {
                try {
                    this.addShutdownHook();
                    this.setLockFile();
                    int port = this.checkRunning();
                    if (port <= 0) {
                        if (CAT.isInfoEnabled()) {
                            CAT.info("nothing running");
                        }
                        this.runAsServer(args);
                        break block14;
                    }
                    if (CAT.isInfoEnabled()) {
                        CAT.info("running on: " + port);
                    }
                    Socket socket = null;
                    try {
                        CAT.debug("opening socket to port: " + port);
                        socket = new Socket("127.0.0.1", port);
                        CAT.debug("got socket on port: " + port);
                        this.checkForValidAppRunning(socket);
                    }
                    catch (Exception e) {
                        if (CAT.isInfoEnabled()) {
                            CAT.info("failed to connect", e);
                        }
                        try {
                            if (socket != null) {
                                socket.close();
                            }
                        }
                        catch (Exception err) {
                            CAT.info("problem closing socket after error", err);
                        }
                        socket = null;
                    }
                    if (socket != null) {
                        exitCode = this.forwardArgs(args, socket);
                        break block14;
                    }
                    this.runAsServer(args);
                }
                catch (Exception e) {
                    CAT.error("Error in run()", e);
                    System.exit(1);
                    Object var8_9 = null;
                    this.cleanupLockFile();
                }
            }
            Object var8_8 = null;
            this.cleanupLockFile();
        }
        catch (Throwable throwable) {
            Object var8_10 = null;
            this.cleanupLockFile();
            throw throwable;
        }
        System.exit(exitCode);
    }

    protected void quit() {
        if (this.m_indicator != null) {
            this.m_indicator.removeDesktopIndicatorListener(this);
            this.m_indicator.hide();
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }
        this.cleanupLockFile();
        this.cleanupServers();
        System.exit(0);
    }

    protected void addShutdownHook() {
        Runtime.getRuntime().addShutdownHook(new Thread(){

            public void run() {
                FormServer.this.cleanupLockFile();
                FormServer.this.cleanupServers();
            }
        });
    }

    protected void cleanupLockFile() {
        if (this.m_deleteLock) {
            this.m_lockFile.delete();
        }
    }

    protected void cleanupServers() {
        Iterator iter = Locator.getServerCache().values().iterator();
        while (iter.hasNext()) {
            Server server = (Server)iter.next();
            try {
                server.disconnect();
            }
            catch (Exception e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void processCommand(Socket socket) throws IOException {
        try {
            DataOutputStream out = new DataOutputStream(socket.getOutputStream());
            DataInputStream in = new DataInputStream(socket.getInputStream());
            out.writeCookie(this.getMagicCookie());
            out.flush();
            String[] args = this.readArgs(in);
            int exitCode = -1;
            try {
                exitCode = this.handleArgs(false, args);
            }
            catch (Exception e) {
                exitCode = -1;
            }
            out.writeInt(exitCode);
            out.flush();
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_8 = null;
            try {
                socket.close();
            }
            catch (IOException ioe) {
                CAT.info("problem when closing socket", ioe);
            }
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (IOException ioe) {
            CAT.info("problem when closing socket", ioe);
        }
    }

    protected void runAsServer(String[] initialArgs) throws IOException {
        Locator l = this.createLocator(initialArgs);
        File dll = System.getProperty("onwin32") != null ? l.getResource(null, null, "DesktopIndicator.dll", false) : null;
        if (dll != null && DesktopIndicator.initialize(dll)) {
            int imageID = DesktopIndicator.loadImageFromResource(105);
            this.m_indicator = new DesktopIndicator(imageID, "StarTeam Form Server");
            this.m_indicator.addDesktopIndicatorListener(this);
            this.m_indicator.show();
        } else if (System.getProperty("onwin32") != null) {
            JFrame f = new JFrame("StarTeam Form Server");
            URL imageUrl = this.getClass().getResource("StarTeam16x16.gif");
            if (imageUrl != null) {
                f.setIconImage(Toolkit.getDefaultToolkit().createImage(imageUrl));
            }
            JOptionPane pane = new JOptionPane("Unable to initialize icon in System Tray.");
            pane.setMessageType(0);
            pane.setOptionType(-1);
            JDialog dlg = pane.createDialog(f, "StarTeam Form Server");
            dlg.toFront();
            dlg.setModal(true);
            dlg.show();
        }
        ServerSocket ss = new ServerSocket(0);
        int port = ss.getLocalPort();
        if (CAT.isInfoEnabled()) {
            CAT.info("made server socket on port: " + port);
        }
        this.setLock(port);
        CAT.debug("saved port number to file");
        try {
            CAT.debug("going to handle args");
            this.handleArgs(true, initialArgs);
            CAT.debug("handled args");
        }
        catch (Throwable t) {
            CAT.error("problem with handleArgs", t);
        }
        while (true) {
            System.gc();
            CAT.debug("about to accept()");
            Socket socket = ss.accept();
            CAT.debug("got remote connection");
            this.handleSocket(socket);
        }
    }

    public void doubleClicked(DesktopIndicator source) {
        try {
            UIManager.setLookAndFeel("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");
            System.out.println("Set Windows look and feel");
        }
        catch (UnsupportedLookAndFeelException e) {
            System.out.println("Couldn't set Windows look and feel");
        }
        catch (Exception e) {
            // empty catch block
        }
        JFrame f = new JFrame("StarTeam");
        URL imageUrl = this.getClass().getResource("StarTeam16x16.gif");
        if (imageUrl != null) {
            f.setIconImage(Toolkit.getDefaultToolkit().createImage(imageUrl));
        }
        JOptionPane pane = new JOptionPane("Shutdown form server?");
        pane.setMessageType(3);
        pane.setOptionType(0);
        JDialog dlg = pane.createDialog(f, "StarTeam Form Server");
        dlg.toFront();
        dlg.setModal(true);
        dlg.show();
        Object response = pane.getValue();
        if (new Integer(0).equals(response)) {
            this.quit();
        }
    }

    protected void handleSocket(final Socket socket) {
        new Thread(new Runnable(){

            public void run() {
                FormServer.this.runCommand(socket);
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void runCommand(Socket socket) {
        try {
            if (!"127.0.0.1".equals(socket.getInetAddress().getHostAddress())) {
                if (CAT.isInfoEnabled()) {
                    CAT.info("refusing connection from: " + socket.getInetAddress());
                }
            } else {
                try {
                    this.processCommand(socket);
                }
                catch (Exception e) {
                    CAT.info("problem processing command from host: " + socket.getInetAddress(), e);
                }
            }
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            try {
                socket.close();
            }
            catch (Exception e) {
                // empty catch block
            }
            throw throwable;
        }
        try {
            socket.close();
        }
        catch (Exception e) {}
    }

    protected void setLockFile() throws IOException {
        File dir = this.getApplicationDir();
        if (!dir.exists()) {
            dir.mkdirs();
        } else if (!dir.isDirectory()) {
            throw new IOException(dir.getAbsolutePath() + " is not a directory");
        }
        this.m_lockFile = new File(dir, "formserver.lck");
        if (CAT.isInfoEnabled()) {
            CAT.info("LOCK FILE: " + this.m_lockFile.getAbsolutePath());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    protected int checkRunning() {
        if (this.m_lockFile.exists()) {
            int n;
            FileInputStream in;
            block10: {
                in = null;
                in = new FileInputStream(this.m_lockFile);
                BufferedReader rdr = new BufferedReader(new InputStreamReader((InputStream)in, "ISO-8859-1"));
                String line = rdr.readLine();
                n = Integer.parseInt(line);
                Object var6_7 = null;
                if (in == null) break block10;
                try {
                    in.close();
                }
                catch (Exception e2) {
                    // empty catch block
                }
            }
            return n;
            catch (Exception e) {
                int n2;
                block11: {
                    try {
                        n2 = -1;
                        Object var6_8 = null;
                        if (in == null) break block11;
                    }
                    catch (Throwable throwable) {
                        Object var6_9 = null;
                        if (in != null) {
                            try {
                                in.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        throw throwable;
                    }
                    try {
                        in.close();
                    }
                    catch (Exception e2) {
                        // empty catch block
                    }
                }
                return n2;
            }
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void setLock(int port) throws IOException {
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.m_lockFile);
            BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)out, "ISO-8859-1"));
            writer.write("" + port);
            writer.newLine();
            writer.flush();
            this.m_deleteLock = true;
            Object var5_4 = null;
            if (out == null) return;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            if (out == null) throw throwable;
            out.close();
            throw throwable;
        }
        out.close();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void checkForValidAppRunning(Socket socket) throws IOException {
        DataInputStream in = new DataInputStream(socket.getInputStream());
        int avail = in.available();
        CAT.debug("available: " + avail);
        int i = 0;
        while (i < 30) {
            Object o;
            if (avail >= MAGIC_COOKIE_LENGTH) break;
            Object object = o = new Object();
            synchronized (object) {
                try {
                    o.wait((i + 1) * 40);
                }
                catch (InterruptedException ie) {
                    // empty catch block
                }
            }
            avail = in.available();
            CAT.debug("available after wait: " + avail);
            ++i;
        }
        if (avail < MAGIC_COOKIE_LENGTH) {
            socket.close();
            throw new IOException("didn't get response from app");
        }
        String cookie = in.readCookie();
        if (!cookie.equals(this.getMagicCookie())) {
            socket.close();
            throw new IOException("not an instance of this app");
        }
        CAT.debug("looks other process is one of us");
    }

    protected int forwardArgs(String[] args, Socket socket) throws IOException {
        DataOutputStream out = new DataOutputStream(socket.getOutputStream());
        DataInputStream in = new DataInputStream(socket.getInputStream());
        out.writeCookie(this.getMagicCookie());
        out.writeInt(args.length);
        int i = 0;
        while (i < args.length) {
            out.writeUTF(args[i]);
            ++i;
        }
        out.flush();
        int code = in.readInt();
        try {
            socket.close();
        }
        catch (Exception e) {}
        return code;
    }

    protected String[] readArgs(DataInputStream in) throws IOException {
        String cookie = in.readCookie();
        if (!cookie.equals(this.getMagicCookie())) {
            throw new RuntimeException("got invalid magic cookie from remote application");
        }
        int size = in.readInt();
        System.out.println(size);
        String[] result = new String[size];
        int i = 0;
        while (i < size) {
            result[i] = in.readUTF();
            System.out.println(result[i]);
            ++i;
        }
        return result;
    }

    public static void main(String[] args) {
        new FormServer().run(args);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        try {
            Class<?> c = Class.forName("com.starbase.starteam.ClientApplication");
            Method m = c.getMethod("setName", class$java$lang$String == null ? (class$java$lang$String = FormServer.class$("java.lang.String")) : class$java$lang$String);
            m.invoke(null, "StarTeam Extensions");
        }
        catch (ClassNotFoundException e) {
        }
        catch (SecurityException e) {
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
        }
        catch (NoSuchMethodException e) {
            // empty catch block
        }
        MAGIC_COOKIE_LENGTH = 30;
    }
}

