/*
 * Decompiled with CFR 0.152.
 */
package com.starbase.starteam.starflow.formserver;

import com.starbase.starteam.starflow.formserver.DesktopIndicatorListener;
import java.io.File;
import java.util.Enumeration;
import java.util.Vector;

public class DesktopIndicator {
    private int image;
    private String tooltip;
    private Vector listeners = new Vector();
    private int handler = 0;

    public DesktopIndicator() {
    }

    public DesktopIndicator(int image, String tooltip) {
        this.image = image;
        this.tooltip = tooltip;
    }

    public void addDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.addElement(listener);
    }

    protected void finalize() {
        this.nativeDisable();
    }

    public void fireClicked() {
        Vector listenersClone = (Vector)this.listeners.clone();
        Enumeration e = listenersClone.elements();
        while (e.hasMoreElements()) {
            DesktopIndicatorListener listener = (DesktopIndicatorListener)e.nextElement();
            listener.doubleClicked(this);
        }
    }

    public static void freeImage(int image) {
        try {
            DesktopIndicator.nativeFreeImage(image);
        }
        catch (UnsatisfiedLinkError x) {}
    }

    public void hide() {
        try {
            this.nativeHide();
        }
        catch (UnsatisfiedLinkError e) {}
    }

    public static boolean initialize() {
        try {
            System.loadLibrary("DesktopIndicator");
        }
        catch (UnsatisfiedLinkError x) {
            return false;
        }
        return true;
    }

    public static boolean initialize(File library) {
        try {
            System.load(library.getAbsolutePath());
        }
        catch (UnsatisfiedLinkError x) {
            return false;
        }
        return true;
    }

    public static int loadImage(String filename) {
        try {
            return DesktopIndicator.nativeLoadImage(filename);
        }
        catch (UnsatisfiedLinkError x) {
            return -1;
        }
    }

    public static int loadImageFromResource(int inResourceNum) {
        System.out.println("loadImageFromResource");
        try {
            return DesktopIndicator.nativeLoadImageFromResource(inResourceNum);
        }
        catch (UnsatisfiedLinkError x) {
            x.printStackTrace();
            return -1;
        }
    }

    private synchronized native void nativeDisable() throws UnsatisfiedLinkError;

    private synchronized native void nativeEnable(int var1, String var2) throws UnsatisfiedLinkError;

    private static synchronized native void nativeFreeImage(int var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImage(String var0) throws UnsatisfiedLinkError;

    private static synchronized native int nativeLoadImageFromResource(int var0) throws UnsatisfiedLinkError;

    private synchronized native void nativeHide() throws UnsatisfiedLinkError;

    public void removeDesktopIndicatorListener(DesktopIndicatorListener listener) {
        this.listeners.removeElement(listener);
    }

    public void show() {
        try {
            this.nativeEnable(this.image, this.tooltip);
        }
        catch (UnsatisfiedLinkError x) {}
    }

    public void update(int image, String tooltip) {
        this.image = image;
        this.tooltip = tooltip;
        try {
            this.nativeEnable(image, tooltip);
        }
        catch (UnsatisfiedLinkError x) {}
    }
}

